/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.UIManager;

public class CheckBox
extends Button {
    private boolean selected = false;
    private boolean oppositeSide;

    public CheckBox(String text) {
        this(text, (Image)null);
    }

    public CheckBox() {
        this("");
    }

    public CheckBox(Image icon) {
        this("", icon);
    }

    public CheckBox(String text, Image icon) {
        super(text, icon);
        this.setUIID("CheckBox");
        this.updateSide();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    public void released(int x, int y) {
        this.selected = !this.isSelected();
        super.released(x, y);
    }

    public void paint(Graphics g) {
        if (this.isToggle()) {
            UIManager.getInstance().getLookAndFeel().drawButton(g, this);
        } else {
            UIManager.getInstance().getLookAndFeel().drawCheckBox(g, this);
        }
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getCheckBoxPreferredSize(this);
    }

    protected String paramString() {
        return super.paramString() + ", selected = " + this.selected;
    }

    void initComponentImpl() {
        super.initComponentImpl();
    }

    private void updateSide() {
        Boolean v = UIManager.getInstance().isThemeConstant("checkBoxOppositeSideBool");
        if (v != null) {
            this.oppositeSide = v;
        }
    }

    public void refreshTheme() {
        super.refreshTheme();
        this.updateSide();
    }

    int getAvaliableSpaceForText() {
        Image[] rButtonImages;
        if (this.isToggle()) {
            return super.getAvaliableSpaceForText();
        }
        LookAndFeel l = UIManager.getInstance().getLookAndFeel();
        if (l instanceof DefaultLookAndFeel && (rButtonImages = ((DefaultLookAndFeel)l).getCheckBoxImages()) != null) {
            int index = this.isSelected() ? 1 : 0;
            return super.getAvaliableSpaceForText() - rButtonImages[index].getWidth();
        }
        return super.getAvaliableSpaceForText() - (this.getHeight() + this.getGap());
    }

    public boolean isOppositeSide() {
        return this.oppositeSide;
    }

    public void setOppositeSide(boolean oppositeSide) {
        this.oppositeSide = oppositeSide;
    }
}

