/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.impl.LWUITImplementation;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class Container
extends Component {
    private static boolean enableLayoutOnPaint = true;
    private Component leadComponent;
    private Layout layout;
    private Vector components = new Vector();
    private boolean shouldLayout = true;
    boolean scrollableX;
    boolean scrollableY;
    private Vector cmpTransitions;
    private int scrollIncrement = 20;
    private boolean blockFocus = false;

    public Container(Layout layout) {
        this.setUIID("Container");
        this.layout = layout;
        this.setFocusable(false);
        LookAndFeel laf = UIManager.getInstance().getLookAndFeel();
        this.setSmoothScrolling(laf.isDefaultSmoothScrolling());
    }

    public Container() {
        this(new FlowLayout());
    }

    public void setLeadComponent(Component lead) {
        this.leadComponent = lead;
        if (this.isInitialized()) {
            this.initLead();
        }
    }

    void focusGainedInternal() {
        super.focusGainedInternal();
        if (this.leadComponent != null) {
            this.setFocusLead(true);
        }
    }

    void focusLostInternal() {
        super.focusLostInternal();
        if (this.leadComponent != null) {
            this.setFocusLead(false);
        }
    }

    public Component getLeadComponent() {
        if (this.leadComponent != null) {
            return this.leadComponent;
        }
        if (this.hasLead) {
            return super.getLeadComponent();
        }
        return null;
    }

    public Container getLeadParent() {
        if (this.leadComponent != null) {
            return this;
        }
        if (this.hasLead) {
            return this.getParent().getLeadParent();
        }
        return null;
    }

    private void initLead() {
        this.disableFocusAndInitLead(this);
        this.setFocusable(true);
        this.hasLead = true;
    }

    public void keyPressed(int k) {
        if (this.leadComponent != null) {
            this.leadComponent.keyPressed(k);
            this.repaint();
        }
    }

    public void keyReleased(int k) {
        if (this.leadComponent != null) {
            this.leadComponent.keyReleased(k);
            this.repaint();
        }
    }

    private void disableFocusAndInitLead(Container c) {
        for (int iter = 0; iter < c.getComponentCount(); ++iter) {
            Component cu = c.getComponentAt(iter);
            if (cu instanceof Container) {
                this.disableFocusAndInitLead((Container)cu);
            }
            cu.setFocusable(false);
            cu.hasLead = true;
        }
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void invalidate() {
        this.setShouldCalcPreferredSize(true);
    }

    protected void setShouldLayout(boolean layout) {
        if (!this.shouldCalcScrollSize) {
            this.shouldCalcScrollSize = layout;
        }
        if (this.shouldLayout != layout) {
            this.shouldLayout = layout;
            this.shouldCalcPreferredSize = layout;
            this.shouldCalcScrollSize = layout;
            Container parent = this.getParent();
            if (parent != null) {
                parent.setShouldLayout(layout);
            }
        }
    }

    public void setShouldCalcPreferredSize(boolean shouldCalcPreferredSize) {
        Container p;
        if (shouldCalcPreferredSize && this.shouldLayout && this.shouldCalcPreferredSize && !this.isInitialized() && (p = this.getParent()) != null && p.shouldLayout && p.shouldCalcPreferredSize) {
            return;
        }
        super.setShouldCalcPreferredSize(shouldCalcPreferredSize);
        this.shouldLayout = shouldCalcPreferredSize;
        if (this.shouldLayout) {
            int size = this.components.size();
            for (int iter = 0; iter < size; ++iter) {
                Component cmp = (Component)this.components.elementAt(iter);
                if (!(cmp instanceof Container)) continue;
                ((Container)cmp).setShouldCalcPreferredSize(shouldCalcPreferredSize);
            }
        }
    }

    public int getLayoutWidth() {
        if (this.isScrollableX()) {
            return Math.max(this.getWidth(), this.getPreferredW());
        }
        Container parent = this.getScrollableParent();
        if (parent != null && parent.isScrollableX()) {
            return Math.max(this.getWidth(), this.getPreferredW());
        }
        int width = this.getWidth();
        if (width <= 0) {
            return this.getPreferredW();
        }
        return width;
    }

    public int getLayoutHeight() {
        if (this.scrollableY) {
            return Math.max(this.getHeight(), this.getPreferredH());
        }
        Container parent = this.getScrollableParent();
        if (parent != null && parent.scrollableY) {
            return Math.max(this.getHeight(), this.getPreferredH());
        }
        int height = this.getHeight();
        if (height <= 1) {
            return this.getPreferredH();
        }
        return height;
    }

    public void applyRTL(boolean rtl) {
        this.setRTL(rtl);
        int c = this.getComponentCount();
        for (int iter = 0; iter < c; ++iter) {
            Component current = this.getComponentAt(iter);
            if (current instanceof Container) {
                ((Container)current).applyRTL(rtl);
                continue;
            }
            current.setRTL(rtl);
        }
    }

    private Container getScrollableParent() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isScrollable()) continue;
            return parent;
        }
        return null;
    }

    public void addComponent(Component cmp) {
        this.layout.addLayoutComponent(null, cmp, this);
        this.insertComponentAt(this.components.size(), cmp);
    }

    public void addComponent(Object constraints, Component cmp) {
        this.layout.addLayoutComponent(constraints, cmp, this);
        this.insertComponentAt(this.components.size(), cmp);
    }

    public void addComponent(int index, Object constraints, Component cmp) {
        this.layout.addLayoutComponent(constraints, cmp, this);
        this.insertComponentAt(index, cmp);
    }

    void insertComponentAt(int index, Component cmp) {
        if (cmp.getParent() != null) {
            throw new IllegalArgumentException("Component is already contained in Container: " + cmp.getParent());
        }
        if (cmp instanceof Form) {
            cmp.setVisible(true);
            cmp.setPreferredSize(null);
        }
        cmp.setParent(this);
        this.components.insertElementAt(cmp, index);
        this.setShouldCalcPreferredSize(true);
        if (this.isInitialized()) {
            cmp.initComponentImpl();
        }
    }

    public void addComponent(int index, Component cmp) {
        this.layout.addLayoutComponent(null, cmp, this);
        this.insertComponentAt(index, cmp);
    }

    public void replaceAndWait(Component current, Component next, Transition t) {
        this.replaceComponents(current, next, t, true, false, null, 0, 0);
    }

    public void replaceAndWait(Component current, Component next, Transition t, int layoutAnimationSpeed) {
        enableLayoutOnPaint = false;
        this.replaceComponents(current, next, t, true, false, null, 0, layoutAnimationSpeed);
        if (layoutAnimationSpeed > 0) {
            this.animateLayoutAndWait(layoutAnimationSpeed);
        }
        enableLayoutOnPaint = true;
    }

    public void replace(Component current, Component next, Transition t, Runnable onFinish, int growSpeed) {
        this.replaceComponents(current, next, t, false, false, onFinish, growSpeed, 0);
    }

    public void replaceAndWait(Component current, Component next, Transition t, boolean dropEvents) {
        this.replaceComponents(current, next, t, true, dropEvents, null, 0, 0);
    }

    public void replace(Component current, Component next, Transition t) {
        this.replaceComponents(current, next, t, false, false, null, 0, 0);
    }

    private void replaceComponents(Component current, Component next, Transition t, boolean wait, boolean dropEvents, Runnable onFinish, int growSpeed, int layoutAnimationSpeed) {
        if (!this.contains(current)) {
            throw new IllegalArgumentException("Component " + current + " is not contained in this Container");
        }
        if (t == null || !this.isVisible() || this.getComponentForm() == null) {
            this.replace(current, next, false);
            return;
        }
        this.setScrollX(0);
        this.setScrollY(0);
        next.setX(current.getX());
        next.setY(current.getY());
        next.setWidth(current.getWidth());
        next.setHeight(current.getHeight());
        next.setParent(this);
        if (next instanceof Container) {
            ((Container)next).layoutContainer();
        }
        Anim anim = new Anim(this, current, next, t);
        anim.onFinish = onFinish;
        anim.growSpeed = growSpeed;
        anim.layoutAnimationSpeed = layoutAnimationSpeed;
        this.getComponentForm().registerAnimatedInternal(anim);
        if (wait) {
            Display.getInstance().invokeAndBlock(anim, dropEvents);
        }
    }

    private boolean isParentOf(Component c) {
        if ((c = c.getParent()) == null || c instanceof Form) {
            return false;
        }
        return c == this || this.isParentOf(c);
    }

    private boolean requestFocusChild(boolean avoidRepaint) {
        for (int iter = 0; iter < this.getComponentCount(); ++iter) {
            Component c = this.getComponentAt(iter);
            if (c.isFocusable()) {
                if (avoidRepaint) {
                    this.getComponentForm().setFocusedInternal(c);
                } else {
                    c.requestFocus();
                }
                return true;
            }
            if (!(c instanceof Container) || !((Container)c).requestFocusChild(avoidRepaint)) continue;
            return true;
        }
        return false;
    }

    private void cancelRepaintsRecursively(Component c, LWUITImplementation l) {
        if (c instanceof Container) {
            Container cnt = (Container)c;
            int count = cnt.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.cancelRepaintsRecursively(cnt.getComponentAt(i), l);
            }
        }
        l.cancelRepaint(c);
    }

    private void cancelRepaintsRecursively(Component c) {
        this.cancelRepaintsRecursively(c, Display.getInstance().getImplementation());
    }

    void replace(Component current, Component next, boolean avoidRepaint) {
        Object constraint;
        int index = this.components.indexOf(current);
        boolean currentFocused = false;
        if (current.getComponentForm() != null) {
            Component currentF = current.getComponentForm().getFocused();
            boolean bl = currentFocused = currentF == current;
            if (!currentFocused && current instanceof Container && currentF != null && ((Container)current).isParentOf(currentF)) {
                currentFocused = true;
            }
        }
        if ((constraint = this.layout.getComponentConstraint(current)) != null) {
            this.removeComponentImpl(current);
            this.layout.addLayoutComponent(constraint, next, this);
        } else {
            this.removeComponentImpl(current);
        }
        this.cancelRepaintsRecursively(current);
        next.setParent(null);
        if (index < 0) {
            index = 0;
        }
        this.insertComponentAt(index, next);
        if (currentFocused) {
            if (next.isFocusable()) {
                if (avoidRepaint) {
                    this.getComponentForm().setFocusedInternal(next);
                } else {
                    next.requestFocus();
                }
            } else if (next instanceof Container) {
                ((Container)next).requestFocusChild(avoidRepaint);
            }
        }
    }

    void initComponentImpl() {
        if (!this.isInitialized()) {
            super.initComponentImpl();
        }
        int size = this.components.size();
        for (int iter = 0; iter < size; ++iter) {
            ((Component)this.components.elementAt(iter)).initComponentImpl();
        }
        if (this.leadComponent != null) {
            this.initLead();
        }
    }

    public boolean isEnabled() {
        if (this.leadComponent != null) {
            return this.leadComponent.isEnabled();
        }
        return super.isEnabled();
    }

    public void removeComponent(Component cmp) {
        this.removeComponentImpl(cmp);
    }

    void removeComponentImpl(Component cmp) {
        Form parentForm = cmp.getComponentForm();
        this.layout.removeLayoutComponent(cmp);
        cmp.deinitializeImpl();
        this.components.removeElement(cmp);
        cmp.setParent(null);
        if (parentForm != null) {
            if (parentForm.getFocused() == cmp || cmp instanceof Container && ((Container)cmp).contains(parentForm.getFocused())) {
                parentForm.setFocused(null);
            }
            if (cmp.isSmoothScrolling()) {
                parentForm.deregisterAnimatedInternal(cmp);
            }
        }
        Display.getInstance().getImplementation().cancelRepaint(cmp);
        if (cmp instanceof Form) {
            cmp.setVisible(false);
        }
        this.setShouldCalcPreferredSize(true);
    }

    void deinitializeImpl() {
        super.deinitializeImpl();
        int size = this.components.size();
        for (int iter = 0; iter < size; ++iter) {
            ((Component)this.components.elementAt(iter)).deinitializeImpl();
        }
        this.flushReplace();
    }

    public void flushReplace() {
        if (this.cmpTransitions != null) {
            int size = this.cmpTransitions.size();
            for (int iter = 0; iter < size; ++iter) {
                ((Anim)this.cmpTransitions.elementAt(iter)).destroy();
            }
            this.cmpTransitions.removeAllElements();
            this.cmpTransitions = null;
        }
    }

    public void removeAll() {
        Component focus;
        Form parentForm = this.getComponentForm();
        if (parentForm != null && (focus = parentForm.getFocused()) != null && this.contains(focus)) {
            parentForm.setFocused(null);
        }
        Object[] arr = new Object[this.components.size()];
        this.components.copyInto(arr);
        for (int i = 0; i < arr.length; ++i) {
            this.removeComponent((Component)arr[i]);
        }
    }

    public void revalidate() {
        this.setShouldCalcPreferredSize(true);
        Form root = this.getComponentForm();
        if (root != null) {
            root.layoutContainer();
            root.repaint();
        } else {
            this.layoutContainer();
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        if (enableLayoutOnPaint) {
            this.layoutContainer();
        }
        g.translate(this.getX(), this.getY());
        int size = this.components.size();
        LWUITImplementation impl = Display.getInstance().getImplementation();
        for (int i = 0; i < size; ++i) {
            Component cmp = (Component)this.components.elementAt(i);
            cmp.paintInternal(impl.getComponentScreenGraphics(this, g), false);
        }
        int tx = g.getTranslateX();
        int ty = g.getTranslateY();
        g.translate(-tx, -ty);
        this.paintGlass(g);
        g.translate(tx, ty);
        g.translate(-this.getX(), -this.getY());
    }

    void paintGlassImpl(Graphics g) {
        super.paintGlassImpl(g);
        int tx = g.getTranslateX();
        int ty = g.getTranslateY();
        g.translate(-tx, -ty);
        this.paintGlass(g);
        g.translate(tx, ty);
    }

    protected void paintGlass(Graphics g) {
    }

    void paintIntersecting(Graphics g, Component cmp, int x, int y, int w, int h, boolean above) {
        if (this.layout.isOverlapSupported() && this.components.contains(cmp)) {
            int endIndex;
            int startIndex;
            int indexOfComponent = this.components.indexOf(cmp);
            if (above) {
                startIndex = indexOfComponent + 1;
                endIndex = this.components.size();
            } else {
                startIndex = 0;
                endIndex = indexOfComponent;
            }
            for (int i = startIndex; i < endIndex; ++i) {
                Component cmp2 = (Component)this.components.elementAt(i);
                if (!Rectangle.intersects(x, y, w, h, cmp2.getAbsoluteX() + cmp2.getScrollX(), cmp2.getAbsoluteY() + cmp2.getScrollY(), cmp2.getBounds().getSize().getWidth(), cmp2.getBounds().getSize().getHeight())) continue;
                cmp2.paintInternal(g, false);
            }
        }
    }

    public void layoutContainer() {
        if (this.shouldLayout) {
            this.shouldLayout = false;
            this.doLayout();
        }
    }

    void doLayout() {
        this.layout.layoutContainer(this);
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponentAt(i);
            if (c instanceof Container) {
                ((Container)c).layoutContainer();
                continue;
            }
            c.laidOut();
        }
        this.laidOut();
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public Component getComponentAt(int index) {
        return (Component)this.components.elementAt(index);
    }

    public int getComponentIndex(Component cmp) {
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponentAt(i);
            if (!c.equals(cmp)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Component cmp) {
        boolean found = false;
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponentAt(i);
            if (c.equals(cmp)) {
                return true;
            }
            if (!(c instanceof Container) || !(found = ((Container)c).contains(cmp))) continue;
            return true;
        }
        return false;
    }

    protected void scrollComponentToVisible(Component c) {
        if (this.isScrollable() && c != null) {
            Rectangle r = c.getVisibleBounds();
            this.scrollRectToVisible(r.getX(), r.getY(), Math.min(r.getSize().getWidth(), this.getWidth()), Math.min(r.getSize().getHeight(), this.getHeight()), c);
        }
    }

    boolean moveScrollTowards(int direction, Component next) {
        if (this.isScrollable()) {
            boolean nextIntersects;
            Component current = null;
            Form f = this.getComponentForm();
            current = f.getFocused();
            boolean cyclic = f.isCyclicFocus();
            f.setCyclicFocus(false);
            boolean edge = false;
            boolean currentLarge = false;
            boolean scrollOutOfBounds = false;
            int x = this.getScrollX();
            int y = this.getScrollY();
            int w = this.getWidth();
            int h = this.getHeight();
            switch (direction) {
                case 1: {
                    y = this.getScrollY() - this.scrollIncrement;
                    edge = f.findNextFocusUp() == null;
                    currentLarge = current != null && current.getVisibleBounds().getSize().getHeight() > this.getHeight();
                    boolean bl = scrollOutOfBounds = y < 0;
                    if (!scrollOutOfBounds) break;
                    y = 0;
                    break;
                }
                case 6: {
                    y = this.getScrollY() + this.scrollIncrement;
                    edge = f.findNextFocusDown() == null;
                    currentLarge = current != null && current.getVisibleBounds().getSize().getHeight() > this.getHeight();
                    boolean bl = scrollOutOfBounds = y > this.getScrollDimension().getHeight() - this.getHeight();
                    if (!scrollOutOfBounds) break;
                    y = this.getScrollDimension().getHeight() - this.getHeight();
                    break;
                }
                case 5: {
                    x = this.getScrollX() + this.scrollIncrement;
                    edge = f.findNextFocusRight() == null;
                    currentLarge = current != null && current.getVisibleBounds().getSize().getWidth() > this.getWidth();
                    boolean bl = scrollOutOfBounds = x > this.getScrollDimension().getWidth() - this.getWidth();
                    if (!scrollOutOfBounds) break;
                    x = this.getScrollDimension().getWidth() - this.getWidth();
                    break;
                }
                case 2: {
                    x = this.getScrollX() - this.scrollIncrement;
                    edge = f.findNextFocusLeft() == null;
                    currentLarge = current != null && current.getVisibleBounds().getSize().getWidth() > this.getWidth();
                    boolean bl = scrollOutOfBounds = x < 0;
                    if (!scrollOutOfBounds) break;
                    x = 0;
                }
            }
            f.setCyclicFocus(cyclic);
            if (next == null || next == this) {
                this.scrollRectToVisible(x, y, w, h, this);
                return false;
            }
            boolean bl = nextIntersects = this.contains(next) && Rectangle.intersects(next.getAbsoluteX(), next.getAbsoluteY(), next.getWidth(), next.getHeight(), this.getAbsoluteX() + x, this.getAbsoluteY() + y, w, h);
            if (nextIntersects && !currentLarge && !edge || Rectangle.contains(this.getAbsoluteX() + this.getScrollX(), this.getAbsoluteY() + this.getScrollY(), w, h, next.getAbsoluteX(), next.getAbsoluteY(), next.getWidth(), next.getHeight())) {
                return true;
            }
            if (!scrollOutOfBounds) {
                this.scrollRectToVisible(x, y, w, h, this);
                return nextIntersects && !Rectangle.intersects(current.getAbsoluteX(), current.getAbsoluteY(), current.getWidth(), current.getHeight(), this.getAbsoluteX() + x, this.getAbsoluteY() + y, w, h);
            }
            return true;
        }
        return true;
    }

    public Component getComponentAt(int x, int y) {
        int count = this.getComponentCount();
        boolean overlaps = this.getLayout().isOverlapSupported();
        Component component = null;
        for (int i = count - 1; i >= 0; --i) {
            Component cmp = this.getComponentAt(i);
            if (!cmp.contains(x, y)) continue;
            component = cmp;
            if (!overlaps && component.isFocusable()) {
                return component;
            }
            if (cmp instanceof Container) {
                component = ((Container)cmp).getComponentAt(x, y);
            }
            if (overlaps && !component.isFocusable() && !component.isGrabsPointerEvents()) continue;
            return component;
        }
        if (component != null) {
            return component;
        }
        if (this.contains(x, y)) {
            return this;
        }
        return null;
    }

    public void pointerHover(int[] x, int[] y) {
        Component c;
        if (!this.isDragActivated() && (c = this.getComponentAt(x[0], y[0])) != null && c.isFocusable()) {
            c.requestFocus();
        }
        super.pointerDragged(x[0], y[0]);
    }

    public void pointerPressed(int x, int y) {
        this.clearDrag();
        this.setDragActivated(false);
        Component cmp = this.getComponentAt(x, y);
        if (cmp == this) {
            super.pointerPressed(x, y);
        } else if (cmp != null) {
            cmp.pointerPressed(x, y);
        }
    }

    protected Dimension calcPreferredSize() {
        Dimension d = this.layout.getPreferredSize(this);
        Style style = this.getStyle();
        if (style.getBorder() != null && d.getWidth() != 0 && d.getHeight() != 0) {
            d.setWidth(Math.max(style.getBorder().getMinimumWidth(), d.getWidth()));
            d.setHeight(Math.max(style.getBorder().getMinimumHeight(), d.getHeight()));
        }
        return d;
    }

    protected String paramString() {
        String className = this.layout.getClass().getName();
        String layoutStr = className.substring(className.lastIndexOf(46) + 1);
        return super.paramString() + ", layout = " + layoutStr + ", scrollableX = " + this.scrollableX + ", scrollableY = " + this.scrollableY + ", components = " + this.getComponentsNames();
    }

    private String getComponentsNames() {
        String ret = "[";
        int size = this.components.size();
        for (int iter = 0; iter < size; ++iter) {
            String className = this.components.elementAt(iter).getClass().getName();
            ret = ret + className.substring(className.lastIndexOf(46) + 1) + ", ";
        }
        if (ret.length() > 1) {
            ret = ret.substring(0, ret.length() - 2);
        }
        ret = ret + "]";
        return ret;
    }

    public void refreshTheme() {
        super.refreshTheme();
        int size = this.components.size();
        for (int iter = 0; iter < size; ++iter) {
            Component cmp = (Component)this.components.elementAt(iter);
            cmp.refreshTheme();
        }
    }

    public boolean isScrollableX() {
        return this.scrollableX && this.getScrollDimension().getWidth() > this.getWidth();
    }

    public boolean isScrollableY() {
        return this.scrollableY && (this.getScrollDimension().getHeight() > this.getHeight() || this.isAlwaysTensile());
    }

    public int getSideGap() {
        if (Display.getInstance().getDeviceType() == 2 || Display.getInstance().getDeviceType() == 3) {
            return 0;
        }
        if (this.scrollSize == null) {
            if (this.scrollableY && this.isScrollVisible()) {
                return UIManager.getInstance().getLookAndFeel().getVerticalScrollWidth();
            }
        } else {
            return super.getSideGap();
        }
        return 0;
    }

    public int getBottomGap() {
        if (this.scrollableX && this.isScrollVisible()) {
            return UIManager.getInstance().getLookAndFeel().getHorizontalScrollHeight();
        }
        return 0;
    }

    public void setScrollableX(boolean scrollableX) {
        this.scrollableX = scrollableX;
    }

    public void setScrollableY(boolean scrollableY) {
        this.scrollableY = scrollableY;
    }

    public void setScrollable(boolean scrollable) {
        this.setScrollableX(scrollable);
        this.setScrollableY(scrollable);
    }

    public void setCellRenderer(boolean cellRenderer) {
        if (this.isCellRenderer() != cellRenderer) {
            super.setCellRenderer(cellRenderer);
            int size = this.getComponentCount();
            for (int iter = 0; iter < size; ++iter) {
                this.getComponentAt(iter).setCellRenderer(cellRenderer);
            }
        }
    }

    public void setScrollIncrement(int scrollIncrement) {
        this.scrollIncrement = scrollIncrement;
    }

    public int getScrollIncrement() {
        return this.scrollIncrement;
    }

    public Component findFirstFocusable() {
        int size = this.getComponentCount();
        for (int iter = 0; iter < size; ++iter) {
            Component cmp;
            Component current = this.getComponentAt(iter);
            if (!current.isVisible()) continue;
            if (current.isFocusable()) {
                return current;
            }
            if (!(current instanceof Container) || ((Container)current).isBlockFocus() || (cmp = ((Container)current).findFirstFocusable()) == null) continue;
            return cmp;
        }
        return null;
    }

    private void setFocusLead(boolean f) {
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponentAt(i);
            if (c instanceof Container) {
                ((Container)c).setFocusLead(f);
            }
            c.setFocus(f);
            if (f) {
                c.fireFocusGained();
                continue;
            }
            c.fireFocusLost();
        }
    }

    protected void dragInitiated() {
        super.dragInitiated();
        if (this.leadComponent != null) {
            this.leadComponent.dragInitiated();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponentAt(i);
            c.setEnabled(enabled);
        }
    }

    protected int getGridPosY() {
        int scroll = this.getScrollY();
        int size = this.getComponentCount();
        int bestRow = 0;
        for (int iter = 0; iter < size; ++iter) {
            Component c = this.getComponentAt(iter);
            int y = c.getY();
            if (Math.abs(scroll - y) >= Math.abs(scroll - bestRow)) continue;
            bestRow = y;
        }
        if (Math.abs(scroll - bestRow) > 2) {
            return bestRow;
        }
        return scroll;
    }

    private boolean shouldPaintContainerBackground() {
        Component c;
        Style s;
        if (this.getComponentCount() == 1 && (s = this.getStyle()).getPadding(0) == 0 && s.getPadding(2) == 0 && s.getPadding(1) == 0 && s.getPadding(3) == 0 && (c = this.getComponentAt(0)).getWidth() == this.getWidth() && c.getHeight() == this.getHeight()) {
            if (c.isFlatten() || (c.getStyle().getBgTransparency() & 0xFF) == 255) {
                return false;
            }
            if (c instanceof Container) {
                return ((Container)c).shouldPaintContainerBackground();
            }
        }
        return true;
    }

    public void paintBackground(Graphics g) {
        if (this.isFlatten()) {
            super.paintBackgrounds(g);
            return;
        }
        if (this.shouldPaintContainerBackground()) {
            super.paintBackground(g);
        }
    }

    protected int getGridPosX() {
        int scroll = this.getScrollX();
        int size = this.getComponentCount();
        int bestCol = 0;
        for (int iter = 0; iter < size; ++iter) {
            Component c = this.getComponentAt(iter);
            int x = c.getX();
            if (Math.abs(scroll - x) >= Math.abs(scroll - bestCol)) continue;
            bestCol = x;
        }
        if (Math.abs(scroll - bestCol) > 2) {
            return bestCol;
        }
        return scroll;
    }

    void setBlockFocus(boolean blockFocus) {
        this.blockFocus = blockFocus;
    }

    boolean isBlockFocus() {
        return this.blockFocus;
    }

    public void animateLayoutAndWait(int duration) {
        this.animateLayout(duration, true);
    }

    public void animateLayout(int duration) {
        this.animateLayout(duration, false);
    }

    public void drop(Component dragged, int x, int y) {
        int destIndex;
        Component dest;
        int i = this.getComponentIndex(dragged);
        if (i > -1 && (dest = this.getComponentAt(x, y)) != dragged && (destIndex = this.getComponentIndex(dest)) > -1 && destIndex != i) {
            this.removeComponent(dragged);
            Object con = this.getLayout().getComponentConstraint(dragged);
            if (con != null) {
                this.addComponent(destIndex, con, dragged);
            } else {
                this.addComponent(destIndex, dragged);
            }
        }
        this.animateLayout(400);
    }

    private void animateLayout(int duration, boolean wait) {
        Component current;
        int iter;
        enableLayoutOnPaint = false;
        int componentCount = this.getComponentCount();
        int[] beforeX = new int[componentCount];
        int[] beforeY = new int[componentCount];
        int[] beforeW = new int[componentCount];
        int[] beforeH = new int[componentCount];
        Motion[] xMotions = new Motion[componentCount];
        Motion[] yMotions = new Motion[componentCount];
        Motion[] wMotions = new Motion[componentCount];
        Motion[] hMotions = new Motion[componentCount];
        for (iter = 0; iter < componentCount; ++iter) {
            current = this.getComponentAt(iter);
            beforeX[iter] = current.getX();
            beforeY[iter] = current.getY();
            beforeW[iter] = current.getWidth();
            beforeH[iter] = current.getHeight();
        }
        this.layoutContainer();
        for (iter = 0; iter < componentCount; ++iter) {
            current = this.getComponentAt(iter);
            xMotions[iter] = Motion.createSplineMotion(beforeX[iter], current.getX(), duration);
            yMotions[iter] = Motion.createSplineMotion(beforeY[iter], current.getY(), duration);
            wMotions[iter] = Motion.createSplineMotion(beforeW[iter], current.getWidth(), duration);
            hMotions[iter] = Motion.createSplineMotion(beforeH[iter], current.getHeight(), duration);
            xMotions[iter].start();
            yMotions[iter].start();
            wMotions[iter].start();
            hMotions[iter].start();
            current.setX(beforeX[iter]);
            current.setY(beforeY[iter]);
            current.setWidth(beforeW[iter]);
            current.setHeight(beforeH[iter]);
        }
        Anim a2 = new Anim(this, duration, new Motion[][]{xMotions, yMotions, wMotions, hMotions});
        this.getComponentForm().registerAnimated(a2);
        if (wait) {
            Display.getInstance().invokeAndBlock(a2);
        }
    }

    static class Anim
    implements Animation,
    Runnable {
        private int animationType;
        private long startTime;
        private int duration;
        private Transition t;
        private Component current;
        private Component next;
        private boolean started = false;
        private Container thisContainer;
        private boolean finished = false;
        private Form parent;
        private Motion[][] motions;
        Runnable onFinish;
        int growSpeed;
        int layoutAnimationSpeed;

        public Anim(Container thisContainer, int duration, Motion[][] motions) {
            this.startTime = System.currentTimeMillis();
            this.animationType = 2;
            this.duration = duration;
            this.thisContainer = thisContainer;
            this.motions = motions;
        }

        public Anim(Container thisContainer, Component current, Component next, Transition t) {
            this.animationType = 1;
            this.t = t;
            this.next = next;
            this.current = current;
            this.thisContainer = thisContainer;
            this.parent = thisContainer.getComponentForm();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean animate() {
            boolean notFinished;
            switch (this.animationType) {
                case 2: {
                    int componentCount = this.thisContainer.getComponentCount();
                    for (int iter = 0; iter < componentCount; ++iter) {
                        Component currentCmp = this.thisContainer.getComponentAt(iter);
                        if (currentCmp == null) continue;
                        currentCmp.setX(this.motions[0][iter].getValue());
                        currentCmp.setY(this.motions[1][iter].getValue());
                        currentCmp.setWidth(this.motions[2][iter].getValue());
                        currentCmp.setHeight(this.motions[3][iter].getValue());
                    }
                    this.thisContainer.repaint();
                    if (System.currentTimeMillis() - this.startTime >= (long)this.duration) {
                        enableLayoutOnPaint = true;
                        Form f = this.thisContainer.getComponentForm();
                        f.deregisterAnimated(this);
                        f.revalidate();
                        Anim anim = this;
                        synchronized (anim) {
                            this.finished = true;
                            this.notify();
                        }
                    }
                    return false;
                }
            }
            if (!this.started) {
                this.t.init(this.current, this.next);
                this.t.initTransition();
                this.started = true;
                if (this.thisContainer.cmpTransitions == null) {
                    this.thisContainer.cmpTransitions = new Vector();
                }
                this.thisContainer.cmpTransitions.addElement(this);
            }
            if (!(notFinished = this.t.animate())) {
                this.thisContainer.cmpTransitions.removeElement(this);
                this.destroy();
            }
            return notFinished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            this.parent.deregisterAnimatedInternal(this);
            this.next.setParent(null);
            this.thisContainer.replace(this.current, this.next, this.growSpeed > 0 || this.layoutAnimationSpeed > 0);
            this.t.cleanup();
            if (this.thisContainer.cmpTransitions.size() == 0 && this.growSpeed > -1) {
                if (this.growSpeed > 0) {
                    this.current.growShrink(this.growSpeed);
                } else if (this.layoutAnimationSpeed <= 0) {
                    this.parent.revalidate();
                }
            }
            Anim anim = this;
            synchronized (anim) {
                this.finished = true;
                this.notify();
            }
            if (this.onFinish != null) {
                this.onFinish.run();
            }
        }

        public void paint(Graphics g) {
            this.t.paint(g);
        }

        public boolean isFinished() {
            return this.finished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isFinished()) {
                try {
                    Anim anim = this;
                    synchronized (anim) {
                        this.wait(50L);
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

