/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.MenuBar;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;

public class Dialog
extends Form {
    private boolean disposed;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_ALARM = 1;
    public static final int TYPE_CONFIRMATION = 2;
    public static final int TYPE_ERROR = 3;
    public static final int TYPE_INFO = 4;
    public static final int TYPE_WARNING = 5;
    private long time;
    protected Command lastCommandPressed;
    private boolean menu;
    private int dialogType;
    private int top = -1;
    private int bottom;
    private int left;
    private int right;
    private boolean includeTitle;
    private String position;
    private static boolean dialogTitleCompatibilityMode;
    private static boolean autoAdjustDialogSize;
    private static String defaultDialogPosition;
    private String dialogPosition = defaultDialogPosition;
    private static boolean disableStaticDialogScrolling;
    private boolean autoDispose = true;
    private boolean modal = true;
    private Command[] buttonCommands;
    private boolean disposeOnRotation;
    private static int defaultDialogType;
    private static boolean commandsAsButtons;
    private boolean disposeWhenPointerOutOfBounds = false;
    private Label dialogTitle;
    private Container dialogContentPane;
    private Container dialogTitleContainer;

    public static boolean isDialogTitleCompatibilityMode() {
        return dialogTitleCompatibilityMode;
    }

    public static void setDialogTitleCompatibilityMode(boolean aDialogTitleCompatibilityMode) {
        dialogTitleCompatibilityMode = aDialogTitleCompatibilityMode;
    }

    public Dialog(String title) {
        this();
        this.setTitle(title);
    }

    public Dialog() {
        this("Dialog", "DialogTitle");
    }

    protected Dialog(String dialogUIID, String dialogTitleUIID) {
        if (Display.getInstance().getDeviceType() == 2) {
            commandsAsButtons = true;
        } else if (Display.getInstance().getDeviceType() == 3) {
            commandsAsButtons = true;
            if (dialogUIID.equals("Dialog") && dialogTitleUIID.equals("DialogTitle")) {
                if (UIManager.getInstance().getThemeName() != null && UIManager.getInstance().getThemeName().equals("NokiaTheme")) {
                    dialogTitleCompatibilityMode = true;
                }
            } else {
                dialogTitleCompatibilityMode = false;
            }
        } else {
            commandsAsButtons = false;
        }
        if (dialogTitleCompatibilityMode) {
            if (Display.getInstance().getDeviceType() == 3) {
                this.dialogTitleContainer = new Container(new FlowLayout(4));
                this.dialogTitle = new Label("", dialogTitleUIID);
                this.dialogTitleContainer.addComponent(this.dialogTitle);
                this.getContentPane().setUIID("DialogContentPane");
                this.getTitleComponent().setUIID(dialogTitleUIID);
                super.getTitleComponent().setVisible(false);
                this.titleArea.setVisible(false);
                this.dialogContentPane = new Container();
                this.dialogContentPane.setUIID("DialogContentPane");
                super.getContentPane().setLayout(new BorderLayout());
                super.getContentPane().addComponent("North", (Component)this.dialogTitleContainer);
                super.getContentPane().addComponent("Center", (Component)this.dialogContentPane);
            } else {
                this.getContentPane().setUIID(dialogUIID);
                this.getTitleComponent().setUIID(dialogTitleUIID);
            }
        } else {
            super.getContentPane().setUIID(dialogUIID);
            super.getTitleComponent().setText("");
            super.getTitleComponent().setVisible(false);
            this.titleArea.setVisible(false);
            this.dialogContentPane = new Container();
            this.dialogContentPane.setUIID("DialogContentPane");
            this.dialogTitle = new Label("", dialogTitleUIID);
            super.getContentPane().setLayout(new BorderLayout());
            super.getContentPane().addComponent("North", (Component)this.dialogTitle);
            super.getContentPane().addComponent("Center", (Component)this.dialogContentPane);
            super.getContentPane().setScrollable(false);
            super.getContentPane().setAlwaysTensile(false);
        }
        super.getStyle().setBgTransparency(0);
        super.getStyle().setBgImage(null);
        this.setSmoothScrolling(false);
        this.deregisterAnimated(this);
    }

    public Container getContentPane() {
        if (dialogTitleCompatibilityMode) {
            return super.getContentPane();
        }
        return this.dialogContentPane;
    }

    public Layout getLayout() {
        if (dialogTitleCompatibilityMode) {
            return super.getLayout();
        }
        return this.dialogContentPane.getLayout();
    }

    public String getTitle() {
        if (dialogTitleCompatibilityMode && Display.getInstance().getDeviceType() != 3) {
            return super.getTitle();
        }
        return this.dialogTitle.getText();
    }

    public void addComponent(Component cmp) {
        if (dialogTitleCompatibilityMode && Display.getInstance().getDeviceType() != 3) {
            super.addComponent(cmp);
            return;
        }
        this.dialogContentPane.addComponent(cmp);
    }

    public void addComponent(Object constraints, Component cmp) {
        if (dialogTitleCompatibilityMode && Display.getInstance().getDeviceType() != 3) {
            super.addComponent(constraints, cmp);
            return;
        }
        this.dialogContentPane.addComponent(constraints, cmp);
    }

    public void addComponent(int index, Object constraints, Component cmp) {
        if (dialogTitleCompatibilityMode && Display.getInstance().getDeviceType() != 3) {
            super.addComponent(index, constraints, cmp);
            return;
        }
        this.dialogContentPane.addComponent(index, constraints, cmp);
    }

    public void addComponent(int index, Component cmp) {
        if (dialogTitleCompatibilityMode && Display.getInstance().getDeviceType() != 3) {
            super.addComponent(index, cmp);
            return;
        }
        this.dialogContentPane.addComponent(index, cmp);
    }

    public void removeAll() {
        if (dialogTitleCompatibilityMode && Display.getInstance().getDeviceType() != 3) {
            super.removeAll();
            return;
        }
        this.dialogContentPane.removeAll();
    }

    public void removeComponent(Component cmp) {
        if (dialogTitleCompatibilityMode && Display.getInstance().getDeviceType() != 3) {
            super.removeComponent(cmp);
            return;
        }
        this.dialogContentPane.removeComponent(cmp);
    }

    public Label getTitleComponent() {
        if (dialogTitleCompatibilityMode && Display.getInstance().getDeviceType() != 3) {
            return super.getTitleComponent();
        }
        return this.dialogTitle;
    }

    public Style getTitleStyle() {
        if (dialogTitleCompatibilityMode && Display.getInstance().getDeviceType() != 3) {
            return super.getTitleStyle();
        }
        return this.dialogTitle.getStyle();
    }

    public void setLayout(Layout layout) {
        if (dialogTitleCompatibilityMode && Display.getInstance().getDeviceType() != 3) {
            super.setLayout(layout);
            return;
        }
        this.dialogContentPane.setLayout(layout);
    }

    public void setTitle(String title) {
        if (dialogTitleCompatibilityMode && Display.getInstance().getDeviceType() != 3) {
            super.setTitle(title);
            return;
        }
        this.dialogTitle.setText(title);
    }

    public void setTitleComponent(Label title) {
        if (dialogTitleCompatibilityMode) {
            if (Display.getInstance().getDeviceType() == 3) {
                this.dialogTitle = title;
                return;
            }
            super.setTitleComponent(title);
            return;
        }
        super.getContentPane().removeComponent(this.dialogTitle);
        this.dialogTitle = title;
        super.getContentPane().addComponent("North", (Component)this.dialogTitle);
    }

    public Container getDialogComponent() {
        return super.getContentPane();
    }

    public void setTitleComponent(Label title, Transition t) {
        if (dialogTitleCompatibilityMode) {
            if (Display.getInstance().getDeviceType() == 3) {
                this.dialogTitle = title;
                return;
            }
            super.setTitleComponent(title, t);
            return;
        }
        super.getContentPane().replace((Component)this.dialogTitle, (Component)title, t);
        this.dialogTitle = title;
    }

    public void setDialogStyle(Style style) {
        super.getContentPane().setUnselectedStyle(style);
    }

    public void setDialogUIID(String uiid) {
        super.getContentPane().setUIID(uiid);
    }

    public String getDialogUIID() {
        return super.getContentPane().getUIID();
    }

    public Style getDialogStyle() {
        return super.getContentPane().getStyle();
    }

    void initLaf(LookAndFeel laf) {
        this.setTransitionOutAnimator(laf.getDefaultDialogTransitionOut());
        this.setTransitionInAnimator(laf.getDefaultDialogTransitionIn());
    }

    public Command show(int top, int bottom, int left, int right, boolean includeTitle) {
        return this.show(top, bottom, left, right, includeTitle, true);
    }

    public Command show(int top, int bottom, int left, int right, boolean includeTitle, boolean modal) {
        this.top = top;
        this.bottom = bottom;
        if (this.isRTL()) {
            this.left = right;
            this.right = left;
        } else {
            this.left = left;
            this.right = right;
        }
        this.includeTitle = includeTitle;
        this.setDisposed(false);
        this.modal = modal;
        this.lastCommandPressed = null;
        this.showModal(this.top, this.bottom, this.left, this.right, includeTitle, modal, false);
        return this.lastCommandPressed;
    }

    public void setTimeout(long time) {
        this.time = System.currentTimeMillis() + time;
        super.registerAnimatedInternal(this);
    }

    public static boolean show(String title, String text, int type, Image icon, String okText, String cancelText) {
        return Dialog.show(title, text, type, icon, okText, cancelText, 0L);
    }

    void sizeChangedInternal(int w, int h) {
        if (this.disposeOnRotation) {
            this.dispose();
            Form frm = this.getPreviousForm();
            if (frm != null) {
                frm.sizeChangedInternal(w, h);
            }
            return;
        }
        this.autoAdjust(w, h);
        super.sizeChangedInternal(w, h);
        Form frm = this.getPreviousForm();
        if (frm != null) {
            frm.sizeChangedInternal(w, h);
        }
    }

    protected void autoAdjust(int w, int h) {
        if (autoAdjustDialogSize) {
            Container contentPane = super.getContentPane();
            Label title = super.getTitleComponent();
            int prefHeight = contentPane.getPreferredH();
            int prefWidth = contentPane.getPreferredW();
            Style contentPaneStyle = contentPane.getStyle();
            Style titleStyle = title.getStyle();
            if (this.position != null) {
                int menuHeight = 0;
                if (this.getSoftButtonCount() > 1) {
                    Container menuBar = this.getSoftButton(0).getParent();
                    Style menuStyle = menuBar.getStyle();
                    menuHeight = menuBar.getPreferredH() + menuStyle.getMargin(false, 0) + menuStyle.getMargin(false, 2);
                }
                prefWidth = Math.min(prefWidth, w);
                h = h - menuHeight - title.getPreferredH();
                int topBottom = Math.max(0, (h - prefHeight) / 2);
                int leftRight = Math.max(0, (w - prefWidth) / 2);
                int top = topBottom;
                int bottom = topBottom;
                int left = leftRight;
                int right = leftRight;
                if (this.position.equals("East")) {
                    left = Math.max(0, w - prefWidth);
                    right = 0;
                } else if (this.position.equals("West")) {
                    right = 0;
                    left = Math.max(0, w - prefWidth);
                } else if (this.position.equals("North")) {
                    top = 0;
                    bottom = Math.max(0, h - prefHeight);
                } else if (this.position.equals("South")) {
                    top = Math.max(0, h - prefHeight);
                    bottom = 0;
                }
                if (this.includeTitle) {
                    titleStyle.setMargin(0, top, true);
                    titleStyle.setMargin(2, 0, true);
                    titleStyle.setMargin(1, left, true);
                    titleStyle.setMargin(3, right, true);
                    contentPaneStyle.setMargin(0, 0, true);
                    contentPaneStyle.setMargin(2, bottom, true);
                    contentPaneStyle.setMargin(1, left, true);
                    contentPaneStyle.setMargin(3, right, true);
                } else {
                    titleStyle.setMargin(0, 0, true);
                    titleStyle.setMargin(2, 0, true);
                    titleStyle.setMargin(1, 0, true);
                    titleStyle.setMargin(3, 0, true);
                    contentPaneStyle.setMargin(0, top, true);
                    contentPaneStyle.setMargin(2, bottom, true);
                    contentPaneStyle.setMargin(1, left, true);
                    contentPaneStyle.setMargin(3, right, true);
                }
                return;
            }
            int oldW = this.getWidth();
            int oldH = this.getHeight();
            if (oldW != w || oldH != h) {
                if (prefWidth <= w && prefHeight <= h) {
                    float oldLeftRightDistRatio = 1.0f;
                    if (this.left + this.right != 0) {
                        oldLeftRightDistRatio = (float)this.left / ((float)this.left + (float)this.right);
                    }
                    float oldTopBottomDistRatio = 1.0f;
                    if (this.left + this.right != 0) {
                        oldTopBottomDistRatio = (float)this.top / ((float)this.top + (float)this.bottom);
                    }
                    this.top = Math.max(0, (int)((float)(h - prefHeight) * oldTopBottomDistRatio));
                    this.left = Math.max(0, (int)((float)(w - prefWidth) * oldLeftRightDistRatio));
                    this.bottom = Math.max(0, h - prefHeight - this.top);
                    this.right = Math.max(0, w - prefWidth - this.left);
                    if (this.includeTitle) {
                        titleStyle.setMargin(0, this.top, true);
                        titleStyle.setMargin(2, 0, true);
                        titleStyle.setMargin(1, this.left, true);
                        titleStyle.setMargin(3, this.right, true);
                        contentPaneStyle.setMargin(0, 0, true);
                        contentPaneStyle.setMargin(2, this.bottom, true);
                        contentPaneStyle.setMargin(1, this.left, true);
                        contentPaneStyle.setMargin(3, this.right, true);
                    } else {
                        titleStyle.setMargin(0, 0, true);
                        titleStyle.setMargin(2, 0, true);
                        titleStyle.setMargin(1, 0, true);
                        titleStyle.setMargin(3, 0, true);
                        contentPaneStyle.setMargin(0, this.top, true);
                        contentPaneStyle.setMargin(2, this.bottom, true);
                        contentPaneStyle.setMargin(1, this.left, true);
                        contentPaneStyle.setMargin(3, this.right, true);
                    }
                    return;
                }
                float ratioW = (float)w / (float)oldW;
                float ratioH = (float)h / (float)oldH;
                Style s = this.getDialogStyle();
                s.setMargin(0, (int)((float)s.getMargin(false, 0) * ratioH));
                s.setMargin(2, (int)((float)s.getMargin(false, 2) * ratioH));
                s.setMargin(1, (int)((float)s.getMargin(this.isRTL(), 1) * ratioW));
                s.setMargin(3, (int)((float)s.getMargin(this.isRTL(), 3) * ratioW));
                titleStyle.setMargin(0, (int)((float)titleStyle.getMargin(false, 0) * ratioH));
                titleStyle.setMargin(1, (int)((float)titleStyle.getMargin(this.isRTL(), 1) * ratioW));
                titleStyle.setMargin(3, (int)((float)titleStyle.getMargin(this.isRTL(), 3) * ratioW));
                return;
            }
        }
    }

    public static boolean show(String title, String text, int type, Image icon, String okText, String cancelText, long timeout) {
        Command okCommand = new Command(okText);
        Command[] cmds = cancelText != null ? new Command[]{okCommand, new Command(cancelText)} : new Command[]{okCommand};
        return Dialog.show(title, text, okCommand, cmds, type, icon, timeout) == okCommand;
    }

    public static Command show(String title, String text, Command[] cmds, int type, Image icon, long timeout) {
        return Dialog.show(title, text, null, cmds, type, icon, timeout);
    }

    public static Command show(String title, String text, Command defaultCommand, Command[] cmds, int type, Image icon, long timeout) {
        return Dialog.show(title, text, defaultCommand, cmds, type, icon, timeout, null);
    }

    public static Command show(String title, String text, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        return Dialog.show(title, text, null, cmds, type, icon, timeout, transition);
    }

    public static Command show(String title, String text, Command defaultCommand, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        Object o;
        Hashtable h = UIManager.getInstance().getResourceBundle();
        if (h != null && text != null && (o = h.get(text)) != null) {
            text = (String)o;
        }
        TextArea t = new TextArea(text, 3, 30);
        t.setUIID("DialogBody");
        t.setEditable(false);
        t.setFocusable(false);
        return Dialog.show(title, t, defaultCommand, cmds, type, icon, timeout, transition);
    }

    public static boolean show(String title, String text, String okText, String cancelText) {
        return Dialog.show(title, text, defaultDialogType, null, okText, cancelText);
    }

    public static Command show(String title, Component body, Command[] cmds) {
        return Dialog.show(title, body, cmds, defaultDialogType, null);
    }

    public static Command show(String title, Component body, Command[] cmds, int type, Image icon) {
        return Dialog.show(title, body, cmds, type, icon, 0L);
    }

    public static Command show(String title, Component body, Command[] cmds, int type, Image icon, long timeout) {
        return Dialog.show(title, body, cmds, type, icon, timeout, null);
    }

    public static Command show(String title, Component body, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        return Dialog.show(title, body, null, cmds, type, icon, timeout, transition);
    }

    private void addButtonBar(Container c) {
        super.getContentPane().addComponent("South", (Component)c);
    }

    public void placeButtonCommands(Command[] cmds) {
        this.buttonCommands = cmds;
        Container buttonArea = UIManager.getInstance().isThemeConstant("dlgCommandGridBool", false) ? new Container(new GridLayout(1, cmds.length)) : (UIManager.getInstance().isThemeConstant("dlgCommandBoxBool", false) ? new Container(new BoxLayout(2)) : new Container(new FlowLayout(4)));
        buttonArea.setUIID("DialogCommandArea");
        buttonArea.setWidth(this.getWidth());
        if (dialogTitleCompatibilityMode) {
            super.getContentPane().addComponent("South", (Component)buttonArea);
        } else {
            this.addButtonBar(buttonArea);
        }
        if (cmds.length > 0) {
            int iter;
            int largest = Integer.parseInt(UIManager.getInstance().getThemeConstant("dlgCommandButtonSizeInt", "0"));
            for (iter = 0; iter < cmds.length; ++iter) {
                Button b = new Button(cmds[iter]);
                if (Display.getInstance().getDeviceType() == 3) {
                    b.setUIID("DialogButton");
                }
                largest = Math.max(b.getPreferredW(), largest);
                buttonArea.addComponent(b);
            }
            for (iter = 0; iter < cmds.length; ++iter) {
                buttonArea.getComponentAt(iter).setPreferredW(largest);
            }
            buttonArea.getComponentAt(0).requestFocus();
        }
    }

    public void keyReleased(int keyCode) {
        if (commandsAsButtons) {
            if (MenuBar.isLSK(keyCode) && this.buttonCommands != null && this.buttonCommands.length > 0) {
                this.dispatchCommand(this.buttonCommands[0], new ActionEvent(this.buttonCommands[0]));
                return;
            }
            if (MenuBar.isRSK(keyCode) && this.buttonCommands != null && this.buttonCommands.length > 1) {
                this.dispatchCommand(this.buttonCommands[1], new ActionEvent(this.buttonCommands[1]));
                return;
            }
        }
        super.keyReleased(keyCode);
    }

    public static Command show(String title, Component body, Command defaultCommand, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        Dialog dialog = new Dialog(title);
        dialog.dialogType = type;
        dialog.setTransitionInAnimator(transition);
        dialog.setTransitionOutAnimator(transition);
        dialog.lastCommandPressed = null;
        dialog.setLayout(new BorderLayout());
        if (cmds != null) {
            if (commandsAsButtons) {
                dialog.placeButtonCommands(cmds);
            } else {
                for (int iter = 0; iter < cmds.length; ++iter) {
                    dialog.addCommand(cmds[iter]);
                }
                if (cmds.length == 1) {
                    dialog.setDefaultCommand(cmds[0]);
                } else if (cmds.length == 2) {
                    dialog.setBackCommand(cmds[1]);
                }
            }
        }
        if (defaultCommand != null && !commandsAsButtons) {
            dialog.setDefaultCommand(defaultCommand);
        }
        dialog.addTitle();
        dialog.addComponent("Center", body);
        if (icon != null) {
            dialog.addComponent("East", (Component)new Label(icon));
        }
        if (timeout != 0L) {
            dialog.setTimeout(timeout);
        }
        if (body.isScrollable() || disableStaticDialogScrolling) {
            dialog.setScrollable(false);
        }
        dialog.show();
        return dialog.lastCommandPressed;
    }

    private void addTitle() {
        if (dialogTitleCompatibilityMode) {
            super.getContentPane().removeComponent(this.dialogTitleContainer);
            super.getContentPane().addComponent("North", (Component)this.dialogTitleContainer);
        }
    }

    protected void onShow() {
        if (this.dialogType > 0) {
            Display.getInstance().playDialogSound(this.dialogType);
        }
    }

    public void showBack() {
        this.showImpl(true);
    }

    public void setScrollable(boolean scrollable) {
        this.getContentPane().setScrollable(scrollable);
    }

    public void show() {
        this.showImpl(false);
    }

    private void showImpl(boolean reverse) {
        this.setDisposed(false);
        if (this.top > -1) {
            this.show(this.top, this.bottom, this.left, this.right, this.includeTitle, this.modal);
        } else if (this.modal) {
            if (this.getDialogPosition() == null) {
                super.showModal(reverse);
            } else {
                this.showPacked(this.getDialogPosition(), true);
            }
        } else {
            this.showModeless();
        }
    }

    public void showModeless() {
        this.modal = false;
        this.setDisposed(false);
        if (this.top > -1) {
            this.show(this.top, this.bottom, this.left, this.right, this.includeTitle, false);
        } else if (this.getDialogPosition() == null) {
            this.showDialog(false, false);
        } else {
            this.showPacked(this.getDialogPosition(), false);
        }
    }

    void showModal(int top, int bottom, int left, int right, boolean includeTitle, boolean modal, boolean reverse) {
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
        if (!dialogTitleCompatibilityMode && this.dialogTitle != null && UIManager.getInstance().isThemeConstant("hideEmptyTitleBool", false)) {
            this.dialogTitle.setVisible(this.dialogTitle.getText().length() > 0);
        }
        super.showModal(top, bottom, left, right, includeTitle, modal, reverse);
    }

    public Command showPopupDialog(Component c) {
        Command result;
        if (this.getDialogUIID().equals("Dialog") || this.getDialogUIID().equals("DialogContentPane")) {
            this.setDialogUIID("PopupDialog");
            if (this.getTitleComponent().getUIID().equals("DialogTitle")) {
                this.getTitleComponent().setUIID("PopupDialogTitle");
            }
        }
        this.disposeOnRotation = true;
        this.disposeWhenPointerOutOfBounds = true;
        Command backCommand = null;
        if (this.getBackCommand() == null) {
            backCommand = new Command("Back");
            this.setBackCommand(backCommand);
        }
        Container contentPane = super.getContentPane();
        Label title = super.getTitleComponent();
        int menuHeight = this.calcMenuHeight();
        if (!dialogTitleCompatibilityMode && this.dialogTitle != null && UIManager.getInstance().isThemeConstant("hideEmptyTitleBool", false)) {
            this.getTitleComponent().setVisible(this.getTitle().length() > 0);
        }
        this.revalidate();
        Style contentPaneStyle = this.getDialogStyle();
        boolean restoreArrow = false;
        if (UIManager.getInstance().isThemeConstant(this.getDialogUIID() + "ArrowBool", false)) {
            Image t = UIManager.getInstance().getThemeImageConstant(this.getDialogUIID() + "ArrowTopImage");
            Image b = UIManager.getInstance().getThemeImageConstant(this.getDialogUIID() + "ArrowBottomImage");
            Image l = UIManager.getInstance().getThemeImageConstant(this.getDialogUIID() + "ArrowLeftImage");
            Image r = UIManager.getInstance().getThemeImageConstant(this.getDialogUIID() + "ArrowRightImage");
            Border border = contentPaneStyle.getBorder();
            if (border != null) {
                border.setImageBorderSpecialTile(t, b, l, r, c);
                restoreArrow = true;
            }
        }
        int prefHeight = contentPane.getPreferredH();
        int prefWidth = contentPane.getPreferredW();
        if (contentPaneStyle.getBorder() != null) {
            prefWidth = Math.max(contentPaneStyle.getBorder().getMinimumWidth(), prefWidth);
            prefHeight = Math.max(contentPaneStyle.getBorder().getMinimumHeight(), prefHeight);
        }
        Rectangle componentPos = c.getSelectedRect();
        int availableHeight = Display.getInstance().getDisplayHeight() - menuHeight - title.getPreferredH();
        int availableWidth = Display.getInstance().getDisplayWidth();
        int width = Math.min(availableWidth, prefWidth);
        int x = 0;
        int y = 0;
        boolean showPortrait = Display.getInstance().isPortrait();
        if (showPortrait) {
            if (availableHeight < (availableWidth - c.getWidth()) / 2) {
                showPortrait = false;
            }
        } else if (availableHeight / 2 > availableWidth - c.getWidth()) {
            showPortrait = true;
        }
        if (showPortrait) {
            int height;
            int idealX;
            if (width < availableWidth && (idealX = componentPos.getX() - width / 2 + componentPos.getSize().getWidth() / 2) > 0) {
                x = idealX + width > availableWidth ? availableWidth - width : idealX;
            }
            if (componentPos.getY() < availableHeight / 2) {
                y = componentPos.getY() + componentPos.getSize().getHeight();
                height = Math.min(prefHeight, availableHeight - y);
                result = this.show(y, availableHeight - height - y, x, availableWidth - width - x, true, true);
            } else {
                height = Math.min(prefHeight, availableHeight - (availableHeight - componentPos.getY()));
                y = componentPos.getY() - height;
                result = this.show(y, availableHeight - height - y, x, availableWidth - width - x, true, true);
            }
        } else {
            int idealY;
            int height = Math.min(prefHeight, availableHeight);
            if (height < availableHeight && (idealY = componentPos.getY() - height / 2 + componentPos.getSize().getHeight() / 2) > 0) {
                y = idealY + height > availableHeight ? availableHeight - height : idealY;
            }
            if (componentPos.getX() < availableWidth / 2) {
                x = componentPos.getX() + componentPos.getSize().getWidth();
                width = Math.min(prefWidth, availableWidth - x);
                result = this.show(y, availableHeight - height - y, x, availableWidth - width - x, true, true);
            } else {
                width = Math.min(prefWidth, availableWidth - (availableWidth - componentPos.getX()));
                x = componentPos.getX() - width;
                result = this.show(y, availableHeight - height - y, x, availableWidth - width - x, true, true);
            }
        }
        if (restoreArrow) {
            contentPaneStyle.getBorder().clearImageBorderSpecialTile();
        }
        if (result == backCommand) {
            return null;
        }
        return result;
    }

    private int calcMenuHeight() {
        if (this.getSoftButtonCount() > 1) {
            Container menuBar = this.getSoftButton(0).getParent();
            Style menuStyle = menuBar.getStyle();
            return menuBar.getPreferredH() + menuStyle.getMargin(false, 0) + menuStyle.getMargin(false, 2);
        }
        return 0;
    }

    public Command showPacked(String position, boolean modal) {
        this.position = position;
        int height = Display.getInstance().getDisplayHeight();
        int width = Display.getInstance().getDisplayWidth();
        if (this.top > -1) {
            this.refreshTheme();
        }
        Container contentPane = super.getContentPane();
        Label title = super.getTitleComponent();
        if (!dialogTitleCompatibilityMode && this.dialogTitle != null && UIManager.getInstance().isThemeConstant("hideEmptyTitleBool", false)) {
            this.getTitleComponent().setVisible(this.getTitle().length() > 0);
        }
        Style contentPaneStyle = this.getDialogStyle();
        int menuHeight = this.calcMenuHeight();
        this.revalidate();
        int prefHeight = contentPane.getPreferredH();
        int prefWidth = contentPane.getPreferredW();
        prefWidth = Math.min(prefWidth, width);
        if (contentPaneStyle.getBorder() != null) {
            prefWidth = Math.max(contentPaneStyle.getBorder().getMinimumWidth(), prefWidth);
            prefHeight = Math.max(contentPaneStyle.getBorder().getMinimumHeight(), prefHeight);
            if (UIManager.getInstance().getThemeName().equals("NokiaTheme")) {
                prefHeight += this.dialogContentPane.getStyle().getPadding(0);
                prefHeight += this.dialogContentPane.getStyle().getPadding(2);
            }
        }
        height = height - menuHeight - title.getPreferredH();
        int topBottom = Math.max(0, (height - (prefHeight += contentPaneStyle.getMargin(0) + contentPaneStyle.getMargin(2))) / 2);
        int leftRight = Math.max(0, (width - prefWidth) / 2);
        if (position.equals("Center")) {
            this.show(topBottom, topBottom, leftRight, leftRight, true, modal);
            return this.lastCommandPressed;
        }
        if (position.equals("East")) {
            this.show(topBottom, topBottom, Math.max(0, width - prefWidth), 0, true, modal);
            return this.lastCommandPressed;
        }
        if (position.equals("West")) {
            this.show(topBottom, topBottom, 0, Math.max(0, width - prefWidth), true, modal);
            return this.lastCommandPressed;
        }
        if (position.equals("North")) {
            this.show(0, Math.max(0, height - prefHeight), leftRight, leftRight, true, modal);
            return this.lastCommandPressed;
        }
        if (position.equals("South")) {
            this.show(Math.max(0, height - prefHeight), 0, leftRight, leftRight, true, modal);
            return this.lastCommandPressed;
        }
        throw new IllegalArgumentException("Unknown position: " + position);
    }

    public void dispose() {
        this.setDisposed(true);
        if (!this.menu) {
            super.dispose();
        }
    }

    public Command showDialog() {
        this.lastCommandPressed = null;
        this.show();
        return this.lastCommandPressed;
    }

    protected void actionCommand(Command cmd) {
        if (!this.autoDispose || this.lastCommandPressed == null) {
            this.lastCommandPressed = cmd;
        }
        if (this.menu || this.autoDispose && cmd.isDisposesDialog()) {
            this.dispose();
        }
    }

    public boolean animate() {
        this.isTimedOut();
        return false;
    }

    private boolean isTimedOut() {
        if (this.time != 0L && System.currentTimeMillis() >= this.time) {
            this.time = 0L;
            this.dispose();
            this.deregisterAnimatedInternal(this);
            return true;
        }
        return false;
    }

    boolean isMenu() {
        return this.menu;
    }

    protected void setMenu(boolean menu) {
        this.menu = menu;
    }

    void addSelectCommand() {
        if (!this.menu) {
            this.getMenuBar().addSelectCommand(this.getSelectCommandText());
        }
    }

    boolean isDisposed() {
        return this.disposed || this.isTimedOut();
    }

    void setDisposed(boolean disposed) {
        this.disposed = disposed;
    }

    public boolean isAutoDispose() {
        return this.autoDispose;
    }

    public void setAutoDispose(boolean autoDispose) {
        this.autoDispose = autoDispose;
    }

    public static void setDefaultDialogPosition(String p) {
        defaultDialogPosition = p;
    }

    public static String getDefaultDialogPosition() {
        return defaultDialogPosition;
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(int dialogType) {
        this.dialogType = dialogType;
    }

    public static void setDefaultDialogType(int d) {
        defaultDialogType = d;
    }

    public static int getDefaultDialogType() {
        return defaultDialogType;
    }

    public static void setAutoAdjustDialogSize(boolean a2) {
        autoAdjustDialogSize = a2;
    }

    public static void setDisableStaticDialogScrolling(boolean d) {
        disableStaticDialogScrolling = d;
    }

    public static boolean isDisableStaticDialogScrolling() {
        return disableStaticDialogScrolling;
    }

    public static void setCommandsAsButtons(boolean c) {
        if (!Display.getInstance().isPureTouch()) {
            commandsAsButtons = c;
        }
    }

    public static boolean isCommandsAsButtons() {
        return commandsAsButtons;
    }

    public void setDisposeWhenPointerOutOfBounds(boolean disposeWhenPointerOutOfBounds) {
        this.disposeWhenPointerOutOfBounds = disposeWhenPointerOutOfBounds;
    }

    public boolean isDisposeWhenPointerOutOfBounds() {
        return this.disposeWhenPointerOutOfBounds;
    }

    public void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        if (this.disposeWhenPointerOutOfBounds && !this.getTitleComponent().contains(x, y) && !this.getContentPane().contains(x, y) && !this.getMenuBar().contains(x, y)) {
            this.dispose();
        }
    }

    public String getDialogPosition() {
        return this.dialogPosition;
    }

    public void setDialogPosition(String dialogPosition) {
        this.dialogPosition = dialogPosition;
    }

    public void setDisposeOnRotation(boolean value) {
        this.disposeOnRotation = value;
    }

    public boolean getDisposeOnRotation() {
        return this.disposeOnRotation;
    }

    static {
        autoAdjustDialogSize = true;
        defaultDialogType = 4;
    }
}

