/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.impl.s40;

import com.nokia.lwuit.GestureHandler;
import com.nokia.mid.ui.gestures.GestureEvent;
import com.nokia.mid.ui.gestures.GestureInteractiveZone;
import com.nokia.mid.ui.gestures.GestureListener;
import com.nokia.mid.ui.gestures.GestureRegistrationManager;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.impl.s40.S40Implementation;
import java.util.Vector;

public class S40GestureImplementation
extends S40Implementation {
    private GestureHandler currentFormGestureHandler;
    private GestureHandler globalGestureHandler;
    private Vector gestureListeners = new Vector();
    private GestureListenerImpl internalListener;
    private boolean registered = false;
    private GestureInteractiveZone giz;

    public void init(Object m) {
        super.init(m);
        this.internalListener = new GestureListenerImpl();
    }

    private void registerAllGesturesToCanvas() {
        int gestures = 31;
        if (Display.getInstance().getDeviceType() == 2 || Display.getInstance().getDeviceType() == 3) {
            gestures = 49407;
        }
        this.giz = new GestureInteractiveZone(gestures);
        this.registerToCanvas();
    }

    private void registerToCanvas() {
        GestureRegistrationManager.unregisterAll((Object)this.canvas);
        GestureRegistrationManager.register((Object)this.canvas, (GestureInteractiveZone)this.giz);
        GestureRegistrationManager.setListener((Object)this.canvas, (GestureListener)this.internalListener);
        this.registered = true;
    }

    private void registerGesture(int gesture) {
        int gestures = gesture;
        if (this.giz != null) {
            gestures = this.giz.getGestures() | gesture;
        }
        this.giz = new GestureInteractiveZone(gestures);
        this.registerToCanvas();
    }

    public void addGestureHandler(GestureHandler l) {
        if (l.getGestures() == 49279) {
            this.registerAllGesturesToCanvas();
        } else {
            this.registerGesture(l.getGestures());
        }
        this.gestureListeners.addElement(l);
    }

    public synchronized void setCurrentGestureListener(Form f) {
        int l = this.gestureListeners.size();
        GestureHandler h = null;
        GestureHandler c = null;
        for (int i = 0; i < l; ++i) {
            c = (GestureHandler)this.gestureListeners.elementAt(i);
            if (c.getForm() != f) continue;
            h = c;
            break;
        }
        this.currentFormGestureHandler = h;
    }

    public synchronized void removeGestureHandler(GestureHandler l) {
        this.gestureListeners.removeElement(l);
    }

    public synchronized void setGlobalGestureHandler(GestureHandler l) {
        if (l.getGestures() == 49279) {
            this.registerAllGesturesToCanvas();
        } else {
            this.registerGesture(l.getGestures());
        }
        this.globalGestureHandler = l;
    }

    public boolean areGesturesSupported() {
        return true;
    }

    private class GestureListenerImpl
    implements GestureListener {
        private GestureListenerImpl() {
        }

        public void gestureAction(Object container, GestureInteractiveZone gestureInteractiveZone, GestureEvent gestureEvent) {
            if (S40GestureImplementation.this.currentFormGestureHandler != null && (S40GestureImplementation.this.currentFormGestureHandler.getGestures() & gestureEvent.getType()) != 0 && Display.getInstance().getCurrent() == S40GestureImplementation.this.currentFormGestureHandler.getForm()) {
                S40GestureImplementation.this.currentFormGestureHandler.gestureAction(gestureEvent);
            }
            if (S40GestureImplementation.this.globalGestureHandler != null && (S40GestureImplementation.this.globalGestureHandler.getGestures() & gestureEvent.getType()) != 0) {
                S40GestureImplementation.this.globalGestureHandler.gestureAction(gestureEvent);
            }
        }
    }
}

