/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;
import java.util.Vector;

public class FlowLayout
extends Layout {
    private boolean fillRows;
    private int orientation = 1;
    private int valign = 0;
    private boolean vAlignByRow;

    public FlowLayout() {
    }

    public FlowLayout(int orientation) {
        this.orientation = orientation;
    }

    public void layoutContainer(Container parent) {
        int x = parent.getStyle().getPadding(parent.isRTL(), 1);
        int width = parent.getLayoutWidth() - parent.getSideGap() - parent.getStyle().getPadding(parent.isRTL(), 3) - x;
        boolean rtl = parent.isRTL();
        if (rtl) {
            x += parent.getSideGap();
        }
        int initX = x;
        int y = parent.getStyle().getPadding(false, 0);
        int rowH = 0;
        int start = 0;
        int maxComponentWidth = width;
        int numOfcomponents = parent.getComponentCount();
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            Style style = cmp.getStyle();
            int marginX = style.getMargin(false, 1) + style.getMargin(false, 3);
            cmp.setWidth(Math.min(maxComponentWidth - marginX, cmp.getPreferredW()));
            cmp.setHeight(cmp.getPreferredH());
            if (x == parent.getStyle().getPadding(rtl, 1) || x + cmp.getPreferredW() <= width) {
                x += cmp.getStyle().getMargin(false, 1);
                if (rtl) {
                    cmp.setX(Math.max(width + initX - (x - initX) - cmp.getPreferredW(), style.getMargin(false, 1)));
                } else {
                    cmp.setX(x);
                }
                cmp.setY(y + cmp.getStyle().getMargin(cmp.isRTL(), 0));
                x += cmp.getPreferredW() + cmp.getStyle().getMargin(false, 3);
                rowH = Math.max(rowH, cmp.getPreferredH() + cmp.getStyle().getMargin(false, 0) + cmp.getStyle().getMargin(false, 2));
                continue;
            }
            this.moveComponents(parent, parent.getStyle().getPadding(rtl, 1), y, width - x, rowH, start, i);
            this.fillRow(parent, width, start, i);
            x = initX + cmp.getStyle().getMargin(false, 1);
            y += rowH;
            if (rtl) {
                cmp.setX(Math.max(width + initX - (x - initX) - cmp.getPreferredW(), style.getMargin(false, 1)));
            } else {
                cmp.setX(x);
            }
            cmp.setY(y + cmp.getStyle().getMargin(false, 0));
            rowH = cmp.getPreferredH() + cmp.getStyle().getMargin(false, 0) + cmp.getStyle().getMargin(false, 2);
            x += cmp.getPreferredW() + cmp.getStyle().getMargin(false, 3);
            start = i;
        }
        this.moveComponents(parent, parent.getStyle().getPadding(parent.isRTL(), 1), y, width - x, rowH, start, numOfcomponents);
        this.fillRow(parent, width, start, numOfcomponents);
    }

    private void fillRow(Container target, int width, int start, int end) {
        if (this.fillRows && end - start > 0) {
            Component c;
            int i;
            Vector<Component> toBeStretched = new Vector<Component>();
            int stretchWidth = width / (end - start);
            for (i = start; i < end; ++i) {
                Component c2 = target.getComponentAt(i);
                toBeStretched.addElement(c2);
            }
            int size = toBeStretched.size();
            for (i = 0; i < size; ++i) {
                c = (Component)toBeStretched.elementAt(i);
                int w = c.getWidth();
                if (w < stretchWidth) continue;
                toBeStretched.removeElement(c);
                size = toBeStretched.size();
                if (size > 0) {
                    stretchWidth = (width -= c.getWidth()) / size;
                    i = 0;
                    continue;
                }
                return;
            }
            int x = 0;
            for (int i2 = start; i2 < end; ++i2) {
                boolean rtl;
                c = target.getComponentAt(i2);
                if (i2 == 0) {
                    x = c.getX();
                } else {
                    c.setX(x);
                }
                if (toBeStretched.contains(c)) {
                    c.setWidth(stretchWidth);
                }
                if (rtl = target.isRTL()) {
                    x -= c.getWidth();
                    continue;
                }
                x += c.getWidth();
            }
        }
    }

    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd) {
        switch (this.orientation) {
            case 4: {
                if (target.isRTL()) {
                    x -= width / 2;
                    break;
                }
                x += width / 2;
                break;
            }
            case 3: {
                x += width;
            }
        }
        Style parentStyle = target.getStyle();
        int parentPadding = parentStyle.getPadding(1) + parentStyle.getPadding(3);
        block8: for (int i = rowStart; i < rowEnd; ++i) {
            Component m = target.getComponentAt(i);
            Style style = m.getStyle();
            int marginX = style.getMargin(false, 1) + style.getMargin(false, 3);
            if (m.getWidth() + marginX < target.getWidth() - parentPadding) {
                m.setX(m.getX() + x);
            }
            int marginTop = m.getStyle().getMargin(false, 0);
            switch (this.valign) {
                case 2: {
                    if (this.vAlignByRow) {
                        m.setY(y + Math.max(marginTop, height - m.getHeight()));
                        continue block8;
                    }
                    m.setY(y + Math.max(marginTop, target.getHeight() - m.getHeight()));
                    continue block8;
                }
                case 4: {
                    if (this.vAlignByRow) {
                        m.setY(y + Math.max(marginTop, (height - m.getHeight()) / 2));
                        continue block8;
                    }
                    m.setY(y + Math.max(marginTop, (target.getHeight() - m.getHeight()) / 2));
                    continue block8;
                }
                default: {
                    m.setY(y + marginTop);
                }
            }
        }
    }

    public Dimension getPreferredSize(Container parent) {
        int parentWidth = parent.getWidth();
        if (parentWidth == 0) {
            parent.invalidate();
        }
        int width = 0;
        int height = 0;
        int w = 0;
        int numOfcomponents = parent.getComponentCount();
        Style parentStyle = parent.getStyle();
        int parentPadding = parentStyle.getPadding(1) + parentStyle.getPadding(3);
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            height = Math.max(height, cmp.getPreferredH() + cmp.getStyle().getMargin(false, 0) + cmp.getStyle().getMargin(false, 2));
            int prefW = cmp.getPreferredW() + cmp.getStyle().getMargin(false, 3) + cmp.getStyle().getMargin(false, 1);
            if (parentWidth <= parentPadding || (w += prefW) < parentWidth || i <= 0) continue;
            height += cmp.getPreferredH() + cmp.getStyle().getMargin(false, 0) + cmp.getStyle().getMargin(false, 2);
            width = Math.max(w, width);
            w = prefW;
        }
        width = Math.max(w, width);
        return new Dimension(width + parent.getStyle().getPadding(false, 1) + parent.getStyle().getPadding(false, 3), height + parent.getStyle().getPadding(false, 0) + parent.getStyle().getPadding(false, 2));
    }

    public String toString() {
        return "FlowLayout";
    }

    public boolean isFillRows() {
        return this.fillRows;
    }

    public void setFillRows(boolean fillRows) {
        this.fillRows = fillRows;
    }

    public int getValign() {
        return this.valign;
    }

    public void setValign(int valign) {
        this.valign = valign;
    }

    public void setValignByRow(boolean internal) {
        this.vAlignByRow = internal;
    }

    public boolean isValignByRow() {
        return this.vAlignByRow;
    }

    public int getAlign() {
        return this.orientation;
    }

    public void setAlign(int orientation) {
        this.orientation = orientation;
    }

    public boolean equals(Object o) {
        return super.equals(o) && ((FlowLayout)o).orientation == this.orientation && ((FlowLayout)o).valign == this.valign && ((FlowLayout)o).fillRows == this.fillRows;
    }
}

