/*
 * Decompiled with CFR 0.152.
 */
package gui;

import Main.Main;
import gui.Gradient;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class Panel
extends GameCanvas {
    protected final Graphics gr;
    protected final int sw;
    protected final int sh;
    protected final int fh;
    protected final Font f;
    private final String title;
    private final int height;
    private final int y;
    private Image[] icons;
    private boolean active = false;
    private int position;
    private int[] cells;

    public Panel(String title1, Image[] icons1) {
        super(false);
        this.y = 3;
        this.setFullScreenMode(true);
        this.gr = this.getGraphics();
        this.f = Font.getFont((int)0, (int)0, (int)8);
        this.fh = this.f.getHeight();
        this.title = title1;
        this.sw = this.getWidth();
        this.sh = this.getHeight();
        this.height = 25;
        this.icons = icons1;
        this.position = 0;
        this.gr.setFont(this.f);
        this.createCells();
    }

    private void createCells() {
        this.cells = new int[this.icons.length];
        int pix = 5;
        int count = 1;
        for (int i = this.icons.length - 1; i > -1; --i) {
            this.cells[i] = this.sw - (pix + 18) * count;
            ++count;
        }
    }

    protected final void clearScreen() {
        this.gr.setColor(0xFFFFFF);
        this.gr.fillRect(0, 0, this.sw, this.sh);
    }

    protected final void panel_draw() {
        Gradient.gradientBox(this.gr, 0x555555, 0, 0, 0, this.sw, this.height, 0, 'a');
        this.gr.setColor(0xFFFFFF);
        this.gr.drawImage(Main.logo, 2, 3, 20);
        if (this.title != null) {
            this.gr.drawString(this.title, 22, (this.height - this.f.getHeight()) / 2, 20);
        }
        if (this.active) {
            this.drawCursor();
        }
        for (int i = 0; i < this.icons.length; ++i) {
            this.gr.drawImage(this.icons[i], this.cells[i], 3, 20);
        }
    }

    private void drawCursor() {
        Gradient.gradientBox(this.gr, 0x9999FF, 0x1111FF, this.cells[this.position] - 1, 2, 20, 20, 0, 'b');
    }

    protected final void panel_setActive(boolean option) {
        this.active = option;
    }

    protected final boolean panel_getActive() {
        return this.active;
    }

    protected final void panel_moveleft() {
        if (this.active) {
            --this.position;
            if (this.position < 0) {
                this.position = 0;
            }
        }
    }

    protected final void panel_moveright() {
        if (this.active) {
            ++this.position;
            if (this.position > this.icons.length - 1) {
                this.position = this.icons.length - 1;
            }
        }
    }

    protected final void panel_setCursor(int pos) {
        if (pos > this.icons.length - 1) {
            pos = this.icons.length - 1;
        }
        if (pos < 0) {
            pos = 0;
        }
        this.position = pos;
    }

    protected final int panel_getPos() {
        return this.position;
    }

    protected final int[] panel_getCells() {
        return this.cells;
    }

    protected final int panel_getHeight() {
        return this.height;
    }
}

