/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.LangWindow;
import gui.SwapWindow;
import javax.microedition.lcdui.Graphics;

public final class LangWindows {
    public LangWindow lw1;
    public LangWindow lw2;
    public SwapWindow lw3;
    private boolean active;
    private int index = 0;
    private int height;
    private int[] pos = new int[4];

    public LangWindows(int sw, int sh, int y, String text1, String text2, Graphics gr) {
        int ww = sw / 2 - 6;
        this.height = gr.getFont().getHeight() + 4;
        this.pos[0] = 2;
        this.lw1 = new LangWindow(2, y, ww, this.height, text1, gr);
        this.pos[1] = 2 + ww - 6;
        this.lw2 = new LangWindow(sw - ww - 2, y, ww, this.height, text2, gr);
        this.pos[2] = sw - ww - 2 + 6;
        this.pos[3] = sw - 2;
        this.lw3 = new SwapWindow(sw / 2 - 10, y, 20, 20, gr);
        this.active = false;
        this.setActive(this.active);
    }

    protected void draw() {
        this.lw1.draw();
        this.lw2.draw();
        this.lw3.draw();
    }

    protected boolean getActive() {
        return this.active;
    }

    protected final int getHeight() {
        return this.height;
    }

    protected final int[] getPositions() {
        return this.pos;
    }

    protected final int getSelectedIndex() {
        return this.index;
    }

    protected final void setSelectedIndex(int ind) {
        if (ind > 2) {
            ind = 2;
        }
        if (ind < 0) {
            ind = 0;
        }
        this.index = ind;
    }

    protected void setActive(boolean active) {
        this.active = active;
        if (active) {
            switch (this.index) {
                case 0: {
                    this.lw1.setActive(active);
                    break;
                }
                case 1: {
                    this.lw3.setActive(active);
                    break;
                }
                case 2: {
                    this.lw2.setActive(active);
                }
            }
        } else {
            this.lw1.setActive(active);
            this.lw2.setActive(active);
            this.lw3.setActive(active);
        }
    }

    protected void setCursor(int index) {
        this.index = index;
        if (this.active) {
            switch (index) {
                case 0: {
                    this.lw1.setActive(true);
                    this.lw2.setActive(false);
                    this.lw3.setActive(false);
                    break;
                }
                case 1: {
                    this.lw1.setActive(false);
                    this.lw2.setActive(false);
                    this.lw3.setActive(true);
                    break;
                }
                case 2: {
                    this.lw1.setActive(false);
                    this.lw2.setActive(true);
                    this.lw3.setActive(false);
                }
            }
        }
    }

    protected void moveRight() {
        ++this.index;
        if (this.index > 2) {
            this.index = 2;
        }
        if (this.active) {
            switch (this.index) {
                case 0: {
                    this.lw1.setActive(true);
                    this.lw2.setActive(false);
                    this.lw3.setActive(false);
                    break;
                }
                case 1: {
                    this.lw1.setActive(false);
                    this.lw2.setActive(false);
                    this.lw3.setActive(true);
                    break;
                }
                case 2: {
                    this.lw1.setActive(false);
                    this.lw2.setActive(true);
                    this.lw3.setActive(false);
                }
            }
        }
    }

    protected void moveLeft() {
        --this.index;
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.active) {
            switch (this.index) {
                case 0: {
                    this.lw1.setActive(true);
                    this.lw2.setActive(false);
                    this.lw3.setActive(false);
                    break;
                }
                case 1: {
                    this.lw1.setActive(false);
                    this.lw2.setActive(false);
                    this.lw3.setActive(true);
                    break;
                }
                case 2: {
                    this.lw1.setActive(false);
                    this.lw2.setActive(true);
                    this.lw3.setActive(false);
                }
            }
        }
    }
}

