/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.utils;

public class Math2D {
    public static long COMPUTED_ROOTS = 0L;
    public static final int BITS = 10;
    public static final long UNIT = 1024L;
    public static final long PI = 3217L;
    public static final long[] SIN = new long[]{0L, 18L, 36L, 54L, 71L, 89L, 107L, 125L, 143L, 160L, 178L, 195L, 213L, 230L, 248L, 265L, 282L, 299L, 316L, 333L, 350L, 367L, 384L, 400L, 416L, 433L, 449L, 465L, 481L, 496L, 512L, 527L, 543L, 558L, 573L, 587L, 602L, 616L, 630L, 644L, 658L, 672L, 685L, 698L, 711L, 724L, 737L, 749L, 761L, 773L, 784L, 796L, 807L, 818L, 828L, 839L, 849L, 859L, 868L, 878L, 887L, 896L, 904L, 912L, 920L, 928L, 935L, 943L, 949L, 956L, 962L, 968L, 974L, 979L, 984L, 989L, 994L, 998L, 1002L, 1005L, 1008L, 1011L, 1014L, 1016L, 1018L, 1020L, 1022L, 1023L, 1023L, 1024L, 1024L};

    public static int getPixel(long l) {
        return (int)(l >>> 10);
    }

    public static long sqrt(long l) {
        ++COMPUTED_ROOTS;
        if (l == 0L) {
            return 0L;
        }
        long l2 = l <<= 10;
        long l3 = 0L;
        while (l3 != l2) {
            l3 = l2;
            l2 = (l << 10) / l2 + l2 >> 1;
        }
        return l2 >> 5;
    }

    public static long pow2(long l) {
        return l * l >> 10;
    }

    public static long[] normalize(long l, long l2) {
        long[] lArray = new long[]{0L, 0L};
        long[] lArray2 = lArray;
        lArray[1] = Math2D.sqrt(l * l + l2 * l2 >> 10);
        if (lArray2[1] == 0L) {
            lArray2[0] = l;
            lArray2[1] = l2;
            return lArray2;
        }
        lArray2[0] = (l << 10) / lArray2[1];
        lArray2[1] = (l2 << 10) / lArray2[1];
        return lArray2;
    }

    public static boolean isPointOverRect(long l, long l2, long l3, long l4, long l5, long l6) {
        long[] lArray = Math2D.getPointOverRect(l, l2, l3, l4, l5, l6);
        return Math.min(l3, l5) <= lArray[0] && lArray[0] <= Math.max(l3, l5) && Math.min(l4, l6) <= lArray[1] && lArray[1] <= Math.max(l4, l6);
    }

    public static boolean isPointOverRect(long l, long l2, long l3, long l4, long l5, long l6, long[] lArray) {
        lArray = Math2D.getPointOverRect(l, l2, l3, l4, l5, l6);
        return Math.min(l3, l5) <= lArray[0] && lArray[0] <= Math.max(l3, l5) && Math.min(l4, l6) <= lArray[1] && lArray[1] <= Math.max(l4, l6);
    }

    public static long[] getPointOverRect(long l, long l2, long l3, long l4, long l5, long l6) {
        long[] lArray = new long[]{0L, 0L};
        if (Math.abs(l3 - l5) < 1024L) {
            lArray[0] = l3;
            lArray[1] = l2;
        } else if (Math.abs(l4 - l6) < 1024L) {
            lArray[0] = l;
            lArray[1] = l4;
        } else {
            long l7 = (l6 - l4 << 10) / (l5 - l3);
            long l8 = (l << 10) / l7;
            l8 += l7 * l3 >> 10;
            l8 += l2 - l4;
            l8 = l7 * l8 >> 10;
            lArray[0] = (l8 << 10) / ((l7 * l7 >> 10) + 1024L);
            lArray[1] = l4 + (l7 * (lArray[0] - l3) >> 10);
        }
        return lArray;
    }

    public static int getRelativePosition(long l, long l2, long l3, long l4, long l5, long l6) {
        if (l3 == l5) {
            return 0;
        }
        long[] lArray = Math2D.getPointOverRect(l, l2, l3, l4, l5, l6);
        if (l2 > lArray[1]) {
            return 1;
        }
        if (l2 < lArray[1]) {
            return -1;
        }
        return 0;
    }

    public static boolean intersectionPointRects(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long[] lArray) {
        if (Math.abs(l3 - l) <= 1024L && Math.abs(l7 - l5) <= 1024L) {
            return Math.abs(l7 - l) <= 1024L;
        }
        if (Math.abs(l3 - l) <= 1024L) {
            if (lArray != null) {
                long l9 = (l8 - l6 << 10) / (l7 - l5);
                lArray[0] = l;
                lArray[1] = (l9 * (lArray[0] - l5) >> 10) + l6;
            }
            return true;
        }
        if (Math.abs(l7 - l5) <= 1024L) {
            if (lArray != null) {
                long l10 = (l4 - l2 << 10) / (l3 - l);
                lArray[0] = l5;
                lArray[1] = (l10 * (lArray[0] - l) >> 10) + l2;
            }
            return true;
        }
        long l11 = (l4 - l2 << 10) / (l3 - l);
        long l12 = (l8 - l6 << 10) / (l7 - l5);
        if (l11 == l12) {
            return l6 - l2 == l11 * (l5 - l);
        }
        if (lArray != null) {
            lArray[0] = l6 - l2 + (l11 * l >> 10) - (l12 * l5 >> 10);
            lArray[0] = (lArray[0] << 10) / (l11 - l12);
            lArray[1] = l12 == 0L ? l6 : (l11 * (lArray[0] - l) >> 10) + l2;
        }
        return true;
    }

    public static boolean intersectionPointSegments(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long[] lArray) {
        if (lArray == null) {
            lArray = new long[2];
        }
        return Math2D.intersectionPointRects(l, l2, l3, l4, l5, l6, l7, l8, lArray) && Math.min(l, l3) <= lArray[0] && lArray[0] <= Math.max(l, l3) && Math.min(l2, l4) <= lArray[1] && lArray[1] <= Math.max(l2, l4) && Math.min(l5, l7) <= lArray[0] && lArray[0] <= Math.max(l5, l7) && Math.min(l6, l8) <= lArray[1] && lArray[1] <= Math.max(l6, l8);
    }

    public static int intersectionPolygonSegment(long[] lArray, long[] lArray2, long l, long l2, long l3, long l4, long[] lArray3) {
        for (int i = 0; i < lArray.length - 1; ++i) {
            if (!Math2D.intersectionPointSegments(lArray[i], lArray2[i], lArray[i + 1], lArray2[i + 1], l, l2, l3, l4, lArray3)) continue;
            return i;
        }
        if (Math2D.intersectionPointSegments(lArray[lArray.length - 1], lArray2[lArray.length - 1], lArray[0], lArray2[0], l, l2, l3, l4, lArray3)) {
            return lArray.length - 1;
        }
        return -1;
    }

    public static long[] rotatePoint(long l, long l2, int n) {
        long[] lArray = new long[]{0L, 0L};
        long[] lArray2 = lArray;
        lArray[0] = l * Math2D.cos(n) - l2 * Math2D.sin(n) >> 10;
        lArray2[1] = l2 * Math2D.cos(n) + l * Math2D.sin(n) >> 10;
        return lArray2;
    }

    public static long[] rotatePoint(long l, long l2, int n, long l3, long l4) {
        long[] lArray = new long[]{0L, 0L};
        long[] lArray2 = lArray;
        lArray[0] = (l - l3) * Math2D.cos(n) - (l2 - l4) * Math2D.sin(n) >> 10;
        lArray2[1] = (l2 - l4) * Math2D.cos(n) + (l - l3) * Math2D.sin(n) >> 10;
        lArray2[0] = lArray2[0] + l3;
        lArray2[1] = lArray2[1] + l4;
        return lArray2;
    }

    public static long sin(int n) {
        if (0 <= n && n <= 90) {
            return SIN[n];
        }
        if (-90 <= n && n < 0) {
            return -SIN[-n];
        }
        if (90 < n && n <= 180) {
            return SIN[180 - n];
        }
        if (-180 <= n && n < -90) {
            return -SIN[180 + n];
        }
        if (n > 180) {
            while (n > 180) {
                n -= 360;
            }
        } else if (n < 180) {
            while (n < 0) {
                n += 360;
            }
        } else {
            System.out.println("CAN'T COMPUTE sin(" + n + ")");
        }
        return Math2D.sin(n);
    }

    public static long cos(int n) {
        return Math2D.sin(90 + n);
    }

    public static int atan(long l, long l2, long l3, long l4) {
        long l5;
        long l6 = l3 - l;
        long l7 = l4 - l2;
        long l8 = 804L;
        long l9 = 3L * l8;
        long l10 = 5L * l8;
        long l11 = 7L * l8;
        long l12 = Math.abs(l7);
        if (l6 == 0L) {
            if (l7 < 0L) {
                return 90;
            }
            if (l7 > 90L) {
                return 270;
            }
            return 0;
        }
        if (l7 == 0L) {
            if (l6 >= 0L) {
                return 0;
            }
            return 180;
        }
        if (l6 > 0L) {
            if (l7 < 0L) {
                long l13 = l6 - l12 << 10;
                l5 = l8 - l8 * (l13 /= l6 + l12);
            } else {
                long l14 = l6 - l12 << 10;
                l5 = l11 - l8 * (l14 /= l6 + l12);
            }
        } else if (l7 < 0L) {
            long l15 = l6 + l12 << 10;
            l5 = l9 - l8 * (l15 /= l12 - l6);
        } else {
            long l16 = l6 + l12 << 10;
            l5 = l10 - l8 * (l16 /= l12 - l6);
        }
        l5 = l5 * 180L / 3217L >> 10;
        if (l6 >= 0L) {
            if (l7 > 0L) {
                return (int)(-l5 - 45L);
            }
            return (int)(l5 + 45L);
        }
        if (l7 > 0L) {
            return (int)(-l5 + 45L + 180L);
        }
        return (int)(l5 - 45L + 180L);
    }

    public static int atan2(long l, long l2, long l3, long l4) {
        long l5;
        long l6 = l3 - l;
        long l7 = l4 - l2;
        long l8 = 804L;
        long l9 = 3L * l8;
        long l10 = Math.abs(l7);
        if (l6 == 0L) {
            if (l7 < 0L) {
                return 90;
            }
            if (l7 > 90L) {
                return 270;
            }
            return 0;
        }
        if (l7 == 0L) {
            if (l6 >= 0L) {
                return 0;
            }
            return 180;
        }
        if (l6 < 0L) {
            l6 = Math.abs(l6);
        }
        if (l6 > 0L) {
            long l11 = l6 - l10 << 10;
            l5 = l8 - l8 * (l11 /= l6 + l10);
        } else {
            long l12 = l6 + l10 << 10;
            l5 = l9 - l8 * (l12 /= l10 - l6);
        }
        l5 = l5 * 180L / 3217L >> 10;
        if (l6 >= 0L) {
            if (l7 < 0L) {
                return (int)(-l5 - 45L);
            }
            return (int)(l5 + 45L);
        }
        if (l7 < 0L) {
            return (int)(-l5 + 45L);
        }
        return (int)(l5 - 45L);
    }

    public static int atan_original(long l, long l2, long l3, long l4) {
        long l5;
        long l6 = l3 - l;
        long l7 = l4 - l2;
        long l8 = 804L;
        long l9 = 3L * l8;
        long l10 = Math.abs(l7);
        if (l6 == 0L) {
            return 90;
        }
        if (l7 == 0L) {
            return 0;
        }
        if (l6 > 0L) {
            long l11 = l6 - l10 << 10;
            l5 = l8 - l8 * (l11 /= l6 + l10);
        } else {
            long l12 = l6 + l10 << 10;
            l5 = l9 - l8 * (l12 /= l10 - l6);
        }
        l5 = l5 * 180L / 3217L >> 10;
        if (l6 >= 0L) {
            if (l7 < 0L) {
                return (int)(-l5 - 45L);
            }
            return (int)(l5 + 45L);
        }
        if (l7 < 0L) {
            return (int)(-l5 + 45L);
        }
        return (int)(l5 - 45L);
    }

    public static long distancePointRect_Pow2(long l, long l2, long l3, long l4, long l5, long l6) {
        long l7 = 0L;
        if (Math.abs(l3 - l5) < 1024L) {
            l7 = l3 - l;
            l7 = l7 * l7 >> 10;
        } else if (Math.abs(l4 - l6) < 1024L) {
            l7 = l4 - l2;
            l7 = l7 * l7 >> 10;
        } else {
            long l8 = (l6 - l4 << 10) / (l5 - l3);
            long l9 = l8 * (l - l3) >> 10;
            l9 = l9 - l2 + l4;
            l9 = l9 * l9 >> 10;
            long l10 = l8 * l8 >> 10;
            l7 = (l9 << 10) / (l10 += 1024L);
        }
        return l7;
    }

    public static long distancePointPoint_Pow2(long l, long l2, long l3, long l4) {
        long l5 = 0L;
        if (Math.abs(l3 - l) < 1024L) {
            l5 = l4 - l2;
            l5 = l5 * l5 >> 10;
        } else if (Math.abs(l4 - l2) < 1024L) {
            l5 = l3 - l;
            l5 = l5 * l5 >> 10;
        } else {
            l5 = (l3 - l) * (l3 - l) + (l4 - l2) * (l4 - l2) >> 10;
        }
        return l5;
    }

    public static long distancePointPoint_Pow2_v2(int n, int n2, int n3, int n4) {
        long l = 0L;
        if (Math.abs(n3 - n) < 1) {
            l = n4 - n2;
            l *= l;
        } else if (Math.abs(n4 - n2) < 1) {
            l = n3 - n;
            l *= l;
        } else {
            l = (n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2);
        }
        return l;
    }
}

