/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions.cc3d;

import cocos2d.extensions.cc3d.CC3Math;
import cocos2d.extensions.cc3d.CC3Utils;
import cocos2d.extensions.cc3d.CC3Vector;
import cocos2d.extensions.cc3d.CC4Vector;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexArray;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CC3Transform {
    private static final float[] a = new float[16];
    private static final float[] b = new float[12];
    private static final CC3Vector a = new CC3Vector();
    static final Transform a = new Transform();
    private static CC3Transform a = new CC3Transform();
    public boolean isUpdated = true;
    private static final float[] c = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public float[] internalMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    public Transform getTransform() {
        a.set(this.internalMatrix);
        return a;
    }

    public CC3Transform() {
    }

    public CC3Transform(CC3Transform cC3Transform) {
        this.set(cC3Transform.internalMatrix);
    }

    public void get(float[] fArray) {
        System.arraycopy(this.internalMatrix, 0, fArray, 0, 16);
    }

    public void set(float[] fArray) {
        System.arraycopy(fArray, 0, this.internalMatrix, 0, 16);
        this.isUpdated = true;
    }

    public void set(Transform transform) {
        transform.get(this.internalMatrix);
        this.isUpdated = true;
    }

    public void set(CC3Transform cC3Transform) {
        cC3Transform.get(this.internalMatrix);
        this.isUpdated = true;
    }

    public void setIdentity() {
        System.arraycopy(c, 0, this.internalMatrix, 0, 16);
        this.isUpdated = true;
    }

    public void transform(CC4Vector cC4Vector) {
        float f2 = cC4Vector.x;
        float f3 = cC4Vector.y;
        float f4 = cC4Vector.z;
        float f5 = cC4Vector.w;
        cC4Vector.x = f2 * this.internalMatrix[0] + f3 * this.internalMatrix[1] + f4 * this.internalMatrix[2] + f5 * this.internalMatrix[3];
        cC4Vector.y = f2 * this.internalMatrix[4] + f3 * this.internalMatrix[5] + f4 * this.internalMatrix[6] + f5 * this.internalMatrix[7];
        cC4Vector.z = f2 * this.internalMatrix[8] + f3 * this.internalMatrix[9] + f4 * this.internalMatrix[10] + f5 * this.internalMatrix[11];
        cC4Vector.w = f2 * this.internalMatrix[12] + f3 * this.internalMatrix[13] + f4 * this.internalMatrix[14] + f5 * this.internalMatrix[15];
    }

    public void transform(float[] fArray) {
        int n2 = fArray.length;
        int n3 = 0;
        while (n3 < n2) {
            float f2 = fArray[n3];
            float f3 = fArray[n3 + 1];
            float f4 = fArray[n3 + 2];
            float f5 = fArray[n3 + 3];
            fArray[n3++] = f2 * this.internalMatrix[0] + f3 * this.internalMatrix[1] + f4 * this.internalMatrix[2] + f5 * this.internalMatrix[3];
            fArray[n3++] = f2 * this.internalMatrix[4] + f3 * this.internalMatrix[5] + f4 * this.internalMatrix[6] + f5 * this.internalMatrix[7];
            fArray[n3++] = f2 * this.internalMatrix[8] + f3 * this.internalMatrix[9] + f4 * this.internalMatrix[10] + f5 * this.internalMatrix[11];
            fArray[n3++] = f2 * this.internalMatrix[12] + f3 * this.internalMatrix[13] + f4 * this.internalMatrix[14] + f5 * this.internalMatrix[15];
        }
    }

    public void transform(VertexArray vertexArray, float[] fArray, boolean bl) {
        if (vertexArray == null) {
            throw new NullPointerException("in can not be null");
        }
        if (fArray == null) {
            throw new NullPointerException("out can not be null");
        }
        if (fArray.length < vertexArray.getVertexCount() << 2) {
            throw new IllegalArgumentException("Number of elements in out array must be at least vertexCount*4");
        }
        int n2 = vertexArray.getComponentCount();
        int n3 = vertexArray.getVertexCount();
        if (vertexArray.getComponentType() == 1) {
            int n4 = n3 * n2;
            byte[] byArray = new byte[n4];
            vertexArray.get(0, n3, byArray);
            int n5 = 0;
            n3 = 0;
            while (n5 < n4) {
                float f2 = byArray[n5++];
                float f3 = n2 >= 2 ? byArray[n5++] : (byte)0;
                float f4 = n2 >= 3 ? byArray[n5++] : (byte)0;
                float f5 = n2 >= 4 ? byArray[n5++] : (bl ? (byte)1 : 0);
                fArray[n3++] = f2 * this.internalMatrix[0] + f3 * this.internalMatrix[1] + f4 * this.internalMatrix[2] + f5 * this.internalMatrix[3];
                fArray[n3++] = f2 * this.internalMatrix[4] + f3 * this.internalMatrix[5] + f4 * this.internalMatrix[6] + f5 * this.internalMatrix[7];
                fArray[n3++] = f2 * this.internalMatrix[8] + f3 * this.internalMatrix[9] + f4 * this.internalMatrix[10] + f5 * this.internalMatrix[11];
                fArray[n3++] = f2 * this.internalMatrix[12] + f3 * this.internalMatrix[13] + f4 * this.internalMatrix[14] + f5 * this.internalMatrix[15];
            }
            return;
        }
        int n6 = n3 * n2;
        short[] sArray = new short[n6];
        vertexArray.get(0, n3, sArray);
        int n7 = 0;
        n3 = 0;
        while (n7 < n6) {
            float f6 = sArray[n7++];
            float f7 = n2 >= 2 ? sArray[n7++] : (short)0;
            float f8 = n2 >= 3 ? sArray[n7++] : (short)0;
            float f9 = n2 >= 4 ? sArray[n7++] : (bl ? (short)1 : 0);
            fArray[n3++] = f6 * this.internalMatrix[0] + f7 * this.internalMatrix[1] + f8 * this.internalMatrix[2] + f9 * this.internalMatrix[3];
            fArray[n3++] = f6 * this.internalMatrix[4] + f7 * this.internalMatrix[5] + f8 * this.internalMatrix[6] + f9 * this.internalMatrix[7];
            fArray[n3++] = f6 * this.internalMatrix[8] + f7 * this.internalMatrix[9] + f8 * this.internalMatrix[10] + f9 * this.internalMatrix[11];
            fArray[n3++] = f6 * this.internalMatrix[12] + f7 * this.internalMatrix[13] + f8 * this.internalMatrix[14] + f9 * this.internalMatrix[15];
        }
    }

    public void invert() {
        int n2 = 4;
        while (n2-- != 0) {
            int n3 = n2 << 2;
            CC3Transform.a[n2] = this.internalMatrix[n3++];
            CC3Transform.a[n2 + 4] = this.internalMatrix[n3++];
            CC3Transform.a[n2 + 8] = this.internalMatrix[n3++];
            CC3Transform.a[n2 + 12] = this.internalMatrix[n3];
        }
        CC3Transform.b[0] = a[10] * a[15];
        CC3Transform.b[1] = a[11] * a[14];
        CC3Transform.b[2] = a[9] * a[15];
        CC3Transform.b[3] = a[11] * a[13];
        CC3Transform.b[4] = a[9] * a[14];
        CC3Transform.b[5] = a[10] * a[13];
        CC3Transform.b[6] = a[8] * a[15];
        CC3Transform.b[7] = a[11] * a[12];
        CC3Transform.b[8] = a[8] * a[14];
        CC3Transform.b[9] = a[10] * a[12];
        CC3Transform.b[10] = a[8] * a[13];
        CC3Transform.b[11] = a[9] * a[12];
        this.internalMatrix[0] = b[0] * a[5] + b[3] * a[6] + b[4] * a[7] - (b[1] * a[5] + b[2] * a[6] + b[5] * a[7]);
        this.internalMatrix[1] = b[1] * a[4] + b[6] * a[6] + b[9] * a[7] - (b[0] * a[4] + b[7] * a[6] + b[8] * a[7]);
        this.internalMatrix[2] = b[2] * a[4] + b[7] * a[5] + b[10] * a[7] - (b[3] * a[4] + b[6] * a[5] + b[11] * a[7]);
        this.internalMatrix[3] = b[5] * a[4] + b[8] * a[5] + b[11] * a[6] - (b[4] * a[4] + b[9] * a[5] + b[10] * a[6]);
        float f2 = 1.0f / (a[0] * this.internalMatrix[0] + a[1] * this.internalMatrix[1] + a[2] * this.internalMatrix[2] + a[3] * this.internalMatrix[3]);
        this.internalMatrix[0] = this.internalMatrix[0] * f2;
        this.internalMatrix[1] = this.internalMatrix[1] * f2;
        this.internalMatrix[2] = this.internalMatrix[2] * f2;
        this.internalMatrix[3] = this.internalMatrix[3] * f2;
        this.internalMatrix[4] = (b[1] * a[1] + b[2] * a[2] + b[5] * a[3] - (b[0] * a[1] + b[3] * a[2] + b[4] * a[3])) * f2;
        this.internalMatrix[5] = (b[0] * a[0] + b[7] * a[2] + b[8] * a[3] - (b[1] * a[0] + b[6] * a[2] + b[9] * a[3])) * f2;
        this.internalMatrix[6] = (b[3] * a[0] + b[6] * a[1] + b[11] * a[3] - (b[2] * a[0] + b[7] * a[1] + b[10] * a[3])) * f2;
        this.internalMatrix[7] = (b[4] * a[0] + b[9] * a[1] + b[10] * a[2] - (b[5] * a[0] + b[8] * a[1] + b[11] * a[2])) * f2;
        CC3Transform.b[0] = a[2] * a[7];
        CC3Transform.b[1] = a[3] * a[6];
        CC3Transform.b[2] = a[1] * a[7];
        CC3Transform.b[3] = a[3] * a[5];
        CC3Transform.b[4] = a[1] * a[6];
        CC3Transform.b[5] = a[2] * a[5];
        CC3Transform.b[6] = a[0] * a[7];
        CC3Transform.b[7] = a[3] * a[4];
        CC3Transform.b[8] = a[0] * a[6];
        CC3Transform.b[9] = a[2] * a[4];
        CC3Transform.b[10] = a[0] * a[5];
        CC3Transform.b[11] = a[1] * a[4];
        this.internalMatrix[8] = (b[0] * a[13] + b[3] * a[14] + b[4] * a[15] - (b[1] * a[13] + b[2] * a[14] + b[5] * a[15])) * f2;
        this.internalMatrix[9] = (b[1] * a[12] + b[6] * a[14] + b[9] * a[15] - (b[0] * a[12] + b[7] * a[14] + b[8] * a[15])) * f2;
        this.internalMatrix[10] = (b[2] * a[12] + b[7] * a[13] + b[10] * a[15] - (b[3] * a[12] + b[6] * a[13] + b[11] * a[15])) * f2;
        this.internalMatrix[11] = (b[5] * a[12] + b[8] * a[13] + b[11] * a[14] - (b[4] * a[12] + b[9] * a[13] + b[10] * a[14])) * f2;
        this.internalMatrix[12] = (b[2] * a[10] + b[5] * a[11] + b[1] * a[9] - (b[4] * a[11] + b[0] * a[9] + b[3] * a[10])) * f2;
        this.internalMatrix[13] = (b[8] * a[11] + b[0] * a[8] + b[7] * a[10] - (b[6] * a[10] + b[9] * a[11] + b[1] * a[8])) * f2;
        this.internalMatrix[14] = (b[6] * a[9] + b[11] * a[11] + b[3] * a[8] - (b[10] * a[11] + b[2] * a[8] + b[7] * a[9])) * f2;
        this.internalMatrix[15] = (b[10] * a[10] + b[4] * a[8] + b[9] * a[9] - (b[8] * a[9] + b[11] * a[10] + b[5] * a[8])) * f2;
        this.isUpdated = true;
    }

    public void transpose() {
        float[] fArray = this.internalMatrix;
        float f2 = this.internalMatrix[1];
        fArray[1] = fArray[4];
        fArray[4] = f2;
        f2 = fArray[2];
        fArray[2] = fArray[8];
        fArray[8] = f2;
        f2 = fArray[3];
        fArray[3] = fArray[12];
        fArray[12] = f2;
        f2 = fArray[6];
        fArray[6] = fArray[9];
        fArray[9] = f2;
        f2 = fArray[7];
        fArray[7] = fArray[13];
        fArray[13] = f2;
        f2 = fArray[11];
        fArray[11] = fArray[14];
        fArray[14] = f2;
        this.isUpdated = true;
    }

    public void postMultiply(CC3Transform object) {
        object = ((CC3Transform)object).internalMatrix;
        float f2 = ((CC3Transform)object).internalMatrix[0];
        Object object2 = object[1];
        Object object3 = object[2];
        Object object4 = object[3];
        Object object5 = object[4];
        Object object6 = object[5];
        Object object7 = object[6];
        Object object8 = object[7];
        Object object9 = object[8];
        Object object10 = object[9];
        Object object11 = object[10];
        Object object12 = object[11];
        Object object13 = object[12];
        Object object14 = object[13];
        Object object15 = object[14];
        Object object16 = object[15];
        float f3 = this.internalMatrix[0];
        float f4 = this.internalMatrix[1];
        float f5 = this.internalMatrix[2];
        float f6 = this.internalMatrix[3];
        this.internalMatrix[0] = f3 * f2 + f4 * object5 + f5 * object9 + f6 * object13;
        this.internalMatrix[1] = f3 * object2 + f4 * object6 + f5 * object10 + f6 * object14;
        this.internalMatrix[2] = f3 * object3 + f4 * object7 + f5 * object11 + f6 * object15;
        this.internalMatrix[3] = f3 * object4 + f4 * object8 + f5 * object12 + f6 * object16;
        f3 = this.internalMatrix[4];
        f4 = this.internalMatrix[5];
        f5 = this.internalMatrix[6];
        f6 = this.internalMatrix[7];
        this.internalMatrix[4] = f3 * f2 + f4 * object5 + f5 * object9 + f6 * object13;
        this.internalMatrix[5] = f3 * object2 + f4 * object6 + f5 * object10 + f6 * object14;
        this.internalMatrix[6] = f3 * object3 + f4 * object7 + f5 * object11 + f6 * object15;
        this.internalMatrix[7] = f3 * object4 + f4 * object8 + f5 * object12 + f6 * object16;
        f3 = this.internalMatrix[8];
        f4 = this.internalMatrix[9];
        f5 = this.internalMatrix[10];
        f6 = this.internalMatrix[11];
        this.internalMatrix[8] = f3 * f2 + f4 * object5 + f5 * object9 + f6 * object13;
        this.internalMatrix[9] = f3 * object2 + f4 * object6 + f5 * object10 + f6 * object14;
        this.internalMatrix[10] = f3 * object3 + f4 * object7 + f5 * object11 + f6 * object15;
        this.internalMatrix[11] = f3 * object4 + f4 * object8 + f5 * object12 + f6 * object16;
        f3 = this.internalMatrix[12];
        f4 = this.internalMatrix[13];
        f5 = this.internalMatrix[14];
        f6 = this.internalMatrix[15];
        this.internalMatrix[12] = f3 * f2 + f4 * object5 + f5 * object9 + f6 * object13;
        this.internalMatrix[13] = f3 * object2 + f4 * object6 + f5 * object10 + f6 * object14;
        this.internalMatrix[14] = f3 * object3 + f4 * object7 + f5 * object11 + f6 * object15;
        this.internalMatrix[15] = f3 * object4 + f4 * object8 + f5 * object12 + f6 * object16;
        this.isUpdated = true;
    }

    private void a() {
        float[] fArray = CC3Transform.a.internalMatrix;
        float f2 = CC3Transform.a.internalMatrix[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = fArray[4];
        float f6 = fArray[5];
        float f7 = fArray[6];
        float f8 = fArray[8];
        float f9 = fArray[9];
        float f10 = fArray[10];
        float f11 = this.internalMatrix[0];
        float f12 = this.internalMatrix[1];
        float f13 = this.internalMatrix[2];
        this.internalMatrix[0] = f11 * f2 + f12 * f5 + f13 * f8;
        this.internalMatrix[1] = f11 * f3 + f12 * f6 + f13 * f9;
        this.internalMatrix[2] = f11 * f4 + f12 * f7 + f13 * f10;
        f11 = this.internalMatrix[4];
        f12 = this.internalMatrix[5];
        f13 = this.internalMatrix[6];
        this.internalMatrix[4] = f11 * f2 + f12 * f5 + f13 * f8;
        this.internalMatrix[5] = f11 * f3 + f12 * f6 + f13 * f9;
        this.internalMatrix[6] = f11 * f4 + f12 * f7 + f13 * f10;
        f11 = this.internalMatrix[8];
        f12 = this.internalMatrix[9];
        f13 = this.internalMatrix[10];
        this.internalMatrix[8] = f11 * f2 + f12 * f5 + f13 * f8;
        this.internalMatrix[9] = f11 * f3 + f12 * f6 + f13 * f9;
        this.internalMatrix[10] = f11 * f4 + f12 * f7 + f13 * f10;
        this.isUpdated = true;
    }

    public void postRotateNormalized(float f2, float f3, float f4, float f5) {
        if ((double)f2 > 1.0E-6 || (double)f2 < -1.0E-6) {
            CC3Transform.a(f2, f3, f4, f5);
            this.a();
        }
    }

    public void postRotate(float f2, float f3, float f4, float f5) {
        if ((double)f2 > 1.0E-6 || (double)f2 < -1.0E-6) {
            a.set(f3, f4, f5);
            a.normalize();
            CC3Transform.a(f2, CC3Transform.a.x, CC3Transform.a.y, CC3Transform.a.z);
            this.a();
        }
    }

    public void postRotateQuat(float f2, float f3, float f4, float f5) {
        if (f2 == 0.0f && f3 == 0.0f && f4 == 0.0f && f5 == 0.0f) {
            throw new IllegalArgumentException("Atleast one the components of the quaternion must be non zero.");
        }
        CC4Vector cC4Vector = new CC4Vector(f2, f3, f4, f5);
        cC4Vector.normalize();
        f5 = cC4Vector.w;
        f4 = cC4Vector.z;
        f3 = cC4Vector.y;
        float f6 = cC4Vector.x;
        float f7 = f6 + f6;
        float f8 = f3 + f3;
        float f9 = f4 + f4;
        f6 = f7 * f6;
        float f10 = f7 * f3;
        float f11 = f7 * f4;
        f7 *= f5;
        f3 = f8 * f3;
        float f12 = f8 * f4;
        f8 *= f5;
        f4 = f9 * f4;
        f5 = f9 * f5;
        a.setIdentity();
        float[] fArray = CC3Transform.a.internalMatrix;
        CC3Transform.a.internalMatrix[0] = 1.0f - f3 + f4;
        fArray[1] = f10 - f5;
        fArray[2] = f11 + f8;
        fArray[4] = f10 + f5;
        fArray[5] = 1.0f - f6 + f4;
        fArray[6] = f12 - f7;
        fArray[8] = f11 - f8;
        fArray[9] = f12 + f7;
        fArray[10] = 1.0f - f6 + f3;
        this.a();
    }

    public void postScale(float f2, float f3, float f4) {
        this.internalMatrix[0] = this.internalMatrix[0] * f2;
        this.internalMatrix[1] = this.internalMatrix[1] * f3;
        this.internalMatrix[2] = this.internalMatrix[2] * f4;
        this.internalMatrix[4] = this.internalMatrix[4] * f2;
        this.internalMatrix[5] = this.internalMatrix[5] * f3;
        this.internalMatrix[6] = this.internalMatrix[6] * f4;
        this.internalMatrix[8] = this.internalMatrix[8] * f2;
        this.internalMatrix[9] = this.internalMatrix[9] * f3;
        this.internalMatrix[10] = this.internalMatrix[10] * f4;
        this.isUpdated = true;
    }

    public void postTranslate(float f2, float f3, float f4) {
        this.internalMatrix[3] = this.internalMatrix[3] + (this.internalMatrix[0] * f2 + this.internalMatrix[1] * f3 + this.internalMatrix[2] * f4);
        this.internalMatrix[7] = this.internalMatrix[7] + (this.internalMatrix[4] * f2 + this.internalMatrix[5] * f3 + this.internalMatrix[6] * f4);
        this.internalMatrix[11] = this.internalMatrix[11] + (this.internalMatrix[8] * f2 + this.internalMatrix[9] * f3 + this.internalMatrix[10] * f4);
        this.isUpdated = true;
    }

    private static void a(float f2, float f3, float f4, float f5) {
        f2 = (float)((double)f2 * (Math.PI / 180));
        a.setIdentity();
        float[] fArray = CC3Transform.a.internalMatrix;
        float f6 = (float)Math.cos(f2);
        f2 = (float)Math.sin(f2);
        float f7 = 1.0f - f6;
        float f8 = f3 * f7;
        float f9 = f4 * f7;
        f7 = f5 * f7;
        float f10 = f8 * f4;
        float f11 = f8 * f5;
        float f12 = f9 * f5;
        float f13 = f3 * f2;
        float f14 = f5 * f2;
        f2 = f4 * f2;
        fArray[0] = f3 * f8 + f6;
        fArray[1] = f10 - f14;
        fArray[2] = f11 + f2;
        fArray[4] = f10 + f14;
        fArray[5] = f4 * f9 + f6;
        fArray[6] = f12 - f13;
        fArray[8] = f11 - f2;
        fArray[9] = f12 + f13;
        fArray[10] = f5 * f7 + f6;
    }

    public String toString() {
        StringBuffer stringBuffer = CC3Utils.getStringBuffer("[");
        for (int i2 = 0; i2 < 16; ++i2) {
            stringBuffer.append(CC3Math.shortenFloat(this.internalMatrix[i2])).append(", ");
        }
        return stringBuffer.append(']').toString();
    }
}

