/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Shape {
    protected FXVector[] a;
    int[] c;
    int a;
    private int h;
    int b;
    private int i;
    int c;
    long a;
    protected int d;
    protected int e = 1024;
    int f = 4096;
    long b = 0x1000000L;
    long c = 4096L;
    long d = 0x1000000L;
    int g = -1;
    protected UserData a;
    protected FXVector a = new FXVector();
    public static final int MAX_MASS_FX = 0x1000001;

    public static Shape createRectangle(int n2, int n3) {
        FXVector[] fXVectorArray = new FXVector[4];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(-(n2 <<= 12) / 2, -(n3 <<= 12) / 2);
        fXVectorArray2[1] = new FXVector(-n2 / 2, n3 / 2);
        fXVectorArray2[2] = new FXVector(n2 / 2, n3 / 2);
        fXVectorArray2[3] = new FXVector(n2 / 2, -n3 / 2);
        return new Shape(fXVectorArray2);
    }

    public static Shape createCircle(int n2) {
        FXVector[] fXVectorArray = new FXVector[1];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(0, n2 << 12);
        return new Shape(fXVectorArray2);
    }

    public static Shape createRegularPolygon(int n2, int n3) {
        FXVector[] fXVectorArray = new FXVector[n3];
        FXVector fXVector = new FXVector(0, n2 << 12);
        for (int i2 = 0; i2 < n3; ++i2) {
            FXMatrix fXMatrix = FXMatrix.createRotationMatrix((int)(105414356L * (long)((i2 << 1) + 1) / (long)(n3 << 1)));
            fXVectorArray[n3 - 1 - i2] = fXMatrix.mult(fXVector);
        }
        return new Shape(fXVectorArray);
    }

    public static Shape loadShape(PhysicsFileReader object, UserData userData) {
        int n2 = ((PhysicsFileReader)object).getVersion();
        if (n2 <= 512) {
            ((PhysicsFileReader)object).next();
        }
        int n3 = ((PhysicsFileReader)object).next();
        FXVector[] fXVectorArray = new FXVector[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            fXVectorArray[i2] = ((PhysicsFileReader)object).nextVector();
        }
        Shape shape = new Shape(fXVectorArray);
        shape.setElasticityFX(((PhysicsFileReader)object).nextIntFX());
        shape.setFrictionFX(((PhysicsFileReader)object).nextIntFX());
        if (n2 >= 1280) {
            shape.setMassFX(((PhysicsFileReader)object).nextIntFX());
        }
        if (((PhysicsFileReader)object).getVersion() > 1536) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                shape.a = userData.createNewUserData((String)object, 2);
            }
        }
        return shape;
    }

    public Shape(FXVector[] fXVectorArray) {
        if (fXVectorArray.length > 12) {
            return;
        }
        this.a = fXVectorArray;
        this.c();
        this.setMass(1);
    }

    public Shape(Shape shape) {
        this.a = new FXVector[shape.a.length];
        System.arraycopy(shape.a, 0, this.a, 0, this.a.length);
        this.setElasticityFX(shape.d);
        this.setFrictionFX(shape.e);
        this.c();
        this.setMassFX(shape.f);
        if (shape.a != null) {
            this.a = shape.a.copy();
        }
    }

    protected Shape() {
    }

    protected final void c() {
        this.a();
        this.h = 0;
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            FXVector fXVector = this.a[i2];
            if (fXVector.lengthSquare() <= this.h * this.h) continue;
            this.h = fXVector.lengthFX() >> 12;
        }
        this.b = this.h << 12;
        this.b();
        Shape shape = this;
        this.i = this.c = shape.b << 1;
        for (int i3 = 0; i3 < shape.c.length && shape.c[i3] >= 0; i3 += 2) {
            long l2;
            FXVector fXVector = new FXVector(shape.a[shape.c[i3]]);
            fXVector.subtract(shape.a[shape.c[i3 + 1]]);
            fXVector.normalize();
            long l3 = l2 = (long)shape.a[0].xFX * (long)fXVector.yFX - (long)shape.a[0].yFX * (long)fXVector.xFX >> 12;
            for (int i4 = 1; i4 < shape.a.length; ++i4) {
                long l4 = (long)shape.a[i4].xFX * (long)fXVector.yFX - (long)shape.a[i4].yFX * (long)fXVector.xFX >> 12;
                if (l4 < l3) {
                    l3 = l4;
                    continue;
                }
                if (l4 <= l2) continue;
                l2 = l4;
            }
            if ((long)shape.c < l2 - l3) {
                shape.c = (int)(l2 - l3);
            }
            if ((long)shape.i <= l2 - l3) continue;
            shape.i = (int)(l2 - l3);
        }
    }

    public void correctCentroid() {
        if (this.a.length < 3) {
            return;
        }
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        int n3 = this.a.length - 1;
        while (n2 < this.a.length) {
            long l4 = (long)this.a[n2].xFX * (long)this.a[n3].yFX - (long)this.a[n2].yFX * (long)this.a[n3].xFX >> 12;
            l2 += l4 * (long)(this.a[n2].xFX + this.a[n3].xFX) >> 12;
            l3 += l4 * (long)(this.a[n2].yFX + this.a[n3].yFX) >> 12;
            n3 = n2++;
        }
        l2 = (l2 << 12) / (this.a * 6L);
        l3 = (l3 << 12) / (this.a * 6L);
        for (n2 = 0; n2 < this.a.length; ++n2) {
            this.a[n2].subtract(new FXVector((int)l2, (int)l3));
        }
        this.c();
    }

    public FXVector[] getCorners() {
        return this.a;
    }

    public int getBoundingRadiusSquare() {
        return this.h * this.h;
    }

    public int getBoundingRadiusFX() {
        return this.b;
    }

    void a() {
        if (this.a.length == 1) {
            this.c = new int[0];
            this.a = 0;
            return;
        }
        this.c = new int[this.a.length << 1];
        Vector<FXVector> vector = new Vector<FXVector>();
        int n2 = 0;
        int n3 = this.a.length - 1;
        while (n2 < this.a.length) {
            FXVector fXVector = new FXVector(this.a[n2]);
            fXVector.subtract(this.a[n3]);
            fXVector.normalize();
            boolean bl = true;
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                FXVector fXVector2 = (FXVector)vector.elementAt(i2);
                if (Math.abs((long)fXVector.xFX * (long)fXVector2.xFX + (long)fXVector.yFX * (long)fXVector2.yFX >> 12) <= 4088L) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.c[vector.size() << 1] = n2;
                this.c[(vector.size() << 1) + 1] = n3;
                vector.addElement(fXVector);
            }
            n3 = n2++;
        }
        this.a = vector.size() << 1;
        for (n2 = vector.size() << 1; n2 < this.c.length; ++n2) {
            this.c[n2] = -1;
        }
    }

    public void setFriction(int n2) {
        this.e = (n2 << 12) / 100;
    }

    public void setFrictionFX(int n2) {
        this.e = n2;
    }

    public int getFrictionFX() {
        return this.e;
    }

    public void setElasticity(int n2) {
        this.d = (n2 << 12) / 100;
    }

    public void setElasticityFX(int n2) {
        this.d = n2;
    }

    public int getElasticityFX() {
        return this.d;
    }

    public final void setMass(int n2) {
        this.setMassFX(n2 << 12);
    }

    public final void setMassFX(int n2) {
        if (this.a == 0L) {
            this.c = 0x1000001L;
            this.b = 0L;
            this.d = 0L;
            return;
        }
        this.f = n2;
        this.b = 0x1000000000L / (long)n2;
        this.b();
    }

    public int getMass() {
        return this.f >> 12;
    }

    public int getMassFX() {
        return this.f;
    }

    public int getId() {
        return this.g;
    }

    public long getAreaFX() {
        return this.a;
    }

    void b() {
        this.a = 0L;
        this.c = 0L;
        if (this.a.length == 1) {
            this.a = 52707178L * (long)((int)((long)this.b * (long)this.b) >> 24) >> 12;
            this.c = (int)((long)(this.f / 2) * (long)this.b * (long)this.b >> 24);
        } else if (this.a.length > 2) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                FXVector fXVector = this.a[i2];
                FXVector fXVector2 = this.a[i2 + 1 >= this.a.length ? 0 : i2 + 1];
                long l2 = (long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12;
                this.a += l2 / 2L;
                long l3 = fXVector.xFX;
                long l4 = fXVector.yFX;
                long l5 = fXVector2.xFX;
                long l6 = fXVector2.yFX;
                long l7 = (int)((l3 * l3 + l5 * l3 + l5 * l5) / 12L >> 12);
                long l8 = (int)((l4 * l4 + l6 * l4 + l6 * l6) / 12L >> 12);
                this.c += l2 * (l7 + l8) >> 12;
            }
            this.c = (this.c << 12) / this.a * (long)this.f >> 12;
        }
        if (this.a > 0L) {
            long l9 = 0L;
            long l10 = 0L;
            int n2 = 0;
            int n3 = this.a.length - 1;
            while (n2 < this.a.length) {
                long l11 = (long)this.a[n2].xFX * (long)this.a[n3].yFX - (long)this.a[n2].yFX * (long)this.a[n3].xFX >> 12;
                l9 += l11 * (long)(this.a[n2].xFX + this.a[n3].xFX) >> 12;
                l10 += l11 * (long)(this.a[n2].yFX + this.a[n3].yFX) >> 12;
                n3 = n2++;
            }
            l9 = (l9 << 12) / (this.a * 6L);
            l10 = (l10 << 12) / (this.a * 6L);
            this.a.assignFX((int)l9, (int)l10);
        } else {
            this.a.assignFX(0, 0);
        }
        this.c += (long)this.f * (long)this.a.lengthSquareFX() >> 12;
        if (this.c == 0L) {
            this.d = Integer.MAX_VALUE;
            return;
        }
        this.d = 0x1000000000L / this.c;
    }

    protected final void a(FXVector fXVector, FXMatrix fXMatrix, FXVector[] fXVectorArray) {
        if (fXVectorArray.length < this.a.length) {
            return;
        }
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            fXMatrix.mult(this.a[i2], fXVectorArray[i2]);
            fXVectorArray[i2].xFX += fXVector.xFX;
            fXVectorArray[i2].yFX += fXVector.yFX;
        }
    }

    public UserData getUserData() {
        return this.a;
    }

    public void setUserData(UserData userData) {
        this.a = userData;
    }
}

