/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Spring
implements Constraint {
    private Body a;
    private Body b;
    private FXVector c;
    private FXVector d;
    private int e;
    private int f = 0;
    private UserData g = null;
    private long h;
    private long i;
    private FXVector j = new FXVector();
    private int k;
    private FXVector l = new FXVector();
    private FXVector m = new FXVector();
    private long n;
    private int o = 0;
    private static FXVector p = new FXVector();
    private static FXVector q = new FXVector();
    private static FXVector r = new FXVector();

    public Spring(Body body, Body body2, FXVector fXVector, FXVector fXVector2, int n2) {
        this.a = body;
        this.b = body2;
        this.c = fXVector;
        this.d = fXVector2;
        if (n2 < 0) {
            this.a();
            return;
        }
        this.e = n2 << 12;
    }

    private Spring(Spring spring, Body[] bodyArray) {
        if (bodyArray == null) {
            this.a = spring.a;
            this.b = spring.b;
        } else {
            this.a = bodyArray[spring.a.o];
            this.b = bodyArray[spring.b.o];
        }
        this.c = new FXVector(spring.c);
        this.d = new FXVector(spring.d);
        this.e = spring.e;
        this.f = spring.f;
        if (spring.g != null) {
            this.g = spring.g.copy();
        }
    }

    public Constraint copy(Body[] bodyArray) {
        return new Spring(this, bodyArray);
    }

    private Spring() {
    }

    public static Spring loadSpring(PhysicsFileReader object, Vector vector, UserData userData) {
        Spring spring = new Spring();
        new Spring().a = (Body)vector.elementAt(((PhysicsFileReader)object).next());
        spring.c = ((PhysicsFileReader)object).nextVector();
        spring.b = (Body)vector.elementAt(((PhysicsFileReader)object).next());
        spring.d = ((PhysicsFileReader)object).nextVector();
        spring.e = ((PhysicsFileReader)object).nextIntFX();
        spring.f = ((PhysicsFileReader)object).nextIntFX();
        if (((PhysicsFileReader)object).getVersion() > 1792) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                spring.g = userData.createNewUserData((String)object, 4);
            }
        }
        return spring;
    }

    private void a() {
        if (this.a != null && this.b != null) {
            this.a.getAbsoluePoint(this.c, q);
            this.b.getAbsoluePoint(this.d, r);
            FXVector fXVector = new FXVector(r);
            fXVector.subtract(q);
            this.e = fXVector.lengthFX();
        }
    }

    public void setCoefficient(int n2) {
        this.f = n2 << 12;
    }

    public void setCoefficientFX(int n2) {
        this.f = n2;
    }

    public int getCoefficientFX() {
        return this.f;
    }

    public void setCollisionLayer(int n2) {
        this.a.addCollisionLayer(n2);
        this.b.addCollisionLayer(n2);
    }

    public FXVector getPoint1() {
        return this.a.getAbsoluePoint(this.c);
    }

    public void getPoint1(FXVector fXVector) {
        this.a.getAbsoluePoint(this.c, fXVector);
    }

    public FXVector getPoint2() {
        return this.b.getAbsoluePoint(this.d);
    }

    public void getPoint2(FXVector fXVector) {
        this.b.getAbsoluePoint(this.d, fXVector);
    }

    public FXVector getRawPoint1() {
        return this.c;
    }

    public FXVector getRawPoint2() {
        return this.d;
    }

    public Body getBody1() {
        return this.a;
    }

    public Body getBody2() {
        return this.b;
    }

    public void precalculate(long l2) {
        this.a.getAbsoluePoint(this.c, q);
        this.b.getAbsoluePoint(this.d, r);
        this.j.assignDiff(r, q);
        this.k = this.j.lengthFX();
        if (this.k == 0) {
            return;
        }
        this.a.getRotationMatrix().mult(this.c, this.l);
        this.b.getRotationMatrix().mult(this.d, this.m);
        this.j.divideByFX(this.k);
        this.h = -((long)this.j.xFX * (long)this.l.yFX - (long)this.j.yFX * (long)this.l.xFX >> 12);
        this.i = -((long)this.j.xFX * (long)this.m.yFX - (long)this.j.yFX * (long)this.m.xFX >> 12);
        int n2 = (int)(this.a.getInvInertia2FX() * (this.h * this.h >> 12) >> 12);
        int n3 = (int)(this.b.getInvInertia2FX() * (this.i * this.i >> 12) >> 12);
        this.n = this.a.getInvMass2FX() + (long)n2 + this.b.getInvMass2FX() + (long)n3;
        if (this.f > 0) {
            int n4 = -((int)(((long)this.f * (long)(this.e - this.k) << 12) / l2 >> 12));
            Spring.p.xFX = this.j.xFX;
            Spring.p.yFX = this.j.yFX;
            p.multFX(n4);
            this.a.applyMomentumAt(p, this.l);
            p.mult(-1);
            this.b.applyMomentumAt(p, this.m);
        }
    }

    public boolean applyMomentum(long l2) {
        if (this.f > 0 || this.n == 0L) {
            return true;
        }
        int n2 = -((int)((((long)this.a.b.xFX * (long)this.j.xFX + (long)this.a.b.yFX * (long)this.j.yFX >> 12) - ((long)this.a.d * this.h >> 24) - ((long)this.b.b.xFX * (long)this.j.xFX + (long)this.b.b.yFX * (long)this.j.yFX >> 12) + ((long)this.b.d * this.i >> 24) + ((1024L * (long)(this.e - this.k) >> 12) * l2 >> 12) << 24) / this.n));
        Spring.p.xFX = this.j.xFX;
        Spring.p.yFX = this.j.yFX;
        p.multFX(n2);
        this.a.applyMomentumAt(p, this.l);
        p.mult(-1);
        this.b.applyMomentumAt(p, this.m);
        this.o += n2;
        return Math.abs(n2) < 16;
    }

    public void postStep() {
    }

    public int getDistance() {
        return this.e >> 12;
    }

    public int getDistanceFX() {
        return this.e;
    }

    public void setDistanceFX(int n2) {
        if (n2 < 0) {
            this.a();
            return;
        }
        this.e = n2;
    }

    public int getImpulseFX() {
        return this.o;
    }

    public boolean concernsBody(Body body) {
        return this.a == body || this.b == body;
    }

    public boolean equals(Constraint constraint) {
        return constraint instanceof Spring && ((Spring)constraint).a.equals(this.a) && ((Spring)constraint).b.equals(this.b) && ((Spring)constraint).c.xFX == this.c.xFX && ((Spring)constraint).c.yFX == this.c.yFX && ((Spring)constraint).d.xFX == this.d.xFX && ((Spring)constraint).d.yFX == this.d.yFX;
    }

    public UserData getUserData() {
        return this.g;
    }

    public void setUserData(UserData userData) {
        this.g = userData;
    }
}

