/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Joint
implements Constraint {
    private Body a;
    private Body b;
    private FXVector c;
    private FXVector d;
    private boolean e;
    private int f;
    private FXMatrix g = new FXMatrix();
    private FXVector h = new FXVector();
    private FXVector i = new FXVector();
    private FXVector j = new FXVector();
    private int k = 0;
    private long l;
    private FXVector m = new FXVector();
    private static FXVector n = new FXVector();
    private static FXVector o = new FXVector();
    private UserData p = null;

    public Joint(Body body, Body body2, FXVector fXVector, FXVector fXVector2, boolean bl) {
        this.a = body;
        this.b = body2;
        this.c = fXVector;
        this.d = fXVector2;
        this.e = bl;
        if (this.a != null && this.b != null) {
            this.f = FXUtil.wrapAngleFX(this.a.c - this.b.c);
        }
    }

    private Joint(Joint joint, Body[] bodyArray) {
        if (bodyArray == null) {
            this.a = joint.a;
            this.b = joint.b;
        } else {
            this.a = bodyArray[joint.a.o];
            this.b = bodyArray[joint.b.o];
        }
        this.c = new FXVector(joint.c);
        this.d = new FXVector(joint.d);
        this.e = joint.e;
        this.f = joint.f;
        if (joint.p != null) {
            this.p = joint.p.copy();
        }
    }

    public Constraint copy(Body[] bodyArray) {
        return new Joint(this, bodyArray);
    }

    private Joint() {
    }

    public static Joint loadJoint(PhysicsFileReader object, Vector vector, UserData userData) {
        Joint joint = new Joint();
        new Joint().a = (Body)vector.elementAt(((PhysicsFileReader)object).next());
        joint.c = ((PhysicsFileReader)object).nextVector();
        joint.b = (Body)vector.elementAt(((PhysicsFileReader)object).next());
        joint.d = ((PhysicsFileReader)object).nextVector();
        joint.e = ((PhysicsFileReader)object).next() > 0;
        joint.f = FXUtil.wrapAngleFX(joint.a.c - joint.b.c);
        if (((PhysicsFileReader)object).getVersion() > 1792) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                joint.p = userData.createNewUserData((String)object, 4);
            }
        }
        return joint;
    }

    public void setCollisionLayer(int n2) {
        this.a.addCollisionLayer(n2);
        this.b.addCollisionLayer(n2);
    }

    public FXVector getPoint1() {
        return this.a.getAbsoluePoint(this.c);
    }

    public FXVector getPoint2() {
        return this.b.getAbsoluePoint(this.d);
    }

    public FXVector getRawPoint1() {
        return this.c;
    }

    public FXVector getRawPoint2() {
        return this.d;
    }

    public void setBody1(Body body) {
        this.a = body;
    }

    public Body getBody1() {
        return this.a;
    }

    public Body getBody2() {
        return this.b;
    }

    public boolean isFixed() {
        return this.e;
    }

    public void precalculate(long l2) {
        int n2 = (int)this.a.getInvMass2FX();
        int n3 = (int)this.b.getInvMass2FX();
        long l3 = this.a.getInvInertia2FX();
        long l4 = this.b.getInvInertia2FX();
        n2 = n2 + n3 >> 9;
        this.a.getRotationMatrix().mult(-this.c.yFX, this.c.xFX, this.h);
        this.b.getRotationMatrix().mult(this.d.yFX, -this.d.xFX, this.i);
        FXVector fXVector = this.h;
        FXVector fXVector2 = this.i;
        this.g.mCol1xFX = n2 + (int)(((long)fXVector.xFX * (long)fXVector.xFX >> 12) * l3 + ((long)fXVector2.xFX * (long)fXVector2.xFX >> 12) * l4 >> 21);
        this.g.mCol2xFX = this.g.mCol1yFX = (long)((int)(((long)fXVector.xFX * (long)fXVector.yFX >> 12) * l3 + ((long)fXVector2.xFX * (long)fXVector2.yFX >> 12) * l4 >> 21));
        this.g.mCol2yFX = n2 + (int)(((long)fXVector.yFX * (long)fXVector.yFX >> 12) * l3 + ((long)fXVector2.yFX * (long)fXVector2.yFX >> 12) * l4 >> 21);
        this.g.invert();
        this.a.getAbsoluePoint(this.c, n);
        this.b.getAbsoluePoint(this.d, o);
        this.j.assignDiff(o, n);
        this.j.multFX(l2);
        this.j.multFX(1024L);
        if (this.e) {
            this.l = l3 + l4;
            this.k = (int)(((long)FXUtil.angleDiffFX(this.f, FXUtil.wrapAngleFX(this.a.c - this.b.c)) * l2 >> 12) * 3072L >> 12);
        }
    }

    public boolean applyMomentum(long l2) {
        if (this.e && this.l != 0L) {
            int n2 = (int)(((long)(this.a.d - this.b.d) - (long)this.k << 12) / this.l);
            this.a.applyTorque(n2);
            this.b.applyTorque(-n2);
        }
        FXVector fXVector = o;
        fXVector.assignFX((int)((long)this.a.b.xFX - ((long)this.h.xFX * (long)this.a.d >> 24) - (long)this.b.b.xFX - ((long)this.i.xFX * (long)this.b.d >> 24)), (int)((long)this.a.b.yFX - ((long)this.h.yFX * (long)this.a.d >> 24) - (long)this.b.b.yFX - ((long)this.i.yFX * (long)this.b.d >> 24)));
        fXVector.subtract(this.j);
        fXVector.mult(-1);
        this.g.mult(fXVector, n);
        fXVector = n;
        this.a.applyMomentum(fXVector);
        this.a.applyTorque((int)(((long)fXVector.xFX * (long)this.h.xFX >> 12) + ((long)fXVector.yFX * (long)this.h.yFX >> 12)));
        this.b.applyTorque((int)(((long)fXVector.xFX * (long)this.i.xFX >> 12) + ((long)fXVector.yFX * (long)this.i.yFX >> 12)));
        fXVector.mult(-1);
        this.b.applyMomentum(fXVector);
        fXVector.mult(-1);
        this.m.xFX = fXVector.xFX;
        this.m.yFX = fXVector.yFX;
        return fXVector.fastLengthFX() < 16;
    }

    public void postStep() {
    }

    public int getImpulseFX() {
        return this.m.lengthFX();
    }

    public boolean concernsBody(Body body) {
        return this.a == body || this.b == body;
    }

    public boolean equals(Constraint constraint) {
        return constraint instanceof Joint && ((Joint)constraint).a.equals(this.a) && ((Joint)constraint).b.equals(this.b) && ((Joint)constraint).c.xFX == this.c.xFX && ((Joint)constraint).c.yFX == this.c.yFX && this.isFixed() == ((Joint)constraint).isFixed();
    }

    public void setFixPoint(FXVector fXVector) {
        if (this.a != null) {
            this.c = this.a.getRelativePoint(fXVector);
        }
        if (this.b != null) {
            this.d = this.b.getRelativePoint(fXVector);
        }
        if (this.a != null && this.b != null) {
            this.f = FXUtil.wrapAngleFX(this.a.rotation2FX() - this.b.rotation2FX());
        }
    }

    public UserData getUserData() {
        return this.p;
    }

    public void setUserData(UserData userData) {
        this.p = userData;
    }
}

