/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.actions;

import cocos2d.actions.CCAction;
import cocos2d.nodes.CCNode;
import cocos2d.types.CCBezierConfig;
import cocos2d.types.CCPoint;
import cocos2d.types.Real;

public class CCBezierBy
extends CCAction {
    private CCBezierConfig a;
    private CCPoint b = CCPoint.zero();
    private Real c = new Real();
    private Real d = new Real();

    public static final CCBezierBy action(CCBezierConfig cCBezierConfig, long l2) {
        return new CCBezierBy(cCBezierConfig, l2);
    }

    public CCBezierBy(CCBezierConfig cCBezierConfig, long l2) {
        this.a = cCBezierConfig;
        this.duration = l2;
        this.c.assign(l2);
        this.c.mul(Real.PERCENT);
        this.c.recip();
        this.c.mul(Real.PERCENT);
    }

    public void update(CCNode cCNode, long l2) {
        if (this.isFinished || !this.isStarted) {
            this.isStarted = true;
            this.isFinished = false;
            this.b.set(cCNode.position);
            this.a.controlPoint_1.x -= this.b.x;
            this.a.controlPoint_1.y -= this.b.y;
            this.a.controlPoint_2.x -= this.b.x;
            this.a.controlPoint_2.y -= this.b.y;
            this.a.endPosition.x -= this.b.x;
            this.a.endPosition.y -= this.b.y;
            this.elapsedTime = 0L;
        } else {
            this.elapsedTime += l2;
        }
        if (this.elapsedTime < this.duration) {
            this.d.assign(this.elapsedTime);
            this.d.mul(this.c);
            int n2 = this.a.controlPoint_1.x;
            int n3 = this.a.controlPoint_2.x;
            int n4 = this.a.endPosition.x;
            int n5 = this.a.controlPoint_1.y;
            int n6 = this.a.controlPoint_2.y;
            int n7 = this.a.endPosition.y;
            n2 = CCBezierConfig.bezierAt(0, n2, n3, n4, this.d);
            n3 = CCBezierConfig.bezierAt(0, n5, n6, n7, this.d);
            cCNode.setPosition(this.b.x + n2, this.b.y + n3);
        } else {
            this.isFinished = true;
            this.a.controlPoint_1.x += this.b.x;
            this.a.controlPoint_1.y += this.b.y;
            this.a.controlPoint_2.x += this.b.x;
            this.a.controlPoint_2.y += this.b.y;
            this.a.endPosition.x += this.b.x;
            this.a.endPosition.y += this.b.y;
            cCNode.setPosition(this.a.endPosition);
        }
        super.update(cCNode, l2);
    }

    public CCAction copy() {
        return new CCBezierBy(this.a.copy(), this.duration);
    }

    public CCAction reverse() {
        return this.copy();
    }
}

