/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions.cc3d;

import cocos2d.extensions.cc3d.CC3Plane;
import cocos2d.extensions.cc3d.CC3Vector;
import cocos2d.extensions.cc3d.CC4Vector;

public class CC3Math {
    private static int a;
    private static int b;
    private static int c;
    private static float d;
    private static final CC3Vector e;
    public static final double EPSILON = 1.0E-6;
    private static CC4Vector f;
    private static CC4Vector g;
    private static CC4Vector h;
    private static CC4Vector i;
    private static CC4Vector j;

    public static final float round(float f2) {
        if (f2 > 0.0f) {
            return (int)(f2 + 0.5f);
        }
        if (f2 < 0.0f) {
            return (int)(f2 - 0.5f);
        }
        return 0.0f;
    }

    private static final float a(float f2) {
        float f3 = f2 * f2;
        return ((((16.15364f * f3 + 268.42548f) * f3 + 1153.0293f) * f3 + 1780.4064f) * f3 + 896.78595f) / (((((f3 + 58.95697f) * f3 + 536.2654f) * f3 + 1666.7838f) * f3 + 2079.335f) * f3 + 896.78595f) * f2;
    }

    private static final float b(float f2) {
        if (f2 < 0.41421357f) {
            return CC3Math.a(f2);
        }
        if (f2 > 2.4142137f) {
            return 1.5707964f - CC3Math.a(1.0f / f2);
        }
        return 0.7853982f + CC3Math.a((f2 - 1.0f) / (f2 + 1.0f));
    }

    public static float atan(float f2) {
        if (f2 > 0.0f) {
            return CC3Math.b(f2);
        }
        return -CC3Math.b(-f2);
    }

    public static float atan2(float f2, float f3) {
        if (f2 + f3 == f2) {
            if (f2 >= 0.0f) {
                return 1.5707964f;
            }
            return -1.5707964f;
        }
        f2 = CC3Math.atan(f2 / f3);
        if (f3 < 0.0f) {
            if (f2 <= 0.0f) {
                return f2 + (float)Math.PI;
            }
            return f2 - (float)Math.PI;
        }
        return f2;
    }

    public static float asin(float f2) {
        float f3;
        boolean bl = false;
        f2 = CC3Math.clamp(f2, -1.0f, 1.0f);
        if (f3 < 0.0f) {
            bl = true;
            f2 = -f2;
        }
        float f4 = (float)Math.sqrt(1.0f - f2 * f2);
        f4 = (double)f2 > 0.7 ? 1.5707964f - CC3Math.atan(f4 / f2) : CC3Math.atan(f2 / f4);
        if (bl) {
            f4 = -f4;
        }
        return f4;
    }

    public static float acos(float f2) {
        return 1.5707964f - CC3Math.asin(f2);
    }

    public static float degToRad(float f2) {
        return f2 * ((float)Math.PI / 180);
    }

    public static double degToRad(double d2) {
        return d2 * 0.01745329238474369;
    }

    public static float radToDeg(float f2) {
        return f2 * 57.29578f;
    }

    public static double radToDeg(double d2) {
        return d2 * (double)57.29578f;
    }

    public static final CC3Vector getRotation(float[] fArray) {
        CC3Vector cC3Vector = new CC3Vector();
        CC3Math.getRotation(fArray, cC3Vector);
        return cC3Vector;
    }

    public static final void getRotation(float[] fArray, CC3Vector cC3Vector) {
        if (fArray[4] > 0.998f) {
            cC3Vector.x = CC3Math.radToDeg(0.0f);
            cC3Vector.y = CC3Math.radToDeg(CC3Math.atan2(fArray[2], fArray[10]));
            cC3Vector.z = CC3Math.radToDeg(1.5707964f);
            return;
        }
        if (fArray[4] < -0.998f) {
            cC3Vector.x = CC3Math.radToDeg(0.0f);
            cC3Vector.y = CC3Math.radToDeg(CC3Math.atan2(fArray[2], fArray[10]));
            cC3Vector.z = CC3Math.radToDeg(-1.5707964f);
            return;
        }
        cC3Vector.x = CC3Math.radToDeg(CC3Math.atan2(-fArray[6], fArray[5]));
        cC3Vector.y = CC3Math.radToDeg(CC3Math.atan2(-fArray[8], fArray[0]));
        cC3Vector.z = CC3Math.radToDeg(CC3Math.asin(fArray[4]));
    }

    public static float shortenFloat(float f2) {
        return (float)((int)((f2 + 0.005f) * 100.0f)) / 100.0f;
    }

    public static int floor(float f2) {
        if (f2 >= 0.0f) {
            return (int)f2;
        }
        int n2 = (int)f2;
        if (f2 == (float)n2) {
            return n2;
        }
        return n2 - 1;
    }

    public static float fmod(float f2, float f3) {
        float f4 = f2 / f3;
        return f2 - (float)CC3Math.floor(f4) * f3;
    }

    public static final float distance_squared(float f2, float f3) {
        return f2 * f2 + f3 * f3;
    }

    public static final float distance(float f2, float f3) {
        return (float)Math.sqrt(f2 * f2 + f3 * f3);
    }

    public static final int distance_squared(int n2, int n3) {
        return n2 * n2 + n3 * n3;
    }

    public static final int approx_distance(float f2, float f3) {
        return CC3Math.approx_distance((int)f2, (int)f3);
    }

    public static final int approx_distance(int n2, int n3) {
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n2 < n3) {
            a = n2;
            b = n3;
        } else {
            a = n3;
            b = n2;
        }
        c = b * 1007 + a * 441;
        if (b < a << 4) {
            c -= b * 40;
        }
        return c + 512 >> 10;
    }

    public static final double sqrt(double d2) {
        long l2 = Double.doubleToLongBits(d2) >> 32;
        double d3 = Double.longBitsToDouble(l2 + 1072632448L << 31);
        return (d3 + d2 / d3) * 0.5;
    }

    public static final CC3Vector crossProduct(CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        CC3Vector cC3Vector3 = new CC3Vector();
        cC3Vector3.setCross(cC3Vector, cC3Vector2);
        return cC3Vector3;
    }

    public static final CC4Vector crossProduct(CC4Vector cC4Vector, CC4Vector cC4Vector2) {
        CC4Vector cC4Vector3 = new CC4Vector();
        cC4Vector3.setCross(cC4Vector, cC4Vector2);
        return cC4Vector3;
    }

    public static final CC3Vector project(CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        d = cC3Vector2.length();
        return CC3Math.scalarMul(cC3Vector.dot(cC3Vector2) / (d * d), cC3Vector2);
    }

    public static final CC3Vector calcNormal(CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        cC3Vector = CC3Math.crossProduct(cC3Vector, cC3Vector2);
        cC3Vector.normalizeFast();
        return cC3Vector;
    }

    public static final void calcNormal(CC3Vector cC3Vector, CC3Vector cC3Vector2, CC3Vector cC3Vector3) {
        cC3Vector3.setCross(cC3Vector, cC3Vector2);
        cC3Vector3.normalizeFast();
    }

    public static final void normalize(CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        CC3Math.scalarDiv(cC3Vector, cC3Vector.length(), cC3Vector2);
    }

    public static final void normalizePrecise(CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        d = cC3Vector.length();
        CC3Math.scalarDiv(cC3Vector, d, cC3Vector2);
    }

    public static final void normalize(CC4Vector cC4Vector, CC4Vector cC4Vector2) {
        d = cC4Vector.lengthFast();
        CC3Math.scalarDiv(cC4Vector, d, cC4Vector2);
    }

    public static final void normalizePrecise(CC4Vector cC4Vector, CC4Vector cC4Vector2) {
        d = cC4Vector.length();
        CC3Math.scalarDiv(cC4Vector, d, cC4Vector2);
    }

    public static final CC3Vector scalarMul(float f2, CC3Vector cC3Vector) {
        CC3Vector cC3Vector2 = new CC3Vector();
        CC3Math.scalarMul(f2, cC3Vector, cC3Vector2);
        return cC3Vector2;
    }

    public static final void scalarMul(float f2, CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        cC3Vector2.set(cC3Vector.x * f2, cC3Vector.y * f2, cC3Vector.z * f2);
    }

    public static final CC3Vector scalarDiv(float f2, CC3Vector cC3Vector) {
        CC3Vector cC3Vector2 = new CC3Vector();
        CC3Math.scalarDiv(f2, cC3Vector, cC3Vector2);
        return cC3Vector2;
    }

    public static final void scalarDiv(float f2, CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        cC3Vector2.set(f2 / cC3Vector.x, f2 / cC3Vector.y, f2 / cC3Vector.z);
    }

    public static final CC3Vector scalarDiv(CC3Vector cC3Vector, float f2) {
        CC3Vector cC3Vector2 = new CC3Vector();
        CC3Math.scalarDiv(cC3Vector, f2, cC3Vector2);
        return cC3Vector2;
    }

    public static final void scalarDiv(CC3Vector cC3Vector, float f2, CC3Vector cC3Vector2) {
        f2 = 1.0f / f2;
        cC3Vector2.set(cC3Vector.x * f2, cC3Vector.y * f2, cC3Vector.z * f2);
    }

    public static final CC4Vector scalarDiv(float f2, CC4Vector cC4Vector) {
        CC4Vector cC4Vector2 = new CC4Vector();
        CC3Math.scalarDiv(f2, cC4Vector, cC4Vector2);
        return cC4Vector2;
    }

    public static final void scalarDiv(float f2, CC4Vector cC4Vector, CC4Vector cC4Vector2) {
        cC4Vector2.set(f2 / cC4Vector.x, f2 / cC4Vector.y, f2 / cC4Vector.z, f2 / cC4Vector.w);
    }

    public static final CC4Vector scalarDiv(CC4Vector cC4Vector, float f2) {
        CC4Vector cC4Vector2 = new CC4Vector();
        CC3Math.scalarDiv(cC4Vector, f2, cC4Vector2);
        return cC4Vector2;
    }

    public static final void scalarDiv(CC4Vector cC4Vector, float f2, CC4Vector cC4Vector2) {
        cC4Vector2.set(cC4Vector.x / f2, cC4Vector.y / f2, cC4Vector.z / f2, cC4Vector.w / f2);
    }

    public static final CC3Vector sub(CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        CC3Vector cC3Vector3 = new CC3Vector();
        cC3Vector3.setSub(cC3Vector, cC3Vector2);
        return cC3Vector3;
    }

    public static final CC4Vector sub(CC4Vector cC4Vector, CC4Vector cC4Vector2) {
        CC4Vector cC4Vector3 = new CC4Vector();
        cC4Vector3.setSub(cC4Vector, cC4Vector2);
        return cC4Vector3;
    }

    public static final void sub(CC3Vector cC3Vector, CC3Vector cC3Vector2, CC3Vector cC3Vector3) {
        cC3Vector3.set(cC3Vector.x - cC3Vector2.x, cC3Vector.y - cC3Vector2.y, cC3Vector.z - cC3Vector2.z);
    }

    public static final CC3Vector subXZ(CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        CC3Vector cC3Vector3 = new CC3Vector();
        CC3Math.subXZ(cC3Vector, cC3Vector2, cC3Vector3);
        return cC3Vector3;
    }

    public static final void subXZ(CC3Vector cC3Vector, CC3Vector cC3Vector2, CC3Vector cC3Vector3) {
        cC3Vector3.set(cC3Vector.x - cC3Vector2.x, 0.0f, cC3Vector.z - cC3Vector2.z);
    }

    public static final CC3Vector add(CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        CC3Vector cC3Vector3 = new CC3Vector();
        cC3Vector3.setAdd(cC3Vector, cC3Vector2);
        return cC3Vector3;
    }

    public static final void add(CC3Vector cC3Vector, CC3Vector cC3Vector2, CC3Vector cC3Vector3) {
        cC3Vector3.set(cC3Vector.x + cC3Vector2.x, cC3Vector.y + cC3Vector2.y, cC3Vector.z + cC3Vector2.z);
    }

    public static final CC4Vector add(CC4Vector cC4Vector, CC4Vector cC4Vector2) {
        CC4Vector cC4Vector3 = new CC4Vector();
        cC4Vector3.setAdd(cC4Vector, cC4Vector2);
        return cC4Vector3;
    }

    public static final CC3Vector mirror(CC3Vector cC3Vector, CC3Plane cC3Plane) {
        return CC3Math.sub(cC3Vector, CC3Math.scalarMul(2.0f, CC3Math.project(cC3Vector, cC3Plane.a)));
    }

    public static final float lerp(float f2, float f3, float f4) {
        return f3 + f2 * (f4 - f3);
    }

    public static float lerpDegrees(float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7 = Math.abs(f4 - f3);
        if (f6 > 180.0f) {
            if (f4 > f3) {
                f3 += 360.0f;
            } else {
                f4 += 360.0f;
            }
        }
        f2 = CC3Math.lerp(f2, f3, f4);
        if (f5 >= 0.0f && f2 <= 360.0f) {
            return f2;
        }
        return f2 % 360.0f;
    }

    public static final void lerp(CC3Vector cC3Vector, CC3Vector cC3Vector2, float f2) {
        CC3Math.scalarMul(f2, cC3Vector2, e);
        cC3Vector.mul(1.0f - f2);
        cC3Vector.add(e);
    }

    public static final void slerp(CC3Vector cC3Vector, CC3Vector cC3Vector2, float f2) {
        float f3 = cC3Vector.dot(cC3Vector2);
        if ((double)f3 > 0.99995 || (double)f3 < 0.9995) {
            CC3Vector cC3Vector3 = CC3Math.sub(cC3Vector2, cC3Vector);
            CC3Math.scalarMul(f2, cC3Vector3, cC3Vector3);
            cC3Vector.add(cC3Vector3);
            cC3Vector.normalizeFast();
            return;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f3 < -1.0f) {
            f3 = -1.0f;
        }
        float f4 = CC3Math.acos(f3) * f2;
        cC3Vector2 = CC3Math.sub(cC3Vector2, new CC3Vector(cC3Vector.x * f3, cC3Vector.y * f3, cC3Vector.z * f3));
        cC3Vector2.normalizeFast();
        cC3Vector2.mul((float)Math.sin(f4));
        cC3Vector.mul((float)Math.cos(f4));
        cC3Vector.add(cC3Vector2);
        cC3Vector.normalizeFast();
    }

    public static final float clamp(float f2, float f3, float f4) {
        if (f2 <= f3) {
            return f3;
        }
        if (f2 >= f4) {
            return f4;
        }
        return f2;
    }

    public static boolean triangle_intersection(CC4Vector cC4Vector, CC4Vector cC4Vector2, CC4Vector cC4Vector3, CC4Vector cC4Vector4, CC4Vector cC4Vector5, int n2) {
        float f2;
        f.setSub(cC4Vector2, cC4Vector);
        g.setSub(cC4Vector3, cC4Vector);
        h.setCross(cC4Vector5, g);
        float f3 = f.dot(h);
        if (n2 == 0 && f3 <= 0.0f || n2 == 1 && f3 >= 0.0f || (double)f3 > -1.0E-6 && (double)f3 < 1.0E-6) {
            return false;
        }
        f3 = 1.0f / f3;
        j.setSub(cC4Vector4, cC4Vector);
        float f4 = j.dot(h) * f3;
        if (f4 < 0.0f || f4 > 1.0f) {
            return false;
        }
        i.setCross(j, f);
        float f5 = cC4Vector5.dot(i) * f3;
        if (f5 < 0.0f || f4 + f5 > 1.0f) {
            return false;
        }
        f4 = g.dot(i) * f3;
        if ((double)f2 > 1.0E-6) {
            System.out.println("Intersected at distance: " + f4);
            return true;
        }
        return false;
    }

    public static final boolean intersectRectangle(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray) {
        int n10;
        if ((n2 = n2 + n4 > n6 + n8 ? n6 + n8 : n2 + n4) - (n10 = n2 < n6 ? n6 : n2) < 0) {
            return false;
        }
        nArray[0] = n10;
        nArray[2] = n2 - n10;
        n2 = n3 + n5 > n7 + n9 ? n7 + n9 : n3 + n5;
        if (n2 - (n10 = n3 < n7 ? n7 : n3) < 0) {
            return false;
        }
        nArray[1] = n10;
        nArray[3] = n2 - n10;
        return true;
    }

    static {
        e = new CC3Vector();
        f = new CC4Vector();
        g = new CC4Vector();
        h = new CC4Vector();
        i = new CC4Vector();
        j = new CC4Vector();
    }
}

