/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Contact;
import at.emini.physics2D.Event;
import at.emini.physics2D.EventSet;
import at.emini.physics2D.ExternalForce;
import at.emini.physics2D.Joint;
import at.emini.physics2D.Landscape;
import at.emini.physics2D.Motor;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.ParticleEmitter;
import at.emini.physics2D.PhysicsEventListener;
import at.emini.physics2D.Script;
import at.emini.physics2D.Shape;
import at.emini.physics2D.ShapeSet;
import at.emini.physics2D.Spring;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class World {
    private PhysicsEventListener s;
    private FXVector t = new FXVector(0, 409600);
    private int u = 0;
    private int v = 0;
    private int w = 204;
    private long x = 0x1000000 / this.w;
    private int y = 10;
    private int z = 5;
    private boolean A = false;
    public static final int M_SHAPE_MAX_VERTICES = 12;
    protected ShapeSet a = new ShapeSet();
    private EventSet B = new EventSet();
    private Body[] C = new Body[128];
    private int D = Integer.MIN_VALUE;
    private int E = Integer.MAX_VALUE;
    int b = 0;
    Body[] c = new Body[128];
    private int F = 0;
    private int G = 0;
    private int H = this.b;
    private Landscape I = new Landscape();
    int d = 0;
    Contact[] e = new Contact[128];
    static int f = 0;
    static Contact[] g = new Contact[32];
    int h = 0;
    Constraint[] i = new Constraint[32];
    private Vector J = new Vector();
    protected Vector j = new Vector();
    Script[] k = new Script[32];
    int l = 0;
    Body[] m = new Body[32];
    int[] n = new int[32];
    int[] o = new int[32];
    int[] p = new int[32];
    int q = 0;
    static int r = 0;
    private UserData K = null;

    public World() {
    }

    public World(World world) {
        if (world == null) {
            return;
        }
        this.a = world.a.copy();
        this.t.assign(world.t);
        this.u = world.u;
        this.v = world.v;
        this.D = world.D;
        this.E = world.E;
        this.w = world.w;
        this.x = world.x;
        this.y = world.y;
        this.z = world.z;
        this.addWorld(world);
        this.B = world.B.copy();
        if (world.I != null) {
            this.setLandscape(world.I.copy());
        }
        if (world.K != null) {
            this.K = world.K.copy();
        }
    }

    public UserData getUserData() {
        return this.K;
    }

    public void setUserData(UserData userData) {
        this.K = userData;
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader) {
        return World.loadWorld(physicsFileReader, null);
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader, UserData userData) {
        int n2 = physicsFileReader.getVersion();
        if ((n2 & 0xFF00) < 256 || (n2 & 0xFF00) > 2560) {
            return null;
        }
        World world = new World();
        Vector<Shape> vector = new Vector<Shape>();
        Vector<Body> vector2 = new Vector<Body>();
        int n3 = 0;
        while (n3 != -1) {
            switch (n3) {
                case 1: {
                    int n4;
                    int n5;
                    int n6 = physicsFileReader.next();
                    for (n5 = 0; n5 < n6; ++n5) {
                        vector.addElement(Shape.loadShape(physicsFileReader, userData));
                    }
                    if (n2 > 2048) {
                        n5 = physicsFileReader.next();
                        for (n4 = 0; n4 < n5; ++n4) {
                            vector.addElement(MultiShape.loadShape(physicsFileReader, userData, vector));
                        }
                    }
                    world.a.registerShapes(vector);
                    break;
                }
                case 2: {
                    int n5;
                    int n7 = physicsFileReader.next();
                    for (n5 = 0; n5 < n7; ++n5) {
                        Body body = Body.loadBody(physicsFileReader, vector, userData);
                        vector2.addElement(body);
                        world.addBody(body);
                    }
                    break;
                }
                case 6: {
                    world.setLandscape(Landscape.loadLandscape(physicsFileReader));
                    break;
                }
                case 3: {
                    int n5;
                    int n8 = physicsFileReader.next();
                    for (n5 = 0; n5 < n8; ++n5) {
                        world.addConstraint(World.loadConstraint(physicsFileReader, vector2, userData));
                    }
                    break;
                }
                case 4: {
                    int n4;
                    int n5;
                    int n9 = physicsFileReader.next();
                    for (n5 = 0; n5 < n9; ++n5) {
                        world.addScript(Script.loadScript(physicsFileReader));
                    }
                    world.q = physicsFileReader.next();
                    for (n5 = 0; n5 < world.q; ++n5) {
                        n4 = physicsFileReader.next();
                        int n10 = physicsFileReader.next();
                        if (n10 < 0 || n10 >= vector2.size() || n4 >= n9) continue;
                        world.n[n5] = physicsFileReader.next();
                        world.m[n5] = (Body)vector2.elementAt(physicsFileReader.next());
                    }
                    break;
                }
                case 5: {
                    int n5;
                    int n11 = physicsFileReader.next();
                    for (n5 = 0; n5 < n11; ++n5) {
                        world.addEvent(Event.loadEvent(physicsFileReader, world, userData));
                    }
                    break;
                }
                case 7: {
                    world.setGravity(physicsFileReader.nextVector());
                    if (physicsFileReader.getVersion() > 2304) {
                        world.setDampingLateralFX(physicsFileReader.nextInt());
                        world.setDampingRotationalFX(physicsFileReader.nextInt());
                    } else {
                        int n12 = 4096 - physicsFileReader.nextInt();
                        world.setDampingLateralFX(n12);
                        world.setDampingRotationalFX(n12);
                    }
                    if (physicsFileReader.getVersion() <= 1792) break;
                    String string = physicsFileReader.nextString();
                    if (userData == null) break;
                    world.K = userData.createNewUserData(string, 6);
                    break;
                }
                case 8: {
                    int n5;
                    int n13 = physicsFileReader.next();
                    for (n5 = 0; n5 < n13; ++n5) {
                        world.addParticleEmitter(ParticleEmitter.loadParticleEmitter(physicsFileReader, world, userData));
                    }
                    break;
                }
            }
            if ((n2 & 0xFF00) == 256) {
                if (++n3 == 4) {
                    ++n3;
                }
                if (n3 <= 5) continue;
                break;
            }
            n3 = physicsFileReader.next();
        }
        physicsFileReader.close();
        return world;
    }

    public int getTimestepFX() {
        return this.w;
    }

    public long getInverseTimestepFX() {
        return this.x;
    }

    public void setTimestepFX(int n2) {
        this.w = n2;
        this.x = 0x1000000 / this.w;
    }

    public void setConstraintIterations(int n2) {
        this.y = n2;
    }

    public void setPositionConstraintIterations(int n2) {
        this.z = n2;
    }

    public int getConstraintIterations() {
        return this.y;
    }

    public int getPositionConstraintIterations() {
        return this.z;
    }

    public void setConstraintIterationDynamic(boolean bl) {
        this.A = bl;
    }

    public void setPhysicsEventListener(PhysicsEventListener physicsEventListener) {
        this.s = physicsEventListener;
    }

    public void setSimulationArea(int n2, int n3) {
        this.D = n2 << 12;
        this.E = n3 << 12;
    }

    public ShapeSet getShapeSet() {
        return this.a;
    }

    public Body[] addWorld(World world) {
        Body body;
        int n2;
        Body[] bodyArray = new Body[world.F];
        for (n2 = 0; n2 < world.b; ++n2) {
            body = world.c[n2].copy();
            this.addBody(body);
            body.a(0);
            bodyArray[world.c[n2].o] = body;
        }
        for (n2 = 0; n2 < world.h; ++n2) {
            this.addConstraint(world.i[n2].copy(bodyArray));
        }
        for (n2 = 0; n2 < world.l; ++n2) {
            this.addScript(world.k[n2].copy());
        }
        for (n2 = 0; n2 < world.q; ++n2) {
            body = bodyArray[world.m[n2].o];
            this.k[world.n[n2]].applyToBody(body, this);
            this.o[n2] = world.o[n2];
            this.p[n2] = world.p[n2];
        }
        for (n2 = 0; n2 < world.J.size(); ++n2) {
            this.addParticleEmitter(((ParticleEmitter)world.J.elementAt(n2)).copy(bodyArray));
        }
        for (n2 = 0; n2 < world.j.size(); ++n2) {
            this.addExternalForce(((ExternalForce)world.j.elementAt(n2)).copy(bodyArray));
        }
        Vector vector = world.B.getEvents();
        int n3 = vector.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.addEvent(((Event)vector.elementAt(i2)).copy(bodyArray));
        }
        Landscape landscape = world.getLandscape();
        for (int i3 = 0; i3 < landscape.a; ++i3) {
            this.I.addSegment(new FXVector(landscape.b[i3]), new FXVector(landscape.c[i3]), landscape.d[i3]);
        }
        return bodyArray;
    }

    public void addBody(Body body) {
        if (body != null) {
            body.o = this.F++;
            this.c = World.a(this.c, this.b);
            this.c[this.b++] = body;
            this.a.registerShape(body.h);
            this.a();
            body.forceUpdate(this.w);
        }
    }

    public void setLandscape(Landscape landscape) {
        this.I = landscape;
    }

    public Landscape getLandscape() {
        return this.I;
    }

    public void addParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.J.addElement(particleEmitter);
        }
    }

    public void addExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.j.addElement(externalForce);
        }
    }

    public void removeBody(Body body) {
        int n2;
        int n3;
        if (body.o < 0) {
            return;
        }
        for (n3 = 0; n3 < this.b; ++n3) {
            if (this.c[n3] != body) continue;
            this.c[n3] = null;
            break;
        }
        this.b = World.a((Object[])this.c, this.b);
        this.a();
        for (n3 = 0; n3 < this.q; ++n3) {
            if (this.m[n3] != body) continue;
            this.o[n3] = -1;
            this.p[n3] = -1;
            this.n[n3] = -1;
            this.m[n3] = null;
            World.b(this.o, this.q);
            World.b(this.p, this.q);
            World.b(this.n, this.q);
            this.q = World.a((Object[])this.m, this.q);
        }
        n3 = this.h;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.i[n2].concernsBody(body)) continue;
            this.i[n2] = null;
        }
        this.h = World.a(this.i, this.h);
        for (n3 = this.J.size() - 1; n3 >= 0; --n3) {
            if (((ParticleEmitter)this.J.elementAt(n3)).getEmitter() != body) continue;
            this.J.removeElementAt(n3);
        }
        n3 = this.d;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.e[n2].concernsBody(body)) continue;
            this.e[n2] = null;
        }
        this.d = World.a((Object[])this.e, this.d);
    }

    public void removeConstraint(Constraint constraint) {
        int n2 = this.h;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.i[i2] != constraint) continue;
            this.i[i2] = null;
        }
        this.h = World.a(this.i, this.h);
    }

    public void removeScript(Script script) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < this.l; ++n2) {
            if (this.k[n2] != script) continue;
            this.k[n2] = null;
            n3 = n2;
            --this.l;
            for (int i2 = n2; i2 < this.l; ++i2) {
                this.k[i2] = this.k[i2 + 1];
            }
            break;
        }
        for (n2 = 0; n2 < this.q; ++n2) {
            if (this.o[n2] != n3) continue;
            this.o[n2] = -1;
            this.p[n2] = -1;
            this.n[n2] = -1;
            this.m[n2] = null;
            World.b(this.o, this.q);
            World.b(this.p, this.q);
            World.b(this.n, this.q);
            this.q = World.a((Object[])this.m, this.q);
            return;
        }
    }

    public void removeEvent(Event event) {
        this.B.removeEvent(event);
    }

    public void removeParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.J.removeElement(particleEmitter);
        }
    }

    public void removeExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.j.removeElement(externalForce);
        }
    }

    static final int[] a(int[] nArray, int n2) {
        if (nArray.length <= n2) {
            int[] nArray2 = new int[nArray.length + 32];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return nArray;
    }

    static final short[] a(short[] sArray, int n2) {
        if (sArray.length <= n2) {
            short[] sArray2 = new short[sArray.length + 32];
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            return sArray2;
        }
        return sArray;
    }

    private static Body[] a(Body[] bodyArray, int n2) {
        if (bodyArray.length <= n2) {
            Body[] bodyArray2 = new Body[bodyArray.length + 32];
            System.arraycopy(bodyArray, 0, bodyArray2, 0, bodyArray.length);
            return bodyArray2;
        }
        return bodyArray;
    }

    static final Contact[] a(Contact[] contactArray, int n2) {
        if (contactArray.length <= n2) {
            Contact[] contactArray2 = new Contact[contactArray.length + 32];
            System.arraycopy(contactArray, 0, contactArray2, 0, contactArray.length);
            return contactArray2;
        }
        return contactArray;
    }

    static final FXVector[] a(FXVector[] fXVectorArray, int n2) {
        if (fXVectorArray.length <= n2) {
            FXVector[] fXVectorArray2 = new FXVector[fXVectorArray.length + 32];
            System.arraycopy(fXVectorArray, 0, fXVectorArray2, 0, fXVectorArray.length);
            return fXVectorArray2;
        }
        return fXVectorArray;
    }

    public Body findBodyById(int n2) {
        if ((n2 = this.bodyIndexOf(n2)) < 0) {
            return null;
        }
        return this.c[n2];
    }

    public Body findBodyAt(int n2, int n3) {
        Body[] bodyArray = this.getBodies();
        FXVector fXVector = new FXVector();
        for (int i2 = 0; i2 < this.getBodyCount(); ++i2) {
            Body body = bodyArray[i2];
            fXVector.assignFX(n2, n3);
            if (n2 < body.getAABBMinXFX() || n2 > body.getAABBMaxXFX() || n3 < body.getAABBMinYFX() || n3 > body.getAABBMaxYFX()) continue;
            FXVector[] fXVectorArray = body.getAxes();
            FXVector[] fXVectorArray2 = body.getVertices();
            boolean bl = true;
            for (int i3 = 0; i3 < fXVectorArray.length; ++i3) {
                long l2;
                long l3 = (long)fXVector.xFX * (long)fXVectorArray[i3].xFX + (long)fXVector.yFX * (long)fXVectorArray[i3].yFX >> 12;
                long l4 = l2 = (long)fXVectorArray2[0].xFX * (long)fXVectorArray[i3].xFX + (long)fXVectorArray2[0].yFX * (long)fXVectorArray[i3].yFX >> 12;
                for (int i4 = 1; i4 < fXVectorArray2.length; ++i4) {
                    long l5 = (long)fXVectorArray2[i4].xFX * (long)fXVectorArray[i3].xFX + (long)fXVectorArray2[i4].yFX * (long)fXVectorArray[i3].yFX >> 12;
                    if (l2 > l5) {
                        l2 = l5;
                    }
                    if (l4 >= l5) continue;
                    l4 = l5;
                }
                if (l2 <= l3 && l4 >= l3) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return body;
        }
        return null;
    }

    public int bodyIndexOf(int n2) {
        for (int i2 = 0; i2 < this.b; ++i2) {
            if (this.c[i2].o != n2) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(Constraint constraint) {
        if (constraint == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.h; ++i2) {
            if (!this.i[i2].equals(constraint)) continue;
            return i2;
        }
        return -1;
    }

    public void addConstraint(Constraint constraint) {
        if (constraint != null) {
            Constraint[] constraintArray;
            int n2 = this.h;
            Constraint[] constraintArray2 = this.i;
            if (this.i.length <= n2) {
                Constraint[] constraintArray3 = new Constraint[constraintArray2.length + 32];
                System.arraycopy(constraintArray2, 0, constraintArray3, 0, constraintArray2.length);
                constraintArray = constraintArray3;
            } else {
                constraintArray = constraintArray2;
            }
            this.i = constraintArray;
            this.i[this.h++] = constraint;
        }
    }

    public void addScript(Script script) {
        if (script != null) {
            Script[] scriptArray;
            int n2 = this.l;
            Script[] scriptArray2 = this.k;
            if (this.k.length <= n2) {
                Script[] scriptArray3 = new Script[scriptArray2.length + 32];
                System.arraycopy(scriptArray2, 0, scriptArray3, 0, scriptArray2.length);
                scriptArray = scriptArray3;
            } else {
                scriptArray = scriptArray2;
            }
            this.k = scriptArray;
            this.k[this.l++] = script;
        }
    }

    public void addEvent(Event event) {
        this.B.registerEvent(event);
    }

    public void setGravity(int n2) {
        this.t = new FXVector(0, n2 << 12);
    }

    public void setGravity(FXVector fXVector) {
        this.t = fXVector;
    }

    public void setDampingLateralFX(int n2) {
        this.u = n2;
    }

    public void setDampingRotationalFX(int n2) {
        this.v = n2;
    }

    public void tick() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Body[] bodyArray = this.c;
        Constraint[] constraintArray = this.i;
        for (n7 = 0; n7 < this.q; ++n7) {
            if (this.m[n7] == null) continue;
            this.k[this.n[n7]].a(n7, this);
        }
        for (n7 = 0; n7 < this.j.size(); ++n7) {
            ((ExternalForce)this.j.elementAt(n7)).applyForce(bodyArray, this.b, this.w);
        }
        for (n7 = this.G; n7 < this.H; ++n7) {
            Body body = bodyArray[n7];
            if (body.e && body.g) {
                body.applyAcceleration(this.t, this.w);
            }
            body.a(this.w);
        }
        World world = this;
        for (n6 = 0; n6 < world.d; ++n6) {
            world.e[n6] = null;
        }
        n6 = world.d = 0;
        world.I.a();
        world.a();
        int n8 = 0;
        int n9 = 0;
        for (n5 = world.G; n5 < world.H; ++n5) {
            n4 = world.c[n5].j;
            world.I.a(world, world.c[n5]);
            for (int i2 = 0; i2 < n9; ++i2) {
                if (world.C[i2] == null) continue;
                if (world.C[i2].k < n4) {
                    --n8;
                    world.C[i2] = null;
                    continue;
                }
                if (world.c[n5].l > world.C[i2].m || world.C[i2].l > world.c[n5].m) continue;
                Body body = world.C[i2];
                Body body2 = world.c[n5];
                World world2 = world;
                if (!body2.e && !body.e || (body2.n & body.n) != 0 || !body2.f || !body.f) continue;
                if (body2.h instanceof MultiShape || body.h instanceof MultiShape) {
                    int n10 = 1;
                    int n11 = 1;
                    if (body2.h instanceof MultiShape) {
                        n10 = ((MultiShape)body2.h).getShapeCount();
                    }
                    if (body.h instanceof MultiShape) {
                        n11 = ((MultiShape)body.h).getShapeCount();
                    }
                    for (int i3 = 0; i3 < n10; ++i3) {
                        for (int i4 = 0; i4 < n11; ++i4) {
                            Contact contact = Collision.detectCollision(body2, i3, body, i4);
                            if (contact == null) continue;
                            world2.e = World.a(world2.e, world2.d);
                            world2.e[world2.d] = contact;
                            ++world2.d;
                        }
                    }
                    continue;
                }
                Contact contact = Collision.detectCollision(body2, body);
                if (contact == null) continue;
                world2.e = World.a(world2.e, world2.d);
                world2.e[world2.d] = contact;
                ++world2.d;
            }
            world.C = World.a(world.C, n9);
            world.C[n9++] = world.c[n5];
            if (n9 <= ++n8 << 1) continue;
            n9 = World.a((Object[])world.C, n9);
        }
        world.I.b();
        for (n5 = world.G; n5 < world.H; ++n5) {
            world.c[n5].a();
        }
        world.I.getBody();
        for (n4 = n6; n4 < world.d; ++n4) {
            Contact contact = world.e[n4];
            world.e[n4].g = false;
            contact.a.a(contact);
            contact.c.a(contact);
        }
        Contact.a(this.e, this.d);
        Contact.a(this.e, this.d, this.I);
        for (int i5 = 0; i5 < this.J.size(); ++i5) {
            ((ParticleEmitter)this.J.elementAt(i5)).applyAcceleration(this.t, this.w);
        }
        World world3 = this;
        for (n3 = 0; n3 < world3.J.size(); ++n3) {
            ParticleEmitter particleEmitter = (ParticleEmitter)world3.J.elementAt(n3);
            if (!particleEmitter.b) continue;
            n9 = 0;
            for (n4 = world3.G; n4 < world3.H; ++n4) {
                while (n9 < particleEmitter.a && (particleEmitter.g[n9] <= 0 || world3.c[n4].j > particleEmitter.c[n9])) {
                    ++n9;
                }
                for (n5 = n9; n5 < particleEmitter.a && (particleEmitter.g[n5] <= 0 || world3.c[n4].k > particleEmitter.c[n5]); ++n5) {
                    FXVector fXVector;
                    if (particleEmitter.g[n5] <= 0 || world3.c[n4].l >= particleEmitter.d[n5] || world3.c[n4].m <= particleEmitter.d[n5] || !world3.c[n4].f || (fXVector = Collision.a(world3.c[n4], particleEmitter.c[n5], particleEmitter.d[n5])) == null) continue;
                    particleEmitter.a(fXVector, n5);
                }
            }
            world3.I.collideParticles(particleEmitter);
        }
        for (n2 = 0; n2 < this.d; ++n2) {
            this.e[n2].a(this.x);
        }
        for (n2 = 0; n2 < this.h; ++n2) {
            constraintArray[n2].precalculate(this.x);
        }
        n2 = 0;
        for (r = 0; !(r >= this.y || n2 != 0 && this.A); ++r) {
            n2 = 1;
            for (n3 = 0; n3 < this.h; ++n3) {
                n2 &= constraintArray[n3].applyMomentum(this.x);
            }
            for (n3 = 0; n3 < this.d; ++n3) {
                n2 &= this.e[n3].a();
            }
        }
        for (n3 = 0; n3 < this.h; ++n3) {
            constraintArray[n3].postStep();
        }
        n3 = 4096 - this.u;
        int n12 = 4096 - this.v;
        for (n8 = this.G; n8 < this.H; ++n8) {
            bodyArray[n8].integrateVelocity(this.w);
            bodyArray[n8].a(n3, n12);
        }
        for (n8 = 0; n8 < this.d; ++n8) {
            this.e[n8].a(this.w, this.x);
        }
        long l2 = 0L;
        for (r = 0; r < this.z; ++r) {
            for (n12 = 0; n12 < this.d; ++n12) {
                long l3 = this.e[n12].b();
                l2 = l2 < l3 ? l3 : l2;
            }
            if (l2 < 32L) break;
        }
        for (n12 = this.G; n12 < this.H; ++n12) {
            bodyArray[n12].integrateVirtualVelocity(this.w, this.t);
        }
        for (n12 = 0; n12 < this.J.size(); ++n12) {
            ((ParticleEmitter)this.J.elementAt(n12)).integrateParticles(this.w);
        }
        if (this.s != null) {
            this.B.checkEvents(this, this.s);
        }
    }

    private static int a(Object[] objectArray, int n2) {
        int n3 = n2--;
        int n4 = 0;
        while (n4 < n2) {
            while (objectArray[n4] != null && n4 < n2) {
                ++n4;
            }
            while (objectArray[n2] == null && n4 < n2) {
                --n2;
            }
            if (n4 < n2) {
                objectArray[n4] = objectArray[n2];
                objectArray[n2] = null;
            }
            if (objectArray[n2] == null) {
                n3 = n2;
            }
            --n2;
        }
        while (n3 > 0 && objectArray[n3 - 1] == null) {
            --n3;
        }
        return n3;
    }

    static final int b(int[] nArray, int n2) {
        int n3 = n2--;
        int n4 = 0;
        while (n4 < n2) {
            while (nArray[n4] != -1 && n4 < n2) {
                ++n4;
            }
            while (nArray[n2] == -1 && n4 < n2) {
                --n2;
            }
            if (n4 < n2) {
                nArray[n4] = nArray[n2];
                nArray[n2] = -1;
                n3 = n2;
            }
            --n2;
        }
        return n3;
    }

    private final void a() {
        int n2;
        for (n2 = 1; n2 < this.b; ++n2) {
            Body body = this.c[n2];
            for (int i2 = n2 - 1; i2 >= 0 && this.c[i2].j > body.j; --i2) {
                this.c[i2 + 1] = this.c[i2];
            }
            this.c[i2 + 1] = body;
        }
        this.G = -1;
        this.H = this.b;
        for (n2 = 0; n2 < this.b; ++n2) {
            if (this.G < 0 && this.c[n2].k > this.D) {
                this.G = n2;
            }
            if (this.c[n2].j >= this.E) continue;
            this.H = n2 + 1;
        }
        if (this.G < 0) {
            this.G = 0;
        }
    }

    public FXVector getGravity() {
        return this.t;
    }

    public int getDampingLateralFX() {
        return this.u;
    }

    public int getDampingRotationalFX() {
        return this.v;
    }

    public static Constraint loadConstraint(PhysicsFileReader physicsFileReader, Vector vector, UserData userData) {
        switch (physicsFileReader.next()) {
            case 0: {
                return Joint.loadJoint(physicsFileReader, vector, userData);
            }
            case 1: {
                return Spring.loadSpring(physicsFileReader, vector, userData);
            }
            case 3: {
                return Motor.loadMotor(physicsFileReader, vector, userData);
            }
        }
        return null;
    }

    public Vector getEvents() {
        return this.B.getEvents();
    }

    public Vector getParticleEmitters() {
        return this.J;
    }

    public int getBodyCount() {
        return this.b;
    }

    public Body[] getBodies() {
        return this.c;
    }

    public int getBodyStartIndex() {
        return this.G;
    }

    public int getBodyEndIndex() {
        return this.H;
    }

    public int getConstraintCount() {
        return this.h;
    }

    public Constraint[] getConstraints() {
        return this.i;
    }

    public int getContactCount() {
        return this.d;
    }

    public Contact[] getContacts() {
        return this.e;
    }

    public int getScriptCount() {
        return this.l;
    }

    public Script[] getScripts() {
        return this.k;
    }

    public Script getScript(int n2) {
        return this.k[n2];
    }

    public Contact[] getContactsForBody(Body contactArray) {
        Contact[] contactArray2 = new Contact[8];
        int n2 = 0;
        contactArray = contactArray.getContacts();
        for (int i2 = 0; i2 < contactArray.length && contactArray[i2] != null; ++i2) {
            contactArray2[n2++] = contactArray[i2];
        }
        return contactArray2;
    }

    public void translate(FXVector fXVector) {
        int n2 = this.getBodyCount();
        Body[] bodyArray = this.getBodies();
        for (int i2 = 0; i2 < n2; ++i2) {
            bodyArray[i2].positionFX().xFX += fXVector.xFX;
            bodyArray[i2].positionFX().yFX += fXVector.yFX;
            bodyArray[i2].a(0);
        }
    }

    public long getBodyTotalEnergyFX(Body body) {
        long l2 = body.velocityFX().lengthSquareFX() / 2;
        long l3 = (long)(-((int)((long)body.positionFX().yFX * (long)this.t.yFX) >> 12)) + (long)(-((int)((long)body.positionFX().xFX * (long)this.t.xFX) >> 12));
        return l2 + l3;
    }
}

