/*
 * Decompiled with CFR 0.152.
 */
package SonicGolf;

import Coral.crlCanvas;
import SonicGolf.cBall;
import SonicGolf.cCanvas;
import SonicGolf.cCourse;
import SonicGolf.cFP;
import SonicGolf.cSprite;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class cObjects {
    static final int MBOOSTER_MAX_INSTANCES = 1;
    private static final byte RING_SIZE = 12;
    public static final byte RING_SMALL_SIZE = 6;
    public static final byte SPRING_SIZE_X = 24;
    private static final byte SPRING_SIZE_Y = 18;
    public static final byte SPRING_SIZE_Y_COILED = 12;
    public static final byte SPRING45_SIZE_X = 28;
    private static final byte SPRING45_SIZE_Y = 25;
    public static final byte RING_BOX_SIZE = 17;
    public static final byte RING_BOX_HIT_OFFSET = 11;
    private static final byte RING_BOX_EFFECT_SIZE_X = 13;
    private static final byte RING_BOX_EFFECT_SIZE_Y = 10;
    public static final byte SAND_EFFECT_SIZE_X = 16;
    public static final byte SAND_EFFECT_SIZE_Y = 10;
    public static final byte SPLASH_EFFECT_SIZE_X = 16;
    public static final byte SPLASH_EFFECT_SIZE_Y = 8;
    public static final byte FLAG_SIZE_X = 36;
    public static final byte FLAG_SIZE_Y = 39;
    public static final byte ROBOTNIK_SIZE_X = 48;
    public static final byte ROBOTNIK_SIZE_Y = 39;
    public static final byte BIRD_SIZE_X = 12;
    public static final byte BIRD_SIZE_Y = 15;
    private static final byte EXPLOSION_SIZE_X = 21;
    private static final byte EXPLOSION_SIZE_Y = 20;
    public static final byte SMALL_EXPLOSION_SIZE_X = 11;
    public static final byte SMALL_EXPLOSION_SIZE_Y = 10;
    public static final byte FISH_SIZE = 24;
    public static final int FISH_JUMP_HEIGHT = 105;
    private static final byte FISH_SPEED = 8;
    public static final byte BAT_SIZE_X = 27;
    private static final byte BAT_SIZE_Y = 28;
    private static final byte BAT_SPEED = 3;
    private static final byte BAT_MOVE_DIST = 80;
    private static final int BAT_WAKE_UP_RADIUS = 113;
    private static final byte BOBIN_DIAMETER = 24;
    private static final byte SPIKE_BALL_SIZE = 24;
    private static final byte SPIKE_BALL_MOVEMENT = 80;
    private static final byte BEE_SIZE_X = 35;
    private static final byte BEE_SIZE_Y = 19;
    private static final byte BEE_SPEED = 8;
    private static final int BEE_MOVE_DIST = 105;
    private static final int RED_SPRING_BOOST = 300;
    private static final int RED_45_SPRING_BOOST_X = 140;
    private static final int RED_45_SPRING_BOOST_Y = 142;
    private static final byte MAX_HOLE_FLAG_SPARKLE = 4;
    public static final int MAX_RINGS = 40;
    public static final byte MAX_BOBINS = 6;
    public static final byte MAX_RING_BOXES = 6;
    public static final byte MAX_AIM_MARKERS = 2;
    public static final byte MAX_DROP_MARKERS = 8;
    public static final byte MAX_SPRINGS = 6;
    public static final byte MAX_ENEMIES = 4;
    private static final byte RING_BOX_RINGS = 10;
    private static final byte OBJ_RING = 0;
    private static final byte OBJ_RING_BOX = 1;
    private static final byte OBJ_ENEMY = 2;
    public static final byte OBJ_SPRING_RED = 3;
    public static final byte OBJ_SPRING_45R = 4;
    public static final byte OBJ_SPRING_45L = 5;
    public static final byte OBJ_SPIKE_BALL = 6;
    public static final byte OBJ_BOBIN = 8;
    public static final byte OBJ_SPIKE_CHAIN = 7;
    public static final byte OBJ_ROBOTNIK = 9;
    public static final byte OBJ_EXTRA_BALL = 10;
    private static int _mCnvsWidth;
    private static int _mCnvsHeight;
    public static cMarker[] mWaterMarker;
    public static cMarker[] mAimMarker;
    public static cMarker[] mSpikeMarker;
    public static cMarker[] mRingBoxEffect;
    public static cMarker mExtraBallEffect;
    public static int[] mFishY;
    public static boolean[] mEnemyUDRL;
    public static int[] mEnemyX;
    public static int[] mEnemyY;
    public static boolean mBirdLeft;
    public static boolean mBirdUp;
    private static byte[] _mEnemyBirdUpFrames;
    public static int mRobotnikMaxY;
    public static int mRobotnikMinY;
    public static boolean mRobotnikUp;
    public static int mRobotnikLaughTimer;
    public static int[] mBobinX;
    public static int[] mBobinY;
    public static boolean[] mBobinBounce;
    public static int[] mBlockSpikeX;
    public static int[] mBlockSpikeY;
    public static int[] mBlockSpikeMove;
    public static boolean[] mFishSpikesDone;
    public static int mShotDropped;
    private static Image _mImgRing;
    private static Image _mImgHoleFlag;
    private static Image _mImgRingBox;
    private static Image _mImgExplosion;
    private static Image _mImgSmallExplosion;
    private static Image _mImgSplashEffect;
    private static Image _mImgSandEffect;
    private static Image _mImgSpring;
    private static Image _mImgSpring45L;
    private static Image _mImgBirdR;
    private static Image _mImgRobotnikL;
    private static Image _mImgEnemyL;
    private static Image _mImgBobin;
    private static Image _mImgSpikeThing;
    private static Image _mImgExtraBall;
    private static Image _mImgScore;
    public static cSprite[] mSprRings;
    public static cSprite[] mSprRingBoxes;
    private static cSprite[] _mSprRBExplosions;
    public static cSprite mSprHoleFlag;
    public static cSprite mSprHoleFlagExplosion;
    private static cSprite[] _mSprHoleFlagSparkle;
    public static cSprite[] mSprSprings;
    public static cSprite[] mSprSprings45R;
    public static cSprite[] mSprSprings45L;
    public static cSprite mSprBird;
    public static cSprite mSprRobotnik;
    public static cSprite[] mSprEnemies;
    private static cSprite[] _mSprEnemyExplosions;
    public static cSprite[] mSprEnemyBirds;
    public static cSprite mSprBallExplosion;
    public static cSprite mSprSplashEffect;
    public static cSprite mSprSandEffect;
    public static cSprite mSprExtraBallBox;
    public static cSprite _mSprEBBExplosion;
    public static final byte[] mFrm0to1;
    public static final byte[] mFrm0to3;
    public static final byte[] mFrm0to4;
    public static final byte[] mFrm0to5;
    public static final byte[] mFrm0to8;
    public static final byte[] mFrm1to0;
    public static final byte[] mFrm1to2;
    public static final byte[] mFrm1to3;
    public static final byte[] mFrm4to8;
    public static final byte[] mFrm3to0;
    public static final byte[] mFrmStatic0;
    public static final byte[] mFrmStatic1;
    public static final byte[] mFrmStatic2;
    public static final byte[] mFrmStatic3;
    public static final byte[] mFrmStatic4;
    public static final byte[] mFrmStatic6;
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;

    cObjects() {
    }

    public static void open(int n, int n2) {
        int n3;
        _mCnvsWidth = n;
        _mCnvsHeight = n2;
        mWaterMarker = new cMarker[8];
        mAimMarker = new cMarker[2];
        mSpikeMarker = new cMarker[8];
        mRingBoxEffect = new cMarker[6];
        mExtraBallEffect = new cMarker();
        mFishY = new int[4];
        mEnemyUDRL = new boolean[4];
        mEnemyX = new int[4];
        mEnemyY = new int[4];
        _mEnemyBirdUpFrames = new byte[4];
        mBobinX = new int[6];
        mBobinY = new int[6];
        mBobinBounce = new boolean[6];
        mBlockSpikeX = new int[6];
        mBlockSpikeY = new int[6];
        mBlockSpikeMove = new int[6];
        mFishSpikesDone = new boolean[6];
        mSprRings = new cSprite[40];
        mSprRingBoxes = new cSprite[6];
        _mSprRBExplosions = new cSprite[6];
        mSprHoleFlag = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 36, 39, 3);
        mSprHoleFlagExplosion = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 21, 20, 1);
        _mSprHoleFlagSparkle = new cSprite[4];
        mSprSprings = new cSprite[6];
        mSprSprings45R = new cSprite[6];
        mSprSprings45L = new cSprite[6];
        mSprBird = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 12, 15, 2);
        mSprRobotnik = new cSprite(_mCnvsWidth, _mCnvsHeight, 41, 21, 48, 39, 1);
        mSprEnemies = new cSprite[4];
        _mSprEnemyExplosions = new cSprite[4];
        mSprEnemyBirds = new cSprite[4];
        mSprBallExplosion = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 11, 10, 2);
        mSprSplashEffect = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 16, 8, 2);
        mSprSandEffect = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 16, 10, 2);
        mSprExtraBallBox = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 17, 17, 2);
        _mSprEBBExplosion = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 21, 20, 1);
        for (n3 = 0; n3 < 2; ++n3) {
            cObjects.mAimMarker[n3] = new cMarker();
        }
        for (n3 = 0; n3 < 8; ++n3) {
            cObjects.mWaterMarker[n3] = new cMarker();
            cObjects.mSpikeMarker[n3] = new cMarker();
        }
        for (n3 = 0; n3 < 6; ++n3) {
            cObjects.mRingBoxEffect[n3] = new cMarker();
        }
        for (n3 = 0; n3 < 4; ++n3) {
            cObjects._mSprHoleFlagSparkle[n3] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 12, 12, 1);
        }
        for (n3 = 0; n3 < 40; ++n3) {
            cObjects.mSprRings[n3] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 12, 12, 2);
        }
        for (n3 = 0; n3 < 6; ++n3) {
            cObjects.mSprRingBoxes[n3] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 17, 17, 2);
            cObjects._mSprRBExplosions[n3] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 21, 20, 1);
        }
        for (n3 = 0; n3 < 6; ++n3) {
            cObjects.mSprSprings[n3] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 24, 18, 2);
            cObjects.mSprSprings45R[n3] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 28, 25, 2);
            cObjects.mSprSprings45L[n3] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 28, 25, 2);
        }
        for (n3 = 0; n3 < 4; ++n3) {
            cObjects._mSprEnemyExplosions[n3] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 21, 20, 1);
            cObjects.mSprEnemyBirds[n3] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 12, 15, 2);
        }
    }

    private static void loadObjectGraphics(byte by) {
        _mImgRing = crlCanvas.gResourceManager.getImageByID(98957899237583L);
        _mImgRingBox = crlCanvas.gResourceManager.getImageByID(103723446388768L);
        _mImgExplosion = crlCanvas.gResourceManager.getImageByID(77686875145587L);
        _mImgSmallExplosion = crlCanvas.gResourceManager.getImageByID(106201579364765L);
        _mImgHoleFlag = crlCanvas.gResourceManager.getImageByID(85753032805827L);
        _mImgSpring = crlCanvas.gResourceManager.getImageByID(117418535015205L);
        _mImgSpring45L = crlCanvas.gResourceManager.getImageByID(110785445350087L);
        _mImgSandEffect = crlCanvas.gResourceManager.getImageByID(73830996700766L);
        _mImgScore = crlCanvas.gResourceManager.getImageByID(105505896877626L);
        _mImgRobotnikL = crlCanvas.gResourceManager.getImageByID(626828939342690L);
        _mImgExtraBall = crlCanvas.gResourceManager.getImageByID(125245280994754L);
        switch (by) {
            default: {
                _mImgBirdR = crlCanvas.gResourceManager.getImageByID(200292651833027L);
                _mImgEnemyL = crlCanvas.gResourceManager.getImageByID(193231628987953L);
                _mImgSplashEffect = crlCanvas.gResourceManager.getImageByID(109877919364289L);
                break;
            }
            case 1: {
                _mImgBirdR = crlCanvas.gResourceManager.getImageByID(302732879501065L);
                _mImgEnemyL = crlCanvas.gResourceManager.getImageByID(295296135027019L);
                _mImgSpikeThing = crlCanvas.gResourceManager.getImageByID(306507289689755L);
                break;
            }
            case 2: {
                _mImgBirdR = crlCanvas.gResourceManager.getImageByID(397996327064939L);
                _mImgEnemyL = crlCanvas.gResourceManager.getImageByID(391841012974834L);
                _mImgBobin = crlCanvas.gResourceManager.getImageByID(401234634457012L);
                _mImgSpikeThing = crlCanvas.gResourceManager.getImageByID(408561659833482L);
            }
        }
    }

    public static void init(byte by) {
        int n;
        cObjects.loadObjectGraphics(by);
        mSprBallExplosion.setAnimProps(0, mFrm0to5, mFrm0to5.length, 120);
        mSprSplashEffect.setAnimProps(0, mFrm0to8, mFrm0to8.length, 80);
        mSprSandEffect.setAnimProps(0, mFrm0to8, mFrm0to8.length, 80);
        mSprHoleFlag.setAnimProps(0, mFrmStatic0, mFrmStatic0.length, 120);
        mSprHoleFlag.setAnimProps(1, mFrm1to3, mFrm1to3.length, 39);
        mSprHoleFlag.setAnimProps(2, mFrmStatic4, mFrmStatic4.length, 120);
        mSprHoleFlag.playAnim(0, false, false);
        mSprHoleFlagExplosion.setAnimProps(0, mFrm0to5, mFrm0to5.length, 120);
        mSprBird.setAnimProps(0, mFrmStatic0, mFrmStatic0.length, 150);
        mSprBird.setAnimProps(1, mFrm1to2, mFrm1to2.length, 150);
        mSprRobotnik.setAnimProps(0, mFrmStatic0, mFrmStatic0.length, 100);
        cObjects.mSprRobotnik.mVisible = false;
        cObjects.mSprRobotnik.mFacingLeft = true;
        for (n = 0; n < 4; ++n) {
            _mSprHoleFlagSparkle[n].setAnimProps(0, mFrm4to8, mFrm4to8.length, 80);
            _mSprHoleFlagSparkle[n].playAnim(0, true, true);
        }
        for (n = 0; n < 40; ++n) {
            mSprRings[n].setAnimProps(0, mFrm0to3, mFrm0to3.length, 160);
            mSprRings[n].setAnimProps(1, mFrm4to8, mFrm4to8.length, 160);
            mSprRings[n].restartAnim(0, true, true);
        }
        for (n = 0; n < 6; ++n) {
            mSprRingBoxes[n].setAnimProps(0, mFrm0to1, mFrm0to1.length, 250);
            mSprRingBoxes[n].setAnimProps(1, mFrmStatic6, mFrmStatic6.length, 160);
            mSprRingBoxes[n].playAnim(0, true, true);
            _mSprRBExplosions[n].setAnimProps(0, mFrm0to5, mFrm0to5.length, 120);
        }
        mSprExtraBallBox.setAnimProps(0, mFrm0to1, mFrm0to1.length, 250);
        mSprExtraBallBox.setAnimProps(1, mFrmStatic6, mFrmStatic6.length, 160);
        _mSprEBBExplosion.setAnimProps(0, mFrm0to5, mFrm0to5.length, 120);
        for (n = 0; n < 6; ++n) {
            mSprSprings[n].setAnimProps(0, mFrmStatic0, mFrmStatic0.length, 200);
            mSprSprings[n].setAnimProps(1, mFrm1to0, mFrm1to0.length, 100);
            mSprSprings[n].playAnim(0, false, true);
            mSprSprings45R[n].setAnimProps(0, mFrmStatic0, mFrmStatic0.length, 200);
            mSprSprings45R[n].setAnimProps(1, mFrm1to0, mFrm1to0.length, 100);
            mSprSprings45R[n].playAnim(0, false, true);
            mSprSprings45L[n].setAnimProps(0, mFrmStatic0, mFrmStatic0.length, 200);
            mSprSprings45L[n].setAnimProps(1, mFrm1to0, mFrm1to0.length, 100);
            mSprSprings45L[n].playAnim(0, false, true);
        }
        for (n = 0; n < 4; ++n) {
            _mSprEnemyExplosions[n].setAnimProps(0, mFrm0to5, mFrm0to5.length, 120);
            mSprEnemyBirds[n].setAnimProps(0, mFrmStatic0, mFrmStatic0.length, 200);
            mSprEnemyBirds[n].setAnimProps(1, mFrm1to2, mFrm1to2.length, 200);
            cObjects._mEnemyBirdUpFrames[n] = 0;
        }
        switch (by) {
            case 0: {
                for (n = 0; n < 4; ++n) {
                    cObjects.mSprEnemies[n] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 24, 24, 2);
                    mSprEnemies[n].setAnimProps(0, mFrm0to1, mFrm0to1.length, 50);
                    mSprEnemies[n].setAnimProps(1, mFrmStatic1, mFrmStatic1.length, 50);
                    mSprEnemies[n].playAnim(0, true, true);
                    cObjects.mFishY[n] = 0;
                    cObjects.mEnemyUDRL[n] = true;
                }
                break;
            }
            case 1: {
                for (n = 0; n < 4; ++n) {
                    cObjects.mSprEnemies[n] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 27, 28, 3);
                    mSprEnemies[n].setAnimProps(0, mFrmStatic0, mFrmStatic0.length, 100);
                    mSprEnemies[n].setAnimProps(1, mFrmStatic1, mFrmStatic1.length, 50);
                    mSprEnemies[n].setAnimProps(2, mFrm1to3, mFrm1to3.length, 50);
                    mSprEnemies[n].playAnim(0, false, true);
                }
                break;
            }
            case 2: {
                for (n = 0; n < 4; ++n) {
                    cObjects.mSprEnemies[n] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 35, 19, 2);
                    mSprEnemies[n].setAnimProps(0, mFrm0to1, mFrm0to1.length, 50);
                    mSprEnemies[n].setAnimProps(1, mFrmStatic1, mFrmStatic1.length, 50);
                    mSprEnemies[n].playAnim(0, true, true);
                }
                break;
            }
        }
    }

    private static void collided(byte by, int n) {
        switch (by) {
            case 0: {
                cObjects.collidedRing(n);
                break;
            }
            case 1: {
                cObjects.collidedRingBox(n);
                break;
            }
            case 2: {
                cObjects.collidedEnemy(n);
                break;
            }
            case 7: {
                cObjects.collidedSpikeObj(n);
                break;
            }
            case 10: {
                cObjects.collidedExtraBall();
            }
        }
    }

    private static void collidedRing(int n) {
        mSprRings[n].playAnim(1, true, false);
        cCanvas.mPlayer[cCanvas.mCurrPlayerID].pickupRings(1);
    }

    private static void collidedRingBox(int n) {
        if (cCanvas.mPowerShot) {
            cObjects.playEffect(_mSprRBExplosions[n], cObjects.mSprRingBoxes[n].mX - 2, cObjects.mSprRingBoxes[n].mY);
            cObjects.mRingBoxEffect[n].mX = cObjects.mSprRingBoxes[n].mX + 2;
            cObjects.mRingBoxEffect[n].mY = cObjects.mSprRingBoxes[n].mY + 3;
            cObjects.mRingBoxEffect[n].mActive = true;
            cObjects.mSprRingBoxes[n].mY += 11;
            cObjects.mSprRingBoxes[n].mFrameHeight = 6;
            mSprRingBoxes[n].playAnim(1, true, false);
            cCanvas.mPlayer[cCanvas.mCurrPlayerID].pickupRings(10);
        }
    }

    private static void collidedExtraBall() {
        if (cCanvas.mPowerShot) {
            cObjects.playEffect(_mSprEBBExplosion, cObjects.mSprExtraBallBox.mX - 2, cObjects.mSprExtraBallBox.mY);
            cObjects.mExtraBallEffect.mX = cObjects.mSprExtraBallBox.mX + 2;
            cObjects.mExtraBallEffect.mY = cObjects.mSprExtraBallBox.mY + 3;
            cObjects.mExtraBallEffect.mActive = true;
            cObjects.mSprExtraBallBox.mY += 11;
            cObjects.mSprExtraBallBox.mFrameHeight = 6;
            mSprExtraBallBox.playAnim(1, true, false);
            cCanvas.mPlayer[cCanvas.mCurrPlayerID].mBalls = (byte)(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mBalls + 1);
        }
    }

    private static void collidedRobotnik() {
        cBall.explode();
        cBall.mDrowned = false;
        mRobotnikLaughTimer = 30;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void collidedBobin(int n, int n2, int n3) {
        int n4 = cFP.toFP(8);
        int n5 = cFP.toFP(mBobinX[n]);
        int n6 = cFP.toFP(mBobinY[n]);
        int n7 = 6144;
        int n8 = cBall.mFPDY;
        if (n2 < n5 + n4) {
            if (n3 < n6 + n4) {
                cBall.mFPDY = -cFP.mul(Math.abs(cBall.mFPDX), n7);
                cBall.mFPDX = -cFP.mul(Math.abs(n8), n7);
                cBall.mFPX = n2 - cFP.toFP(3);
                cBall.mFPY = n3 - cFP.toFP(3);
            } else if (n3 < n6 + 2 * n4) {
                if (cBall.mFPDX <= 0) return;
                cBall.mFPDX = -cFP.mul(Math.abs(cBall.mFPDX), n7);
                cBall.mFPX = n5 - cFP.toFP(3);
                cBall.mFPY = n3;
            } else {
                cBall.mFPDY = cFP.mul(Math.abs(cBall.mFPDX), n7);
                cBall.mFPDX = -cFP.mul(Math.abs(n8), n7);
                cBall.mFPX = n2 - cFP.toFP(3);
                cBall.mFPY = n3;
            }
        } else if (n2 < n5 + 2 * n4) {
            if (n3 < n6 + n4) {
                if (cBall.mFPDY <= 0) return;
                cBall.mFPDY = -cFP.mul(Math.abs(n8), n7);
                cBall.mFPY = n6 - cFP.toFP(3);
                cBall.mFPX = n2;
            } else {
                if (n3 < n6 + 2 * n4) {
                    return;
                }
                if (cBall.mFPDY >= 0) return;
                cBall.mFPDY = cFP.mul(Math.abs(n8), n7);
                cBall.mFPY = n6 + cFP.toFP(24);
                cBall.mFPX = n2;
            }
        } else if (n3 < n6 + n4) {
            cBall.mFPDY = -cFP.mul(Math.abs(cBall.mFPDX), n7);
            cBall.mFPDX = cFP.mul(Math.abs(n8), n7);
            cBall.mFPX = n2;
            cBall.mFPY = n3 - cFP.toFP(3);
        } else if (n3 < n6 + 2 * n4) {
            if (cBall.mFPDX >= 0) return;
            cBall.mFPDX = cFP.mul(Math.abs(cBall.mFPDX), n7);
            cBall.mFPX = n5 + cFP.toFP(24);
            cBall.mFPY = n3;
        } else {
            cBall.mFPDY = cFP.mul(Math.abs(cBall.mFPDX), n7);
            cBall.mFPDX = cFP.mul(Math.abs(n8), n7);
            cBall.mFPX = n2;
            cBall.mFPY = n3;
        }
        cBall.setTrace();
        cBall.mNaturalSpin = 0;
        cBall.mRoll = (byte)2;
        cBall.mCollided = true;
        cObjects.mBobinBounce[n] = true;
    }

    public static void playEffect(cSprite cSprite2, int n, int n2) {
        cSprite2.mX = n;
        cSprite2.mY = n2;
        cSprite2.mVisible = true;
        cSprite2.restartAnim(0, true, true);
    }

    private static void collidedEnemy(int n) {
        if (cCanvas.mPowerShot && !cBall.mDrowned) {
            cObjects.playEffect(_mSprEnemyExplosions[n], cObjects.mSprEnemies[n].mX - (21 - cObjects.mSprEnemies[n].mFrameWidth >> 1), cObjects.mSprEnemies[n].mY);
            cObjects.mSprEnemyBirds[n].mX = cObjects.mSprEnemies[n].mX - (12 - cObjects.mSprEnemies[n].mFrameWidth >> 1);
            cObjects.mSprEnemyBirds[n].mY = cObjects.mSprEnemies[n].mY;
            cObjects.mSprEnemyBirds[n].mVisible = true;
            mSprEnemyBirds[n].playAnim(0, true, true);
            cObjects.mSprEnemyBirds[n].mFacingLeft = cBall.mFPDX < 0;
            cObjects.mSprEnemies[n].mVisible = false;
            ++cCanvas.mPlayer[cCanvas.mCurrPlayerID].mBirdsFreed;
            ++cCanvas.mTotBirdsFreed;
            cCanvas.mPlayer[cCanvas.mCurrPlayerID].mPointsScore += 250;
        } else {
            cBall.explode();
            if (cCanvas.mCurrCourseID != 0) {
                cBall.mNotMarkerDrop = true;
            }
        }
    }

    private static void collidedSpring(cSprite cSprite2, int n, int n2, int n3) {
        if (cBall.mRoll != 1 || n == 3) {
            cSprite2.playAnim(1, true, true);
        }
        n2 = n2 == 0 ? cFP.toFP(2) : n2;
        switch (n) {
            case 3: {
                cBall.mFPDY = -cFP.toFP(300);
                cBall.mFPX = cBall.mNextFPX - cFP.mul(n3, cFP.div(cBall.mNextFPY - cBall.mFPY, n2));
                cBall.mFPDX = cFP.mul(cBall.mFPDX, cBall.ROLL_FP);
                cBall.mFPDX += cFP.mul(cFP.toFP(cBall.mAppliedSpin * cCanvas.mPlayer[cCanvas.mCurrPlayerID].mSpin), 4096);
                break;
            }
            case 5: {
                cBall.mFPDY = -cFP.toFP(142);
                cBall.mFPDX = -cFP.toFP(140);
                break;
            }
            case 4: {
                cBall.mFPDY = -cFP.toFP(142);
                cBall.mFPDX = cFP.toFP(140);
            }
        }
        cBall.mFPDX = cBall.mFPDX == 0 ? (cBall.mFPDX = cFP.toFP(1 - cCanvas.mRand.nextInt(3))) : cBall.mFPDX;
        cBall.mNaturalSpin = 0;
        cBall.mRoll = 0;
        cBall.mCollided = true;
    }

    public static void checkCollisions(int n, int n2, int n3, int n4) {
        int n5;
        for (n5 = 0; n5 < 40; ++n5) {
            cObjects.checkGenericRectCollision(n, n2, n3, n4, !cObjects.mSprRings[n5].mVisible || mSprRings[n5].getCurrAnim() == 1 ? (byte)1 : 0, cObjects.mSprRings[n5].mX, cObjects.mSprRings[n5].mY, 12, 12, (byte)0, n5);
        }
        for (n5 = 0; n5 < 6; ++n5) {
            cObjects.checkGenericRectCollision(n, n2, n3, n4, !cObjects.mSprRingBoxes[n5].mVisible || mSprRingBoxes[n5].getCurrAnim() == 1 ? (byte)1 : 0, cObjects.mSprRingBoxes[n5].mX, cObjects.mSprRingBoxes[n5].mY, 17, 17, (byte)1, n5);
        }
        cObjects.checkGenericRectCollision(n, n2, n3, n4, !cObjects.mSprExtraBallBox.mVisible || mSprExtraBallBox.getCurrAnim() == 1 ? (byte)1 : 0, cObjects.mSprExtraBallBox.mX, cObjects.mSprExtraBallBox.mY, 17, 17, (byte)10, n5);
        if (cCanvas.mCurrCourseID != 1) {
            for (n5 = 0; n5 < 4; ++n5) {
                cObjects.checkGenericRectCollision(n, n2, n3, n4, !cObjects.mSprEnemies[n5].mVisible || mSprEnemies[n5].getCurrAnim() == 1 ? (byte)1 : 0, cObjects.mSprEnemies[n5].mX, cObjects.mSprEnemies[n5].mY, cObjects.mSprEnemies[0].mFrameWidth, cObjects.mSprEnemies[0].mFrameHeight, (byte)2, n5);
            }
        } else {
            for (n5 = 0; n5 < 4; ++n5) {
                if (cObjects.mSprEnemies[n5].mY <= mEnemyY[n5]) {
                    cObjects.checkGenericRectCollision(n, n2, n3, n4, !cObjects.mSprEnemies[n5].mVisible || mSprEnemies[n5].getCurrAnim() == 1 ? (byte)1 : 0, cObjects.mSprEnemies[n5].mX + 6 + 2, cObjects.mSprEnemies[n5].mY, 9, cObjects.mSprEnemies[0].mFrameHeight, (byte)2, n5);
                    continue;
                }
                cObjects.checkGenericRectCollision(n, n2, n3, n4, !cObjects.mSprEnemies[n5].mVisible || mSprEnemies[n5].getCurrAnim() == 1 ? (byte)1 : 0, cObjects.mSprEnemies[n5].mX, cObjects.mSprEnemies[n5].mY, cObjects.mSprEnemies[0].mFrameWidth, cObjects.mSprEnemies[0].mFrameHeight, (byte)2, n5);
            }
        }
        if (cCanvas.mCurrCourseID == 2) {
            for (n5 = 0; n5 < 6; ++n5) {
                if (mBobinY[n5] == 0) continue;
                cObjects.checkGenericCircleCollision(n, n2, n3, n4, 14, mBobinX[n5] + 12 - 2, mBobinY[n5] + 12 - 2, 8, n5);
            }
            for (n5 = 0; n5 < 6; ++n5) {
                if (mBlockSpikeY[n5] == 0) continue;
                cObjects.checkGenericCircleCollision(n, n2, n3, n4, 12, mBlockSpikeX[n5] + 12, mBlockSpikeY[n5] + 12, 6, n5);
            }
        } else if (cCanvas.mCurrCourseID == 1) {
            for (n5 = 0; n5 < 6; ++n5) {
                cObjects.checkGenericRectCollision(n, n2, n3, n4, mBlockSpikeY[n5] == 0 ? (byte)1 : 0, mBlockSpikeX[n5] + 5, mBlockSpikeY[n5] + Math.abs(mBlockSpikeMove[n5]) + 6, 22, 23, (byte)7, n5);
            }
        }
        if (cCanvas.mCurrHoleID == 9) {
            cObjects.checkGenericCircleCollision(n, n2, n3, n4, 19, cObjects.mSprRobotnik.mX + 19, cObjects.mSprRobotnik.mY + 19, 9, -1);
        }
    }

    public static boolean checkGenericCircleCollision(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        int n11 = cFP.toInt(n);
        int n12 = cFP.toInt(n2);
        int n13 = cFP.toInt(n + n3);
        if (!cObjects.checkSimpleBoxColl(n11, n13, n12, n10 = cFP.toInt(n2 + n4), n6, n7, n5, n5)) {
            return false;
        }
        int n14 = cFP.toFP(n5);
        int n15 = cFP.toFP(n6);
        int n16 = cFP.toFP(n7);
        if (Math.abs(n3) < Math.abs(n4)) {
            int n17 = 0 <= n4 ? n : n + n3;
            int n18 = 0 <= n4 ? n2 : n2 + n4;
            int n19 = n17;
            int n20 = n18;
            int n21 = n19 == n ? n + n3 : n;
            int n22 = n20 == n2 ? n2 + n4 : n2;
            int n23 = cFP.div(n3, n4);
            int n24 = cFP.mul(n2, n23) - n;
            int n25 = 4096;
            do {
                int n26;
                int n27;
                if (cFP.toFP((n27 = cFP.toInt((n17 = cFP.mul(n23, n18 += n25) - n24) - n15)) * n27 + (n26 = cFP.toInt(n18 - n16)) * n26) > cFP.mul(n14 + cFP.toFP(1), n14 + cFP.toFP(1))) continue;
                switch (n8) {
                    case 6: {
                        cObjects.collidedSpikeObj(n9);
                        break;
                    }
                    case 8: {
                        cObjects.collidedBobin(n9, n17, n18);
                        break;
                    }
                    case 9: {
                        cObjects.collidedRobotnik();
                    }
                }
                return true;
            } while (n20 <= n18 && n22 >= n18);
        } else if (n3 != 0) {
            int n28 = 0 <= n3 ? n : n + n3;
            int n29 = 0 <= n3 ? n2 : n2 + n4;
            int n30 = n28;
            int n31 = n29;
            int n32 = n30 == n ? n + n3 : n;
            int n33 = n31 == n2 ? n2 + n4 : n2;
            int n34 = cFP.div(n4, n3);
            int n35 = n2 - cFP.mul(n, n34);
            int n36 = 4096;
            do {
                int n37;
                n29 = cFP.mul(n34, n28 += n36) + n35;
                int n38 = cFP.toInt(n28 - n15);
                if (cFP.toFP(n38 * n38 + (n37 = cFP.toInt(n29 - n16)) * n37) > cFP.mul(n14 + cFP.toFP(1), n14 + cFP.toFP(1))) continue;
                switch (n8) {
                    case 6: {
                        cObjects.collidedSpikeObj(n9);
                        break;
                    }
                    case 8: {
                        cObjects.collidedBobin(n9, n28, n29);
                        break;
                    }
                    case 9: {
                        cObjects.collidedRobotnik();
                    }
                }
                return true;
            } while (n30 <= n28 && n32 >= n28);
        }
        return false;
    }

    private static boolean checkGenericRectCollision(int n, int n2, int n3, int n4, byte by, int n5, int n6, int n7, int n8, byte by2, int n9) {
        int n10 = cFP.toInt(n);
        int n11 = cFP.toInt(n2);
        int n12 = cFP.toInt(n + n3);
        int n13 = cFP.toInt(n2 + n4);
        int n14 = n7 >> 1;
        int n15 = n8 >> 1;
        if (by == 1) {
            return false;
        }
        int n16 = n5 + n14;
        int n17 = n6 + n15;
        if (Math.abs(n10 - n16) <= n14 + 1 && Math.abs(n11 - n17) <= n15 + 1 || Math.abs(n12 - n16) <= n14 + 1 && Math.abs(n13 - n17) <= n15 + 1) {
            cObjects.collided(by2, n9);
            return true;
        }
        if (!cObjects.checkSimpleBoxColl(n10, n12, n11, n13, n16, n17, n14, n15)) {
            return false;
        }
        if (Math.abs(n3) < Math.abs(n4)) {
            int n18 = 0 <= n4 ? n : n + n3;
            int n19 = 0 <= n4 ? n2 : n2 + n4;
            int n20 = n18;
            int n21 = n19;
            int n22 = n20 == n ? n + n3 : n;
            int n23 = n21 == n2 ? n2 + n4 : n2;
            int n24 = cFP.div(n3, n4);
            int n25 = cFP.mul(n2, n24) - n;
            int n26 = 4096;
            do {
                if (Math.abs(cFP.toInt(n18 = cFP.mul(n24, n19 += n26) - n25) - n16) > n14 + 1 || Math.abs(cFP.toInt(n19) - n17) > n15 + 1) continue;
                cObjects.collided(by2, n9);
                return true;
            } while (n21 <= n19 && n23 >= n19);
        } else if (n3 != 0) {
            int n27 = 0 <= n3 ? n : n + n3;
            int n28 = 0 <= n3 ? n2 : n2 + n4;
            int n29 = n27;
            int n30 = n28;
            int n31 = n29 == n ? n + n3 : n;
            int n32 = n30 == n ? n2 + n4 : n2;
            int n33 = cFP.div(n4, n3);
            int n34 = n2 - cFP.mul(n, n33);
            int n35 = 4096;
            do {
                n28 = cFP.mul(n33, n27 += n35) + n34;
                if (Math.abs(cFP.toInt(n27) - n16) > n14 + 1 || Math.abs(cFP.toInt(n28) - n17) > n15 + 1) continue;
                cObjects.collided(by2, n9);
                return true;
            } while (n29 <= n27 && n31 >= n27);
        }
        return false;
    }

    public static void collidedSpikeObj(int n) {
        cBall.setTrace();
        cBall.explode();
    }

    public static boolean checkSpringCollision(int n, int n2, int n3, int n4, cSprite[] cSpriteArray, int n5, int n6, int n7) {
        int n8 = cFP.toInt(n);
        int n9 = cFP.toInt(n2) + 4;
        int n10 = cFP.toInt(n + n4);
        int n11 = n5 >> 1;
        boolean bl = false;
        for (int i = 0; i < n6; ++i) {
            if (!cSpriteArray[i].mVisible) continue;
            int n12 = cSpriteArray[i].mX + n11;
            if (n12 - n11 > n8) {
                ++n8;
                ++n10;
            } else if (n12 + n11 < n8) {
                n8 += 0;
                n10 += 0;
            }
            if (n7 == 3) {
                if (Math.abs(n8 - n12) > n11 && Math.abs(n10 - n12) > n11 - 3 || n9 < cSpriteArray[i].mY - 12 || n9 > cSpriteArray[i].mY + 12) continue;
                cObjects.collidedSpring(cSpriteArray[i], n7, n3, n4);
                bl = true;
                continue;
            }
            if (Math.abs(n8 - n12) > n11 && Math.abs(n10 - n12) > n11 || n9 < cSpriteArray[i].mY || n9 > cSpriteArray[i].mY + 18) continue;
            cObjects.collidedSpring(cSpriteArray[i], n7, n3, n4);
            bl = true;
        }
        return bl;
    }

    private static boolean checkSimpleBoxColl(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return !(n + 1 < n5 - n7 && n2 + 1 < n5 - n7 || n - 1 > n5 + n7 && n2 - 1 > n5 + n7 || n3 - 1 > n6 + n8 && n4 - 1 > n6 + n8 || n3 + 1 < n6 - n8 && n4 + 1 < n6 - n8);
    }

    public static void reset() {
        cObjects.resetHoleFlag();
        cObjects.resetRings();
        cObjects.resetPowerUpBoxes();
        cObjects.resetSprings();
        cObjects.resetEnemies();
        switch (cCanvas.mCurrCourseID) {
            case 2: {
                cObjects.resetBobins();
            }
            case 1: {
                cObjects.resetSpikeThings();
            }
        }
    }

    private static void resetHoleFlag() {
        mSprHoleFlag.playAnim(0, false, true);
        cObjects.mSprHoleFlagExplosion.mVisible = false;
        for (int i = 0; i < 4; ++i) {
            cObjects._mSprHoleFlagSparkle[i].mVisible = false;
        }
        mSprBird.playAnim(0, false, true);
        cObjects.mSprBird.mVisible = false;
    }

    private static void resetRings() {
        for (int i = 0; i < 40; ++i) {
            if (!cCanvas.mLoadingGame) {
                cObjects.mSprRings[i].mVisible = false;
                mSprRings[i].restartAnim(0, true, true);
                continue;
            }
            if (!cObjects.mSprRings[i].mVisible) continue;
            mSprRings[i].restartAnim(0, true, true);
        }
    }

    private static void resetPowerUpBoxes() {
        for (int i = 0; i < 6; ++i) {
            cObjects.mRingBoxEffect[i].mActive = false;
            cObjects._mSprRBExplosions[i].mVisible = false;
            cObjects.mSprRingBoxes[i].mFrameHeight = 17;
            if (!cCanvas.mLoadingGame) {
                mSprRingBoxes[i].playAnim(0, true, true);
                cObjects.mSprRingBoxes[i].mVisible = false;
                continue;
            }
            if (cObjects.mSprRingBoxes[i].mVisible) {
                mSprRingBoxes[i].playAnim(0, true, true);
                continue;
            }
            mSprRingBoxes[i].playAnim(1, true, false);
        }
        cObjects.mExtraBallEffect.mActive = false;
        cObjects._mSprEBBExplosion.mVisible = false;
        if (!cCanvas.mLoadingGame) {
            cObjects.mSprExtraBallBox.mFrameHeight = 17;
            mSprExtraBallBox.playAnim(0, true, true);
            cObjects.mSprExtraBallBox.mVisible = false;
        }
    }

    private static void resetSprings() {
        for (int i = 0; i < 6; ++i) {
            mSprSprings[i].playAnim(0, false, true);
            cObjects.mSprSprings[i].mVisible = false;
            mSprSprings45R[i].playAnim(0, false, true);
            cObjects.mSprSprings45R[i].mVisible = false;
            mSprSprings45L[i].playAnim(0, false, true);
            cObjects.mSprSprings45L[i].mVisible = false;
        }
    }

    private static void resetSpikeThings() {
        for (int i = 0; i < 6; ++i) {
            cObjects.mBlockSpikeX[i] = 0;
            cObjects.mBlockSpikeY[i] = 0;
            cObjects.mBlockSpikeMove[i] = 0;
        }
    }

    private static void resetBobins() {
        for (int i = 0; i < 6; ++i) {
            cObjects.mBobinX[i] = 0;
            cObjects.mBobinY[i] = 0;
        }
    }

    public static void updateFlag() {
        if (mSprHoleFlagExplosion.getCurrFrame() == 4) {
            cObjects.mSprHoleFlagExplosion.mVisible = false;
        }
        if (mSprHoleFlag != null) {
            mSprHoleFlag.updateAnim();
        }
        for (int i = 0; i < 4; ++i) {
            _mSprHoleFlagSparkle[i].updateAnim();
        }
        if (mSprHoleFlagExplosion != null && cObjects.mSprHoleFlagExplosion.mVisible) {
            mSprHoleFlagExplosion.updateAnim();
        }
        if (mSprBird != null && cObjects.mSprBird.mVisible) {
            mSprBird.updateAnim();
        }
    }

    public static void updateSpikeBalls() {
        for (int i = 0; i < 6; ++i) {
            if (mBlockSpikeY[i] == 0) continue;
            int n = i;
            mBlockSpikeMove[n] = mBlockSpikeMove[n] + 1;
            if (mBlockSpikeMove[n] > 80) {
                cObjects.mBlockSpikeMove[i] = -80;
            }
            if (mBlockSpikeMove[i] >= 0) {
                int n2 = i;
                mBlockSpikeY[n2] = mBlockSpikeY[n2] - 1;
            } else {
                int n3 = i;
                mBlockSpikeY[n3] = mBlockSpikeY[n3] + 1;
            }
            int n4 = (mBlockSpikeY[i] - 2) / 12;
            int n5 = (mBlockSpikeX[i] + 12) / 12;
            if (n4 < 0 || cCourse.mCollisionInfo[n4][n5] != 0) {
                int n6 = i;
                mBlockSpikeY[n6] = mBlockSpikeY[n6] + 1;
                cObjects.mBlockSpikeMove[i] = -80;
                continue;
            }
            if (cCourse.mCollisionInfo[n4 + 5][n5] == 0) continue;
            int n7 = i;
            mBlockSpikeY[n7] = mBlockSpikeY[n7] - 1;
            cObjects.mBlockSpikeMove[i] = 0;
        }
    }

    public static void updateSpikeChains() {
        for (int i = 0; i < 6; ++i) {
            if (mBlockSpikeY[i] != 0) {
                int n;
                int n2 = mBlockSpikeX[i] / 12;
                if (mBlockSpikeMove[i] >= 0) {
                    int n3 = i;
                    mBlockSpikeMove[n3] = mBlockSpikeMove[n3] + 8;
                    n = (mBlockSpikeY[i] + mBlockSpikeMove[i] + 8 - 24) / 12;
                    if (cCourse.mCollisionInfo[n + 1][n2] != 1) continue;
                    int n4 = i;
                    mBlockSpikeMove[n4] = mBlockSpikeMove[n4] - 8;
                    cObjects.mBlockSpikeMove[i] = -mBlockSpikeMove[i];
                    if (!cBall.mCheckFishSpikeDrop) continue;
                    cObjects.mFishSpikesDone[i] = true;
                    continue;
                }
                int n5 = i;
                mBlockSpikeMove[n5] = mBlockSpikeMove[n5] + 1;
                n = (mBlockSpikeY[i] - mBlockSpikeMove[n5] - 8) / 12;
                if (cCourse.mCollisionInfo[n][n2] != 1) continue;
                cObjects.mBlockSpikeMove[i] = 8;
                cObjects.mFishSpikesDone[i] = false;
                continue;
            }
            cObjects.mFishSpikesDone[i] = true;
        }
    }

    public static void updateSprings() {
        for (int i = 0; i < 6; ++i) {
            if (mSprSprings[i] != null && cObjects.mSprSprings[i].mVisible) {
                if (mSprSprings[i].getCurrFrame() == mSprSprings[i].getEndFrame(0)) {
                    mSprSprings[i].playAnim(0, false, false);
                } else {
                    mSprSprings[i].updateAnim();
                }
            }
            if (mSprSprings45R[i] != null && cObjects.mSprSprings45R[i].mVisible) {
                if (mSprSprings45R[i].getCurrFrame() == mSprSprings45R[i].getEndFrame(0)) {
                    mSprSprings45R[i].playAnim(0, false, false);
                } else {
                    mSprSprings45R[i].updateAnim();
                }
            }
            if (mSprSprings45L[i] == null || !cObjects.mSprSprings45L[i].mVisible) continue;
            if (mSprSprings45L[i].getCurrFrame() == mSprSprings45L[i].getEndFrame(0)) {
                mSprSprings45L[i].playAnim(0, false, false);
                continue;
            }
            mSprSprings45L[i].updateAnim();
        }
    }

    public static void updateRings() {
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < 40; ++i) {
            if (mSprRings[i] == null || !cObjects.mSprRings[i].mVisible) continue;
            if (mSprRings[i].getCurrAnim() == 0) {
                if (n == -1) {
                    n = i;
                    mSprRings[i].updateAnim();
                    n2 = mSprRings[n].getCurrFrameIndex();
                }
                mSprRings[i].setCurrFrame(n2);
            } else {
                mSprRings[i].updateAnim();
            }
            if (mSprRings[i].getCurrFrame() != 8) continue;
            cObjects.mSprRings[i].mVisible = false;
        }
    }

    public static void updateRobotnik() {
        if (cObjects.mSprRobotnik.mVisible) {
            mSprRobotnik.updateAnim();
        }
        if (mRobotnikLaughTimer <= 0) {
            cObjects.mSprRobotnik.mY = cObjects.mSprRobotnik.mY + (mRobotnikUp ? -2 - cCanvas.mRand.nextInt(3) : 2 + cCanvas.mRand.nextInt(3));
            boolean bl = cObjects.mSprRobotnik.mFacingLeft = cObjects.mSprRobotnik.mX + 24 > cFP.toInt(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mFPX) + 12;
            if (cObjects.mSprRobotnik.mY >= mRobotnikMinY) {
                mRobotnikUp = true;
            } else if (cObjects.mSprRobotnik.mY <= mRobotnikMaxY) {
                mRobotnikUp = false;
            }
        }
    }

    public static void updatePowerUpBoxes() {
        for (int i = 0; i < 6; ++i) {
            if (mSprRingBoxes[i] != null && mSprRingBoxes[i].getCurrAnim() == 0) {
                if (mSprRingBoxes[i].getCurrFrame() == 1) {
                    mSprRingBoxes[i].updateAnim();
                } else if (cCanvas.mRand.nextInt(3) == 1) {
                    mSprRingBoxes[i].updateAnim();
                }
            }
            if (_mSprRBExplosions[i].getCurrFrame() == 4) {
                cObjects._mSprRBExplosions[i].mVisible = false;
            }
            if (_mSprRBExplosions[i] == null || !cObjects._mSprRBExplosions[i].mVisible) continue;
            _mSprRBExplosions[i].updateAnim();
        }
        if (mSprExtraBallBox != null && mSprExtraBallBox.getCurrAnim() == 0) {
            if (mSprExtraBallBox.getCurrFrame() == 1) {
                mSprExtraBallBox.updateAnim();
            } else if (cCanvas.mRand.nextInt(3) == 1) {
                mSprExtraBallBox.updateAnim();
            }
        }
        if (_mSprEBBExplosion.getCurrFrame() == 4) {
            cObjects._mSprEBBExplosion.mVisible = false;
        }
        if (_mSprEBBExplosion != null && cObjects._mSprEBBExplosion.mVisible) {
            _mSprEBBExplosion.updateAnim();
        }
    }

    private static void updateFish(int n) {
        if (cCanvas.mRand.nextInt(2) == 1) {
            mSprEnemies[n].updateAnim();
        }
        if (cObjects.mSprEnemies[n].mY <= mFishY[n] - 105) {
            cObjects.mEnemyUDRL[n] = false;
            if (cBall.mCheckFishSpikeDrop) {
                cObjects.mFishSpikesDone[n] = true;
            }
        } else if (cObjects.mSprEnemies[n].mY >= mFishY[n] + 105) {
            cObjects.mEnemyUDRL[n] = true;
            cObjects.mFishSpikesDone[n] = false;
        }
        cObjects.mSprEnemies[n].mY = mEnemyUDRL[n] ? (cObjects.mSprEnemies[n].mY - (mFishY[n] - 105) < 40 ? (cObjects.mSprEnemies[n].mY -= 8 - (40 - (cObjects.mSprEnemies[n].mY - (mFishY[n] - 105))) / 5) : (cObjects.mSprEnemies[n].mY -= 8)) : (cObjects.mSprEnemies[n].mY - (mFishY[n] - 105) < 40 ? (cObjects.mSprEnemies[n].mY += 9 - (40 - (cObjects.mSprEnemies[n].mY - (mFishY[n] - 105))) / 5) : (cObjects.mSprEnemies[n].mY += 8));
    }

    public static void updateHoleBird() {
        if (cObjects.mSprBird.mY > cFP.toInt(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mFPY) - 55 && mBirdUp) {
            cObjects.mSprBird.mY -= 6;
        } else if (cObjects.mSprBird.mY < cFP.toInt(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mFPY) && !mBirdUp) {
            cObjects.mSprBird.mY += 6;
        } else {
            if (mSprBird.getCurrAnim() == 0) {
                mSprBird.playAnim(1, true, true);
            }
            cObjects.mSprBird.mX = mBirdLeft ? cObjects.mSprBird.mX - 6 : cObjects.mSprBird.mX + 6;
        }
    }

    private static void updateBat(int n) {
        mSprEnemies[n].updateAnim();
        int n2 = Math.abs(mEnemyX[n] - cFP.toInt(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mFPX));
        int n3 = Math.abs(mEnemyY[n] - cFP.toInt(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mFPY));
        if (n2 < 113 && n3 < 113 && cObjects.mSprEnemies[n].mY < cFP.toInt(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mFPY)) {
            if (mSprEnemies[n].getCurrAnim() != 2) {
                mSprEnemies[n].playAnim(2, true, true);
                boolean bl = cObjects.mEnemyUDRL[n] = cObjects.mSprEnemies[n].mX > cFP.toInt(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mFPX);
            }
            if (mSprEnemies[n].getCurrAnim() == 2 && cObjects.mSprEnemies[n].mY <= mEnemyY[n] + 12 && cObjects.mSprEnemies[n].mX <= mEnemyX[n] + 3 && cObjects.mSprEnemies[n].mX >= mEnemyX[n] - 3) {
                cObjects.mSprEnemies[n].mX = cObjects.mSprEnemies[n].mX - (mEnemyUDRL[n] ? -3 : 3);
                cObjects.mSprEnemies[n].mY += 2;
            }
        }
        if (mSprEnemies[n].getCurrAnim() == 2) {
            cObjects.mSprEnemies[n].mX = cObjects.mSprEnemies[n].mX + (mEnemyUDRL[n] ? -3 : 3);
        }
        if (cObjects.mSprEnemies[n].mX < mEnemyX[n] - 80) {
            cObjects.mEnemyUDRL[n] = false;
        } else if (cObjects.mSprEnemies[n].mX > mEnemyX[n] + 80) {
            cObjects.mEnemyUDRL[n] = true;
        }
        if (n2 > 80 && n3 > 113 && cObjects.mSprEnemies[n].mX < mEnemyX[n] + 1 && cObjects.mSprEnemies[n].mX > mEnemyX[n] - 1) {
            cObjects.mSprEnemies[n].mX = cObjects.mSprEnemies[n].mX - (mEnemyUDRL[n] ? -3 : 3);
            if (mSprEnemies[n].getCurrAnim() == 2 && cObjects.mSprEnemies[n].mY > mEnemyY[n]) {
                cObjects.mSprEnemies[n].mY -= 2;
            } else {
                mSprEnemies[n].playAnim(0, false, true);
            }
        }
    }

    private static void updateBee(int n) {
        mSprEnemies[n].updateAnim();
        if (mEnemyY[n] <= 0) {
            cObjects.mSprEnemies[n].mX = cObjects.mSprEnemies[n].mX + (mEnemyUDRL[n] ? -8 : 8);
            if (cObjects.mSprEnemies[n].mX < mEnemyX[n] - 105 || cObjects.mSprEnemies[n].mX > mEnemyX[n] + 105) {
                cObjects.mEnemyY[n] = 10;
            }
        } else {
            int n2 = n;
            mEnemyY[n2] = mEnemyY[n2] - 1;
            if (mEnemyY[n2] == 0) {
                int n3 = n;
                mEnemyUDRL[n3] = mEnemyUDRL[n3] ^ true;
            }
        }
    }

    public static void updateSpriteEffect(cSprite cSprite2) {
        if (cSprite2.mVisible && !cSprite2.updateAnim()) {
            cSprite2.mVisible = false;
        }
    }

    public static void updateEnemies() {
        for (int i = 0; i < 4; ++i) {
            if (mSprEnemies[i] != null && cObjects.mSprEnemies[i].mVisible) {
                switch (cCanvas.mCurrCourseID) {
                    case 0: {
                        cObjects.updateFish(i);
                        break;
                    }
                    case 1: {
                        cObjects.updateBat(i);
                        break;
                    }
                    case 2: {
                        cObjects.updateBee(i);
                    }
                }
            } else if (cCanvas.mCurrCourseID == 0 && cCanvas.mDifficulty != 0) {
                cObjects.mFishSpikesDone[i] = true;
            }
            cObjects.updateSpriteEffect(_mSprEnemyExplosions[i]);
            cObjects.updateEnemyBird(mSprEnemyBirds[i], i);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void updateEnemyBird(cSprite var0, int var1_1) {
        block6: {
            if (var0 == null || !var0.mVisible) break block6;
            var0.updateAnim();
            if (var0.getCurrAnim() == 0) {
                var0.mY -= 6;
            } else {
                v0 = var0.mX = var0.mFacingLeft != false ? var0.mX - 6 : var0.mX + 6;
            }
            if (cCanvas.mCurrCourseID != 0) ** GOTO lbl-1000
            v1 = var1_1;
            v2 = cObjects._mEnemyBirdUpFrames[v1];
            cObjects._mEnemyBirdUpFrames[v1] = (byte)(v2 + 1);
            if (v2 > 8 && var0.getCurrAnim() == 0) {
                var0.playAnim(1, true, true);
            } else lbl-1000:
            // 2 sources

            {
                v3 = var1_1;
                v4 = cObjects._mEnemyBirdUpFrames[v3];
                cObjects._mEnemyBirdUpFrames[v3] = (byte)(v4 + 1);
                if (v4 > 2 && var0.getCurrAnim() == 0) {
                    var0.playAnim(1, true, true);
                }
            }
            if (var0.mVisible && (var0.mY + cFP.toInt(cCourse.mFPY) < -25 || var0.mX + cFP.toInt(cCourse.mFPX) < -25 || var0.mX + cFP.toInt(cCourse.mFPX) > cObjects._mCnvsWidth + 25)) {
                var0.mVisible = false;
            }
        }
    }

    public static void renderFlag(Graphics graphics, int n, int n2) {
        int n3 = cObjects.mSprHoleFlag.mX + n;
        int n4 = cObjects.mSprHoleFlag.mY + n2;
        mSprHoleFlag.render(graphics, _mImgHoleFlag, n3, n4);
        if (cCanvas.mGameLoopState == 9) {
            int n5 = cObjects.mSprHoleFlag.mFrameWidth >> 1;
            int n6 = 2 * cObjects.mSprHoleFlag.mFrameHeight / 5;
            Image image = _mImgRing;
            int n7 = 4;
            while (--n7 >= 0) {
                if (n7 % 2 == 0) {
                    _mSprHoleFlagSparkle[n7].render(graphics, image, n3 + n5 + cCanvas.mRand.nextInt(n5), n4 + cCanvas.mRand.nextInt(n6));
                    continue;
                }
                _mSprHoleFlagSparkle[n7].render(graphics, image, n3 - 8 + n5 - cCanvas.mRand.nextInt(n5), n4 + cCanvas.mRand.nextInt(n6));
            }
        }
    }

    public static void renderFlagEffects(Graphics graphics, int n, int n2) {
        cObjects.renderSprite(graphics, mSprHoleFlagExplosion, _mImgExplosion, cFP.toInt(cCourse.mFPHoleX) - 10 + n, cFP.toInt(cCourse.mFPHoleY) - 10 + n2);
        cObjects.renderSprite(graphics, mSprBird, _mImgBirdR, cObjects.mSprBird.mX + n, cObjects.mSprBird.mY + n2, !mBirdLeft ? (byte)1 : 0);
    }

    public static void renderRings(Graphics graphics, int n, int n2) {
        Image image = _mImgRing;
        int n3 = 40;
        while (--n3 >= 0) {
            if (!cObjects.mSprRings[n3].mVisible) continue;
            mSprRings[n3].render(graphics, image, cObjects.mSprRings[n3].mX + n, cObjects.mSprRings[n3].mY + n2);
        }
    }

    public static void renderSprings(Graphics graphics, int n, int n2) {
        int n3 = 6;
        while (--n3 >= 0) {
            cObjects.renderSprite(graphics, mSprSprings[n3], _mImgSpring, cObjects.mSprSprings[n3].mX + n, cObjects.mSprSprings[n3].mY - 8 + n2);
            cObjects.renderSprite(graphics, mSprSprings45R[n3], _mImgSpring45L, cObjects.mSprSprings45R[n3].mX + n, cObjects.mSprSprings45R[n3].mY + n2, (byte)0);
            cObjects.renderSprite(graphics, mSprSprings45L[n3], _mImgSpring45L, cObjects.mSprSprings45L[n3].mX + n, cObjects.mSprSprings45L[n3].mY + n2);
        }
    }

    public static void renderBobins(Graphics graphics, int n, int n2) {
        int n3 = 6;
        while (--n3 >= 0) {
            if (mBobinY[n3] == 0) continue;
            if (mBobinBounce[n3]) {
                cCanvas.renderImage(graphics, _mImgBobin, 24, 0, 26, 26, mBobinX[n3] + n - 1, mBobinY[n3] + n2 - 1);
                cObjects.mBobinBounce[n3] = false;
                continue;
            }
            cCanvas.renderImage(graphics, _mImgBobin, 0, 0, 24, 24, mBobinX[n3] + n, mBobinY[n3] + n2);
        }
    }

    public static void renderSpikeBalls(Graphics graphics, int n, int n2) {
        int n3 = 6;
        while (--n3 >= 0) {
            if (mBlockSpikeY[n3] == 0) continue;
            cCanvas.renderImage(graphics, _mImgSpikeThing, 0, 0, 24, 24, mBlockSpikeX[n3] + n, mBlockSpikeY[n3] + n2);
        }
    }

    public static void renderSpikeChains(Graphics graphics, int n, int n2) {
        int n3 = 6;
        while (--n3 >= 0) {
            if (mBlockSpikeY[n3] == 0) continue;
            int n4 = 0;
            while (n4 <= Math.abs(mBlockSpikeMove[n3]) - 6) {
                cCanvas.renderImage(graphics, _mImgSpikeThing, 9, 6, 6, 12, mBlockSpikeX[n3] + n + 9, mBlockSpikeY[n3] + n2 + Math.abs(mBlockSpikeMove[n3]) - (n4 += 12));
            }
            cCanvas.renderImage(graphics, _mImgSpikeThing, 0, 18, 24, 24, mBlockSpikeX[n3] + n, Math.abs(mBlockSpikeMove[n3]) + mBlockSpikeY[n3] + n2);
            cCanvas.renderImage(graphics, _mImgSpikeThing, 0, 0, 24, 6, mBlockSpikeX[n3] + n, mBlockSpikeY[n3] + n2);
        }
    }

    public static void renderRobotnik(Graphics graphics, int n, int n2) {
        if (cObjects.mSprRobotnik.mVisible) {
            mSprRobotnik.render(graphics, _mImgRobotnikL, cObjects.mSprRobotnik.mX + n, cObjects.mSprRobotnik.mY + n2, cObjects.mSprRobotnik.mFacingLeft ? (byte)1 : 0);
            if (mRobotnikLaughTimer-- > 0 && cCanvas.mFrameCount % 2 == 0) {
                if (cObjects.mSprRobotnik.mFacingLeft) {
                    cCanvas.renderImage(graphics, _mImgRobotnikL, 1, 56, 40, 16, cObjects.mSprRobotnik.mX + n + 2, cObjects.mSprRobotnik.mY + n2 - 1);
                } else {
                    graphics.setClip(cObjects.mSprRobotnik.mX + n + 6, cObjects.mSprRobotnik.mY + n2 - 1, 40, 16);
                    graphics.drawRegion(_mImgRobotnikL, 1, 56, 40, 16, 2, cObjects.mSprRobotnik.mX + n + 6, cObjects.mSprRobotnik.mY + n2 - 1, 0x10 | 4);
                }
            } else if (mRobotnikLaughTimer > 0) {
                if (cObjects.mSprRobotnik.mFacingLeft) {
                    cCanvas.renderImage(graphics, _mImgRobotnikL, 1, 75, 40, 15, cObjects.mSprRobotnik.mX + n + 2, cObjects.mSprRobotnik.mY + n2);
                } else {
                    graphics.setClip(cObjects.mSprRobotnik.mX + n + 6, cObjects.mSprRobotnik.mY + n2, 40, 15);
                    graphics.drawRegion(_mImgRobotnikL, 1, 75, 40, 15, 2, cObjects.mSprRobotnik.mX + n + 6, cObjects.mSprRobotnik.mY + n2, 0x10 | 4);
                }
            } else if (cCanvas.mFrameCount % 4 == 0 || cCanvas.mFrameCount % 4 == 1) {
                if (cObjects.mSprRobotnik.mFacingLeft) {
                    cCanvas.renderImage(graphics, _mImgRobotnikL, 1, 40, 40, 14, cObjects.mSprRobotnik.mX + n + 2, cObjects.mSprRobotnik.mY + n2);
                } else {
                    graphics.setClip(cObjects.mSprRobotnik.mX + n + 6, cObjects.mSprRobotnik.mY + n2, 40, 14);
                    graphics.drawRegion(_mImgRobotnikL, 1, 40, 40, 14, 2, cObjects.mSprRobotnik.mX + n + 6, cObjects.mSprRobotnik.mY + n2, 0x10 | 4);
                }
            } else if (cObjects.mSprRobotnik.mFacingLeft) {
                cCanvas.renderImage(graphics, _mImgRobotnikL, 1, 22, 40, 14, cObjects.mSprRobotnik.mX + n + 2, cObjects.mSprRobotnik.mY + n2);
            } else {
                graphics.setClip(cObjects.mSprRobotnik.mX + n + 6, cObjects.mSprRobotnik.mY + n2, 40, 14);
                graphics.drawRegion(_mImgRobotnikL, 1, 22, 40, 14, 2, cObjects.mSprRobotnik.mX + n + 6, cObjects.mSprRobotnik.mY + n2, 0x10 | 4);
            }
            if (cCanvas.mFrameCount % 2 == 0) {
                if (cObjects.mSprRobotnik.mFacingLeft) {
                    cCanvas.renderImage(graphics, _mImgRobotnikL, 41, 86, 9, 7, cObjects.mSprRobotnik.mX + n + 47, cObjects.mSprRobotnik.mY + n2 + 20);
                } else {
                    graphics.setClip(cObjects.mSprRobotnik.mX + n - 8, cObjects.mSprRobotnik.mY + n2 + 20, 9, 7);
                    graphics.drawRegion(_mImgRobotnikL, 41, 86, 9, 7, 2, cObjects.mSprRobotnik.mX + n - 8, cObjects.mSprRobotnik.mY + n2 + 20, 0x10 | 4);
                }
            } else if (cObjects.mSprRobotnik.mFacingLeft) {
                cCanvas.renderImage(graphics, _mImgRobotnikL, 41, 97, 12, 9, cObjects.mSprRobotnik.mX + n + 47, cObjects.mSprRobotnik.mY + n2 + 20);
            } else {
                graphics.setClip(cObjects.mSprRobotnik.mX + n - 11, cObjects.mSprRobotnik.mY + n2 + 20, 12, 9);
                graphics.drawRegion(_mImgRobotnikL, 41, 97, 12, 9, 2, cObjects.mSprRobotnik.mX + n - 11, cObjects.mSprRobotnik.mY + n2 + 20, 0x10 | 4);
            }
        }
    }

    private static void renderSprite(Graphics graphics, cSprite cSprite2, Image image, int n, int n2, byte by) {
        if (cSprite2.mVisible) {
            cSprite2.render(graphics, image, n, n2, by);
        }
    }

    private static void renderSprite(Graphics graphics, cSprite cSprite2, Image image, int n, int n2) {
        if (cSprite2.mVisible) {
            cSprite2.render(graphics, image, n, n2);
        }
    }

    public static void renderEffects(Graphics graphics, int n, int n2) {
        cObjects.renderSprite(graphics, mSprBallExplosion, _mImgSmallExplosion, cObjects.mSprBallExplosion.mX + n, cObjects.mSprBallExplosion.mY + n2);
        cObjects.renderSprite(graphics, mSprSplashEffect, _mImgSplashEffect, cObjects.mSprSplashEffect.mX + n, cObjects.mSprSplashEffect.mY + n2);
        cObjects.renderSprite(graphics, mSprSandEffect, _mImgSandEffect, cObjects.mSprSandEffect.mX + n, cObjects.mSprSandEffect.mY + n2);
    }

    public static void renderEnemies(Graphics graphics, int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            switch (cCanvas.mCurrCourseID) {
                case 0: {
                    cObjects.renderSprite(graphics, mSprEnemies[i], _mImgEnemyL, cObjects.mSprEnemies[i].mX + n, cObjects.mSprEnemies[i].mY + n2);
                    break;
                }
                case 1: 
                case 2: {
                    cObjects.renderSprite(graphics, mSprEnemies[i], _mImgEnemyL, cObjects.mSprEnemies[i].mX + n, cObjects.mSprEnemies[i].mY + n2, mEnemyUDRL[i] ? (byte)1 : 0);
                }
            }
            if (cObjects.mSprEnemyBirds[i].mVisible) {
                int n3 = _mSprEnemyExplosions[i].getCurrFrame();
                if (!cObjects._mSprEnemyExplosions[i].mVisible) {
                    n3 = 5;
                }
                cCanvas.renderImage(graphics, _mImgScore, 0, 0, _mImgScore.getWidth(), _mImgScore.getHeight(), cObjects._mSprEnemyExplosions[i].mX + n + (21 - _mImgScore.getWidth() >> 1), cObjects._mSprEnemyExplosions[i].mY + n2 - n3 - (_mImgScore.getHeight() >> 1));
                mSprEnemyBirds[i].render(graphics, _mImgBirdR, cObjects.mSprEnemyBirds[i].mX + n, cObjects.mSprEnemyBirds[i].mY + n2, !cObjects.mSprEnemyBirds[i].mFacingLeft ? (byte)1 : 0);
            }
            if (!cObjects._mSprEnemyExplosions[i].mVisible) continue;
            _mSprEnemyExplosions[i].render(graphics, _mImgExplosion, cObjects._mSprEnemyExplosions[i].mX + n, cObjects._mSprEnemyExplosions[i].mY + n2);
        }
    }

    public static void renderPowerUpBoxes(Graphics graphics, int n, int n2) {
        for (int i = 0; i < 6; ++i) {
            cObjects.renderSprite(graphics, mSprRingBoxes[i], _mImgRingBox, cObjects.mSprRingBoxes[i].mX + n, cObjects.mSprRingBoxes[i].mY + n2);
            if (cObjects.mRingBoxEffect[i].mActive) {
                cCanvas.renderImage(graphics, _mImgRingBox, 2, 1, 13, 10, cObjects.mRingBoxEffect[i].mX + n, cObjects.mRingBoxEffect[i].mY-- + n2 - 2);
                if (cObjects.mRingBoxEffect[i].mY < cObjects.mSprRingBoxes[i].mY - 11 - 17) {
                    cObjects.mRingBoxEffect[i].mActive = false;
                }
            }
            cObjects.renderSprite(graphics, _mSprRBExplosions[i], _mImgExplosion, cObjects._mSprRBExplosions[i].mX + n, cObjects._mSprRBExplosions[i].mY + n2);
        }
        cObjects.renderSprite(graphics, mSprExtraBallBox, _mImgRingBox, cObjects.mSprExtraBallBox.mX + n, cObjects.mSprExtraBallBox.mY + n2);
        if (cObjects.mSprExtraBallBox.mVisible && mSprExtraBallBox.getCurrFrame() == 0) {
            cCanvas.renderImage(graphics, _mImgExtraBall, 0, 0, 13, 10, cObjects.mSprExtraBallBox.mX + n + 2, cObjects.mSprExtraBallBox.mY + n2 + 1);
        }
        if (cObjects.mExtraBallEffect.mActive) {
            cCanvas.renderImage(graphics, _mImgExtraBall, 0, 0, 16, 14, cObjects.mExtraBallEffect.mX + n, cObjects.mExtraBallEffect.mY-- + n2 - 2);
            if (cObjects.mExtraBallEffect.mY < cObjects.mSprExtraBallBox.mY - 11 - 17) {
                cObjects.mExtraBallEffect.mActive = false;
            }
        }
        cObjects.renderSprite(graphics, _mSprEBBExplosion, _mImgExplosion, cObjects._mSprEBBExplosion.mX + n, cObjects._mSprEBBExplosion.mY + n2);
    }

    private static void resetEnemies() {
        int n;
        cObjects.mSprBallExplosion.mVisible = false;
        cObjects.mSprSplashEffect.mVisible = false;
        cObjects.mSprSandEffect.mVisible = false;
        for (n = 0; n < 4; ++n) {
            if (!cCanvas.mLoadingGame) {
                cObjects.mSprEnemies[n].mVisible = false;
            }
            cObjects._mSprEnemyExplosions[n].mVisible = false;
            cObjects.mSprEnemyBirds[n].mVisible = false;
            cObjects._mEnemyBirdUpFrames[n] = 0;
            cObjects.mEnemyUDRL[n] = false;
        }
        if (cCanvas.mCurrCourseID == 1) {
            for (n = 0; n < 4; ++n) {
                mSprEnemies[n].playAnim(0, false, true);
            }
        }
    }

    public static void close() {
        _mImgRing = null;
        _mImgHoleFlag = null;
        _mImgSandEffect = null;
        _mImgSplashEffect = null;
        _mImgRingBox = null;
        _mImgExplosion = null;
        _mImgSmallExplosion = null;
        _mImgSpring = null;
        _mImgSpring45L = null;
        _mImgBirdR = null;
        _mImgScore = null;
        _mImgRobotnikL = null;
        _mImgEnemyL = null;
        _mImgExtraBall = null;
        _mImgBobin = null;
        _mImgSpikeThing = null;
    }

    static {
        mFrm0to1 = new byte[]{0, 1};
        mFrm0to3 = new byte[]{0, 1, 2, 3};
        mFrm0to4 = new byte[]{0, 1, 2, 3, 4};
        mFrm0to5 = new byte[]{0, 1, 2, 3, 4, 5};
        mFrm0to8 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        mFrm1to0 = new byte[]{1, 0};
        mFrm1to2 = new byte[]{1, 2};
        mFrm1to3 = new byte[]{1, 2, 3};
        mFrm4to8 = new byte[]{4, 5, 6, 7, 8};
        mFrm3to0 = new byte[]{3, 2, 1, 0};
        mFrmStatic0 = new byte[]{0, 0};
        mFrmStatic1 = new byte[]{1, 1};
        mFrmStatic2 = new byte[]{2, 2};
        mFrmStatic3 = new byte[]{3, 3};
        mFrmStatic4 = new byte[]{4, 4};
        mFrmStatic6 = new byte[]{6, 6};
    }

    public static class cMarker {
        public int mX;
        public int mY;
        public boolean mActive;
    }
}

