/*
 * Decompiled with CFR 0.152.
 */
package SonicGolf;

import Coral.Audio.crlAudioManager;
import Coral.crlCanvas;
import SonicGolf.cBall;
import SonicGolf.cCanvas;
import SonicGolf.cCourse;
import SonicGolf.cFP;
import SonicGolf.cObjects;
import SonicGolf.cSprite;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class cPlayer {
    public static final byte MAX_PLAYERS = 3;
    public static final byte SWING_TOP_FRAME = 5;
    public static final byte SWING_HIT_FRAME = 1;
    private static final int BORED_TIMEOUT = 5000;
    private static final int POWER_SPARKLES = 5;
    public static final byte CHAR_SONIC = 0;
    public static final byte CHAR_TAILS = 1;
    public static final byte CHAR_KNUCKLES = 2;
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;
    private static int _mCnvsWidth;
    private static int _mCnvsHeight;
    public byte mMinShotPower;
    public byte mShotPower;
    public byte mShotPowerIncs;
    public int mMaxShotPower;
    public byte mSpin;
    public boolean mFacingLeft;
    public int mFPX;
    public int mFPY;
    public int mFPY0;
    public byte[] mShots = new byte[9];
    public int mTotParScore;
    public byte mShotNumber;
    public boolean mHoleFinished;
    public int mRingsThisHole;
    public int mRings;
    public int mRingsPickedUp;
    public byte mBalls;
    public byte mCharacter;
    public static long mBoredTimeout;
    public static boolean mBored;
    public int mPointsScore;
    public int mHoleParScore;
    public int mParBonus;
    public int mRingBonus;
    public int mBallsBonus;
    public int mBirdsFreed;
    public byte mRingsThisShot;
    public byte mMostRingsShot;
    public int mTotalDrives;
    public int mCurrentDrive;
    public int mLongestDrive;
    public int mAverageDrive;
    public int mTotalPutts;
    public int mCurrentPutt;
    public int mLongestPutt;
    public int mPuttSuccess;
    public int mFairwaysHit;
    public byte mChipIns;
    public byte mHolesInOne;
    public boolean mGameOver;
    private Image _mImgSwingL;
    private Image _mImgJoyR;
    private Image _mImgBoredR;
    private Image _mImgEyesR;
    private Image _mImgTailR;
    public cSprite mSprTail;
    public cSprite mSprSwing;
    public cSprite mSprJoy;
    public cSprite mSprBored;
    public cSprite[] mSprPowerSparkle = new cSprite[5];
    public static final byte[] mFrame2to2;
    public static final byte[] mFrameIronBack;
    public static final byte[] mFrameIronFore;
    public static final byte[] mFrame0to2;
    public static final byte[] mFrame0to4;
    public static final byte[] mFrame3to3;
    public static final byte[] mFrame4to6;
    public static final byte[] mFrame4to9;
    public static final byte[] mFrame6to7;
    public static final byte[] mFrameResetSwing;
    public static final byte[] mFrameKnucklesJoy;
    public static final byte[] mFrameTailsBored;

    public cPlayer(int n, int n2) {
        _mCnvsWidth = n;
        _mCnvsHeight = n2;
        this.resetInfo();
    }

    public void init(int n) {
        this.resetInfo();
        switch (n) {
            case 0: {
                this._mImgSwingL = crlCanvas.gResourceManager.getImageByID(597469299293297L);
                this.mSprSwing = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 29, 31, 6);
                this._mImgJoyR = crlCanvas.gResourceManager.getImageByID(619504580497384L);
                this.mSprJoy = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 25, 41, 5);
                this.mSprJoy.setAnimProps(0, cObjects.mFrmStatic0, cObjects.mFrmStatic1.length, 90);
                this.mSprJoy.setAnimProps(1, cObjects.mFrmStatic1, cObjects.mFrmStatic2.length, 90);
                this.mSprJoy.setAnimProps(2, cObjects.mFrmStatic2, cObjects.mFrmStatic3.length, 90);
                this.mSprJoy.setAnimProps(3, cObjects.mFrmStatic0, cObjects.mFrmStatic0.length, 90);
                this.mSprJoy.setAnimProps(4, cObjects.mFrmStatic0, cObjects.mFrmStatic0.length, 90);
                this._mImgBoredR = crlCanvas.gResourceManager.getImageByID(613476070632804L);
                this.mSprBored = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 24, 29, 2);
                this.mSprBored.setAnimProps(0, cObjects.mFrm0to1, cObjects.mFrm0to1.length, 180);
                this.mSprBored.setAnimProps(1, cObjects.mFrmStatic1, cObjects.mFrmStatic1.length, 250);
                this._mImgEyesR = crlCanvas.gResourceManager.getImageByID(627122059139231L);
                this.mMinShotPower = (byte)18;
                this.mShotPower = (byte)18;
                this.mShotPowerIncs = (byte)13;
                this.mSpin = (byte)6;
                break;
            }
            case 1: {
                this._mImgSwingL = crlCanvas.gResourceManager.getImageByID(697950424039104L);
                this.mSprSwing = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 24, 26, 6);
                this._mImgJoyR = crlCanvas.gResourceManager.getImageByID(693445571920920L);
                this.mSprJoy = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 21, 23, 2);
                this.mSprJoy.setAnimProps(0, mFrame0to2, mFrame0to2.length, 250);
                this.mSprJoy.setAnimProps(1, cObjects.mFrmStatic2, cObjects.mFrmStatic2.length, 250);
                this._mImgBoredR = crlCanvas.gResourceManager.getImageByID(687705524735407L);
                this.mSprBored = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 17, 23, 1);
                this.mSprBored.setAnimProps(0, mFrameTailsBored, mFrameTailsBored.length, 250);
                this._mImgEyesR = crlCanvas.gResourceManager.getImageByID(710144356235884L);
                this._mImgTailR = crlCanvas.gResourceManager.getImageByID(710871520426980L);
                this.mSprTail = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 15, 17, 1);
                this.mSprTail.setAnimProps(0, mFrame0to4, mFrame0to4.length, 180);
                this.mSprTail.playAnim(0, true, true);
                this.mMinShotPower = (byte)13;
                this.mShotPower = (byte)13;
                this.mShotPowerIncs = (byte)15;
                this.mSpin = (byte)5;
                break;
            }
            case 2: {
                this._mImgSwingL = crlCanvas.gResourceManager.getImageByID(717901327997415L);
                this.mSprSwing = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 34, 34, 6);
                this._mImgJoyR = crlCanvas.gResourceManager.getImageByID(734355591702115L);
                this.mSprJoy = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 24, 29, 2);
                this.mSprJoy.setAnimProps(0, mFrameKnucklesJoy, mFrameKnucklesJoy.length, 180);
                this.mSprJoy.setAnimProps(1, cObjects.mFrmStatic2, cObjects.mFrmStatic2.length, 90);
                this._mImgBoredR = crlCanvas.gResourceManager.getImageByID(728961658236077L);
                this.mSprBored = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 21, 29, 2);
                this.mSprBored.setAnimProps(0, cObjects.mFrm0to3, cObjects.mFrm0to3.length, 210);
                this.mSprBored.setAnimProps(1, mFrame3to3, mFrame3to3.length, 180);
                this._mImgEyesR = crlCanvas.gResourceManager.getImageByID(733393459984502L);
                this.mMinShotPower = (byte)22;
                this.mShotPower = (byte)22;
                this.mShotPowerIncs = (byte)11;
                this.mSpin = (byte)4;
            }
        }
        this.mMaxShotPower = 30 + this.mMinShotPower + this.mShotPowerIncs * this.mShotPower;
        this.mSprSwing.setAnimProps(0, mFrameIronBack, mFrameIronBack.length, 90);
        this.mSprSwing.setAnimProps(1, mFrameIronFore, mFrameIronFore.length, 70);
        this.mSprSwing.setAnimProps(2, cObjects.mFrm1to0, cObjects.mFrm1to0.length, 90);
        this.mSprSwing.setAnimProps(3, mFrame0to2, mFrame0to2.length, 70);
        this.mSprSwing.setAnimProps(4, mFrameResetSwing, mFrameResetSwing.length, 75);
        this.mSprSwing.setAnimProps(5, mFrame2to2, mFrame2to2.length, 75);
        int n2 = 5;
        while (--n2 >= 0) {
            this.mSprPowerSparkle[n2] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 6, 6, 1);
            this.mSprPowerSparkle[n2].setAnimProps(0, cObjects.mFrm4to8, cObjects.mFrm4to8.length, 150);
        }
    }

    public void initShot(int n, int n2) {
        this.mFPX = n;
        this.mFPY = n2;
        this.mRingsThisShot = 0;
        this.mCurrentDrive = 0;
        this.mHoleFinished = false;
        this.resetBoredom();
    }

    public void initHoleComplete(int n, int n2) {
        this.mHoleFinished = true;
        this.setParScore(n, n2);
        this.setShotCompleteStats();
        this.setHoleCompleteStats();
    }

    private void setHoleCompleteStats() {
        if (this.mShotNumber == 1) {
            ++cCanvas.mTotHolesInOne;
            this.mHolesInOne = (byte)(this.mHolesInOne + 1);
        }
        if (!cBall.mPutting) {
            ++cCanvas.mTotChipIns;
            this.mChipIns = (byte)(this.mChipIns + 1);
        }
        ++this.mBirdsFreed;
        ++cCanvas.mTotBirdsFreed;
    }

    public void setShotCompleteStats() {
        if (cBall.mPutting) {
            this.mCurrentPutt = Math.abs(cFP.toInt(cBall.mFPX - cBall.mReplayFPX));
            this.mPuttSuccess = cBall.mHoled ? (this.mPuttSuccess * this.mTotalPutts + 100) / ++this.mTotalPutts : this.mPuttSuccess * this.mTotalPutts / ++this.mTotalPutts;
        } else {
            int n;
            int n2 = this.mFairwaysHit = cBall.mFairwayHit ? (this.mFairwaysHit * this.mTotalDrives + 100) / (this.mTotalDrives + 1) : this.mFairwaysHit * this.mTotalDrives / ++this.mTotalDrives;
            if (cBall.mFairwayHit) {
                this.mCurrentDrive = Math.abs(cFP.toInt(cBall.mFPX - cBall.mReplayFPX));
                n = (this.mAverageDrive * this.mTotalDrives + this.mCurrentDrive) / ++this.mTotalDrives;
            } else {
                n = this.mAverageDrive;
            }
            this.mAverageDrive = n;
        }
        this.mMostRingsShot = this.mRingsThisShot > this.mMostRingsShot ? this.mRingsThisShot : this.mMostRingsShot;
        cCanvas.mBestRingsShot = this.mRingsThisShot > cCanvas.mBestRingsShot ? this.mRingsThisShot : cCanvas.mBestRingsShot;
        this.mLongestDrive = this.mCurrentDrive > this.mLongestDrive ? this.mCurrentDrive : this.mLongestDrive;
        cCanvas.mBestLongestDrive = this.mCurrentDrive > cCanvas.mBestLongestDrive ? this.mCurrentDrive : cCanvas.mBestLongestDrive;
        this.mLongestPutt = this.mCurrentPutt > this.mLongestPutt ? this.mCurrentPutt : this.mLongestPutt;
        cCanvas.mBestLongestPutt = this.mCurrentPutt > cCanvas.mBestLongestPutt ? this.mCurrentPutt : cCanvas.mBestLongestPutt;
    }

    public void setParScore(int n, int n2) {
        this.mShots[n] = this.mShotNumber;
        this.mTotParScore += this.mShotNumber - n2;
        if (this.mTotParScore <= -100) {
            this.mTotParScore = -99;
        } else if (this.mTotParScore >= 100) {
            this.mTotParScore = 99;
        }
    }

    private void resetInfo() {
        int n = 9;
        while (--n >= 0) {
            this.mShots[n] = 0;
        }
        this.mTotParScore = 0;
        this.mPointsScore = 0;
        this.mRingsThisHole = 0;
        this.mRings = 0;
        this.mRingsPickedUp = 0;
        this.mShotNumber = 1;
        this.mParBonus = 0;
        this.mRingBonus = 0;
        this.mBallsBonus = 0;
        this.mBirdsFreed = 0;
        this.mMostRingsShot = 0;
        this.mTotalDrives = 0;
        this.mLongestDrive = 0;
        this.mAverageDrive = 0;
        this.mLongestPutt = 0;
        this.mPuttSuccess = 0;
        this.mFairwaysHit = 0;
        this.mChipIns = 0;
        this.mHolesInOne = 0;
        this.mTotalPutts = 0;
        this.mBalls = (byte)9;
        this.mGameOver = false;
    }

    public int checkProgress(boolean bl) {
        int n = 0;
        int n2 = this.mRings - this.mRingsThisHole;
        int n3 = 0;
        while (this.mRings - this.mRingsThisHole < n) {
            n -= 50;
            ++n3;
            n2 += 50;
        }
        if (cObjects.mSprExtraBallBox != null && cObjects.mSprExtraBallBox.getCurrAnim() == 1) {
            ++n3;
        }
        if (bl) {
            this.mRingsPickedUp -= this.mRingsThisHole;
            this.mRings = n2;
            this.mBalls = (byte)(this.mBalls - n3);
        }
        return n3;
    }

    public void pickupRings(int n) {
        this.mRingsThisHole += n;
        this.mRings += n;
        this.mRingsThisShot = (byte)(this.mRingsThisShot + n);
        this.mRingsPickedUp += n;
        if (this.mRings >= 50) {
            this.mBalls = (byte)(this.mBalls + 1);
            this.mRings -= 50;
        }
    }

    public boolean clockScore(boolean bl) {
        boolean bl2 = true;
        if (bl) {
            this.mPointsScore += this.mParBonus > 0 ? this.mParBonus : 0;
            this.mPointsScore += this.mRingBonus > 0 ? this.mRingBonus : 0;
            this.mPointsScore += this.mBallsBonus > 0 ? this.mBallsBonus : 0;
            this.mBallsBonus = 0;
            this.mParBonus = 0;
            this.mRingBonus = 0;
        } else if (this.mParBonus > 0) {
            this.mParBonus -= 1000;
            this.mPointsScore += 1000;
            bl2 = false;
        } else if (this.mRingBonus > 0) {
            this.mRingBonus -= 250;
            this.mPointsScore += 250;
            bl2 = false;
        } else if (this.mBallsBonus > 0) {
            this.mBallsBonus -= 100;
            this.mPointsScore += 100;
            bl2 = false;
        }
        if (this.mShotNumber < cCourse.mPar[cCanvas.mCurrHoleID - 1] && bl2 && cCanvas.mGameSettings[0] > 0) {
            cCanvas.mAudioManager.stopAllAudio();
            cCanvas.mAudioManager.playAudio(5, crlAudioManager.VOLUME_LEVEL[cCanvas.mGameSettings[0]], 1);
        }
        return bl2;
    }

    public void update() {
        if (cCanvas.mGameLoopState == 2 || cCanvas.mGameLoopState == 3) {
            this.checkPlayerBoredom();
        }
        if (cCanvas.mGameLoopState != 9 && cCanvas.mGameLoopState != 10 && this.mSprSwing != null) {
            this.mSprSwing.updateAnim();
        } else if (this.mSprJoy != null) {
            this.mSprJoy.updateAnim();
        }
        if (this.mSprBored != null) {
            this.mSprBored.updateAnim();
        }
        if (this.mCharacter == 1 && this.mSprTail != null) {
            this.mSprTail.updateAnim();
        }
        int n = 5;
        while (--n >= 0) {
            if (!this.mSprPowerSparkle[n].mVisible) continue;
            this.mSprPowerSparkle[n].updateAnim();
            if (this.mSprPowerSparkle[n].getCurrFrame() == this.mSprPowerSparkle[n].getEndFrame(0)) {
                this.mSprPowerSparkle[n].mVisible = false;
                continue;
            }
            if (n >= 4 || this.mSprPowerSparkle[n + 1].mVisible) continue;
            this.mSprPowerSparkle[n + 1].playAnim(0, true, true);
            this.mSprPowerSparkle[n + 1].mVisible = true;
        }
    }

    public void render(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4 = 1;
        boolean bl = false;
        int n5 = this.mSprSwing.mFrameWidth;
        int n6 = this.mSprSwing.mFrameHeight;
        int n7 = cFP.toInt(this.mFPX + cCourse.mFPX);
        int n8 = cFP.toInt(this.mFPY + cCourse.mFPY);
        if (cBall.mFPAngle > 368640) {
            bl = true;
            n5 -= 6;
        } else {
            n5 += 6;
        }
        if (this.mCharacter == 1) {
            n3 = bl ? -2 : -19;
            n2 = 0;
            if (cCanvas.mPowerUp) {
                if (this.mSprSwing.getCurrFrame() == 3) {
                    n3 += bl ? 1 : -1;
                    n2 = -1;
                } else if (this.mSprSwing.getCurrFrame() == 4) {
                    n3 += bl ? 2 : -2;
                    n2 = -2;
                } else if (this.mSprSwing.getCurrFrame() == 5) {
                    n3 -= bl ? 1 : -1;
                    n2 = -1;
                }
            } else if (mBored || this.mSprBored.getCurrAnim() == 1) {
                n3 += bl ? 1 : -1;
            }
            this.mSprTail.render(graphics, this._mImgTailR, n7 - (n5 >> 1) + 15 + n3, n8 - n6 + 8 + n2, !bl ? (byte)1 : 0);
        }
        if (mBored || this.mSprBored.getCurrAnim() == 1) {
            n3 = n7 - (this.mSprBored.mFrameWidth >> 1);
            if (this.mCharacter == 1) {
                n3 += bl ? 4 : -4;
            }
            if (this.mCharacter != 0 && this.mSprSwing.getCurrAnim() == 5) {
                this.mSprSwing.render(graphics, this._mImgSwingL, n7 - (n5 >> 1), n8 - n6 - 1 * n4, bl ? (byte)1 : 0);
                this.mSprSwing.playAnim(0, false, false);
            } else {
                this.mSprBored.render(graphics, this._mImgBoredR, n3, n8 - this.mSprBored.mFrameHeight - 1 * n4, !bl ? (byte)1 : 0);
                if (this.mCharacter != 2) {
                    this.mSprBored.playAnim(0, true, true);
                }
                return;
            }
        }
        if (cCanvas.mGameLoopState != 9 && cCanvas.mGameLoopState != 10 && cCanvas.mGameLoopState != 12 || this.mSprJoy.getCurrAnim() == 3) {
            this.mSprSwing.render(graphics, this._mImgSwingL, n7 - (n5 >> 1), n8 - n6 - 1 * n4, bl ? (byte)1 : 0);
            if (!cCanvas.mPowerUp && this.mSprSwing.getCurrFrame() == 1) {
                n3 = 8;
                n2 = 6;
                n = 11;
                int n9 = 10;
                int n10 = 6;
                if (this.mCharacter == 1) {
                    n3 = 7;
                    n2 = 5;
                    n = 9;
                    n9 = 8;
                    n10 = 7;
                } else if (this.mCharacter == 2) {
                    n3 = 11;
                    n2 = 4;
                    n = 12;
                    n9 = 11;
                    n10 = 7;
                }
                if (cCanvas.mFrameCount % 28 == 19 || cCanvas.mFrameCount % 28 == 0) {
                    cCanvas.renderImage(graphics, this._mImgEyesR, 0, 0, n3, n2, n7 - (n5 >> 1) + (bl ? n9 : n), n8 - n6 + n10);
                } else if (cCanvas.mFrameCount % 28 >= 20) {
                    if (bl) {
                        int n11 = n7 - (n5 >> 1) + n9;
                        int n12 = n8 - n6 + n10;
                        graphics.setClip(n11, n12, n3, n2);
                        graphics.drawRegion(this._mImgEyesR, n3, 0, n3, n2, 2, n11, n12, 0x10 | 4);
                    } else {
                        cCanvas.renderImage(graphics, this._mImgEyesR, n3, 0, n3, n2, n7 - (n5 >> 1) + n, n8 - n6 + n10);
                    }
                }
            }
        } else if (cCanvas.mPlayer[cCanvas.mCurrPlayerID].mShotNumber - cCourse.mPar[cCanvas.mCurrHoleID - 1] <= 0) {
            if (this.mCharacter == 0) {
                if (this.mSprJoy.getCurrAnim() == 4 && cObjects.mSprHoleFlag.getCurrAnim() != 0) {
                    if (cCanvas.mFrameCount % 4 == 0) {
                        this.mSprJoy.restartAnim(0, false, false);
                    }
                } else if (this.mSprJoy.getCurrAnim() == 0) {
                    this.mFPY = this.mFPY >= this.mFPY0 - cFP.toFP(10) ? (this.mFPY -= cFP.toFP(5)) : (this.mFPY -= cFP.toFP(3));
                    if (this.mFPY < this.mFPY0 - cFP.toFP(12)) {
                        this.mSprJoy.restartAnim(1, false, false);
                    }
                } else if (this.mSprJoy.getCurrAnim() == 1) {
                    this.mFPY = this.mFPY >= this.mFPY0 - cFP.toFP(10) ? (this.mFPY += cFP.toFP(5)) : (this.mFPY += cFP.toFP(3));
                    if (this.mFPY >= this.mFPY0) {
                        this.mFPY = this.mFPY0;
                        this.mSprJoy.restartAnim(2, false, false);
                    }
                }
            } else if (this.mSprJoy.getCurrFrame() == this.mSprJoy.getEndFrame(0)) {
                this.mSprJoy.playAnim(1, false, true);
            } else {
                this.mSprJoy.playAnim(0, true, true);
            }
            n6 = this.mSprJoy.mFrameHeight;
            this.mSprJoy.render(graphics, this._mImgJoyR, n7 - (this.mSprJoy.mFrameWidth >> 1), n8 - n6 - 1 * n4, !bl ? (byte)1 : 0);
        } else {
            n3 = n7 - (this.mSprBored.mFrameWidth >> 1);
            if (this.mCharacter == 1) {
                n3 += bl ? 4 : -4;
            }
            this.mSprBored.restartAnim(0, true, false);
            if (this.mCharacter == 2) {
                this.mSprSwing.render(graphics, this._mImgSwingL, n7 - (n5 >> 1), n8 - n6 - 1 * n4, bl ? (byte)1 : 0);
            } else {
                this.mSprBored.render(graphics, this._mImgBoredR, n3, n8 - this.mSprBored.mFrameHeight - 1 * n4, !bl ? (byte)1 : 0);
            }
        }
        Image image = crlCanvas.gResourceManager.getImageByID(668277111819206L);
        n = 5;
        while (--n >= 0) {
            if (!this.mSprPowerSparkle[n].mVisible) continue;
            n3 = bl ? 1 : -1;
            switch (n) {
                case 0: {
                    this.mSprPowerSparkle[n].render(graphics, image, n7 + 20 * n3 * 3 / 4, n8 + 11 - n6);
                    break;
                }
                case 1: {
                    this.mSprPowerSparkle[n].render(graphics, image, n7 + 17 * n3 * 3 / 4, n8 + 21 - n6);
                    break;
                }
                case 2: {
                    this.mSprPowerSparkle[n].render(graphics, image, n7, n8 + 30 - n6);
                    break;
                }
                case 3: {
                    this.mSprPowerSparkle[n].render(graphics, image, n7 - 17 * n3 * 3 / 4, n8 + 21 - n6);
                    break;
                }
                case 4: {
                    this.mSprPowerSparkle[n].render(graphics, image, n7 - 20 * n3 * 3 / 4, n8 + 11 - n6);
                }
            }
        }
    }

    public void resetBoredom() {
        mBoredTimeout = System.currentTimeMillis() + 5000L;
        if (mBored) {
            if (this.mCharacter == 0) {
                this.mSprBored.playAnim(1, false, true);
            } else {
                this.mSprBored.playAnim(0, true, true);
            }
            mBored = false;
        }
    }

    private void checkPlayerBoredom() {
        if (this.mSprSwing.getCurrFrame() == 1) {
            if (System.currentTimeMillis() > mBoredTimeout) {
                if (!mBored) {
                    if (this.mCharacter == 0) {
                        this.mSprBored.playAnim(1, false, true);
                    } else if (this.mCharacter == 2) {
                        this.mSprBored.restartAnim(0, true, false);
                    } else {
                        this.mSprSwing.playAnim(5, false, false);
                    }
                    mBored = true;
                } else if (this.mSprBored.getCurrAnim() == 1 && this.mCharacter != 2) {
                    if (this.mCharacter == 1) {
                        this.mSprBored.restartAnim(0, true, true);
                    } else {
                        this.mSprBored.playAnim(0, true, true);
                    }
                }
            }
        } else {
            this.resetBoredom();
        }
    }

    public void close() {
        this.mSprSwing = null;
        this._mImgSwingL = null;
        this._mImgJoyR = null;
        this.mSprJoy = null;
        this._mImgBoredR = null;
        this._mImgEyesR = null;
        this._mImgTailR = null;
    }

    static {
        mFrame2to2 = new byte[]{2, 2};
        mFrameIronBack = new byte[]{1, 0, 6, 5};
        mFrameIronFore = new byte[]{6, 0, 1, 2, 3, 4};
        mFrame0to2 = new byte[]{0, 1, 2};
        mFrame0to4 = new byte[]{0, 1, 2, 3, 4};
        mFrame3to3 = new byte[]{3, 3};
        mFrame4to6 = new byte[]{4, 5, 6};
        mFrame4to9 = new byte[]{4, 5, 6, 7, 8, 9};
        mFrame6to7 = new byte[]{6, 7};
        mFrameResetSwing = new byte[]{6, 0, 1};
        mFrameKnucklesJoy = new byte[]{1, 0, 1, 2};
        mFrameTailsBored = new byte[]{0, 1, 2, 3, 2, 3, 2, 1, 0};
    }
}

