/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

class GameCanvas
extends FullCanvas
implements Runnable {
    private static final int MILLIS_PER_TICK = 100;
    static long T;
    static long U;
    public Graphics backbufferG;
    private byte byLoad = 0;
    private byte byReady = 1;
    private byte close;
    int iCOffset = 0;
    public int iDisplaySizeX = 176;
    public int iDisplaySizeY = 208;
    int iFrameTime = 0;
    int iIDFxExp;
    int iIDSndMenu;
    int iIDSndWin;
    Font m_Font;
    CLevel m_Level;
    CMenu m_Menu;
    CMenu m_MenuPause;
    CShip m_Ship;
    CShot[] m_Shots;
    CSoundsManager m_SndMan;
    public boolean m_bKeyDown = false;
    public boolean m_bKeyLeft = false;
    public boolean m_bKeyRight = false;
    public boolean m_bKeyUp = false;
    byte m_byLevel = 0;
    byte m_byMode = 0;
    byte m_byScreen = (byte)5;
    byte m_bySoundEnable;
    byte m_byVibrationEnable;
    int m_iHScore = 0;
    int m_iScore = 0;
    int[] m_iStarsX;
    int[] m_iStarsY;
    private Image m_imBackbuffer;
    Image m_imFH;
    Image m_imFont;
    Image m_imHB;
    Image m_imHT;
    Image m_imLogo;
    Image m_imPowerUp;
    Image m_imShots;
    Image m_imTitle;
    long m_lGameCounter = 0L;
    long m_lLastFrameTime = 0L;
    CTileSet m_tsFont;
    CTileSet m_tsPowerUp;
    CTileSet m_tsShots;
    private final GameMIDlet parent;
    public Random random;

    GameCanvas(GameMIDlet parent) {
        this.parent = parent;
        this.close = 1;
        this.random = new Random();
        this.random.setSeed(System.currentTimeMillis());
        try {
            this.m_imLogo = Image.createImage((String)"/ls.png");
            this.repaint();
            this.serviceRepaints();
            this.m_imShots = Image.createImage((String)"/s.png");
            this.m_tsShots = new CTileSet(this.m_imShots, "/s.dat");
            this.m_tsShots.SetClipRect(0, 0, this.iDisplaySizeX, this.iDisplaySizeY);
            this.m_imPowerUp = Image.createImage((String)"/p.png");
            this.m_tsPowerUp = new CTileSet(this.m_imPowerUp, "/p.dat");
            this.m_tsPowerUp.SetClipRect(0, 0, this.iDisplaySizeX, this.iDisplaySizeY);
            this.m_imFont = Image.createImage((String)"/n.png");
            this.m_tsFont = new CTileSet(this.m_imFont, "/n.dat");
            this.m_tsFont.SetClipRect(0, 0, this.iDisplaySizeX, this.iDisplaySizeY);
            this.m_imTitle = Image.createImage((String)"/tt.png");
            this.m_imFH = Image.createImage((String)"/f_h.png");
            this.m_imHT = Image.createImage((String)"/ht.png");
            this.m_imHB = Image.createImage((String)"/hb.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_Ship = new CShip(this);
        this.m_Shots = new CShot[20];
        int i = 0;
        while (i < 20) {
            this.m_Shots[i] = new CShot(this);
            ++i;
        }
        this.m_iStarsX = new int[30];
        this.m_iStarsY = new int[30];
        i = 0;
        while (i < 30) {
            this.m_iStarsX[i] = Math.abs(this.random.nextInt() % this.iDisplaySizeX);
            this.m_iStarsY[i] = Math.abs(this.random.nextInt() % this.iDisplaySizeY);
            ++i;
        }
        this.m_Level = new CLevel(this);
        this.m_byLevel = 0;
        this.LoadLevel();
        this.m_bySoundEnable = 1;
        this.m_byVibrationEnable = 1;
        this.LoadStoreData();
        this.m_Font = Font.getFont((int)0, (int)1, (int)16);
        this.m_Menu = new CMenu(this);
        CMenuItem itemMM = this.m_Menu.m_itemRoot;
        itemMM.m_strName = "Main Menu";
        itemMM.AddMenuItem(50, "Start Game");
        itemMM.AddMenuItem(1, "Options");
        itemMM.AddMenuItem(10, "Help");
        itemMM.AddMenuItem(11, "Credits");
        itemMM.AddMenuItem(1, "Quit");
        this.m_Menu.m_itemCurrent = (CMenuItem)itemMM.m_vMenuItems.elementAt(0);
        CMenuItem itemSM = (CMenuItem)itemMM.m_vMenuItems.elementAt(1);
        if (this.m_bySoundEnable == 0) {
            itemSM.AddMenuItem(100, "Sound:Off");
        } else {
            itemSM.AddMenuItem(100, "Sound:On");
        }
        itemSM.AddMenuItem(-1, "menu");
        itemSM = (CMenuItem)itemMM.m_vMenuItems.elementAt(4);
        itemSM.AddMenuItem(2, "Yes");
        itemSM.AddMenuItem(-1, "No");
        this.m_MenuPause = new CMenu(this);
        itemMM = this.m_MenuPause.m_itemRoot;
        itemMM.m_strName = "Pause";
        itemMM.AddMenuItem(20, "continue");
        itemMM.AddMenuItem(21, "menu");
        this.m_MenuPause.m_itemCurrent = (CMenuItem)itemMM.m_vMenuItems.elementAt(0);
        this.m_SndMan = new CSoundsManager();
        this.iIDSndMenu = this.m_SndMan.loadSound("/menu.mid", "audio/midi");
        this.iIDSndWin = this.m_SndMan.loadSound("/win.mid", "audio/midi");
        this.iIDFxExp = this.m_SndMan.loadSound("/exp.wav", "audio/x-wav");
        this.m_SndMan.m_bSoundEnabled = true;
        this.PlayMusic();
    }

    public CShot GetFreeShot() {
        int i = 0;
        while (i < 20) {
            if (this.m_Shots[i].m_byParent == -1) {
                return this.m_Shots[i];
            }
            ++i;
        }
        return null;
    }

    public void LoadLevel() {
        this.byLoad = 1;
        if (this.m_byScreen != 5) {
            this.m_byScreen = (byte)2;
        }
        this.repaint();
        this.serviceRepaints();
        this.m_Level.ReleaseData();
        switch (this.m_byLevel) {
            case 0: {
                this.m_Level.Load("/b.m", 1, 1, (byte)0);
                break;
            }
            case 1: {
                this.m_Level.Load("/1.m", 1, 1, (byte)1);
                break;
            }
            case 2: {
                this.m_Level.Load("/2.m", 1, 7, (byte)1);
                break;
            }
            case 3: {
                this.m_Level.Load("/3.m", 2, 2, (byte)1);
                break;
            }
            case 4: {
                this.m_Level.Load("/4.m", 2, 9, (byte)1);
                break;
            }
            case 5: {
                this.m_Level.Load("/5.m", 3, 6, (byte)1);
                break;
            }
            case 6: {
                this.m_Level.Load("/6.m", 3, 8, (byte)1);
                break;
            }
            case 7: {
                this.m_Level.Load("/7.m", 3, 5, (byte)1);
                break;
            }
            case 8: {
                this.m_Level.Load("/8.m", 4, 4, (byte)1);
                break;
            }
            case 9: {
                this.m_Level.Load("/9.m", 4, 3, (byte)1);
            }
        }
        this.m_Level.Reset();
        if (this.m_byLevel == 0) {
            CLevel.m_iCurrentUOffset = 0;
        }
        this.m_byLevel = (byte)(this.m_byLevel + 1);
        if (this.m_byLevel > 9) {
            this.m_byLevel = 0;
        }
        this.byLoad = 0;
        if (this.m_byScreen != 5) {
            this.m_byScreen = 0;
        }
    }

    public void LoadStoreData() {
        try {
            RecordStore recordstore = RecordStore.openRecordStore((String)"kR", (boolean)true);
            int nRecords = recordstore.getNumRecords();
            if (nRecords == 1) {
                byte[] byData = new byte[6];
                recordstore.getRecord(1, byData, 0);
                int iValue = 0;
                int i = 0;
                while (i < 4) {
                    iValue = byData[i];
                    this.m_iHScore |= (iValue &= 0xFF) << i * 8;
                    ++i;
                }
                this.m_bySoundEnable = byData[4];
                this.m_byVibrationEnable = byData[5];
            }
            recordstore.closeRecordStore();
        }
        catch (Exception e) {
        }
    }

    public void PlayFX() {
        if (this.m_bySoundEnable == 0) {
            return;
        }
        this.m_SndMan.playSound(this.iIDFxExp, 1);
    }

    public void PlayMusic() {
        if (this.m_bySoundEnable == 0) {
            return;
        }
        this.m_SndMan.playSound(this.iIDSndMenu, 1);
    }

    public void PlayWinMusic() {
        if (this.m_bySoundEnable == 0) {
            return;
        }
        this.m_SndMan.playSound(this.iIDSndWin, 1);
    }

    public void PrepareGameStart() {
        this.m_byLevel = 1;
        this.LoadLevel();
        this.m_byMode = 1;
        this.m_iScore = 0;
        this.StopMusic();
        int i = 0;
        while (i < 20) {
            this.m_Shots[i].m_byParent = (byte)-1;
            ++i;
        }
        this.m_lGameCounter = 0L;
        this.m_Ship.Reset();
        this.m_byScreen = 0;
    }

    public void Respawn() {
        this.m_Ship.Respawn();
        this.m_Level.Respawn();
        int i = 0;
        while (i < 20) {
            this.m_Shots[i].m_byParent = (byte)-1;
            ++i;
        }
    }

    public void SaveStoreData() {
        if (this.m_iScore > this.m_iHScore) {
            this.m_iHScore = this.m_iScore;
        }
        try {
            RecordStore recordstore = RecordStore.openRecordStore((String)"kR", (boolean)true);
            int nRecords = recordstore.getNumRecords();
            byte[] byData = new byte[6];
            int i = 0;
            while (i < 4) {
                byData[i] = (byte)(this.m_iHScore >> i * 8 & 0xFF);
                ++i;
            }
            byData[4] = this.m_bySoundEnable;
            byData[5] = this.m_byVibrationEnable;
            if (nRecords == 0) {
                recordstore.addRecord(byData, 0, byData.length);
            } else {
                recordstore.setRecord(1, byData, 0, byData.length);
            }
            recordstore.closeRecordStore();
        }
        catch (Exception e) {
        }
    }

    public void StopMusic() {
        this.m_SndMan.stopSound(this.iIDSndMenu);
    }

    public void Vibrate() {
    }

    public void keyPressed(int keyCode) {
        if (this.byLoad == 1) {
            return;
        }
        switch (keyCode) {
            case -5: 
            case 53: {
                if (this.m_byMode == 1) {
                    this.m_Ship.m_byBeamShot = (byte)10;
                }
            }
            case -7: {
                int i;
                if (keyCode == -7 && this.m_byMode == 1 && this.m_byScreen == 0) {
                    this.m_byScreen = 1;
                    break;
                }
                if (this.m_byMode == 0) {
                    i = this.m_Menu.Keypressed(2);
                    if (this.m_byScreen == 0) {
                        switch (i) {
                            case 2: {
                                this.StopMusic();
                                this.parent.exit();
                                break;
                            }
                            case 10: {
                                this.iCOffset = this.iDisplaySizeY;
                                this.m_byScreen = (byte)3;
                                break;
                            }
                            case 11: {
                                this.iCOffset = this.iDisplaySizeY;
                                this.m_byScreen = (byte)4;
                                break;
                            }
                            case 50: {
                                this.PrepareGameStart();
                                break;
                            }
                            case 100: {
                                this.m_bySoundEnable = this.m_bySoundEnable == 0 ? (byte)1 : 0;
                                this.m_Menu.m_itemCurrent.m_strName = this.m_bySoundEnable == 0 ? "Sound:Off" : "Sound:On";
                                if (this.m_bySoundEnable == 0) {
                                    this.StopMusic();
                                } else {
                                    this.PlayMusic();
                                }
                                this.SaveStoreData();
                            }
                        }
                    } else if (this.m_byScreen >= 3) {
                        this.m_byScreen = 0;
                    }
                }
                if (this.m_byScreen == 1) {
                    i = this.m_MenuPause.Keypressed(2);
                    switch (i) {
                        case 20: {
                            this.m_byScreen = 0;
                            break;
                        }
                        case 21: {
                            this.m_byLevel = 0;
                            this.LoadLevel();
                            this.PlayMusic();
                            this.SaveStoreData();
                            this.m_byMode = 0;
                        }
                    }
                }
                if (this.m_byMode == 2 || this.m_byMode == 4) {
                    this.m_byLevel = 0;
                    this.LoadLevel();
                    this.SaveStoreData();
                    this.PlayMusic();
                    this.SaveStoreData();
                    this.m_byMode = 0;
                }
                if (this.m_byMode != 3) break;
                if (this.m_byLevel == 0) {
                    this.m_byMode = (byte)4;
                    break;
                }
                this.LoadLevel();
                this.m_Ship.NewLevel();
                i = 0;
                while (i < 20) {
                    this.m_Shots[i].m_byParent = (byte)-1;
                    ++i;
                }
                this.m_byMode = 1;
                break;
            }
            case -3: 
            case 52: {
                this.m_bKeyLeft = true;
                break;
            }
            case -4: 
            case 54: {
                this.m_bKeyRight = true;
                break;
            }
            case -1: 
            case 50: {
                if (this.m_byMode == 0) {
                    this.m_Menu.Keypressed(0);
                }
                if (this.m_byScreen == 1) {
                    this.m_MenuPause.Keypressed(0);
                }
                this.m_bKeyUp = true;
                break;
            }
            case -2: 
            case 56: {
                if (this.m_byMode == 0) {
                    this.m_Menu.Keypressed(1);
                }
                if (this.m_byScreen == 1) {
                    this.m_MenuPause.Keypressed(1);
                }
                this.m_bKeyDown = true;
                break;
            }
            case -6: 
            case 55: {
                if (this.m_byMode == 1 && this.m_byScreen == 0) {
                    this.m_byScreen = 1;
                }
                break;
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (this.byLoad == 1) {
            return;
        }
        switch (keyCode) {
            case -3: 
            case 52: {
                this.m_bKeyLeft = false;
                break;
            }
            case -4: 
            case 54: {
                this.m_bKeyRight = false;
                break;
            }
            case -1: 
            case 50: {
                this.m_bKeyUp = false;
                break;
            }
            case -2: 
            case 56: {
                this.m_bKeyDown = false;
            }
        }
    }

    public void paint(Graphics g) {
        int iL;
        String strScore;
        if (this.m_byScreen == 5) {
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, this.iDisplaySizeX, this.iDisplaySizeY);
            g.drawImage(this.m_imLogo, this.iDisplaySizeX >> 1, this.iDisplaySizeY >> 1, 3);
            this.byReady = 1;
            return;
        }
        g.setFont(this.m_Font);
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.iDisplaySizeX, this.iDisplaySizeY);
        if (this.m_byScreen == 2) {
            g.setColor(255, 255, 255);
            g.drawString("Loading..", this.iDisplaySizeX >> 1, this.iDisplaySizeY >> 1, 17);
            this.byReady = 1;
            return;
        }
        g.setColor(105, 105, 105);
        int i = 0;
        while (i < 30) {
            if (i == 15) {
                g.setColor(245, 245, 245);
            }
            g.drawLine(this.m_iStarsX[i], this.m_iStarsY[i], this.m_iStarsX[i] + 1, this.m_iStarsY[i]);
            ++i;
        }
        if (this.m_byScreen == 3) {
            g.drawImage(this.m_imTitle, 88, 5, 17);
            g.setColor(255, 255, 0);
            g.drawString("Help", this.iDisplaySizeX >> 1, 34, 17);
            g.setColor(255, 255, 255);
            g.drawString("4 Way Button/2,4,6,8:", this.iDisplaySizeX >> 1, 55, 17);
            g.drawString("Spaceship Movement", this.iDisplaySizeX >> 1, 75, 17);
            g.drawString("Button '5':", this.iDisplaySizeX >> 1, 100, 17);
            g.drawString("Beamshot", this.iDisplaySizeX >> 1, 120, 17);
            g.drawString("Button '7':", this.iDisplaySizeX >> 1, 145, 17);
            g.drawString("Pause on/off", this.iDisplaySizeX >> 1, 165, 17);
            this.paintOK(g, 0);
            this.byReady = 1;
            return;
        }
        if (this.m_byScreen == 4) {
            this.paintCredits(g);
            this.paintOK(g, 0);
            this.byReady = 1;
            return;
        }
        if (this.m_byMode == 1 || this.m_byMode == 3) {
            i = 0;
            while (i < 20) {
                if (this.m_Shots[i].m_byParent != -1) {
                    if (this.m_Shots[i].m_byParent == 0) {
                        this.m_tsPowerUp.DrawTile(g, (byte)(this.m_Shots[i].m_byType - 10), this.m_Shots[i].m_iFixX >> 16, (this.m_Shots[i].m_iFixY >> 16) + 9, true);
                    } else if (this.m_Shots[i].m_byType == 5) {
                        this.m_tsShots.DrawTile(g, (byte)10, this.m_Shots[i].m_iFixX >> 16, (this.m_Shots[i].m_iFixY >> 16) + 9, true);
                    } else if (this.m_Shots[i].m_byType == 8) {
                        this.m_tsShots.DrawTile(g, (byte)(5L + this.m_lGameCounter % 2L), this.m_Shots[i].m_iFixX >> 16, (this.m_Shots[i].m_iFixY >> 16) + 9, true);
                    } else if (this.m_Shots[i].m_byType == 2) {
                        this.m_tsShots.DrawTile(g, (byte)(3L + this.m_lGameCounter % 2L), this.m_Shots[i].m_iFixX >> 16, (this.m_Shots[i].m_iFixY >> 16) + 9, true);
                    } else if (this.m_Shots[i].m_byType == 3) {
                        this.m_tsShots.DrawTile(g, (byte)(8L + this.m_lGameCounter % 2L), (this.m_Shots[i].m_iFixX >> 16) - 12, (this.m_Shots[i].m_iFixY >> 16) + 9, true);
                        this.m_tsShots.DrawTile(g, (byte)(8L + this.m_lGameCounter % 2L), this.m_Shots[i].m_iFixX >> 16, (this.m_Shots[i].m_iFixY >> 16) + 9, true);
                        this.m_tsShots.DrawTile(g, (byte)(8L + this.m_lGameCounter % 2L), (this.m_Shots[i].m_iFixX >> 16) + 12, (this.m_Shots[i].m_iFixY >> 16) + 9, true);
                    } else if (this.m_Shots[i].m_byParent == 1) {
                        this.m_tsShots.DrawTile(g, this.m_Ship.m_PUW, this.m_Shots[i].m_iFixX >> 16, (this.m_Shots[i].m_iFixY >> 16) + 9, true);
                    } else {
                        this.m_tsShots.DrawTile(g, (byte)7, this.m_Shots[i].m_iFixX >> 16, (this.m_Shots[i].m_iFixY >> 16) + 9, true);
                    }
                }
                ++i;
            }
            this.m_Ship.Draw(g);
        }
        if (this.byLoad == 0) {
            this.m_Level.Render(g);
        }
        if (this.m_byMode == 0) {
            this.m_Menu.Render(g);
            g.drawImage(this.m_imTitle, 88, 12, 17);
            g.setClip(0, 0, this.iDisplaySizeX, this.iDisplaySizeY);
            strScore = Integer.toString(this.m_iHScore);
            iL = 6 - strScore.length();
            i = 0;
            while (i < iL) {
                strScore = "0" + strScore;
                ++i;
            }
            i = 0;
            while (i < strScore.length()) {
                this.m_tsFont.DrawTile(g, (byte)((byte)strScore.charAt(i) - 48), i * 9 + 59, this.iDisplaySizeY - 8, false);
                ++i;
            }
        }
        if (this.m_byMode >= 1 || this.m_byScreen == 1) {
            g.setClip(0, 0, this.iDisplaySizeX, this.iDisplaySizeY);
            g.drawImage(this.m_imHT, 0, 0, 0);
            g.drawImage(this.m_imHB, 0, 185, 0);
            strScore = Integer.toString(this.m_iScore);
            iL = 6 - strScore.length();
            i = 0;
            while (i < iL) {
                strScore = "0" + strScore;
                ++i;
            }
            i = 0;
            while (i < strScore.length()) {
                this.m_tsFont.DrawTile(g, (byte)((byte)strScore.charAt(i) - 48), i * 9 + 5, 191, false);
                ++i;
            }
            this.m_tsFont.DrawTile(g, this.m_Ship.m_byGameShips, 163, 191, false);
            g.setClip(0, 0, this.iDisplaySizeX, this.iDisplaySizeY);
            g.setColor(100, 220, 100);
            i = 0;
            while (i < this.m_Ship.m_byShield) {
                g.fillRect(70 + i * 8, 190, 7, 2);
                ++i;
            }
            if (this.m_Ship.m_byBeamShot > 0) {
                g.setColor(255, 150, 150);
                g.fillRect(70, 196, (10 - this.m_Ship.m_byBeamShot) * 6, 2);
            }
        }
        g.setColor(255, 255, 255);
        g.setClip(0, 0, this.iDisplaySizeX, this.iDisplaySizeY);
        if (this.m_byMode == 2) {
            g.drawString("Game Over!", this.iDisplaySizeX >> 1, this.iDisplaySizeY >> 1, 17);
        }
        if (this.m_byMode == 3 && this.m_lGameCounter % 2L == 0L) {
            g.drawString("Mission completed!", this.iDisplaySizeX >> 1, this.iDisplaySizeY >> 1, 17);
        }
        if (this.m_byMode == 4) {
            g.drawString("Mankind is", this.iDisplaySizeX >> 1, 58, 17);
            g.drawString("saved, for now...", this.iDisplaySizeX >> 1, 70, 17);
        }
        if (this.m_byScreen == 1) {
            this.m_MenuPause.Render(g);
        }
        if (this.m_byMode != 1 || this.m_byScreen == 1) {
            if (this.m_byMode == 0) {
                this.paintOK(g, 0);
            } else {
                this.paintOK(g, 23);
            }
        }
        this.byReady = 1;
    }

    public void paintCredits(Graphics g) {
        g.setClip(0, 0, this.iDisplaySizeX, this.iDisplaySizeY);
        int i = 0;
        while (i < 17) {
            String str = CConfig.strCredits[i][0];
            if (str == "1") {
                g.setColor(255, 255, 0);
            }
            if (str == "2") {
                g.setColor(200, 200, 200);
            }
            if (str == "3") {
                g.setColor(230, 230, 230);
            }
            g.drawString(CConfig.strCredits[i][1], this.iDisplaySizeX >> 1, i * 20 + this.iCOffset, 17);
            ++i;
        }
        if (--this.iCOffset < -340) {
            this.iCOffset = this.iDisplaySizeY;
        }
    }

    public void paintOK(Graphics g, int yOffset) {
        g.setColor(50, 50, 140);
        g.fillRect(this.iDisplaySizeX - 24, this.iDisplaySizeY - 18 - yOffset, 24, 18);
        g.setColor(200, 200, 200);
        g.drawString("OK", this.iDisplaySizeX - 22, this.iDisplaySizeY - 16 - yOffset, 20);
    }

    public final void run() {
        while (this.close != 0) {
            T = U;
            U = System.currentTimeMillis();
            this.byReady = 0;
            if (this.m_byScreen != 1) {
                this.update();
            }
            this.repaint();
            this.serviceRepaints();
            while (this.byReady == 0) {
                Thread.yield();
            }
            try {
                T = System.currentTimeMillis() - U;
                if (T <= 0L || T >= 100L) continue;
                Thread.sleep(100L - T);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.parent.notifyDestroyed();
        this.parent.destroyApp(true);
    }

    protected void showNotify() {
        if (this.m_byMode == 1 && this.m_byScreen == 0) {
            this.m_byScreen = 1;
        }
    }

    public void update() {
        int i;
        ++this.m_lGameCounter;
        if (this.m_byScreen == 5 && this.m_lGameCounter > 20L) {
            this.m_byScreen = 0;
        }
        if (this.m_byMode == 1 || this.m_byMode == 3) {
            if (this.byLoad == 0 && this.m_byScreen == 0) {
                this.m_Level.Update();
            }
            if (this.byLoad == 0 && this.m_byMode == 1 && this.m_Ship.m_byShipMode == 2) {
                if (this.m_Level.CheckBoxCollision(this.m_Ship.m_iShipPosX + CConfig.byShipHWidth, this.m_Ship.m_iShipPosY + CConfig.byShipHHeight, CConfig.byShipHWidth - 4, CConfig.byShipHHeight - 2)) {
                    this.m_Ship.m_byShipMode = (byte)3;
                }
                if (this.m_Ship.m_byDrone != -1) {
                    this.m_Level.CheckEnemyBoxCollision(this.m_Ship.m_iShipPosX + CConfig.byShipHWidth, this.m_Ship.m_iShipPosY, 15, 15, (byte)100);
                }
                if (this.m_Level.CheckEnemyBoxCollision(this.m_Ship.m_iShipPosX, this.m_Ship.m_iShipPosY, CConfig.byShipWidth, CConfig.byShipHeight, (byte)100) >= 1 && this.m_Ship.m_bySTime <= 0) {
                    this.m_Ship.m_byShield = (byte)(this.m_Ship.m_byShield - 2);
                    this.Vibrate();
                }
            }
            if (this.byLoad == 0 && this.m_byMode == 1) {
                i = 0;
                while (i < 20) {
                    if (this.m_Shots[i].m_byParent != -1) {
                        if (this.m_Shots[i].m_byParent == 1) {
                            byte byRes = 0;
                            byRes = this.m_Shots[i].m_byType == 3 ? this.m_Level.CheckEnemyBoxCollision((this.m_Shots[i].m_iFixX >> 16) - 18, (this.m_Shots[i].m_iFixY >> 16) - 3, 36, 5, this.m_Shots[i].m_byStrength) : (this.m_Shots[i].m_byType == 5 ? this.m_Level.CheckEnemyBoxCollision((this.m_Shots[i].m_iFixX >> 16) - 9, (this.m_Shots[i].m_iFixY >> 16) - 6, 18, 11, this.m_Shots[i].m_byStrength) : this.m_Level.CheckEnemyPointCollision(this.m_Shots[i].m_iFixX >> 16, this.m_Shots[i].m_iFixY >> 16, this.m_Shots[i].m_byStrength));
                            if (byRes != 0) {
                                if (this.m_Shots[i].m_byType != 5 || byRes == 3) {
                                    this.m_Shots[i].m_byParent = (byte)-1;
                                }
                                this.m_iScore += 10;
                            }
                            if (byRes == 2) {
                                if (this.random.nextInt() % 12 == 0) {
                                    this.m_Shots[i].m_byParent = 0;
                                    this.m_Shots[i].m_byType = (byte)(this.m_lGameCounter % 4L + 10L);
                                    this.m_Shots[i].m_byStrength = 0;
                                    this.m_Shots[i].m_iFixDirX = -65536;
                                    this.m_Shots[i].m_iFixDirY = 0;
                                    if (this.m_Shots[i].m_byType == 3) {
                                        int iD = this.m_Ship.m_byDrone;
                                        if (iD == 5) {
                                            iD = 2;
                                        }
                                        if (iD >= (this.m_byLevel - 1) % 3) {
                                            this.m_Shots[i].m_byParent = (byte)-1;
                                        }
                                    }
                                }
                                this.PlayFX();
                                this.Vibrate();
                            }
                        }
                        if (this.m_Shots[i].m_byParent != -1) {
                            if (this.m_Shots[i].m_byParent != 2 && this.m_Level.CheckPointCollision(this.m_Shots[i].m_iFixX >> 16, this.m_Shots[i].m_iFixY >> 16)) {
                                this.m_Shots[i].m_byParent = (byte)-1;
                            }
                            if (this.m_Shots[i].m_byParent != -1) {
                                if (this.m_Ship.m_byShipMode == 2 && this.m_Ship.m_byDrone != -1 && this.m_Shots[i].m_byParent == 2 && CCollision.CollidePointRect(this.m_Shots[i].m_iFixX >> 16, this.m_Shots[i].m_iFixY >> 16, this.m_Ship.m_iShipPosX + CConfig.byShipHWidth + 7, this.m_Ship.m_iShipPosY + CConfig.byShipHHeight, 7, 7)) {
                                    this.m_Shots[i].m_byParent = (byte)-1;
                                }
                                if (this.m_Shots[i].m_byParent != -1) {
                                    if (this.m_Shots[i].m_byParent == 0 && CCollision.CollideRectRect(this.m_Shots[i].m_iFixX >> 16, this.m_Shots[i].m_iFixY >> 16, 3, 3, this.m_Ship.m_iShipPosX + CConfig.byShipHWidth, this.m_Ship.m_iShipPosY + CConfig.byShipHHeight, CConfig.byShipHWidth, CConfig.byShipHHeight)) {
                                        if (this.m_Shots[i].m_byType == 10 && this.m_Ship.m_PUW < 2) {
                                            this.m_Ship.m_PUW = (byte)(this.m_Ship.m_PUW + 1);
                                        }
                                        if (this.m_Shots[i].m_byType == 11) {
                                            this.m_Ship.m_PUR = (byte)(this.m_Ship.m_PUR + 1);
                                        }
                                        if (this.m_Shots[i].m_byType == 12) {
                                            this.m_Ship.m_PUS = (byte)(this.m_Ship.m_PUS + 1);
                                            this.m_Ship.m_bySTime = (byte)(this.m_Ship.m_PUR * 5 + 50);
                                        }
                                        if (this.m_Shots[i].m_byType == 13) {
                                            if (this.m_Ship.m_byDrone == 1) {
                                                this.m_Ship.m_byDrone = (byte)5;
                                            }
                                            if (this.m_Ship.m_byDrone == 0) {
                                                this.m_Ship.m_byDrone = 1;
                                            }
                                            if (this.m_Ship.m_byDrone == -1) {
                                                this.m_Ship.m_byDrone = 0;
                                            }
                                        }
                                        this.m_Shots[i].m_byParent = (byte)-1;
                                    }
                                    if (this.m_Shots[i].m_byParent != -1 && this.m_Ship.m_byShipMode == 2 && this.m_Ship.m_bySTime <= 0 && this.m_Shots[i].m_byParent == 2 && CCollision.CollidePointRect(this.m_Shots[i].m_iFixX >> 16, this.m_Shots[i].m_iFixY >> 16, this.m_Ship.m_iShipPosX + CConfig.byShipHWidth, this.m_Ship.m_iShipPosY + CConfig.byShipHHeight, CConfig.byShipHWidth, CConfig.byShipHHeight)) {
                                        this.m_Shots[i].m_byParent = (byte)-1;
                                        this.m_Ship.m_byShield = (byte)(this.m_Ship.m_byShield - 2);
                                        this.Vibrate();
                                    }
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            this.m_Level.FindNearestEnemy();
            i = 0;
            while (i < 20) {
                this.m_Shots[i].Update(CEnemy.iNEX, CEnemy.iNEY);
                ++i;
            }
            this.m_Ship.Update();
        }
        i = 0;
        while (i < 30) {
            if (i >= 15) {
                int n = i;
                this.m_iStarsX[n] = this.m_iStarsX[n] - 1;
            } else if (this.m_lGameCounter % 2L == 0L) {
                int n = i;
                this.m_iStarsX[n] = this.m_iStarsX[n] - 1;
            }
            if (this.m_iStarsX[i] < 0) {
                this.m_iStarsX[i] = this.iDisplaySizeX;
                this.m_iStarsY[i] = Math.abs(this.random.nextInt() % this.iDisplaySizeY);
            }
            ++i;
        }
        if (this.m_byMode == 1 && this.m_Ship.m_byGameShips == 0) {
            this.m_byMode = (byte)2;
        }
    }
}

