/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MapRenderer {
    private Core core;
    public boolean firstFrame;
    public boolean firstColumn;
    int currentLevelLoaded = -1;
    Image BgLayer_tile;
    Image FgLayerTileSheet;
    Image FgLayerBossTileSheet;
    final int FgLayer_TILESHEET_WIDTH_IN_TILES;
    Image ScreenBuffer;
    Graphics ScreenBufferGraphics;

    public MapRenderer(Core core) {
        this.FgLayer_TILESHEET_WIDTH_IN_TILES = 32;
        this.core = core;
    }

    public void init() {
        if (this.core.Map_BgLayer_type == 2) {
            this.BgLayer_tile = this.core.IO_readSingleFileImage("/b.dat", this.core.Level_currentLevel - 1);
        }
        if (this.currentLevelLoaded != this.core.Level_currentLevel) {
            this.core.Map_FgLayer_map = this.core.Map_rtypeBuildMap(this.core.Level_currentLevel, false);
            this.FgLayer_tileInit();
        }
        this.currentLevelLoaded = this.core.Level_currentLevel;
        this.firstFrame = true;
        this.firstColumn = true;
        this.ScreenBuffer_();
    }

    public void ScreenBuffer_() {
        this.ScreenBuffer = Image.createImage((int)204, (int)180);
        this.ScreenBufferGraphics = this.ScreenBuffer.getGraphics();
    }

    public void FgLayer_tileInit() {
        this.FgLayerTileSheet = this.core.IO_readSingleFileImage("/t.dat", this.core.Level_currentLevel - 1);
        if (this.core.Level_currentLevel == 1 && this.core.Map_BOSS[0] || this.core.Level_currentLevel == 2 && this.core.Map_BOSS[1] || this.core.Level_currentLevel == 7 && this.core.Map_BOSS[6]) {
            this.FgLayerBossTileSheet = this.core.IO_readSingleFileImage("/t.dat", 7 + this.core.Level_currentLevel - 1);
        }
    }

    public void deallocateMainBuffer() {
        this.ScreenBuffer = null;
        this.ScreenBufferGraphics = null;
        this.currentLevelLoaded = -1;
    }

    public void paint(Graphics g) {
        g.drawImage(this.ScreenBuffer, 0 - (this.core.Map_FgLayer_frameXOffset * 12 + this.core.Map_FgLayer_pixelXOffset), 0 - this.core.Engine_yOffset, 20);
        int pasteX = -((this.core.Map_FgLayer_frameXOffset - 2) * 12 + this.core.Map_FgLayer_pixelXOffset) + 180;
        int width = 180 - pasteX;
        if (width > 0) {
            g.drawImage(this.ScreenBuffer, 0 + pasteX, 0 - this.core.Engine_yOffset, 20);
        }
    }

    public void FgLayer_pasteTiles() {
        if (this.firstFrame) {
            if (this.core.Level_currentLevel == 3) {
                this.core.Map_FgLayer_map = this.core.Map_rtypeBuildMap(this.core.Level_currentLevel, false);
            }
            int pasteColumn = 0;
            int mapColumn = 0;
            while (mapColumn < 16) {
                int mapRow = 0;
                while (mapRow < 15) {
                    short tileNumber;
                    int yOffset;
                    int xOffset;
                    this.ScreenBufferGraphics.setClip(pasteColumn, 12 * mapRow, 12, 12);
                    if (this.core.Map_BgLayer_type == 0 || this.core.Level_currentLevel == 1 && (this.core.Map_FgLayer_tileXOffset + 15 < 112 || this.core.Map_FgLayer_tileXOffset + 15 >= 220)) {
                        this.ScreenBufferGraphics.setColor(0, 0, 0);
                        this.ScreenBufferGraphics.fillRect(pasteColumn, 12 * mapRow, 12, 12);
                    } else {
                        xOffset = mapColumn % (this.BgLayer_tile.getWidth() / 12) * 12;
                        int bgPatternHeight = this.BgLayer_tile.getHeight() / 12;
                        yOffset = mapRow % bgPatternHeight * 12;
                        this.ScreenBufferGraphics.drawImage(this.BgLayer_tile, pasteColumn - xOffset, 12 * mapRow - yOffset, 20);
                    }
                    short pasteTileNumber = tileNumber = this.core.Map_FgLayer_map[mapColumn + this.core.Map_FgLayer_tileXOffset][mapRow];
                    byte transformType = 0;
                    transformType = this.core.Map_Tile_transformType[tileNumber];
                    if (this.core.Map_Tile_parentTile[tileNumber] != 0) {
                        pasteTileNumber = this.core.Map_Tile_parentTile[tileNumber];
                    }
                    xOffset = pasteTileNumber % 32 * 12;
                    yOffset = pasteTileNumber / 32 * 12;
                    if (pasteTileNumber != 0) {
                        this.ScreenBufferGraphics.drawRegion(this.FgLayerTileSheet, xOffset, yOffset, 12, 12, (int)transformType, pasteColumn, 12 * mapRow, 20);
                    }
                    ++mapRow;
                }
                pasteColumn += 12;
                ++mapColumn;
            }
            this.firstFrame = false;
        }
        this.FgLayer_pasteNewTiles(0, 0, 0, false);
    }

    public void FgLayer_pasteNewTiles(int x, int y, int tile, boolean singleTile) {
        if (singleTile) {
            int xOnBuffer;
            System.out.println("Single tile");
            x /= 1000;
            y /= 1000;
            x = ((x + this.core.Map_FgLayer_pixelXOffset) / 12 + 1) * 12;
            y = y / 12 * 12;
            int xInternalPaste = this.core.Map_FgLayer_frameXOffset - 1;
            if (xInternalPaste < 0) {
                xInternalPaste += this.core.Map_FgLayer_NUM_FRAMES;
            }
            if ((xOnBuffer = x + 12 * xInternalPaste) >= this.ScreenBuffer.getWidth()) {
                xOnBuffer -= this.ScreenBuffer.getWidth();
            }
            this.ScreenBufferGraphics.setClip(xOnBuffer, y, 12, 12);
            int xOffset = tile % 32 * 12;
            int yOffset = tile / 32 * 12;
            if (tile == 0) {
                this.ScreenBufferGraphics.setColor(0, 0, 0);
                this.ScreenBufferGraphics.fillRect(xOnBuffer, y, 12, 12);
            } else {
                this.ScreenBufferGraphics.drawRegion(this.FgLayerTileSheet, xOffset, yOffset, 12, 12, 0, xOnBuffer, y, 20);
            }
        } else {
            int numFramesPerTileStrip = 12 / this.core.Map_FgLayer_Vx;
            int numTilesToPastePerFrame = 150 / numFramesPerTileStrip;
            if (numTilesToPastePerFrame % 10 > 0) {
                numTilesToPastePerFrame = numTilesToPastePerFrame - numTilesToPastePerFrame % 10 + 10;
            }
            int startRow = this.core.Map_FgLayer_pixelXOffset / this.core.Map_FgLayer_Vx * (numTilesToPastePerFrame /= 10);
            if (this.firstColumn) {
                startRow = 0;
                numTilesToPastePerFrame = 15;
                this.firstColumn = false;
            }
            int mapRow = startRow;
            while (mapRow < startRow + numTilesToPastePerFrame) {
                if (mapRow < 15) {
                    Image pasteImage;
                    int yOffset;
                    int xOffset;
                    int xInternalPaste = this.core.Map_FgLayer_frameXOffset - 1;
                    if (xInternalPaste < 0) {
                        xInternalPaste += this.core.Map_FgLayer_NUM_FRAMES;
                    }
                    this.ScreenBufferGraphics.setClip(12 * xInternalPaste, mapRow * 12, 12, 12);
                    if (this.core.Map_BgLayer_type == 0 || this.core.Level_currentLevel == 1 && (this.core.Map_FgLayer_tileXOffset + 15 < 112 || this.core.Map_FgLayer_tileXOffset + 15 >= 220)) {
                        this.ScreenBufferGraphics.setColor(0, 0, 0);
                        this.ScreenBufferGraphics.fillRect(12 * xInternalPaste, 12 * mapRow, 12, 12);
                    } else {
                        xOffset = this.core.Map_FgLayer_tileXOffset % (this.BgLayer_tile.getWidth() / 12) * 12;
                        int bgPatternHeight = this.BgLayer_tile.getHeight() / 12;
                        yOffset = mapRow % bgPatternHeight * 12;
                        this.ScreenBufferGraphics.drawImage(this.BgLayer_tile, 12 * xInternalPaste - xOffset, 12 * mapRow - yOffset, 20);
                        if (this.core.Level_currentLevel == 1 && (this.core.Map_FgLayer_tileXOffset + 15 >= 112 && this.core.Map_FgLayer_tileXOffset + 15 < 128 || this.core.Map_FgLayer_tileXOffset + 15 >= 204 && this.core.Map_FgLayer_tileXOffset + 15 < 220)) {
                            int fadeRectangleSize = this.core.Map_FgLayer_tileXOffset + 15 < 128 ? 128 - (this.core.Map_FgLayer_tileXOffset + 15) : 12 - (220 - (this.core.Map_FgLayer_tileXOffset + 15));
                            this.ScreenBufferGraphics.setColor(0, 0, 0);
                            this.ScreenBufferGraphics.fillRect(12 * xInternalPaste, 12 * mapRow + (6 - fadeRectangleSize / 2), 12, fadeRectangleSize);
                        }
                    }
                    int tileNumber = this.core.Map_FgLayer_map[this.core.Map_FgLayer_tileXOffset + 1 + 15][mapRow];
                    byte transformType = 0;
                    transformType = this.core.Map_Tile_transformType[tileNumber];
                    if (this.core.Map_Tile_parentTile[tileNumber] != 0) {
                        tileNumber = this.core.Map_Tile_parentTile[tileNumber];
                    }
                    if (tileNumber < this.core.Map_NUM_TILES[this.core.Level_currentLevel - 1]) {
                        pasteImage = this.FgLayerTileSheet;
                    } else {
                        pasteImage = this.FgLayerBossTileSheet;
                        tileNumber -= this.core.Map_NUM_TILES[this.core.Level_currentLevel - 1];
                    }
                    xOffset = tileNumber % 32 * 12;
                    yOffset = tileNumber / 32 * 12;
                    if (tileNumber > 0) {
                        this.ScreenBufferGraphics.drawRegion(pasteImage, xOffset, yOffset, 12, 12, (int)transformType, 12 * xInternalPaste, mapRow * 12, 20);
                    }
                }
                ++mapRow;
            }
        }
    }
}

