/*
 * Decompiled with CFR 0.152.
 */
package tinbrain;

import handson.Handson;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import tinbrain.BitmapFont;
import tinbrain.Menu;
import tinbrain.RM;
import tinbrain.Tinlet;
import tinbrain.math3d.M3D;
import tinbrain.midp20.ACanvas;
import tinbrain.midp20.MIDP20Proxy;

public final class GCanvas
implements Runnable {
    protected static volatile boolean isRunning;
    private static int screenOrientation;
    private static int globalFrameCount;
    private static long uptimeMillis;
    protected static int width;
    protected static int height;
    private static boolean forcedSize;
    private static int keyStatesUp;
    private static int keyStatesDown;
    private static int keyStates;
    private static Canvas canvas;
    private static Graphics deviceGraphics;
    private static Graphics targetGraphics;
    private static Graphics offscreenGraphics;
    private static Image backBuffer;
    public static boolean backBufferEnabled;
    private static int[] fontDefinition;
    private static Font[] nativeFonts;
    private static int[] nativeFontColors;
    private static int softkeyPressed;
    public static int lastSoftkeyPressFrame;
    protected static byte[][] softkeys;
    private static int leftSoftButton;
    private static int rightSoftButton;
    public static boolean hideSoftKeys;
    private static final int[][] clipStack;
    private static int clipStackPtr;
    public static long frameTime;
    private static long lastFrameTime;
    private static long lastDrawTime;
    private static int frameTimeCount;
    private static String fpsMessage;
    private static StringBuffer fpsBuf;
    private static String tmpMessage;
    private static int tmpMessageTime;
    private static int cheatFlags;
    private static final int[] cheatBase;
    private static int cheatPosition;
    private static int scheduledCheat;
    private static long current;
    private static long last;
    private static long delay;
    private static short[] sinTable;
    private static boolean inputDone;
    protected static volatile boolean inPauseHandling;
    private static int[] pointerState;
    private static short[] spriteCache;
    private static boolean sScreenSizeChanged;
    private static int sScreenSizeChangedWidth;
    private static int sScreenSizeChangedHeight;
    private static Random random;
    public static int[] sTouchscreenEvents;
    public static int sCurrentTouchscreenEvent;

    public static final void setForcedSize(int n, int n2) {
        if (n != width || n2 != height) {
            GCanvas.setSize(n, n2);
            forcedSize = true;
        }
    }

    public static final int getEnforcedSize(int n, int n2) {
        return n << 16 | n2;
    }

    public static final void setSize(int n, int n2) {
        GCanvas.setSize(n, n2, false);
    }

    public static final void setSize(int n, int n2, boolean bl) {
        int n3 = GCanvas.getEnforcedSize(n, n2);
        n2 = n3 & 0xFFFF;
        n = (n3 & 0xFFFF0000) >> 16;
        sScreenSizeChanged = bl;
        if (sScreenSizeChanged) {
            sScreenSizeChangedWidth = n;
            sScreenSizeChangedHeight = n2;
            return;
        }
        if (!forcedSize) {
            GCanvas.createBackbuffer(n, n2);
            width = n;
            height = n2;
            int n4 = screenOrientation = width > height ? 1 : 0;
            if (Menu.isInitialized() || Menu.getMode() == 1) {
                Menu.setupLayout();
            }
        }
    }

    private static final void createBackbuffer(int n, int n2) {
        if (backBuffer == null || backBuffer.getWidth() != n || backBuffer.getHeight() != n2) {
            backBuffer = Image.createImage((int)n, (int)n2);
            offscreenGraphics = backBuffer.getGraphics();
        }
    }

    public static final void init(MIDlet mIDlet) {
        sScreenSizeChanged = false;
        M3D.locInit(3, 10);
        canvas = new ACanvas();
        Display.getDisplay((MIDlet)mIDlet).setCurrent((Displayable)canvas);
        GCanvas.setRandomSeed((int)System.currentTimeMillis());
        Handson.init();
    }

    public static final void initResources() {
        BitmapFont.init(14);
        GCanvas.initFonts();
        sinTable = RM.getShorts(16);
        short[] sArray = RM.getShorts(80);
        spriteCache = new short[sArray.length];
        RM.arraycopy(sArray, 0, spriteCache, 0, sArray.length);
        GCanvas.updateSpriteCache();
    }

    private static void updateSpriteCache() {
        int n = RM.getHeight(80);
        int n2 = 0;
        short[] sArray = spriteCache;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            block10: {
                int n7;
                int n8;
                block9: {
                    short s;
                    block8: {
                        block7: {
                            int n9;
                            int n10;
                            block6: {
                                block5: {
                                    short s2 = sArray[0 + n2];
                                    n6 = RM.getWidth(s2);
                                    int n11 = RM.getHeight(s2);
                                    short s3 = sArray[1 + n2];
                                    s = sArray[2 + n2];
                                    n5 = sArray[3 + n2];
                                    n4 = sArray[4 + n2];
                                    n3 = n11 / s3;
                                    if ((s & 1) == 0) break block5;
                                    n10 = n5;
                                    n9 = n6 / 2;
                                    break block6;
                                }
                                if ((s & 4) == 0) break block7;
                                n10 = n5;
                                n9 = n6;
                            }
                            n5 = n10 + n9;
                        }
                        if ((s & 2) == 0) break block8;
                        n8 = n4;
                        n7 = n3 / 2;
                        break block9;
                    }
                    if ((s & 8) == 0) break block10;
                    n8 = n4;
                    n7 = n3;
                }
                n4 = n8 + n7;
            }
            sArray[5 + n2] = (short)n6;
            sArray[6 + n2] = (short)n3;
            sArray[3 + n2] = (short)n5;
            sArray[4 + n2] = (short)n4;
            n2 += 7;
        }
    }

    private static void initFonts() {
        int n;
        int n2;
        int n3 = RM.getHeight(15);
        int n4 = 0;
        fontDefinition = new int[n3];
        int[] nArray = fontDefinition;
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray[n2] = RM.getValue(15, n2, 0);
            if (nArray[n2] >= 0) continue;
            ++n4;
        }
        nativeFonts = new Font[n4];
        nativeFontColors = new int[n4];
        n4 = 0;
        for (int i = 0; i < n3; ++i) {
            Font font;
            int n5;
            Font[] fontArray;
            if (RM.getValue(15, i, 0) >= 0) continue;
            n2 = RM.getValue(15, i, 1);
            n = RM.getValue(15, i, 2);
            int n6 = RM.getValue(15, i, 3);
            if (n2 < 0) {
                fontArray = nativeFonts;
                n5 = n4;
                font = Font.getDefaultFont();
            } else {
                fontArray = nativeFonts;
                n5 = n4;
                font = Font.getFont((int)64, (int)n, (int)n2);
            }
            fontArray[n5] = font;
            GCanvas.nativeFontColors[n4] = n6;
            RM.setValue(15, i, 4, n4++);
        }
    }

    private static final void updateInput() {
        keyStates = keyStatesDown;
        keyStatesDown &= ~keyStatesUp;
        keyStatesUp = 0;
    }

    public static final void resetKeys() {
        softkeyPressed = 0;
        keyStatesUp = 0;
        keyStatesDown = 0;
        keyStates = 0;
    }

    public static final int getSoftkeys() {
        int n = softkeyPressed;
        softkeyPressed = 0;
        return n;
    }

    public static final int getSoftKeyAreaTop() {
        return height - (2 + GCanvas.getFontHeight(10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void drawScene(Graphics graphics) {
        deviceGraphics = graphics;
        targetGraphics = backBufferEnabled ? offscreenGraphics : graphics;
        Graphics graphics2 = graphics;
        synchronized (graphics2) {
            GCanvas.doDrawScene$272d79b7();
            return;
        }
    }

    private static void doDrawScene$272d79b7() {
        Graphics graphics = targetGraphics;
        clipStackPtr = -1;
        graphics.setClip(0, 0, width, height);
        graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
        try {
            Menu.onDraw(graphics);
        }
        catch (Throwable throwable) {}
        if (!hideSoftKeys) {
            GCanvas.drawSoftButtons(graphics);
        }
        long l = System.currentTimeMillis();
        if (GCanvas.cheatEnabled(3)) {
            if (--frameTimeCount == 0) {
                frameTimeCount = 16;
                int n = (int)(l - lastFrameTime);
                lastFrameTime = l;
                if ((n >>= 4) > 0) {
                    int n2 = 1024000 / n + 512;
                    int n3 = n2 >> 10;
                    int n4 = n2 & 0x3FF;
                    int n5 = 10 * n4 >> 10;
                    if (fpsBuf == null) {
                        fpsBuf = new StringBuffer();
                    }
                    fpsBuf.setLength(0);
                    fpsBuf.append(n3);
                    fpsBuf.append('.');
                    fpsBuf.append(n5);
                    fpsMessage = fpsBuf.toString();
                }
            }
            if (fpsMessage != null) {
                graphics.setColor(-16777216);
                graphics.fillRect(0, 18, GCanvas.getStringWidth(fpsMessage, 0) + 4, GCanvas.getFontHeight(0) + 6);
                GCanvas.drawString(graphics, 0, fpsMessage, 2, 20, 20);
            }
        }
        GCanvas.updateUptime(l);
        if (tmpMessageTime > 0) {
            graphics.setColor(-16777216);
            graphics.fillRect(0, (height >> 1) - 2, width, GCanvas.getFontHeight(0) + 4);
            GCanvas.drawString(graphics, 0, tmpMessage, width >> 1, height >> 1, 17);
            --tmpMessageTime;
        }
        ++globalFrameCount;
        if (backBufferEnabled) {
            deviceGraphics.drawImage(backBuffer, 0, 0, 20);
        }
        inputDone = false;
    }

    private static final void updateUptime(long l) {
        if (canvas.isShown()) {
            long l2 = Math.abs(l - lastDrawTime);
            if (l2 < 672L) {
                uptimeMillis += l2;
            }
            lastDrawTime = l;
        }
    }

    private static void drawSoftButtons(Graphics graphics) {
        block7: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            block9: {
                int n6;
                int n7;
                int n8;
                block8: {
                    String string;
                    int n9;
                    block4: {
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        block6: {
                            block5: {
                                if (leftSoftButton == -1) break block4;
                                n8 = softkeys[leftSoftButton][2] & 0xFF;
                                n7 = 0;
                                n6 = height - 1 + 0;
                                n9 = RM.getShortFromBytes(softkeys[leftSoftButton], 0);
                                string = RM.t(n9);
                                if (n8 != 255) break block5;
                                if (Menu.game$486afe46.drawCustomSoftkeyLeft$276ff40f()) break block4;
                                GCanvas.drawString(targetGraphics, 10, string, 3, n6, 36);
                                if (!GCanvas.isTouchscreenEnabled()) break block4;
                                n14 = 3;
                                n13 = n6;
                                n12 = 3 + GCanvas.getStringWidth(string, 10);
                                n11 = n6;
                                n10 = GCanvas.getFontHeight(10);
                                break block6;
                            }
                            if (Menu.game$486afe46.drawCustomSoftkeyLeft$276ff40f()) break block4;
                            GCanvas.drawImage(graphics, n8, 3, n6, true, 36);
                            if (!GCanvas.isTouchscreenEnabled()) break block4;
                            n14 = 3;
                            n13 = n6;
                            n12 = 3 + RM.getWidth(n8);
                            n11 = n6;
                            n10 = RM.getHeight(n8);
                        }
                        Menu.addHotspotAligned(n14, n13, n12, n11 + n10, 0x1000000, 1, 36);
                    }
                    if (rightSoftButton == -1) break block7;
                    n8 = softkeys[rightSoftButton][2] & 0xFF;
                    n7 = width - 3;
                    n6 = height - 1 + 0;
                    n9 = RM.getShortFromBytes(softkeys[rightSoftButton], 0);
                    string = RM.t(n9);
                    if (n8 != 255) break block8;
                    if (Menu.game$486afe46.drawCustomSoftkeyRight$276ff40f()) break block7;
                    GCanvas.drawString(targetGraphics, 10, string, n7, n6, 40);
                    if (!GCanvas.isTouchscreenEnabled()) break block7;
                    n5 = n7;
                    n4 = n6;
                    n3 = n7 + GCanvas.getStringWidth(string, 10);
                    n2 = n6;
                    n = GCanvas.getFontHeight(10);
                    break block9;
                }
                if (Menu.game$486afe46.drawCustomSoftkeyRight$276ff40f()) break block7;
                GCanvas.drawImage(graphics, n8, n7, n6, true, 40);
                if (!GCanvas.isTouchscreenEnabled()) break block7;
                n5 = n7;
                n4 = n6;
                n3 = n7 + RM.getWidth(n8);
                n2 = n6;
                n = RM.getHeight(n8);
            }
            Menu.addHotspotAligned(n5, n4, n3, n2 + n, 0x1000000, 3, 40);
        }
    }

    public static final boolean cheatEnabled(int n) {
        return (cheatFlags & 1 << n) != 0;
    }

    public static final boolean isTouchscreenEnabled() {
        return false;
    }

    private static void showTemporaryMessage(String string) {
        if (tmpMessageTime <= 0) {
            tmpMessage = string;
            tmpMessageTime = 30;
            GCanvas.redraw();
            Thread.yield();
        }
    }

    public static final long getUptimeMillis() {
        return uptimeMillis;
    }

    private static void tick() {
        if (sScreenSizeChanged) {
            GCanvas.setSize(sScreenSizeChangedWidth, sScreenSizeChangedHeight, false);
        }
        GCanvas.handleInput();
        if (inputDone) {
            GCanvas.redraw();
        }
        current = System.currentTimeMillis();
        frameTime = Math.abs(current - last);
        long l = Menu.getMode() == 2 ? Menu.game$486afe46.getDesiredFrameTime() : 42L;
        delay = Math.max(2L, l - frameTime);
        GCanvas.sleep(delay);
        last = System.currentTimeMillis();
        if (Handson.mrcUse() && Menu.getCurrentMenu() == 26) {
            Handson.mrcHandleLicense();
        }
    }

    private static void handleInput() {
        if (inputDone) {
            return;
        }
        try {
            GCanvas.updateInput();
            int n = scheduledCheat;
            if (n >= 0) {
                scheduledCheat = -1;
                GCanvas.toggleCheat(n);
            }
            Menu.onInput();
        }
        catch (Throwable throwable) {}
        inputDone = true;
    }

    public static final void redraw() {
        canvas.repaint();
        canvas.serviceRepaints();
    }

    public static final void idleTick() {
        GCanvas.updateUptime(System.currentTimeMillis());
    }

    private static void sleep(long l) {
        try {
            Thread.sleep(l);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static final void simulateKeyPress(int n) {
        GCanvas.keyPressed(n);
        GCanvas.keyReleased(n);
    }

    public static final void simulateVKeyPress(int n) {
        keyStatesDown |= n;
        keyStatesUp |= n;
    }

    public static final void simulateVKeyPressTouch(int n) {
        keyStatesDown = n;
    }

    public static final void simulateVKeyReleaseTouch(int n) {
        keyStatesUp = n;
    }

    public static final void keyPressed(int n) {
        block9: {
            int n2;
            int n3;
            block10: {
                block8: {
                    int n4 = GCanvas.getVKey(n);
                    if (Menu.getMode() != 0) {
                        if (cheatPosition == cheatBase.length) {
                            int n5 = 0;
                            int[] nArray = RM.getInts(24);
                            for (int i = 0; i < 4; ++i) {
                                if (n4 == (nArray[0 + n5] & 0xFFFF)) {
                                    scheduledCheat = i;
                                    break;
                                }
                                n5 += 4;
                            }
                            cheatPosition = 0;
                        }
                        int n6 = cheatPosition = cheatBase[cheatPosition] == n4 ? cheatPosition + 1 : 0;
                    }
                    if (n4 != 0) {
                        keyStatesDown |= n4;
                        return;
                    }
                    if (n != -6) break block8;
                    if (globalFrameCount - lastSoftkeyPressFrame <= 0) break block9;
                    n3 = softkeyPressed;
                    n2 = 131072;
                    break block10;
                }
                if (n != Handson.keycodeRSK() || globalFrameCount - lastSoftkeyPressFrame <= 0) break block9;
                n3 = softkeyPressed;
                n2 = 262144;
            }
            softkeyPressed = n3 | n2;
            lastSoftkeyPressFrame = globalFrameCount;
        }
    }

    public static final boolean isLandscape() {
        return screenOrientation == 1;
    }

    /*
     * Unable to fully structure code
     */
    private static void toggleCheat(int var0) {
        block4: {
            var1_1 = -1;
            var2_2 = 1 << var0;
            if ((GCanvas.cheatFlags & var2_2) == 0) break block4;
            GCanvas.cheatFlags &= ~var2_2;
            v0 = 51;
            ** GOTO lbl17
        }
        var3_3 = RM.getValue(24, var0, 2);
        if (var3_3 != 0) {
            Menu.performMenuAction(var3_3, var0);
        } else {
            var3_3 = RM.getValue(24, var0, 3);
            if (var3_3 != 0) {
                Menu.performMenuAction(var3_3, var0);
            }
            GCanvas.cheatFlags |= var2_2;
            v0 = 50;
lbl17:
            // 2 sources

            var1_1 = v0;
        }
        var3_3 = RM.getValue(24, var0, 1);
        if (var3_3 != -1 && var1_1 != -1) {
            GCanvas.showTemporaryMessage(RM.t(var3_3) + " " + RM.t(var1_1));
            Menu.refreshMenu();
        }
    }

    public static final void keyReleased(int n) {
        keyStatesUp |= GCanvas.getVKey(n);
    }

    private static boolean isKeyPressed(int n) {
        return (keyStates & n) != 0;
    }

    private static boolean isUP() {
        return (0x81 & keyStates) != 0;
    }

    public static final boolean isRIGHT() {
        return (0x802 & keyStates) != 0;
    }

    private static boolean isDOWN() {
        return (0x2004 & keyStates) != 0;
    }

    public static final boolean isLEFT() {
        return (0x208 & keyStates) != 0;
    }

    public static final boolean isFIRE() {
        return (0x410 & keyStates) != 0;
    }

    public static final boolean consumeKey(int n) {
        if (GCanvas.isKeyPressed(n)) {
            keyStatesDown &= ~n;
            return true;
        }
        return false;
    }

    public static final boolean consumeUP() {
        if (GCanvas.isUP()) {
            keyStatesDown &= 0xFFFFFF7E;
            return true;
        }
        return false;
    }

    public static final boolean consumeDOWN() {
        if (GCanvas.isDOWN()) {
            keyStatesDown &= 0xFFFFDFFB;
            return true;
        }
        return false;
    }

    public static final boolean consumeLEFT() {
        if (GCanvas.isLEFT()) {
            keyStatesDown &= 0xFFFFFDF7;
            return true;
        }
        return false;
    }

    public static final boolean consumeRIGHT() {
        if (GCanvas.isRIGHT()) {
            keyStatesDown &= 0xFFFFF7FD;
            return true;
        }
        return false;
    }

    public static final boolean consumeFIRE() {
        if (GCanvas.isFIRE()) {
            keyStatesDown &= 0xFFFFFBEF;
            return true;
        }
        return false;
    }

    private static final int mapVKey(int n) {
        switch (n) {
            case 48: {
                return 32;
            }
            case 49: {
                return 64;
            }
            case 50: {
                return 128;
            }
            case 51: {
                return 256;
            }
            case 52: {
                return 512;
            }
            case 53: {
                return 1024;
            }
            case 54: {
                return 2048;
            }
            case 55: {
                return 4096;
            }
            case 56: {
                return 8192;
            }
            case 57: {
                return 16384;
            }
            case 42: {
                return 32768;
            }
            case 35: {
                return 65536;
            }
        }
        return 0;
    }

    private static final int checkDPAD(int n) {
        int n2 = 0;
        try {
            n2 = canvas.getGameAction(n);
        }
        catch (Exception exception) {}
        switch (n2) {
            case 1: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 8: {
                return 16;
            }
        }
        return 0;
    }

    private static final int getVKey(int n) {
        int n2 = GCanvas.mapVKey(n);
        if (n2 != 0) {
            return n2;
        }
        int n3 = n;
        if (n3 == -6 || n3 == Handson.keycodeRSK()) {
            return 0;
        }
        return GCanvas.checkDPAD(n);
    }

    public static final void hideNotify() {
        try {
            Menu.stopMusic();
            Menu.doPause();
        }
        catch (Exception exception) {}
        inPauseHandling = false;
    }

    public static final void showNotify() {
        if (!inPauseHandling) {
            inPauseHandling = true;
            try {
                Menu.resumeFromInterrupt();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public final void run() {
        isRunning = true;
        lastDrawTime = last = System.currentTimeMillis();
        uptimeMillis = last;
        while (isRunning) {
            GCanvas.tick();
        }
        if (!isRunning) {
            Tinlet.instance.notifyDestroyed();
        }
    }

    public static void shuffle(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n >> 1; ++i) {
            int n2 = GCanvas.getRandom(0, n);
            int n3 = GCanvas.getRandom(0, n);
            int n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int ipGetLambda(int var0, int var1_1) {
        switch (var1_1) {
            case 0: {
                break;
            }
            case 1: {
                v0 = 1024 - GCanvas.cos(var0 >> 2);
                ** GOTO lbl12
            }
            case 2: {
                v0 = GCanvas.cos(256 - (var0 >> 2));
                ** GOTO lbl12
            }
            case 3: {
                v0 = 512 + (GCanvas.cos(512 + (var0 >> 1)) >> 1);
lbl12:
                // 3 sources

                var0 = v0;
            }
        }
        var0 = GCanvas.clamp(var0, 0, 1024);
        return var0;
    }

    public static final int mathAtan2Unit(int n, int n2) {
        if (GCanvas.mathAbs(n) > GCanvas.mathAbs(n2)) {
            if (n > 0) {
                return GCanvas.mathAcos(n2);
            }
            return -GCanvas.mathAcos(n2);
        }
        return 256 - (n2 > 0 ? GCanvas.mathAcos(n) : -GCanvas.mathAcos(n));
    }

    private static int mathAcos(int n) {
        int n2 = 256;
        int n3 = GCanvas.cos(256);
        int n4 = 0;
        int n5 = 0;
        for (int i = 128; n3 != n && i > 0; i >>= 1) {
            n4 = n2;
            int n6 = n3 > n ? i : -i;
            n5 = n3;
            n3 = GCanvas.cos(n2 += n6);
        }
        if (GCanvas.mathAbs(n - n5) < GCanvas.mathAbs(n - n3)) {
            return n4;
        }
        return n2;
    }

    public static int mathModWrap(int n, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return n2;
        }
        int n5 = (n - n2) % n4;
        if (n5 < 0) {
            n5 += n4;
        }
        return n5 + n2;
    }

    public static int mathWrap(int n, int n2, int n3) {
        if (n > n3) {
            int n4 = n3 - n2 + 1;
            return n - (n - n2) / n4 * n4;
        }
        if (n < n2) {
            int n5 = n3 - n2 + 1;
            return n + (n3 - n) / n5 * n5;
        }
        return n;
    }

    private static int mathAbs(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    public static final boolean isSpacingNeeded(int n) {
        if (GCanvas.isTouchscreenEnabled()) {
            return true;
        }
        int n2 = GCanvas.getFontDef(n);
        if (n2 >= 0) {
            return BitmapFont.isSpacingNeeded();
        }
        return true;
    }

    public static final int getFontDef(int n) {
        if (fontDefinition != null) {
            return fontDefinition[n];
        }
        return -1;
    }

    private static Font getNativeFont(int n) {
        if (n == 0 || !RM.isLoaded(15)) {
            return Font.getDefaultFont();
        }
        int n2 = RM.getValue(15, n, 4);
        if (n2 >= 0) {
            return nativeFonts[n2];
        }
        return null;
    }

    private static final int getNativeFontColor(int n) {
        int n2;
        if (n != 0 && RM.isLoaded(15) && (n2 = RM.getValue(15, n, 4)) >= 0) {
            return nativeFontColors[n2];
        }
        return -1;
    }

    public static final int getFontHeight(int n) {
        int n2 = GCanvas.getFontDef(n);
        if (n2 >= 0) {
            return BitmapFont.getHeight(n2);
        }
        return GCanvas.getNativeFont(n).getHeight();
    }

    public static final int getSubstringWidth(String string, int n, int n2, int n3) {
        int n4 = GCanvas.getFontDef(n3);
        if (n4 >= 0) {
            return BitmapFont.getSubstringWidth(n4, string, n, n2);
        }
        return GCanvas.getNativeFont(n3).substringWidth(string, n, n2);
    }

    public static final int getCharWidth(char c, int n) {
        int n2 = GCanvas.getFontDef(n);
        if (n2 >= 0) {
            return BitmapFont.getCharWidth(n2, c);
        }
        return GCanvas.getNativeFont(n).charWidth(c);
    }

    public static final int getStringWidth(String string, int n) {
        int n2 = GCanvas.getFontDef(n);
        if (n2 >= 0) {
            return BitmapFont.getStringWidth(n2, string);
        }
        return GCanvas.getNativeFont(n).stringWidth(string);
    }

    public static final int getTextWidth(int n, int n2) {
        String string = RM.t(n);
        return GCanvas.getStringWidth(string, n2);
    }

    public static final void setSoftButton(int n, int n2) {
        leftSoftButton = n;
        rightSoftButton = n2;
    }

    public static final int getLSK() {
        return leftSoftButton;
    }

    public static final int getRSK() {
        return rightSoftButton;
    }

    public static final void drawImage(Graphics graphics, int n, int n2, int n3) {
        GCanvas.drawImage(graphics, n, n2, n3, 20);
    }

    public static final void drawImage(Graphics graphics, int n, int n2, int n3, int n4) {
        GCanvas.drawImage(graphics, n, n2, n3, true, n4);
    }

    private static void drawImage(Graphics graphics, int n, int n2, int n3, boolean bl, int n4) {
        int n5 = RM.getType(n);
        if (n5 == 1) {
            graphics.drawImage(RM.getImage(n), n2, n3, n4);
            return;
        }
        if (n5 == 4) {
            int n6 = RM.getWidth(n);
            MIDP20Proxy.drawImage(graphics, RM.getInts(n), n2, n3, n6, RM.getHeight(n), n6, bl, n4);
            return;
        }
        if (n5 == 5) {
            return;
        }
    }

    public static final void drawString(Graphics graphics, int n, String string, int n2, int n3, int n4) {
        int n5 = GCanvas.getFontDef(n);
        if (n5 >= 0) {
            BitmapFont.drawString(graphics, n5, string, n2, n3, n4);
            return;
        }
        Font font = GCanvas.getNativeFont(n);
        if ((n4 & 2) != 0) {
            n4 &= 0xFFFFFFFD;
            n4 |= 0x10;
            n3 -= font.getHeight() >> 1;
        }
        graphics.setFont(font);
        graphics.setColor(GCanvas.getNativeFontColor(n));
        graphics.drawString(string, n2 + 0, n3 + 0, n4);
    }

    public static final void drawSpriteWithHotspot(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        GCanvas.drawSprite(graphics, n, n2, n3, n4);
        if (GCanvas.isTouchscreenEnabled()) {
            short[] sArray = spriteCache;
            int n7 = n * 7;
            short s = sArray[3 + n7];
            short s2 = sArray[4 + n7];
            short s3 = sArray[5 + n7];
            short s4 = sArray[6 + n7];
            Menu.addHotspot(n2 -= s, n3 -= s2, n2 + s3, n3 + s4, n5, n6);
        }
    }

    public static final void drawSprite(Graphics graphics, int n, int n2, int n3, int n4) {
        short[] sArray = spriteCache;
        int n5 = n * 7;
        short s = sArray[0 + n5];
        short s2 = sArray[3 + n5];
        short s3 = sArray[4 + n5];
        short s4 = sArray[5 + n5];
        short s5 = sArray[6 + n5];
        GCanvas.pushClip(graphics);
        if (GCanvas.clipRect(graphics, n2 -= s2, n3 -= s3, s4, s5)) {
            GCanvas.drawImage(graphics, s, n2, n3 - n4 * s5, true, 20);
        }
        GCanvas.popClip(graphics);
    }

    public static final void drawSprite(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        short[] sArray = spriteCache;
        int n7 = n * 7;
        short s = sArray[0 + n7];
        short s2 = sArray[5 + n7];
        short s3 = sArray[6 + n7];
        GCanvas.pushClip(graphics);
        if (GCanvas.clipRect(graphics, n2 -= n4, n3 -= n5, s2, s3)) {
            GCanvas.drawImage(graphics, s, n2, n3 - n6 * s3, true, 20);
        }
        GCanvas.popClip(graphics);
    }

    public static final int getSpriteWidth(int n) {
        return spriteCache[5 + n * 7];
    }

    public static final int getSpriteHeight(int n) {
        return spriteCache[6 + n * 7];
    }

    public static final int getSpriteFrames(int n) {
        return spriteCache[1 + n * 7];
    }

    public static final int mul(int n, int n2) {
        return (int)((long)n * (long)n2 >> 10);
    }

    public static final int div(int n, int n2) {
        return (int)(((long)n << 10) / (long)n2);
    }

    public static final int sqr(int n) {
        long l = n;
        return (int)(l * l >> 10);
    }

    private static final int sqrtCalculated(int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = 0x40000000;
        do {
            int n5 = n2 + n4;
            n2 >>= 1;
            if (n5 > n3) continue;
            n3 -= n5;
            n2 += n4;
        } while ((n4 >>= 2) != 0);
        if (n2 < n3) {
            ++n2;
        }
        return n2 << 5;
    }

    public static final int sqrt(int n) {
        return GCanvas.sqrtCalculated(n);
    }

    public static final int sin(int n) {
        short[] sArray = sinTable;
        if ((n &= 0x3FF) <= 256) {
            return sArray[n];
        }
        if (n <= 512) {
            return sArray[512 - n];
        }
        if (n <= 768) {
            return -sArray[n - 512];
        }
        return -sArray[1024 - n];
    }

    public static final int cos(int n) {
        return GCanvas.sin(n + 256);
    }

    public static final void setRandomSeed(long l) {
        if (random == null) {
            random = new Random();
        }
        random.setSeed(l);
    }

    public static final int getRandom(int n, int n2) {
        if (random == null) {
            random = new Random();
        }
        if (n2 == n) {
            return n;
        }
        int n3 = random.nextInt();
        n3 = n3 < 0 ? -n3 : n3;
        int n4 = n2 - n;
        return n + n3 % n4;
    }

    public static final int[] getUniqueRandomValues(int n, int n2, int n3) {
        if (n3 > n2 - n) {
            throw new IllegalArgumentException("you need a bigger set of possible values to fill the array");
        }
        int[] nArray = new int[n3];
        int n4 = n2 - n << 10;
        int n5 = n4 / n3;
        int n6 = n << 10;
        for (int i = 0; i < nArray.length; ++i) {
            int n7;
            int n8 = n6 >> 10;
            int n9 = n6 + n5 >> 10;
            nArray[i] = n7 = GCanvas.getRandom(n8, n9);
            n6 += n5;
        }
        GCanvas.shuffle(nArray);
        return nArray;
    }

    public static final int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static final void vibrate(int n) {
        GCanvas.doVibrate(n);
    }

    private static final void doVibrate(int n) {
        if (Menu.getOption(3) != 0) {
            MIDP20Proxy.vibrate(n);
        }
    }

    public static final int getGlobalFrameCount() {
        return globalFrameCount;
    }

    public static final int getWidth() {
        return width;
    }

    public static final int getHeight() {
        return height;
    }

    public static final void pushClip(Graphics graphics) {
        int[] nArray = clipStack[++clipStackPtr];
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        nArray[0] = n;
        nArray[2] = n + graphics.getClipWidth();
        nArray[1] = n2;
        nArray[3] = n2 + graphics.getClipHeight();
    }

    public static final boolean clipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int[] nArray = clipStack[clipStackPtr];
        int n5 = nArray[0];
        int n6 = nArray[1];
        int n7 = nArray[2];
        int n8 = nArray[3];
        int n9 = n + n3;
        int n10 = n2 + n4;
        if (n5 < n) {
            n5 = n;
        }
        if (n6 < n2) {
            n6 = n2;
        }
        if (n7 > n9) {
            n7 = n9;
        }
        if (n8 > n10) {
            n8 = n10;
        }
        if (n7 > n5 && n8 > n6) {
            graphics.setClip(n5, n6, n7 - n5, n8 - n6);
            return true;
        }
        return false;
    }

    public static final void popClip(Graphics graphics) {
        GCanvas.setClip(graphics, clipStack[clipStackPtr--]);
    }

    public static final void setClip(Graphics graphics, int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        graphics.setClip(n, n2, n3 - n, n4 - n2);
    }

    public static final int getPointerState(int n) {
        int n2 = pointerState[n];
        if (n2 == 3) {
            GCanvas.pointerState[n] = 0;
        }
        return n2;
    }

    private static int lineMagnitude(int n, int n2, int n3, int n4) {
        return GCanvas.sqrt(GCanvas.sqr(n3 - n) + GCanvas.sqr(n4 - n2));
    }

    public static int distanceFromLineToPoint(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = GCanvas.lineMagnitude(n3, n4, n5, n6);
        int n8 = (n - n3) * (n5 - n3) + (n2 - n4) * (n6 - n4);
        if ((n8 /= GCanvas.sqr(n7)) < 0 || n8 > 1) {
            return Math.min(GCanvas.lineMagnitude(n, n2, n3, n4), GCanvas.lineMagnitude(n, n2, n5, 2));
        }
        int n9 = n3 + n8 * (n5 - n3);
        int n10 = n4 + n8 * (n6 - n4);
        return GCanvas.lineMagnitude(n, n2, n9, n10);
    }

    public static final void fillRectWithImage(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        GCanvas.pushClip(graphics);
        int n7 = RM.getWidth(n);
        int n8 = RM.getHeight(n);
        int n9 = n6 = n2;
        while (n9 < n4) {
            int n10;
            int n11 = Math.min(n7, n4 - n6);
            int n12 = n10 = n3;
            while (n12 < n5) {
                int n13 = Math.min(n8, n5 - n10);
                graphics.setClip(n6, n10, n11, n13);
                GCanvas.drawImage(graphics, n, n6, n10);
                n12 = n10 + n8;
            }
            n9 = n6 + n7;
        }
        GCanvas.popClip(graphics);
    }

    static {
        backBufferEnabled = true;
        lastSoftkeyPressFrame = 0;
        leftSoftButton = -1;
        rightSoftButton = -1;
        clipStack = new int[8][4];
        clipStackPtr = -1;
        frameTimeCount = 16;
        cheatBase = new int[]{65536, 128, 32, 32};
        scheduledCheat = -1;
        pointerState = new int[2];
        sTouchscreenEvents = new int[120];
        sCurrentTouchscreenEvent = 39;
    }
}

