/*
 * Decompiled with CFR 0.152.
 */
package game.dirtfield;

import game.Game;
import game.Tank;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.math3d.AutoBezier;

public abstract class DirtFieldBase {
    public int mPixelWidth;
    public int mPixelHeight;
    public int mWidth;
    public int mViewX;
    public int mViewY;
    protected short[] mCachedHeights;
    public boolean mDirty;
    protected int[] mOut = new int[2];

    public void init(int n, int n2) {
        this.mPixelWidth = n;
        this.mPixelHeight = n2;
        Game.instance.calcAspectRatio(n, n2);
        this.mWidth = this.dirtFieldToLogicalX(n);
        this.mDirty = true;
    }

    protected final void allocCachedHeights(int n) {
        this.mCachedHeights = new short[n];
        for (int i = 0; i < n; ++i) {
            this.mCachedHeights[i] = 0;
        }
    }

    protected final AutoBezier setupSpline() {
        AutoBezier autoBezier = new AutoBezier(450, false);
        int n = 3 * this.mPixelHeight / 4;
        int n2 = this.mPixelHeight / 4;
        int n3 = 0;
        int n4 = n / 5 + GCanvas.getRandom(0, n * 4 / 10);
        int n5 = 2 + GCanvas.getRandom(0, 6);
        autoBezier.initBlank(n5 + 1);
        autoBezier.setPoint(0, 0, n4);
        for (int i = 0; i < n5; ++i) {
            int n6 = i == n5 - 1 ? this.mPixelWidth : n3 + this.mPixelWidth / n5;
            n4 = n2 + (n / 5 + GCanvas.getRandom(0, n * 4 / 10));
            autoBezier.setPoint(1 + i, n6, n4);
            n3 = n6;
        }
        autoBezier.calculateWeights();
        return autoBezier;
    }

    public abstract void createSplineLandscape();

    public abstract boolean isSolid(int var1, int var2);

    public final int getGroundLevel(int n) {
        return this.dirtFieldToLogicalY(this.getCachedGroundLevelForColumn(this.logicalToDirtFieldX(n)));
    }

    public static int getAngle$134621() {
        return 0;
    }

    public abstract boolean update();

    public abstract boolean isReady();

    public static void renderSky(Graphics graphics) {
        graphics.setColor(0x8080C0);
        graphics.fillRect(0, 0, Game.instance.viewportGetWidth(), Game.instance.viewportGetHeight());
    }

    public abstract void render(Graphics var1);

    public abstract void createCircle(int var1, int var2, int var3);

    public abstract void destroyCircle(int var1, int var2, int var3, int var4);

    public abstract void createWall(int var1, int var2);

    public static void checkForFallingTanks(int n, int n2) {
        Game game = Game.instance;
        Tank[] tankArray = game.gamestate_players;
        for (int i = 0; i < tankArray.length; ++i) {
            Tank tank = tankArray[i];
            if (tank == null) continue;
            int n3 = tank.x;
            int n4 = tank.logicalWidth() / 2;
            int n5 = n3 - n4;
            int n6 = n3 + n4;
            int n7 = n - n2;
            int n8 = n + n2;
            if (!(n5 >= n7 && n5 <= n8 || n6 >= n7 && n6 <= n8) && (n5 > n7 || n6 < n8)) continue;
            tank.falling = true;
        }
    }

    protected void getClampedCoordX(int n, int n2, int n3, int[] nArray) {
        n = Math.max(0, Math.min(n, n3 - n2));
        int n4 = Math.min(n3, n2);
        if (n4 + n > n3) {
            n4 = n3 - n;
        }
        nArray[0] = n;
        nArray[1] = n4;
    }

    protected final void getClampedCoordY(int n, int n2, int n3, int[] nArray) {
        this.getClampedCoordX(n, n2, n3, nArray);
    }

    public void setViewTopLeft(int n, int n2) {
        int n3 = GCanvas.clamp(n, 0, this.mPixelWidth - Game.instance.viewportGetWidth());
        int n4 = GCanvas.clamp(n2, 0, this.mPixelHeight - Game.instance.viewportGetHeight());
        if (n3 != this.mViewX || n4 != this.mViewY) {
            this.mDirty = true;
        }
        this.mViewX = n3;
        this.mViewY = n4;
    }

    public final int logicalToScreenX(int n) {
        return this.logicalToDirtFieldX(n) - this.mViewX + Game.instance.viewportGetLeft();
    }

    public final int logicalToScreenY(int n) {
        return this.logicalToDirtFieldY(n) - this.mViewY + Game.instance.viewportGetTop();
    }

    public final int logicalToDirtFieldX(int n) {
        return (int)(((long)n << 10) / (long)Game.instance.mAspectRatio * (long)this.mPixelWidth >> 10);
    }

    public final int logicalToDirtFieldY(int n) {
        return (int)(((long)n << 10) / 102400L * (long)this.mPixelHeight >> 10);
    }

    public final int dirtFieldToLogicalX(int n) {
        return (n << 10) / this.mPixelWidth * Game.instance.mAspectRatio >> 10;
    }

    public final int dirtFieldToLogicalY(int n) {
        return (n << 10) / this.mPixelHeight * 100;
    }

    public int getCachedGroundLevelForColumn(int n) {
        if (n < 0 || n >= this.mPixelWidth) {
            return 0;
        }
        return this.mCachedHeights[n];
    }
}

