/*
 * Decompiled with CFR 0.152.
 */
package game.dirtfield;

import game.Game;
import game.dirtfield.DirtFieldBase;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.math3d.AutoBezier;
import tinbrain.math3d.Point2D;

public final class DirtField_SpansNoBuffer
extends DirtFieldBase {
    private int mGroundTexture = -1;
    private int[] mField;

    public final void init(int n, int n2) {
        int n3 = n / 2;
        if (n % 2 != 0) {
            ++n3;
        }
        this.allocCachedHeights(n3);
        super.init(n3 * 2, n2);
        this.mField = new int[n3 * 3];
        this.mGroundTexture = GCanvas.getRandom(Game.instance.getRuleValueInt(20), Game.instance.getRuleValueInt(21));
    }

    private void reset() {
        this.initCachedHeights();
    }

    public final void createCircle(int n, int n2, int n3) {
        DirtFieldBase.checkForFallingTanks(n, n3);
        int n4 = this.logicalToDirtFieldX(n);
        int n5 = this.logicalToDirtFieldY(n2);
        int n6 = this.logicalToDirtFieldX(n3);
        int n7 = Math.max(0, n4 - n6);
        int n8 = Math.min(this.mPixelWidth - 1, n4 + n6);
        int n9 = Math.max(0, n5 - n6);
        int n10 = Math.min(this.mPixelHeight - 1, n5 + n6);
        for (int i = n7; i <= n8; i += 2) {
            int n11;
            int n12 = -1;
            int n13 = -1;
            for (n11 = n10; n11 >= n9; --n11) {
                int n14 = i - n4;
                int n15 = n11 - n5;
                int n16 = GCanvas.sqrt(n14 * n14 + n15 * n15 << 10) >> 10;
                if (n16 >= n6) continue;
                if (n12 == -1) {
                    n12 = n11;
                }
                n13 = n11;
            }
            if (n12 == -1 || n13 == -1) continue;
            n11 = i / 2 * 3;
            this.mField[n11 + 0] = n13;
        }
        this.mDirty = true;
    }

    public final void createSplineLandscape() {
        int n;
        int n2;
        this.mDirty = true;
        AutoBezier autoBezier = this.setupSpline();
        this.clear();
        int[] nArray = this.mField;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Point2D point2D = new Point2D();
        int n6 = autoBezier.mNumSegments;
        for (n2 = 0; n2 < n6 + 1 << 10; n2 += 10) {
            autoBezier.getPoint2D(n2, point2D);
            point2D.x /= 2;
            if (point2D.x >= n3) {
                n4 = Math.max(0, Math.min(point2D.y, this.mPixelHeight - 1));
                n5 = point2D.y;
            } else {
                n4 = n5;
            }
            if (point2D.x >= 0 && point2D.x < this.mPixelWidth / 2) {
                for (n = n3; n < point2D.x; ++n) {
                    int n7 = n * 3;
                    nArray[n7 + 0] = n4;
                    nArray[n7 + 1] = this.mPixelHeight - 1;
                    nArray[n7 + 2] = 0x221100;
                }
            }
            n3 = point2D.x;
        }
        for (n2 = n3; n2 < this.mPixelWidth / 2; ++n2) {
            n = n2 * 3;
            nArray[n + 0] = n4;
            nArray[n + 1] = this.mPixelHeight - 1;
            nArray[n + 2] = 0x221100;
        }
        this.reset();
    }

    public final void createWall(int n, int n2) {
        int n3 = this.logicalToDirtFieldX(n);
        int n4 = this.logicalToDirtFieldX(n2);
        int n5 = Math.max(0, n3 - n4 / 2);
        int n6 = Math.min(this.mPixelWidth - 1, n3 + n4 / 2);
        int n7 = this.mPixelHeight - 1;
        for (int i = n5; i <= n6; i += 2) {
            this.addSpan(i / 2, 0, n7, 0x332200);
        }
        this.mDirty = true;
    }

    public final void destroyCircle(int n, int n2, int n3, int n4) {
        DirtFieldBase.checkForFallingTanks(n, n3);
        int n5 = this.logicalToDirtFieldX(n);
        int n6 = this.logicalToDirtFieldY(n2);
        int n7 = this.logicalToDirtFieldX(n3 + n4);
        int n8 = Math.max(0, n5 - n7);
        int n9 = Math.min(this.mPixelWidth - 1, n5 + n7);
        int n10 = Math.max(0, n6 - n7);
        int n11 = Math.min(this.mPixelHeight - 1, n6 + n7);
        for (int i = n8; i <= n9; i += 2) {
            int n12 = -1;
            int n13 = -1;
            for (int j = n11; j >= n10; --j) {
                int n14 = i - n5;
                int n15 = j - n6;
                int n16 = GCanvas.sqrt(n14 * n14 + n15 * n15 << 10) >> 10;
                if (n16 >= n7) continue;
                if (n12 == -1) {
                    n12 = j;
                }
                n13 = j;
            }
            this.deleteSpan(i / 2, n12, n13);
        }
    }

    private int getGroundLevelForColumn(int n) {
        int[] nArray = this.mField;
        if (n < 0 || n >= this.mPixelWidth) {
            return 0;
        }
        int n2 = n / 2 * 3;
        int n3 = -1;
        for (int i = 0; i < 3; i += 3) {
            if (nArray[n2 + 0 + 0] == -1 || nArray[n2 + 0 + 0] == -1) continue;
            n3 = nArray[n2 + 0 + 0];
        }
        if (n3 != -1) {
            return n3;
        }
        return this.mPixelHeight - 1;
    }

    public final boolean isReady() {
        return true;
    }

    public final boolean isSolid(int n, int n2) {
        int n3 = this.logicalToDirtFieldX(n);
        int n4 = this.logicalToDirtFieldY(n2);
        if (n4 < 0) {
            return false;
        }
        if (n4 >= this.mPixelHeight) {
            return true;
        }
        if (n3 < 0 || n3 >= this.mPixelWidth) {
            return false;
        }
        int n5 = n3 / 2 * 3;
        int[] nArray = this.mField;
        for (int i = 0; i < 3; i += 3) {
            if (nArray[n5 + 0 + 0] == -1 || n4 < nArray[n5 + 0 + 0] || n4 > nArray[n5 + 0 + 1]) continue;
            return true;
        }
        return false;
    }

    public final void render(Graphics graphics) {
        int n;
        int n2 = this.mViewX;
        int n3 = this.mViewY;
        int n4 = 0;
        this.getClampedCoordX(n2, GCanvas.getWidth(), this.mPixelWidth, this.mOut);
        n2 = this.mOut[0];
        n4 = this.mOut[1];
        this.getClampedCoordY(n3, GCanvas.getHeight(), this.mPixelHeight, this.mOut);
        int[] nArray = this.mField;
        int n5 = n = n2 / 2 * 3;
        int n6 = n2 % 2;
        int n7 = 0;
        while (n7 < n4 + n6) {
            int n8 = 0;
            int n9 = 0;
            while (n9 < 1) {
                int n10 = nArray[n5 + n8 + 0];
                if (n10 != -1) {
                    int n11 = nArray[n5 + n8 + 1] - n10 + 1;
                    GCanvas.fillAreaWithImageWithOffset(graphics, this.mGroundTexture, n7 - n6 + 0, n10 + 0, 2, n11, this.mViewX + n7 - n6 + 0, n10 - (this.mPixelHeight >> 2));
                }
                ++n9;
                n8 += 3;
            }
            n7 += 2;
            n5 += 3;
        }
    }

    public final boolean update() {
        int[] nArray = this.mField;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < this.mPixelWidth) {
            int n4 = nArray[n3 + 0];
            if (this.mCachedHeights[n2] != (short)n4) {
                bl = true;
            }
            this.mCachedHeights[n2] = (short)(n4 != -1 ? n4 : this.mPixelHeight);
            n += 2;
            ++n2;
            n3 += 3;
        }
        if (bl) {
            this.mDirty = true;
        }
        if (bl) {
            this.mDirty = true;
        }
        return bl;
    }

    private void clear() {
        int[] nArray = this.mField;
        for (int i = 0; i < this.mPixelWidth / 2 * 3; i += 3) {
            for (int j = 0; j < 3; j += 3) {
                nArray[i + j + 0] = -1;
                nArray[i + j + 1] = -1;
                nArray[i + j + 2] = -1;
            }
        }
    }

    private void deleteSpan(int n, int n2, int n3) {
        int n4;
        int n5 = n * 3;
        int[] nArray = this.mField;
        if (n2 > n3) {
            n4 = n3;
            n3 = n2;
            n2 = n4;
        }
        for (n4 = 0; n4 < 3; n4 += 3) {
            if (nArray[n5 + 0 + 0] == -1) continue;
            if (n2 > nArray[n5 + 0 + 0] || n3 < nArray[n5 + 0 + 1]) {
                if (n2 > nArray[n5 + 0 + 0] && n3 < nArray[n5 + 0 + 1]) {
                    nArray[n5 + 0 + 0] = n3;
                    return;
                }
                if (n2 <= nArray[n5 + 0 + 0] && n3 < nArray[n5 + 0 + 1] && n3 > nArray[n5 + 0 + 0]) {
                    nArray[n5 + 0 + 0] = n3;
                }
                if (n2 <= nArray[n5 + 0 + 0] || n2 >= nArray[n5 + 0 + 1] || n3 < nArray[n5 + 0 + 1]) continue;
            }
            nArray[n5 + 0 + 0] = -1;
        }
    }

    private void addSpan(int n, int n2, int n3, int n4) {
        int n5;
        if (n2 == -1 || n3 == -1) {
            return;
        }
        if (n2 > n3) {
            n5 = n3;
            n3 = n2;
            n2 = n5;
        }
        n5 = n * 3;
        int[] nArray = this.mField;
        int n6 = this.mPixelHeight;
        int n7 = -1;
        for (int i = 0; i >= 0; i -= 3) {
            if (nArray[n5 + i + 0] != -1) {
                if (nArray[n5 + i + 0] != -1 && n6 > nArray[n5 + i + 0]) {
                    n6 = nArray[n5 + i + 0];
                }
                if (i != 0 || i <= 3 || nArray[n5 + i - 3 + 0] == -1) continue;
                int n8 = nArray[n5 + i + 1] - nArray[n5 + i - 3 + 1];
                nArray[n5 + i - 3 + 0] = n8 + nArray[n5 + i + 0];
                nArray[n5 + i + 0] = -1;
            }
            n7 = i;
        }
        if (n7 != -1) {
            if (n3 > n6 && n2 > (n3 = n6 - 1)) {
                return;
            }
            nArray[n5 + n7 + 0] = n2;
            nArray[n5 + n7 + 1] = n3;
            nArray[n5 + n7 + 2] = n4;
        }
    }

    protected final void getClampedCoordX(int n, int n2, int n3, int[] nArray) {
        super.getClampedCoordX(n, n2, n3, nArray);
    }

    public final void setViewTopLeft(int n, int n2) {
        int n3 = GCanvas.clamp(n, 0, this.mPixelWidth - Game.instance.viewportGetWidth() - 2);
        int n4 = GCanvas.clamp(n2, 0, this.mPixelHeight - Game.instance.viewportGetHeight());
        if (n3 != this.mViewX || n4 != this.mViewY) {
            this.mDirty = true;
        }
        this.mViewX = n3;
        this.mViewY = n4;
    }

    private void initCachedHeights() {
        for (int i = 0; i < this.mPixelWidth; i += 2) {
            this.mCachedHeights[i / 2] = (short)this.getGroundLevelForColumn(i);
        }
    }

    public final int getCachedGroundLevelForColumn(int n) {
        if (n < 0 || n >= this.mPixelWidth) {
            return 0;
        }
        return this.mCachedHeights[n /= 2];
    }
}

