/*
 * Decompiled with CFR 0.152.
 */
package root;

import java.util.Hashtable;
import java.util.Random;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.TextBox;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreFullException;
import root.MyMidlet;
import root.TextRenderer;

public class Util {
    public static TextBox textBox;
    private static Display display;
    private static MyMidlet midlet;
    private static TextRenderer renderer;
    private static final Random RANDOM;
    private static boolean errorOcurred;
    private static final boolean CACHE_OPEN_DB = true;
    private static final byte[] emptyTable;
    private static Hashtable openedRMS;
    private static final String NO_RMS_MEMORY_TEXT = "The storage memory is full. You must free memory and run application again. ";

    public static int random(int scale) {
        if (scale == 0) {
            return 0;
        }
        return (RANDOM.nextInt() << 1 >>> 1) % scale;
    }

    public static int randomWithMinus(int scale) {
        if (scale == 0) {
            return 0;
        }
        return (RANDOM.nextInt() >>> 1 << 1) % (scale << 1) >> 1;
    }

    public static void setCurrentScreen(Displayable current) {
        if (!errorOcurred) {
            display.setCurrent(current);
        }
    }

    public static Display getDisplay() {
        return display;
    }

    public static void displayTextBox(String text, String title) {
        Form form = new Form(title);
        form.append(text);
        Util.addForm((Screen)form);
    }

    public static void editTextBox(String text, String title, int len) {
        textBox = new TextBox(title, text, len, 0);
        Util.addForm((Screen)textBox);
    }

    public static void addForm(Screen form) {
        form.setCommandListener((CommandListener)midlet);
        Util.setCurrentScreen((Displayable)form);
    }

    public static void paintText(Graphics g, String text, int xSrodka, int ySrodka, int kolorTekstu, int rodzajTla, int kolorTla) {
        int szerokoscNapisu = renderer.getStringWidth(text.length());
        int wysokoscNapisu = renderer.getStringHeight(1);
        g.setColor(0);
        g.fillRect(xSrodka - szerokoscNapisu / 2 - 6, ySrodka - 2 - 4, szerokoscNapisu + 12, wysokoscNapisu + 8);
        renderer.renderText(g, xSrodka - szerokoscNapisu / 2, ySrodka - 2, new StringBuffer(text));
    }

    public static void critical(Exception e, String description) {
        e.printStackTrace();
        String text = "Error: " + e.toString() + " <" + description + ">";
        System.out.println(text);
        Util.displayTextBox(text, "Error");
        errorOcurred = true;
    }

    public static void registerApplication(MyMidlet midlet, Display display) {
        Util.display = display;
        Util.midlet = midlet;
    }

    public static final byte[] loadBytesFromRMS(String databaseName) {
        byte[] result = emptyTable;
        try {
            RecordStore o = null;
            o = (RecordStore)openedRMS.get(databaseName);
            if (o == null) {
                o = RecordStore.openRecordStore((String)databaseName, (boolean)true);
                openedRMS.put(databaseName, o);
            }
            RecordStore rs = o;
            result = rs.getRecord(1);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    public static final void writeBytesToRMS(String databaseName, byte[] bytes) {
        Util.writeBytesToRMS(databaseName, bytes, bytes.length);
    }

    public static final void writeBytesToRMS(String databaseName, byte[] bytes, int l) {
        try {
            RecordStore o = null;
            o = (RecordStore)openedRMS.get(databaseName);
            if (o == null) {
                o = RecordStore.openRecordStore((String)databaseName, (boolean)true);
                openedRMS.put(databaseName, o);
            }
            RecordStore rs = o;
            try {
                rs.setRecord(1, bytes, 0, l);
            }
            catch (InvalidRecordIDException e) {
                rs.addRecord(bytes, 0, l);
            }
        }
        catch (RecordStoreFullException e) {
            Util.critical((Exception)((Object)e), NO_RMS_MEMORY_TEXT);
        }
        catch (Exception e) {
            Util.critical(e, "WriteBytesToRMS name=" + databaseName + " " + l);
        }
    }

    public static String[] getNextValue(String string, char c) {
        int pozycjaString = 0;
        int pozycja = 0;
        int liczbaStringow = 0;
        while (pozycja != -1) {
            pozycjaString = pozycja = string.indexOf(c, pozycjaString + 1);
            ++liczbaStringow;
        }
        String[] tablica = new String[liczbaStringow];
        pozycjaString = -1;
        pozycja = 0;
        int numer = 0;
        while (pozycja != -1) {
            String s;
            pozycja = string.indexOf(c, pozycjaString + 1);
            if (pozycja == -1) {
                s = string.substring(pozycjaString + 1);
                tablica[numer] = s = Util.zostawOstatniaLinie(s);
            } else {
                s = string.substring(pozycjaString + 1, pozycja);
                s = Util.zostawOstatniaLinie(s);
                pozycjaString = pozycja;
                tablica[numer] = s;
            }
            ++numer;
        }
        return tablica;
    }

    public static String zostawOstatniaLinie(String str) {
        int pozycja = 0;
        int pozycjaString = -1;
        if (str == null) {
            return null;
        }
        while (pozycja != -1) {
            pozycja = str.indexOf(10, pozycjaString + 1);
            if (pozycja == -1) continue;
            pozycjaString = pozycja;
        }
        String s = pozycjaString == -1 ? str : str.substring(pozycjaString + 1);
        s.trim();
        return s;
    }

    public static int stringToInt(String str) {
        if (str == null) {
            return -1;
        }
        return Integer.parseInt(str);
    }

    public static int stringHexToInt(String str) {
        if (str == null) {
            return -1;
        }
        return Integer.parseInt(str, 16);
    }

    static {
        renderer = TextRenderer.getInstance();
        RANDOM = new Random(System.currentTimeMillis());
        errorOcurred = false;
        emptyTable = new byte[0];
        openedRMS = new Hashtable();
    }
}

