/*
 * Decompiled with CFR 0.152.
 */
package world;

import java.io.DataInputStream;
import root.Util;
import world.Tile;

public class Rozklad {
    public byte liczbaObiektow;
    public byte[] polozenieObiektuX;
    public byte[] polozenieObiektuY;
    public byte[] rodzajObiektu;
    public short[] wysokoscObiektu;

    public Rozklad(DataInputStream dis, int factor) {
        try {
            int liczba;
            this.liczbaObiektow = liczba = dis.readByte();
            this.polozenieObiektuX = new byte[liczba];
            this.polozenieObiektuY = new byte[liczba];
            this.rodzajObiektu = new byte[liczba];
            for (int j = 0; j < liczba; ++j) {
                this.polozenieObiektuX[j] = (byte)(dis.readByte() * factor >> 8);
                this.polozenieObiektuY[j] = (byte)(dis.readByte() * factor >> 8);
                this.rodzajObiektu[j] = dis.readByte();
            }
        }
        catch (Exception e) {
            Util.critical(e, "Rozklad");
        }
    }

    public Rozklad() {
        this.liczbaObiektow = 0;
    }

    public Rozklad(Tile tile, Rozklad rozklad) {
        this.liczbaObiektow = rozklad.liczbaObiektow;
        this.polozenieObiektuX = rozklad.polozenieObiektuX;
        this.polozenieObiektuY = rozklad.polozenieObiektuY;
        this.rodzajObiektu = rozklad.rodzajObiektu;
        this.wysokoscObiektu = new short[this.liczbaObiektow];
        for (int i = 0; i < this.liczbaObiektow; ++i) {
            this.wysokoscObiektu[i] = (short)tile.returnHeight(this.polozenieObiektuX[i], this.polozenieObiektuY[i]);
        }
    }
}

