/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.math;

import de.enough.polish.math.HTaylor;

public class HFloat {
    protected static final long lMax = 1000000000000000000L;
    protected static final int iMax = 1000000000;
    protected static final int iMin = 100000001;
    protected static final int eInt = 9;
    protected static final int eLong = 18;
    public static final HFloat PI = new HFloat("3.1415926535897931");
    public static final HFloat EUL = new HFloat("2.7182818284590451");
    public static final HFloat NaN = new HFloat("NaN");
    public int mant;
    public int expo;
    public boolean valid;
    protected static final int ASIN_HTAYLOR = 0;
    protected static final int ATAN_HTAYLOR = 1;
    protected static final int COS_HTAYLOR = 2;
    protected static final int EXP_HTAYLOR = 3;
    protected static final int LN_HTAYLOR = 4;
    protected static final int SIN_HTAYLOR = 5;

    public HFloat() {
        this.HFloatInit(0, 0, false);
    }

    public HFloat(HFloat orig) {
        this.HFloatInit(orig.mant, orig.expo, orig.valid);
    }

    public HFloat(int wertA) {
        this.HFloatInit(wertA, 0, true);
    }

    public HFloat(int wertA, int expoA) {
        this.HFloatInit(wertA, expoA, true);
    }

    public HFloat(String text) {
        if (text.toLowerCase().equals("nan")) {
            this.HFloatInit(0, 0, false);
        } else {
            int[] hilf = this.format(text);
            this.HFloatInit(hilf[0], hilf[1], true);
        }
    }

    public Integer toInteger() {
        int n;
        if (!this.valid) {
            return null;
        }
        int retval = this.mant;
        boolean rund = false;
        for (n = 0; n < this.expo; ++n) {
            retval *= 10;
        }
        for (n = 0; n > this.expo; --n) {
            if (retval % 10 != 0) {
                rund = true;
            }
            retval /= 10;
        }
        if (this.mant < 0 && rund) {
            --retval;
        }
        return new Integer(retval);
    }

    public String toString() {
        int expoA;
        if (!this.valid) {
            return "NaN";
        }
        int cmpI = this.cmp();
        if (cmpI == -1) {
            return "-" + this.neg().toString();
        }
        if (cmpI == 0) {
            expoA = 0;
        } else {
            expoA = -1;
            for (int wertA = this.abs(this.mant); wertA > 0; wertA /= 10) {
                ++expoA;
            }
        }
        String wertS = new Integer(this.mant).toString();
        for (int n = wertS.length(); n < 9; ++n) {
            wertS = wertS + "0";
        }
        return wertS.substring(0, 1) + "." + wertS.substring(1, 9) + "E" + new Integer(expoA + this.expo).toString();
    }

    public HFloat get() {
        return new HFloat(this);
    }

    public void set(HFloat orig) {
        this.HFloatInit(orig.mant, orig.expo, orig.valid);
    }

    public HFloat add(HFloat arg) {
        int wertR;
        if (!this.valid || !arg.valid) {
            return NaN;
        }
        if (this.cmp() == 0) {
            return arg.get();
        }
        if (arg.cmp() == 0) {
            return this.get();
        }
        int wertH = this.mant;
        int argWertH = arg.mant;
        int expoH = this.expo;
        int argExpoH = arg.expo;
        while (expoH < argExpoH) {
            ++expoH;
            wertH /= 10;
        }
        while (expoH > argExpoH) {
            ++argExpoH;
            argWertH /= 10;
        }
        int expoR = expoH;
        for (wertR = wertH + argWertH; wertR > 1000000000; wertR /= 10) {
            ++expoR;
        }
        return new HFloat(wertR, expoR);
    }

    public HFloat add(int arg) {
        return this.add(new HFloat(arg));
    }

    public HFloat add(String arg) {
        return this.add(new HFloat(arg));
    }

    public HFloat neg() {
        if (!this.valid) {
            return NaN;
        }
        return new HFloat(-this.mant, this.expo);
    }

    public HFloat sbt(HFloat arg) {
        return this.add(arg.neg());
    }

    public HFloat sbt(int arg) {
        return this.sbt(new HFloat(arg));
    }

    public HFloat sbt(String arg) {
        return this.sbt(new HFloat(arg));
    }

    public HFloat mlt(HFloat arg) {
        if (!this.valid || !arg.valid) {
            return NaN;
        }
        int[] hilf = this.format((long)this.mant * (long)arg.mant);
        return new HFloat(hilf[0], this.expo + arg.expo + hilf[1]);
    }

    public HFloat mlt(int arg) {
        return this.mlt(new HFloat(arg));
    }

    public HFloat mlt(String arg) {
        return this.mlt(new HFloat(arg));
    }

    public HFloat inv() {
        if (!this.valid || this.cmp() == 0) {
            return NaN;
        }
        int[] hilf = this.format(1000000000000000000L / (long)this.mant);
        return new HFloat(hilf[0], -this.expo - 18 + hilf[1]);
    }

    public HFloat div(HFloat arg) {
        return this.mlt(arg.inv());
    }

    public HFloat div(int arg) {
        return this.div(new HFloat(arg));
    }

    public HFloat div(String arg) {
        return this.div(new HFloat(arg));
    }

    public HFloat abs() {
        if (!this.valid) {
            return NaN;
        }
        if (this.mant < 0) {
            return new HFloat(-this.mant, this.expo);
        }
        return new HFloat(this.mant, this.expo);
    }

    public Integer cmp() {
        if (!this.valid) {
            return null;
        }
        if (this.mant == 0) {
            return new Integer(0);
        }
        if (this.mant > 0) {
            return new Integer(1);
        }
        return new Integer(-1);
    }

    public Integer cmp(HFloat arg) {
        return this.sbt(arg).cmp();
    }

    public Integer cmp(int arg) {
        return this.sbt(arg).cmp();
    }

    public Integer cmp(String arg) {
        return this.sbt(arg).cmp();
    }

    public Integer softCmp(HFloat tol, boolean strict) {
        if (!this.valid || !tol.valid) {
            return null;
        }
        int cmpVal = this.abs().cmp(tol);
        if (cmpVal == -1 || !strict && cmpVal != 1) {
            return new Integer(0);
        }
        return this.cmp();
    }

    public Integer softCmp(int tol, boolean strict) {
        return this.softCmp(new HFloat(tol), strict);
    }

    public Integer softCmp(String tol, boolean strict) {
        return this.softCmp(new HFloat(tol), strict);
    }

    public Integer softCmp(HFloat arg, HFloat tol, boolean strict) {
        return this.sbt(arg).softCmp(tol, strict);
    }

    public Integer softCmp(HFloat arg, int tol, boolean strict) {
        return this.sbt(arg).softCmp(tol, strict);
    }

    public Integer softCmp(HFloat arg, String tol, boolean strict) {
        return this.sbt(arg).softCmp(tol, strict);
    }

    public Integer softCmp(int arg, HFloat tol, boolean strict) {
        return this.sbt(arg).softCmp(tol, strict);
    }

    public Integer softCmp(int arg, int tol, boolean strict) {
        return this.sbt(arg).softCmp(tol, strict);
    }

    public Integer softCmp(int arg, String tol, boolean strict) {
        return this.sbt(arg).softCmp(tol, strict);
    }

    public Integer softCmp(String arg, HFloat tol, boolean strict) {
        return this.sbt(arg).softCmp(tol, strict);
    }

    public Integer softCmp(String arg, int tol, boolean strict) {
        return this.sbt(arg).softCmp(tol, strict);
    }

    public Integer softCmp(String arg, String tol, boolean strict) {
        return this.sbt(arg).softCmp(tol, strict);
    }

    public HFloat unFrac() {
        Integer i = this.toInteger();
        if (i == null) {
            return NaN;
        }
        return new HFloat(i);
    }

    public HFloat frac() {
        return this.sbt(this.unFrac());
    }

    public HFloat mod(HFloat arg) {
        return this.div(arg).frac().mlt(arg);
    }

    public HFloat mod(int arg) {
        return this.div(arg).frac().mlt(arg);
    }

    public HFloat mod(String arg) {
        return this.div(arg).frac().mlt(arg);
    }

    public HFloat quad() {
        return this.mlt(this);
    }

    public HFloat sqrt() {
        if (!this.valid) {
            return NaN;
        }
        int cmpInt = this.cmp();
        if (cmpInt == -1) {
            return this.neg().sqrt();
        }
        if (cmpInt == 0) {
            return new HFloat(0);
        }
        HFloat altRet = new HFloat(2);
        HFloat ret = new HFloat(1);
        HFloat arg = this.get();
        int mltMe = 0;
        while (arg.cmp(1) == 1) {
            ++mltMe;
            arg = arg.div(4);
        }
        while (ret.cmp(altRet) == -1) {
            altRet = ret;
            ret = arg.add(ret.quad()).div(ret).div(2);
        }
        for (int mltLauf = 0; mltLauf < mltMe; ++mltLauf) {
            ret = ret.mlt(2);
        }
        return ret;
    }

    public HFloat pow(HFloat arg) {
        if (!this.valid) {
            return NaN;
        }
        if (this.cmp() == 0) {
            return new HFloat(0);
        }
        return this.ln().mlt(arg).exp();
    }

    public HFloat pow(int arg) {
        return this.pow(new HFloat(arg));
    }

    public HFloat pow(String arg) {
        return this.pow(new HFloat(arg));
    }

    public HFloat exp() {
        if (!this.valid) {
            return NaN;
        }
        if (this.cmp() < 0) {
            return this.neg().exp().inv();
        }
        return this.taylor(new HFloatHTaylor(3));
    }

    public HFloat ln() {
        if (!this.valid) {
            return NaN;
        }
        int cmpInt = this.cmp();
        if (cmpInt == 0) {
            return NaN;
        }
        if (cmpInt == -1) {
            return this.neg().ln();
        }
        HFloat arg = this;
        HFloat zuKlein = new HFloat("0.5");
        HFloat zuGross = new HFloat("1.5");
        int addMe = 0;
        while (arg.cmp(zuKlein) == -1) {
            --addMe;
            arg = arg.mlt(EUL);
        }
        while (arg.cmp(zuGross) == 1) {
            ++addMe;
            arg = arg.div(EUL);
        }
        arg = arg.sbt(1);
        return arg.taylor(new HFloatHTaylor(4)).mlt(arg).add(addMe);
    }

    public HFloat sin() {
        if (!this.valid) {
            return NaN;
        }
        HFloat arg = this.mod(PI.mlt(2));
        if (arg.cmp(PI) > 0) {
            return arg.sbt(PI).sin().neg();
        }
        if (arg.cmp(PI.div(2)) > 0) {
            return PI.sbt(arg).sin();
        }
        return arg.quad().taylor(new HFloatHTaylor(5)).mlt(arg);
    }

    public HFloat cos() {
        if (!this.valid) {
            return NaN;
        }
        HFloat arg = this.mod(PI.mlt(2));
        if (arg.cmp(PI) > 0) {
            return arg.sbt(PI).cos().neg();
        }
        if (arg.cmp(PI.div(2)) > 0) {
            return PI.sbt(arg).cos().neg();
        }
        return arg.quad().taylor(new HFloatHTaylor(2));
    }

    public HFloat tan() {
        return this.sin().div(this.cos());
    }

    public HFloat cot() {
        return this.cos().div(this.sin());
    }

    public HFloat asin() {
        if (!this.valid) {
            return NaN;
        }
        if (this.softCmp(0, 1, false) != 0) {
            return NaN;
        }
        if (this.cmp() < 0) {
            return this.neg().asin().neg();
        }
        if (this.cmp("0.71") > 0) {
            return new HFloat(1).sbt(this.quad()).sqrt().acos();
        }
        return this.mlt(this.quad().taylor(new HFloatHTaylor(0)));
    }

    public HFloat acos() {
        return PI.div(2).sbt(this.asin());
    }

    public HFloat atan() {
        if (!this.valid) {
            return NaN;
        }
        if (this.cmp() < 0) {
            return this.neg().atan().neg();
        }
        if (this.cmp(1) > 0) {
            return PI.div(2).sbt(this.acot());
        }
        if (this.cmp("0.5") > 0) {
            return this.sbt(1).div(this.add(1)).atan().add(PI.div(4));
        }
        return this.mlt(this.quad().taylor(new HFloatHTaylor(1)));
    }

    public HFloat acot() {
        return this.inv().atan();
    }

    public HFloat sinh() {
        return this.exp().sbt(this.neg().exp()).div(2);
    }

    public HFloat cosh() {
        return this.exp().add(this.neg().exp()).div(2);
    }

    public HFloat tanh() {
        return this.sinh().div(this.cosh());
    }

    public HFloat coth() {
        return this.cosh().div(this.sinh());
    }

    public HFloat asinh() {
        return this.add(this.quad().add(1).sqrt()).ln();
    }

    public HFloat acosh() {
        return this.add(this.quad().sbt(1).sqrt()).ln();
    }

    public HFloat atanh() {
        return this.add(1).div(this.sbt(1)).ln().div(2);
    }

    public HFloat acoth() {
        return this.add(1).div(this.sbt(1)).ln().div(2);
    }

    protected void HFloatInit(int wertA, int expoA, boolean validA) {
        this.mant = wertA;
        this.expo = expoA;
        this.valid = validA;
        this.norm();
    }

    protected int[] format(long arg) {
        int[] retval = new int[2];
        int expoR = 0;
        long wertR = arg;
        while (this.abs(wertR) > 1000000000L) {
            ++expoR;
            wertR /= 10L;
        }
        retval[0] = (int)wertR;
        retval[1] = expoR;
        return retval;
    }

    protected int integerParseInt(String text) {
        int retval = 0;
        for (int n = 0; n < text.length(); ++n) {
            retval = 10 * retval + "0123456789".indexOf(text.charAt(n));
        }
        return retval;
    }

    protected String[] fuehrende(String text, char zch0, boolean auch) {
        String[] ret = new String[2];
        StringBuffer[] retBuf = new StringBuffer[2];
        boolean habe = false;
        retBuf[0] = new StringBuffer();
        retBuf[1] = new StringBuffer();
        for (int wo = 0; wo < text.length(); ++wo) {
            char zch1 = text.charAt(wo);
            if (zch0 == zch1) {
                if (habe) {
                    if (!auch) continue;
                    retBuf[0].append(zch1);
                    continue;
                }
                retBuf[1].append(zch1);
                continue;
            }
            habe = true;
            retBuf[0].append(zch1);
        }
        ret[0] = retBuf[0].toString();
        ret[1] = retBuf[1].toString();
        return ret;
    }

    protected String[] stringSplit2(String text, char pat) {
        String[] ret = new String[2];
        StringBuffer[] retBuf = new StringBuffer[2];
        int habe = 0;
        retBuf[0] = new StringBuffer();
        retBuf[1] = new StringBuffer();
        for (int wo = 0; wo < text.length(); ++wo) {
            char zch = text.charAt(wo);
            if (zch == pat) {
                ++habe;
                continue;
            }
            if (habe >= 2) continue;
            retBuf[habe].append(zch);
        }
        ret[0] = retBuf[0].toString();
        ret[1] = retBuf[1].toString();
        return ret;
    }

    protected int[] format(String text) {
        int mantExpo;
        String mantStr;
        int[] retval = new int[2];
        String[] vorNach = new String[2];
        StringBuffer sb = new StringBuffer();
        for (int wo = 0; wo < text.length(); ++wo) {
            char zch = text.charAt(wo);
            if ("0123456789e.-".indexOf(zch) == -1) {
                if (zch == 'E') {
                    sb.append('e');
                }
                if (zch != ',') continue;
                sb.append('.');
                continue;
            }
            sb.append(zch);
        }
        text = sb.toString();
        vorNach = this.stringSplit2(text, 'e');
        String strVorE = vorNach[0];
        String strNachE = vorNach[1];
        vorNach = this.fuehrende(strVorE, '-', false);
        String strMant = this.fuehrende(vorNach[0], '0', true)[0];
        int sgnMant = 1 - 2 * (vorNach[1].length() % 2);
        vorNach = this.stringSplit2(strMant, '.');
        String strMantVorKomma = vorNach[0];
        String strMantNachKomma = vorNach[1];
        vorNach = this.fuehrende(strNachE, '-', false);
        String strExpo = this.fuehrende(vorNach[0], '0', true)[0];
        int sgnExpo = 1 - 2 * (vorNach[1].length() % 2);
        String strExpoVorKomma = this.stringSplit2(strExpo, '.')[0];
        if ("".equals(strMantVorKomma)) {
            vorNach = this.fuehrende(strMantNachKomma, '0', true);
            mantStr = vorNach[0];
            mantExpo = -vorNach[1].length();
        } else {
            mantStr = strMantVorKomma + strMantNachKomma;
            mantExpo = strMantVorKomma.length();
        }
        for (int n = 0; n < 9; ++n) {
            mantStr = mantStr + '0';
        }
        mantStr = mantStr.substring(0, 9);
        int localMant = sgnMant * this.integerParseInt(mantStr);
        int localExpo = sgnExpo * this.integerParseInt(strExpoVorKomma) + mantExpo - 9;
        retval[0] = localMant;
        retval[1] = localExpo;
        return retval;
    }

    protected void norm() {
        if (this.mant == 0) {
            this.expo = 0;
        } else {
            while (this.abs(this.mant) < 100000001) {
                --this.expo;
                this.mant *= 10;
            }
        }
    }

    protected int abs(int i) {
        if (i < 0) {
            return -i;
        }
        return i;
    }

    protected long abs(long i) {
        if (i < 0L) {
            return -i;
        }
        return i;
    }

    public HFloat taylor(HTaylor hTaylor) {
        if (!this.valid) {
            return NaN;
        }
        HFloat summe = new HFloat(0);
        HFloat xN = new HFloat(1);
        int index = 0;
        while (true) {
            HFloat altSumme = summe;
            summe = summe.add(xN.mlt(hTaylor.coeff(index)));
            xN = xN.mlt(this);
            if (summe.cmp(altSumme) == 0) {
                return summe;
            }
            ++index;
        }
    }

    public static HFloat[] polByCrt(HFloat xP, HFloat yP) {
        HFloat[] retval = new HFloat[2];
        HFloat phi = new HFloat();
        HFloat radi = new HFloat();
        if (xP.valid && yP.valid) {
            radi = xP.quad().add(yP.quad()).sqrt();
            int xCmp = xP.cmp();
            int yCmp = yP.cmp();
            switch (xCmp) {
                case 1: {
                    phi = yP.div(xP).atan();
                    break;
                }
                case 0: {
                    phi = PI.div(2).mlt(yCmp);
                    break;
                }
                case -1: {
                    phi = yP.div(xP).atan();
                    phi = phi.add(PI.mlt(-phi.cmp().intValue()));
                }
            }
        }
        retval[0] = phi;
        retval[1] = radi;
        return retval;
    }

    public static HFloat[] crtByPol(HFloat phi, HFloat radi) {
        HFloat[] retval = new HFloat[2];
        HFloat xP = new HFloat();
        HFloat yP = new HFloat();
        if (phi.valid && radi.valid) {
            xP = radi.mlt(phi.cos());
            yP = radi.mlt(phi.sin());
        }
        retval[0] = xP;
        retval[1] = yP;
        return retval;
    }

    public static HFloat[] sphByCrt(HFloat xP, HFloat yP, HFloat zP) {
        HFloat[] retval = new HFloat[3];
        HFloat bet = new HFloat();
        HFloat lam = new HFloat();
        HFloat radi = new HFloat();
        if (xP.valid && yP.valid && zP.valid) {
            HFloat[] pbcXY = HFloat.polByCrt(xP, yP);
            HFloat[] pbcXYZ = HFloat.polByCrt(pbcXY[1], zP);
            lam = pbcXY[0];
            bet = pbcXYZ[0];
            radi = pbcXYZ[1];
        }
        retval[0] = bet;
        retval[1] = lam;
        retval[2] = radi;
        return retval;
    }

    public static HFloat[] crtBySph(HFloat bet, HFloat lam, HFloat radi) {
        HFloat[] retval = new HFloat[3];
        HFloat xP = new HFloat();
        HFloat yP = new HFloat();
        HFloat zP = new HFloat();
        if (bet.valid && lam.valid && radi.valid) {
            HFloat radiCosBet = radi.mlt(bet.cos());
            xP = radiCosBet.mlt(lam.cos());
            yP = radiCosBet.mlt(lam.sin());
            zP = radi.mlt(bet.sin());
        }
        retval[0] = xP;
        retval[1] = yP;
        retval[2] = zP;
        return retval;
    }

    protected class HFloatHTaylor
    implements HTaylor {
        protected int werBinIchP;
        protected int altN;
        protected HFloat altCoeff;

        public HFloatHTaylor() {
            this.init(-1);
        }

        public HFloatHTaylor(int werBinIchP) {
            this.init(werBinIchP);
        }

        protected void init(int werBinIchA) {
            this.werBinIchP = werBinIchA;
            this.altN = 0;
            this.altCoeff = new HFloat(1);
        }

        public HFloat coeff(int n) {
            switch (this.werBinIchP) {
                case 0: {
                    if (n < this.altN) {
                        this.init(this.werBinIchP);
                    }
                    for (int m = this.altN + 1; m <= n; ++m) {
                        int m2 = 2 * m;
                        this.altCoeff = this.altCoeff.mlt(m2 - 1).div(m2);
                    }
                    this.altN = n;
                    return this.altCoeff.div(2 * n + 1);
                }
                case 1: {
                    if (n % 2 == 0) {
                        return new HFloat(1).div(2 * n + 1);
                    }
                    return new HFloat(-1).div(2 * n + 1);
                }
                case 2: {
                    if (n < this.altN) {
                        this.init(this.werBinIchP);
                    }
                    for (int m = this.altN + 1; m <= n; ++m) {
                        int m2 = 2 * m;
                        this.altCoeff = this.altCoeff.div(m2 * (1 - m2));
                    }
                    this.altN = n;
                    return this.altCoeff;
                }
                case 3: {
                    if (n < this.altN) {
                        this.init(this.werBinIchP);
                    }
                    for (int m = this.altN + 1; m <= n; ++m) {
                        this.altCoeff = this.altCoeff.div(m);
                    }
                    this.altN = n;
                    return this.altCoeff;
                }
                case 4: {
                    if (n % 2 == 0) {
                        return new HFloat(1).div(n + 1);
                    }
                    return new HFloat(-1).div(n + 1);
                }
                case 5: {
                    if (n < this.altN) {
                        this.init(this.werBinIchP);
                    }
                    for (int m = this.altN + 1; m <= n; ++m) {
                        int m2 = 2 * m;
                        this.altCoeff = this.altCoeff.div(-m2 * (1 + m2));
                    }
                    this.altN = n;
                    return this.altCoeff;
                }
            }
            return new HFloat();
        }
    }
}

