/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.AccessibleCanvas;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class MasterCanvas
extends Canvas {
    public static MasterCanvas instance;
    protected AccessibleCanvas currentCanvas;
    protected Displayable currentDisplayable;

    private MasterCanvas() {
        this.setFullScreenMode(true);
    }

    protected void hideNotify() {
        if (this.currentCanvas != null) {
            this.currentCanvas.hideNotify();
        }
    }

    protected void showNotify() {
        if (this.currentCanvas != null) {
            this.currentCanvas.showNotify();
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.currentCanvas != null) {
            this.currentCanvas.keyPressed(keyCode);
        }
    }

    protected void keyRepeated(int keyCode) {
        if (this.currentCanvas != null) {
            this.currentCanvas.keyRepeated(keyCode);
        }
    }

    protected void keyReleased(int keyCode) {
        this.currentCanvas.keyReleased(keyCode);
    }

    protected void sizeChanged(int width, int height) {
        if (this.currentCanvas != null) {
            this.currentCanvas.sizeChanged(width, height);
        }
    }

    protected void paint(Graphics g2) {
        if (this.currentCanvas != null) {
            this.currentCanvas.paint(g2);
        }
    }

    public static void setCurrent(Display display, Displayable nextDisplayable) {
        if (nextDisplayable == null) {
            display.setCurrent(null);
            return;
        }
        if (!(nextDisplayable instanceof AccessibleCanvas)) {
            if (instance != null && MasterCanvas.instance.currentCanvas != null && MasterCanvas.instance.currentDisplayable != nextDisplayable) {
                MasterCanvas.instance.currentCanvas.hideNotify();
                MasterCanvas.instance.currentCanvas = null;
                MasterCanvas.instance.currentDisplayable = null;
            }
            display.setCurrent(nextDisplayable);
            return;
        }
        AccessibleCanvas oldCanvas = null;
        if (instance == null) {
            instance = new MasterCanvas();
        } else {
            oldCanvas = MasterCanvas.instance.currentCanvas;
        }
        AccessibleCanvas canvas = (AccessibleCanvas)nextDisplayable;
        canvas.showNotify();
        MasterCanvas.instance.currentCanvas = canvas;
        MasterCanvas.instance.currentDisplayable = nextDisplayable;
        if (oldCanvas != null) {
            oldCanvas.hideNotify();
        }
        if (!instance.isShown()) {
            display.setCurrent((Displayable)instance);
        } else {
            instance.repaint();
        }
    }

    public static Displayable getCurrent(Display display) {
        if (instance != null) {
            return MasterCanvas.instance.currentDisplayable;
        }
        return display.getCurrent();
    }

    public static void repaintAccessibleCanvas(AccessibleCanvas canvas) {
        if (canvas == null) {
            return;
        }
        if (instance != null) {
            instance.repaint();
        } else {
            ((Canvas)canvas).repaint();
        }
    }

    public static void repaintCanvas(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        if (!(canvas instanceof AccessibleCanvas)) {
            canvas.repaint();
        } else if (instance != null) {
            instance.repaint();
        } else {
            canvas.repaint();
        }
    }

    public static boolean isAccessibleCanvasShown(AccessibleCanvas canvas) {
        if (instance != null) {
            return canvas == MasterCanvas.instance.currentCanvas;
        }
        return ((Canvas)canvas).isShown();
    }

    public static boolean isCanvasShown(Canvas canvas) {
        if (instance != null && instance.isShown()) {
            return canvas == MasterCanvas.instance.currentDisplayable;
        }
        return canvas.isShown();
    }

    public static boolean isDisplayableShown(Displayable displayable) {
        if (instance != null && instance.isShown()) {
            return displayable == MasterCanvas.instance.currentDisplayable;
        }
        return displayable.isShown();
    }
}

