/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class Scj {
    static final byte[] PngSig = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    static final byte[] IEND = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    static byte[] PLTE;
    static byte[] tRNS;
    static int[] crc_table;
    static final int NMAX = 5552;
    static final int BASE = 65521;
    static int m_width;
    static int m_height;
    static final int FLIP_NONE = 0;
    static final int FLIP_HORIZONTAL = 1;
    static final int FLIP_VERTICAL = 2;
    static final int FLIP_COMPLEX = 3;
    static final int ROTATE_90 = 4;
    static final int ROTATE_180 = 5;
    static final int ROTATE_270 = 6;

    static int update_crc(int n, byte[] byArray, int n2, int n3) {
        int n4 = n;
        int n5 = 0;
        while (n5 < n3) {
            n4 = crc_table[(n4 ^ byArray[n2 + n5]) & 0xFF] ^ n4 >>> 8;
            ++n5;
        }
        return n4;
    }

    public Scj(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        PLTE = new byte[780];
        System.arraycopy(byArray, 0, PLTE, 0, 780);
        tRNS = new byte[268];
        System.arraycopy(byArray2, 0, tRNS, 0, 268);
        crc_table = new int[256];
        int n = 0;
        while (n < 256) {
            Scj.crc_table[n] = (byArray3[n * 4 + 3] & 0xFF) << 24 | (byArray3[n * 4 + 2] & 0xFF) << 16 | (byArray3[n * 4 + 1] & 0xFF) << 8 | byArray3[n * 4] & 0xFF;
            ++n;
        }
    }

    static int crc(byte[] byArray, int n, int n2) {
        return ~Scj.update_crc(-1, byArray, n, n2);
    }

    static long adler32(long l, byte[] byArray, int n, int n2) {
        long l2 = l & 0xFFFFL;
        long l3 = l >> 16 & 0xFFFFL;
        int n3 = n;
        while (n2 > 0) {
            int n4 = n2 < 5552 ? n2 : 5552;
            n2 -= n4;
            while (n4 >= 16) {
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                n4 -= 16;
            }
            if (n4 != 0) {
                do {
                    l3 += (l2 += (long)(byArray[n3++] & 0xFF));
                } while (--n4 != 0);
            }
            l2 %= 65521L;
            l3 %= 65521L;
        }
        return l3 << 16 | l2;
    }

    void makeCrc(byte[] byArray) {
        int n = 1;
        int n2 = 15;
        byte[] byArray2 = null;
        n = (int)Scj.adler32(n, byArray, n2, (m_width + 1) * m_height);
        byArray2 = Scj.intToBytes(n);
        System.arraycopy(byArray2, 0, byArray, (m_width + 1) * m_height + n2, 4);
        n = Scj.crc(byArray, 4, (m_width + 1) * m_height + n2);
        byArray2 = Scj.intToBytes(n);
        System.arraycopy(byArray2, 0, byArray, (m_width + 1) * m_height + n2 + 4, 4);
    }

    byte[] rotateIDAT(byte[] byArray, int n) {
        byte[] byArray2 = null;
        int n2 = 15;
        if (n != 5) {
            int n3 = m_width;
            m_width = m_height;
            m_height = n3;
        }
        byArray2 = new byte[(m_width + 1) * m_height + 23];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        if (n == 4) {
            int n4 = 0;
            while (n4 < m_height) {
                byArray2[n2 + n4 * (Scj.m_width + 1)] = 0;
                int n5 = 0;
                while (n5 < m_width) {
                    byArray2[n2 + n4 * (Scj.m_width + 1) + n5 + 1] = byArray[n2 + n5 * (m_height + 1) + m_height - n4];
                    ++n5;
                }
                ++n4;
            }
        } else if (n == 5) {
            int n6 = 0;
            while (n6 < m_height) {
                byArray2[n2 + n6 * (Scj.m_width + 1)] = 0;
                int n7 = 0;
                while (n7 < m_width) {
                    byArray2[n2 + n6 * (Scj.m_width + 1) + n7 + 1] = byArray[n2 + (m_height - 1 - n6) * (m_width + 1) + m_width - n7];
                    ++n7;
                }
                ++n6;
            }
        } else if (n == 6) {
            int n8 = 0;
            while (n8 < m_height) {
                byArray2[n2 + n8 * (Scj.m_width + 1)] = 0;
                int n9 = 0;
                while (n9 < m_width) {
                    byArray2[n2 + n8 * (Scj.m_width + 1) + n9 + 1] = byArray[n2 + (m_width - 1 - n9) * (m_height + 1) + 1 + n8];
                    ++n9;
                }
                ++n8;
            }
        } else {
            return null;
        }
        this.makeCrc(byArray2);
        return byArray2;
    }

    byte[] flipIDAT(byte[] byArray, int n) {
        byte[] byArray2 = null;
        int n2 = 15;
        byArray2 = new byte[(m_width + 1) * m_height + 23];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        if (n == 1) {
            int n3 = 0;
            while (n3 < m_height) {
                int n4 = 0;
                while (n4 < m_width) {
                    byArray2[n2 + n3 * (Scj.m_width + 1) + n4 + 1] = byArray[n2 + n3 * (m_width + 1) + (m_width - n4)];
                    ++n4;
                }
                ++n3;
            }
        } else if (n == 2) {
            int n5 = 0;
            while (n5 < m_height) {
                int n6 = 0;
                while (n6 < m_width) {
                    byArray2[n2 + n5 * (Scj.m_width + 1) + n6 + 1] = byArray[n2 + (m_height - 1 - n5) * (m_width + 1) + n6 + 1];
                    ++n6;
                }
                ++n5;
            }
        } else if (n == 3) {
            int n7;
            int n8 = 0;
            while (n8 < m_height) {
                n7 = 0;
                while (n7 < m_width) {
                    byArray2[n2 + n8 * (Scj.m_width + 1) + n7 + 1] = byArray[n2 + n8 * (m_width + 1) + (m_width - n7)];
                    ++n7;
                }
                ++n8;
            }
            n8 = 0;
            while (n8 < m_height) {
                n7 = 0;
                while (n7 < m_width) {
                    byArray2[n2 + n8 * (Scj.m_width + 1) + n7 + 1] = byArray[n2 + (m_height - 1 - n8) * (m_width + 1) + n7 + 1];
                    ++n7;
                }
                ++n8;
            }
        } else {
            return null;
        }
        this.makeCrc(byArray2);
        return byArray2;
    }

    byte[] zoomIDAT(byte[] byArray, int n) {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = new byte[15];
        byte[] byArray5 = new byte[7];
        int n2 = 15;
        if ((m_width * n + 1) * m_height * n + 7 > 32768) {
            return null;
        }
        byArray2 = new byte[(m_width * n + 1) * m_height * n + 23];
        byArray3 = Scj.intToBytes((m_width * n + 1) * m_height * n + 11);
        System.arraycopy(byArray3, 0, byArray2, 0, 4);
        System.arraycopy(byArray, 4, byArray2, 4, 4);
        int n3 = (m_width * n + 1) * m_height * n;
        int n4 = ~n3;
        byArray5[0] = 120;
        byArray5[1] = 1;
        byArray5[2] = 1;
        byArray5[3] = (byte)(n3 & 0xFF);
        byArray5[4] = (byte)((n3 & 0xFF00) >> 8);
        byArray5[5] = (byte)(n4 & 0xFF);
        byArray5[6] = (byte)((n4 & 0xFF00) >> 8);
        System.arraycopy(byArray5, 0, byArray2, 8, 7);
        int n5 = 0;
        while (n5 < m_height) {
            int n6 = 0;
            while (n6 < n) {
                byArray2[n2 + (Scj.m_width * n + 1) * (n5 * n + n6)] = 0;
                ++n6;
            }
            int n7 = 0;
            while (n7 < m_width) {
                byte by = byArray[n2 + (m_width + 1) * n5 + n7 + 1];
                n6 = 0;
                while (n6 < n) {
                    int n8 = 0;
                    while (n8 < n) {
                        byArray2[n2 + (Scj.m_width * n + 1) * (n5 * n + n6) + n7 * n + n8 + 1] = by;
                        ++n8;
                    }
                    ++n6;
                }
                ++n7;
            }
            ++n5;
        }
        m_width *= n;
        m_height *= n;
        this.makeCrc(byArray2);
        return byArray2;
    }

    byte[] makeIDAT(String string, int n, int n2) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = new byte[15];
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            inputStream.read(byArray4, 0, 6);
            if (byArray4[0] != 83 || byArray4[1] != 74) {
                return null;
            }
            m_width = Scj.byteToInt16(byArray4, 2);
            if ((m_width + 1) * (m_height = Scj.byteToInt16(byArray4, 4)) + 7 > 32768) {
                inputStream.close();
                return null;
            }
            byArray = new byte[(m_width + 1) * m_height + 23];
            inputStream.read(byArray, 0, (m_width + 1) * m_height + 23);
            inputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        if (n > 0 || n2 > 1) {
            if (n > 0) {
                byArray2 = n <= 3 ? this.flipIDAT(byArray, n) : this.rotateIDAT(byArray, n);
                byArray = null;
                if (n2 > 1) {
                    byArray3 = this.zoomIDAT(byArray2, n2);
                    byArray2 = null;
                    return byArray3;
                }
                return byArray2;
            }
            if (n2 > 1) {
                byArray2 = this.zoomIDAT(byArray, n2);
                byArray = null;
                return byArray2;
            }
            return byArray;
        }
        return byArray;
    }

    private static int byteToInt16(byte[] byArray, int n) {
        return (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    private static byte[] intToBytes(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >>> 24), (byte)((n & 0xFF0000) >>> 16), (byte)((n & 0xFF00) >>> 8), (byte)(n & 0xFF)};
        return byArray;
    }

    static byte[] makeIHDR() {
        byte[] byArray = new byte[25];
        byte[] byArray2 = null;
        byArray2 = Scj.intToBytes(13);
        System.arraycopy(byArray2, 0, byArray, 0, 4);
        byArray[4] = 73;
        byArray[5] = 72;
        byArray[6] = 68;
        byArray[7] = 82;
        byArray2 = Scj.intToBytes(m_width);
        System.arraycopy(byArray2, 0, byArray, 8, 4);
        byArray2 = Scj.intToBytes(m_height);
        System.arraycopy(byArray2, 0, byArray, 12, 4);
        byArray[16] = 8;
        byArray[17] = 3;
        byArray[18] = 0;
        byArray[19] = 0;
        byArray[20] = 0;
        int n = Scj.crc(byArray, 4, 17);
        byArray2 = Scj.intToBytes(n);
        System.arraycopy(byArray2, 0, byArray, 21, 4);
        return byArray;
    }

    public Image createImage(byte[] byArray, byte[] byArray2) {
        Image image;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        int n = (m_width + 1) * m_height;
        byArray3 = new byte[n + 1116];
        System.arraycopy(PngSig, 0, byArray3, 0, 8);
        byArray4 = Scj.makeIHDR();
        System.arraycopy(byArray4, 0, byArray3, 8, 25);
        byArray4 = null;
        System.arraycopy(byArray2, 0, byArray3, 33, 780);
        System.arraycopy(tRNS, 0, byArray3, 813, 268);
        System.arraycopy(byArray, 0, byArray3, 1081, n + 23);
        byArray = null;
        System.arraycopy(IEND, 0, byArray3, n + 1104, 12);
        try {
            image = Image.createImage((byte[])byArray3, (int)0, (int)byArray3.length);
        }
        catch (Exception exception) {
            return null;
        }
        byArray3 = null;
        System.gc();
        return image;
    }

    public Image createImage(String string, byte[] byArray, int n, int n2) {
        byte[] byArray2 = null;
        byArray2 = this.makeIDAT(string, n, n2);
        System.gc();
        if (byArray2 == null) {
            return null;
        }
        return this.createImage(byArray2, byArray);
    }

    public void setIDAT(byte[] byArray) {
        m_width = Scj.byteToInt16(byArray, 2);
        m_height = Scj.byteToInt16(byArray, 4);
    }

    public byte[] makeIDAT(String string) {
        return this.makeIDAT(string, 0, 1);
    }

    public Image createImage(byte[] byArray) {
        return this.createImage(byArray, PLTE);
    }

    public Image createImage(String string, int n, int n2) {
        return this.createImage(string, PLTE, n, n2);
    }

    public Image createImage(String string) {
        return this.createImage(string, PLTE, 0, 1);
    }

    public Image createImage(String string, int n) {
        return this.createImage(string, PLTE, n, 1);
    }
}

