/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class Animation {
    static final int EXPLOSION_SHIP = 0;
    static final int EXPLOSION_MISSILE = 1;
    static final int DAMAGE = 2;
    static final int[][] animationData = new int[][]{{19, 0, 1, 2, 3}, {20, 0, 1, 2, 3}};
    int x;
    int y;
    int id;
    int currentFrame;
    int maxFrame;
    int[] data;
    Object pData;

    Animation(int n, int n2, int n3, Object object) {
        this.id = n;
        this.x = n2;
        this.y = n3;
        this.pData = object;
        switch (n) {
            case 0: 
            case 1: {
                Target.startVibration();
                this.data = animationData[n];
                this.currentFrame = 1;
                this.maxFrame = this.data.length;
                break;
            }
            case 2: {
                this.currentFrame = 0;
                this.maxFrame = Const.SCREEN_HEIGHT / 4;
            }
        }
    }

    public void draw(Graphics graphics) {
        switch (this.id) {
            case 0: 
            case 1: {
                Form.drawImageFrame(graphics, this.data[0], this.data[this.currentFrame], this.x, this.y, 3);
                break;
            }
            case 2: {
                String string = (String)this.pData;
                Font font = graphics.getFont();
                int n = font.stringWidth(string);
                graphics.setColor(240 - this.currentFrame * 176 / this.maxFrame, 0, 0);
                int n2 = this.x - n / 2;
                if (n2 < 0) {
                    n2 = 1;
                }
                if (n2 + n > GameLogic.gameWidth) {
                    n2 = GameLogic.gameWidth - 1 - n;
                }
                graphics.drawString(string, n2, this.y, 36);
            }
        }
    }

    public boolean tick() {
        boolean bl;
        boolean bl2 = bl = ++this.currentFrame >= this.maxFrame;
        if (!bl) {
            switch (this.id) {
                case 2: {
                    bl = --this.y < 0;
                }
            }
        }
        return bl;
    }
}

