/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Form {
    String[] data;
    String[] strHeader;
    String[] strButton;
    int viewStart;
    int viewLinesAmount;
    int totalLines;
    boolean fullScreen = true;
    boolean vCenter = true;
    boolean reload;
    static long prevFrameTime;
    static long prevLampTime;
    int currentLamp;
    int maxLamps;
    static final int REDRAW_NONE = 0;
    static final int REDRAW_BODY = 1;
    static final int REDRAW_BUTTONS = 2;
    static final int REDRAW_ALL = -1;
    boolean useDB;
    static Image imgBkg;
    static Graphics imgBkgGraphics;
    static int[][] bkgMap;
    int buttonHeight;
    int repaintState = -1;
    int yLampShift;
    int colorButtonFrg = 15358222;
    int actualBH;
    int buttonSlideY;
    long resetSlidingTime;
    static Random rnd;
    static final int[] sin_table;
    public static int[] resTable;
    public static byte[] resData;
    private static Image[] imageArray;

    public Form() {
        this.setup();
        this.fullScreen = false;
    }

    public Form(int n, int n2) {
        this(App.getString(n), App.getString(n2));
    }

    public Form(String string, String string2) {
        this.setButton(15, -1);
        this.setHeader(string);
        this.setText(string2);
    }

    public void reset() {
        this.viewStart = 0;
        this.currentLamp = 0;
        this.repaint();
    }

    String getButton(int n) {
        return this.strButton[n];
    }

    boolean existButton(int n) {
        String string = this.getButton(n);
        return string != null && string.length() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tick() {
        if (App.SM.currentTime > prevFrameTime + 25L) {
            this.slidingTick();
            prevFrameTime = App.SM.currentTime;
            App.SM.redraw();
        }
        if (App.SM.currentTime > prevLampTime + 200L && this.maxLamps > 0) {
            prevLampTime = App.SM.currentTime;
            this.currentLamp = (this.currentLamp + 1) % this.maxLamps;
            App.SM.redraw();
        }
        if (this.repaintState != 0) {
            Image image = imgBkg;
            synchronized (image) {
                imgBkgGraphics.translate(-imgBkgGraphics.getTranslateX(), -imgBkgGraphics.getTranslateY());
                this.draw(imgBkgGraphics);
            }
            App.SM.redraw();
            this.repaintState = 0;
        }
    }

    boolean keyAction(int n) {
        boolean bl = false;
        switch (n) {
            case 1: {
                if (this.viewStart <= 0) break;
                --this.viewStart;
                bl = true;
                break;
            }
            case 6: {
                if (this.viewStart + this.viewLinesAmount >= this.totalLines) break;
                ++this.viewStart;
                bl = true;
            }
        }
        if (bl) {
            this.repaint(3);
        }
        return bl;
    }

    int[][] generateBackgroundMap(boolean bl) {
        int n;
        int n2;
        int n3 = Form.getFrameHeight(21);
        int[][] nArray = new int[(Const.SCREEN_WIDTH + n3 - 1) / n3][(Const.SCREEN_HEIGHT + n3 - 1) / n3];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            for (n = 0; n < nArray[0].length; ++n) {
                nArray[n2][n] = -1;
            }
        }
        if (bl) {
            n2 = nArray.length - 1;
            n = nArray[0].length - 1;
            nArray[n2][n] = 12;
            if (n2 > 0) {
                nArray[n2 - 1][n] = -2;
            }
            if (n > 0) {
                nArray[n2][n - 1] = -2;
            }
            if (n > 1) {
                nArray[n2][n - 2] = -2;
            }
        }
        for (n2 = nArray[0].length - 1; n2 >= 0; --n2) {
            for (n = nArray.length - 1; n >= 0; --n) {
                if (nArray[n][n2] != -1) continue;
                int n4 = 21;
                int n5 = Form.random(Form.getFrameInfo(21, 0));
                if (Form.percent(25) && n > 0 && nArray[n - 1][n2] == -1) {
                    n4 = 11;
                    n5 = Form.random(Form.getFrameInfo(n4, 1));
                } else if (Form.percent(25) && n > 0 && n2 > 2) {
                    n4 = 12;
                    n5 = 0;
                }
                nArray[n][n2] = n4 | n5 << 8;
                if (n4 == 11 && n > 0) {
                    nArray[n - 1][n2] = -2;
                    continue;
                }
                if (n4 != 12) continue;
                nArray[n - 1][n2] = -2;
                nArray[n][n2 - 1] = -2;
                nArray[n][n2 - 2] = -2;
            }
        }
        return nArray;
    }

    void setup() {
        this.viewLinesAmount = this.getMaxTextHeight() / this.getLineHeight(DefaultDefines.fontText);
        if (imgBkg == null) {
            imgBkg = Image.createImage((int)Const.SCREEN_WIDTH, (int)Const.SCREEN_HEIGHT);
            imgBkgGraphics = imgBkg.getGraphics();
        }
        this.initLamps();
    }

    void initLamps() {
        int n = this.getTopY();
        int n2 = Const.SCREEN_HEIGHT - this.buttonHeight - n;
        int n3 = Form.getFrameWidth(13);
        int n4 = Form.getFrameHeight(13);
        this.maxLamps = n2 / (3 * n4);
        this.yLampShift = n + (n2 - (this.maxLamps - 1) * 3 * n4 - 2 * n4) / 2;
    }

    void setButton(int n, int n2) {
        this.setButton(App.getString(n), App.getString(n2));
    }

    void setButton(String string, String string2) {
        if (this.strButton == null) {
            this.strButton = new String[2];
        }
        this.strButton[0] = string;
        this.strButton[1] = string2;
        this.buttonHeight = this.strButton[0] == null && this.strButton[1] == null ? 0 : DefaultDefines.fontButton.getHeight() + 4;
        this.repaint();
        this.resetSliding();
    }

    void setHeader(int n) {
        this.setHeader(App.getString(n));
    }

    void setHeader(String string) {
        this.strHeader = Form.splitInLines(string, DefaultDefines.fontHeader, this.getMaxTextWidth());
    }

    void setText(int n) {
        this.setText(App.getString(n));
    }

    void setText(String string) {
        this.data = Form.splitInLines(string, DefaultDefines.fontText, this.getMaxTextWidth() - 8);
        this.totalLines = this.data != null ? this.data.length : 0;
        this.setup();
        this.repaint();
    }

    int getMaxTextWidth() {
        return Const.SCREEN_WIDTH - 2 * (Form.getFrameWidth(13) + 4 + 4);
    }

    int getMaxTextHeight() {
        int n = this.getTextBarHeight(this.strHeader);
        if (n > 0) {
            n += Form.getFrameHeight(13);
        }
        return Const.SCREEN_HEIGHT - this.buttonHeight - 2 * Form.getFrameHeight(13) - n;
    }

    int getTextBarHeight(String[] stringArray) {
        if (stringArray == null) {
            return 0;
        }
        return 0 + stringArray.length * DefaultDefines.fontHeader.getHeight();
    }

    int getTopY() {
        if (this.fullScreen) {
            return 0;
        }
        int n = this.viewLinesAmount;
        if (!this.fullScreen && this.totalLines < this.viewLinesAmount) {
            n = this.totalLines;
        }
        return this.getMaxTextHeight() - n * this.getLineHeight(DefaultDefines.fontText);
    }

    int getLineHeight(Font font) {
        return font.getHeight() + 1;
    }

    int getFirstLineY() {
        int n;
        int n2 = this.getTopY();
        int n3 = Form.getFrameHeight(13);
        n2 += n3 + 2;
        if (this.vCenter && this.fullScreen) {
            n2 += (this.getMaxTextHeight() - this.getLineHeight(DefaultDefines.fontText) * Math.min(this.viewLinesAmount, this.totalLines)) / 2;
        }
        if ((n = this.getTextBarHeight(this.strHeader)) > 0) {
            n2 += n + n3;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics graphics) {
        Image image = imgBkg;
        synchronized (image) {
            graphics.drawImage(imgBkg, 0, 0, 20);
        }
        this.drawAnimations(graphics);
    }

    void drawAnimations(Graphics graphics) {
        if (this.maxLamps > 0) {
            this.drawLamps(graphics, this.currentLamp, 8);
        }
    }

    void draw(Graphics graphics) {
        this.drawBackground(graphics);
        this.drawBody(graphics);
        this.drawButtons(graphics);
    }

    void repaint(int n) {
        this.repaintState |= n;
    }

    void repaint() {
        this.repaint(-1);
    }

    void drawBackground(Graphics graphics) {
        if (bkgMap == null) {
            bkgMap = this.generateBackgroundMap(true);
        }
        this.drawBackgroundMap(graphics, bkgMap);
    }

    void drawBackgroundMap(Graphics graphics, int[][] nArray) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, Const.SCREEN_WIDTH, Const.SCREEN_HEIGHT);
        int n = Form.getFrameHeight(21);
        int n2 = Const.SCREEN_WIDTH - (nArray.length - 1) * n;
        int n3 = Const.SCREEN_HEIGHT - (nArray[0].length - 1) * n;
        for (int i = nArray.length - 1; i >= 0; --i) {
            for (int j = nArray[0].length - 1; j >= 0; --j) {
                int n4 = nArray[i][j];
                if (n4 <= 0) continue;
                Form.drawImageFrame(graphics, n4 & 0xFF, n4 >> 8, i * n + n2, j * n + n3, 40);
            }
        }
    }

    void drawBorderHorizontal(Graphics graphics, int n, int n2, int n3) {
        int[] nArray = Form.saveClip(graphics, n, n2, n3, Const.SCREEN_HEIGHT);
        int n4 = Form.getFrameWidth(13);
        int n5 = n3 / n4 + 1;
        for (int i = 0; i < n5; ++i) {
            Form.drawImageFrame(graphics, 13, 4, n, n2, 0);
            n += n4;
        }
        Form.restoreClip(graphics, nArray);
    }

    void drawBorderVertical(Graphics graphics, int n, int n2, int n3) {
        int[] nArray = Form.saveClip(graphics, n, n2, Const.SCREEN_WIDTH, n3);
        int n4 = Form.getFrameHeight(13);
        int n5 = n3 / n4 + 1;
        for (int i = 0; i < n5; ++i) {
            Form.drawImageFrame(graphics, 13, 3, n, n2, 0);
            n2 += n4;
        }
        Form.restoreClip(graphics, nArray);
    }

    void drawLamps(Graphics graphics, int n, int n2) {
        int n3 = Const.SCREEN_WIDTH - 8;
        int n4 = (Const.SCREEN_WIDTH - n3) / 2;
        int n5 = Form.getFrameWidth(13);
        int n6 = Form.getFrameHeight(13);
        int n7 = this.yLampShift + n * 3 * n6;
        int n8 = n4 + n3 - n5;
        int n9 = 0;
        while (n9 < 2) {
            Form.drawImageFrame(graphics, 13, n2, n4, n7, 0);
            Form.drawImageFrame(graphics, 13, n2, n8, n7, 0);
            ++n9;
            n7 += n6;
            ++n2;
        }
    }

    void drawBody(Graphics graphics) {
        int n;
        int n2;
        if (this.totalLines == 0 && this.strHeader == null) {
            return;
        }
        int n3 = Form.getFrameWidth(13);
        int n4 = Form.getFrameHeight(13);
        int n5 = this.getTopY();
        int n6 = Const.SCREEN_WIDTH - 8;
        int n7 = (Const.SCREEN_WIDTH - n6) / 2;
        int n8 = Const.SCREEN_HEIGHT - this.buttonHeight - n5;
        this.drawBorderVertical(graphics, n7, n5 + n4, n8 - 2 * n4);
        this.drawBorderVertical(graphics, n7 + n6 - n3, n5 + n4, n8 - 2 * n4);
        Form.drawImageFrame(graphics, 13, 0, n7, n5, 0);
        Form.drawImageFrame(graphics, 13, 2, n7, n5 + n8 - n4, 0);
        Form.drawImageFrame(graphics, 13, 5, n7 + n6 - n3, n5, 0);
        Form.drawImageFrame(graphics, 13, 7, n7 + n6 - n3, n5 + n8 - n4, 0);
        this.drawBorderHorizontal(graphics, n7 + n3, n5, n6 - 2 * n3);
        this.drawBorderHorizontal(graphics, n7 + n3, n5 + n8 - n4, n6 - 2 * n3);
        int n9 = this.getTextBarHeight(this.strHeader);
        if (n9 > 0) {
            for (n2 = 0; n2 < n9; ++n2) {
                int[] nArray = new int[3];
                System.arraycopy(DefaultDefines.TEXT_BAR_GRADIENT_LOW, 0, nArray, 0, 3);
                for (int i = 0; i < 3; ++i) {
                    int n10 = i;
                    nArray[n10] = nArray[n10] + DefaultDefines.TEXT_BAR_GRADIENT_ADD[i] * n2 / n9;
                }
                graphics.setColor(nArray[0], nArray[1], nArray[2]);
                graphics.fillRect(n7 + n3, n5 + n4 + n2, n6 - 2 * n3, 1);
            }
            n2 = n5 + n4 + n9;
            Form.drawImageFrame(graphics, 13, 1, n7, n2, 0);
            this.drawBorderHorizontal(graphics, n7 + n3, n2, n6 - 2 * n3);
            Form.drawImageFrame(graphics, 13, 6, n7 + n6 - n3, n2, 0);
            graphics.setFont(DefaultDefines.fontHeader);
            n = 0;
            this.drawText(graphics, this.strHeader, Const.SCREEN_WIDTH / 2 - n, n5 + n4 + 0 + 2, 17, 0xFFFFFF, 0);
            n5 += n9 + n4;
            n9 += n4;
        }
        for (n2 = 0; n2 < this.maxLamps; ++n2) {
            this.drawLamps(graphics, n2, 10);
        }
        n5 += n4;
        graphics.setColor(0);
        if (!this.fullScreen) {
            graphics.fillRect(n7 + n3, n5, n6 - 2 * n3, n8 - 2 * n4 - n9);
        }
        n2 = this.getLineHeight(DefaultDefines.fontText);
        if (this.vCenter && this.fullScreen) {
            n5 += (this.getMaxTextHeight() - n2 * Math.min(this.viewLinesAmount, this.totalLines)) / 2;
        }
        this.setFont(graphics, DefaultDefines.fontText);
        n5 += 2;
        graphics.setColor(0xFFFFFF);
        n = this.viewStart;
        while (n < this.viewStart + this.viewLinesAmount && n < this.totalLines) {
            this.drawLine(graphics, n, n5);
            ++n;
            n5 += n2;
        }
    }

    void drawLine(Graphics graphics, int n, int n2) {
        graphics.drawString(this.data[n], Const.SCREEN_WIDTH / 2, n2, 17);
    }

    void drawText(Graphics graphics, String[] stringArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getLineHeight(graphics.getFont());
        for (int i = 0; i < stringArray.length; ++i) {
            this.drawText(graphics, stringArray[i], n, n2 + i * n6, n3, n4, n5);
        }
    }

    void drawText(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        if (n4 == n5) {
            n6 = 4;
        } else {
            graphics.setColor(n5);
        }
        for (int i = n6; i <= 4; ++i) {
            int n7 = 0;
            int n8 = 0;
            if (i == 4) {
                graphics.setColor(n4);
            } else if (i % 2 == 0) {
                n8 = i - 1;
            } else {
                n7 = i - 2;
            }
            graphics.drawString(string, n + n7, n2 + n8, n3);
        }
    }

    void drawButtons(Graphics graphics) {
        this.setFont(graphics, DefaultDefines.fontButton);
        graphics.setColor(this.colorButtonFrg);
        for (int i = 0; i < 2; ++i) {
            if (this.strButton[i] == null) continue;
            if (i == 0) {
                graphics.drawString(this.strButton[i], 4, Const.SCREEN_HEIGHT - this.buttonHeight + 2 + 2, 20);
                continue;
            }
            graphics.drawString(this.strButton[i], Const.SCREEN_WIDTH - 4, Const.SCREEN_HEIGHT - this.buttonHeight + 2 + 2, 24);
        }
        this.drawArrows(graphics, Const.SCREEN_WIDTH / 2, Const.SCREEN_HEIGHT - this.buttonHeight / 2);
    }

    void drawArrows(Graphics graphics, int n, int n2) {
        int n3;
        graphics.setColor(0x10A010);
        int n4 = this.getArrowSize(graphics);
        if (this.viewStart > 0) {
            for (n3 = 0; n3 < n4; ++n3) {
                graphics.fillRect(n - n3, n2 - n4 + n3, 2 * n3 + 1, 1);
            }
        }
        if (this.viewStart + this.viewLinesAmount < this.totalLines) {
            for (n3 = 0; n3 < n4; ++n3) {
                graphics.fillRect(n - n3, n2 + n4 - n3, 2 * n3 + 1, 1);
            }
        }
    }

    int getArrowSize(Graphics graphics) {
        return Math.max(graphics.getFont().getHeight() / 2 - 2, 5);
    }

    void setFont(Graphics graphics, Font font) {
        graphics.setFont(font);
    }

    void drawButtonLine(Graphics graphics, int n, int n2, int n3) {
        int n4 = Form.getFrameWidth(14);
        int n5 = n3 - 2 * n4;
        Form.drawImageFrame(graphics, 14, 0, n, n2, 20);
        int n6 = (n += n4) + n5;
        Form.drawImageFrame(graphics, 14, 2, n6, n2, 20);
        int[] nArray = Form.saveClip(graphics, n, 0, n5, Const.SCREEN_HEIGHT);
        while (n < n6) {
            Form.drawImageFrame(graphics, 14, 1, n, n2, 20);
            n += n4;
        }
        Form.restoreClip(graphics, nArray);
    }

    void resetSliding() {
    }

    void slidingTick() {
    }

    static int random(int n) {
        return n == 0 ? 0 : Math.abs(rnd.nextInt()) % n;
    }

    static int random2(int n) {
        return Form.random(2 * n + 1) - n;
    }

    static boolean percent(int n) {
        return Form.random(100) < n;
    }

    static final int normalizeAngle(int n) {
        if ((n %= 360) < 0) {
            n += 360;
        }
        return n;
    }

    static int fixedSin(int n) {
        int n2 = (n = Form.normalizeAngle(n)) <= 90 ? sin_table[n] : (n <= 180 ? sin_table[180 - n] : (n <= 270 ? -sin_table[n - 180] : -sin_table[360 - n]));
        return n2;
    }

    static int fixedCos(int n) {
        return Form.fixedSin(90 - n);
    }

    static int sin_mul(int n, int n2) {
        return Form.fixedSin(n2) * n >> 16;
    }

    static int cos_mul(int n, int n2) {
        return Form.sin_mul(n, 90 - n2);
    }

    static int sqrt(long l, long l2) {
        return Form.sqrt(l * l + l2 * l2);
    }

    static int sqrt(long l) {
        long l2 = l;
        long l3 = l;
        if (l <= 0L) {
            return 0;
        }
        while (true) {
            long l4 = l / l2 + l2;
            l2 = l4 >> 1;
            if (l3 <= (l2 += l4 & 1L)) break;
            l3 = l2;
        }
        if (l / l3 == l3 - 1L && l % l3 == 0L) {
            --l3;
        }
        return (int)l3;
    }

    static int arctan(int n, int n2) {
        int n3 = Math.abs(n);
        int n4 = Math.abs(n2);
        int n5 = Form.arctanUnsign(n3, n4);
        if (n >= 0) {
            return n2 >= 0 ? n5 : 180 - n5;
        }
        return n2 >= 0 ? 360 - n5 : 180 + n5;
    }

    static int arctanUnsign(int n, int n2) {
        int n3;
        int n4 = 45;
        int n5 = 0;
        int n6 = 90;
        int n7 = Form.sqrt(n * n + n2 * n2);
        while (n4 != n5 && n4 != n6 && (n3 = Form.cos_mul(n7, n4)) != n2) {
            if (n3 < n2) {
                n6 = n4;
                n4 = (n5 + n4) / 2;
                continue;
            }
            n5 = n4;
            n4 = (n6 + n4) / 2;
        }
        return n4;
    }

    static int arcsin(int n, int n2) {
        return Form.arctan(n, Form.sqrt(n2 * n2 - n * n));
    }

    static int arccos(int n, int n2) {
        return Form.arctan(Form.sqrt(n2 * n2 - n * n), n);
    }

    static int[] saveClip(Graphics graphics, int n, int n2, int n3, int n4) {
        int[] nArray = new int[]{graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight()};
        graphics.clipRect(n, n2, n3, n4);
        return nArray;
    }

    static void restoreClip(Graphics graphics, int[] nArray) {
        graphics.setClip(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static String[] splitInLines(String string, Font font, int n) {
        int n2;
        if (string == null || font == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = string.length();
        while (n3 < n6) {
            int n7 = 0;
            n2 = n3;
            boolean bl = true;
            while (true) {
                if (n2 == n6) {
                    n4 = n2;
                    break;
                }
                char c = string.charAt(n2);
                bl = true;
                n7 = font.substringWidth(string, n3, n2 + 1 - n3);
                if (c == ' ' || c == '\n' || c == '\t') {
                    n4 = n2;
                    bl = false;
                    if (c == '\n') break;
                }
                if (n7 > n) {
                    if (n4 > n3) break;
                    n4 = n5;
                    if (n4 <= n3) {
                        n4 = n2;
                    }
                    if (n4 != n3) break;
                    ++n4;
                    break;
                }
                if (c == '.' || c == '@') {
                    n5 = n2 + 1;
                }
                ++n2;
            }
            vector.addElement(string.substring(n3, n4).trim());
            n3 = n4 + (bl ? 0 : 1);
        }
        String[] stringArray = new String[vector.size()];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray[n2] = (String)vector.elementAt(n2);
        }
        return stringArray;
    }

    public static String shrinkString(String string, Font font, int n) {
        if (string == null) {
            return "";
        }
        for (int i = string.length(); i > 0; --i) {
            String string2;
            String string3 = string2 = i == string.length() ? string : string.substring(0, i) + ".";
            if (font.stringWidth(string2) > n) continue;
            return string2;
        }
        return "";
    }

    public static String shrinkString2(String string, Font font, int n) {
        int n2;
        if (string == null) {
            return "";
        }
        int n3 = (string = string.trim()).indexOf(32);
        if (n3 == -1) {
            return Form.shrinkString(string, font, n);
        }
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n3);
        int n4 = font.stringWidth(string2);
        if (n4 < (n2 = font.stringWidth(string3))) {
            return Form.shrinkString(string, font, n);
        }
        return Form.shrinkString(string2, font, n - n2) + string3;
    }

    public static byte[] getResource(String string) {
        if (string.charAt(0) != '/') {
            string = '/' + string;
        }
        try {
            InputStream inputStream = ((Object)((Object)App.app)).getClass().getResourceAsStream(string);
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 1;
            while (n > 0) {
                n = inputStream.read(byArray);
                if (n <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] getSoundResource(int n) {
        if (n == 3) {
            return LeaderBoard.pubSoundBynary;
        }
        return Form.getResource(n);
    }

    public static byte[] getResource(int n) {
        return Form.getResource(Integer.toString(n));
    }

    static Image getImage(int n) {
        int n2;
        if (imageArray == null) {
            imageArray = new Image[20];
        }
        if (imageArray[n2 = n - 7] == null) {
            try {
                if (n == 7) {
                    App.debugText("ICON IM1 ");
                }
                if (n == 8) {
                    App.debugText("ICON IM2 ");
                }
                if (n == 10) {
                    App.debugText("INTRO IM ");
                }
                Form.imageArray[n2] = Image.createImage((String)("/" + n));
            }
            catch (Throwable throwable) {
                App.debugText("IM" + n, throwable);
            }
        }
        return imageArray[n2];
    }

    public static void freeImage(int n) {
        Form.imageArray[n] = null;
        System.gc();
    }

    public static void drawImageFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Image image = Form.getImage(n);
        if (image != null) {
            int n6 = Form.getFrameWidth(n);
            int n7 = Form.getFrameHeight(n);
            int n8 = Form.getFrameInfo(n, 0);
            if ((n5 & 1) != 0) {
                n3 -= n6 / 2;
            } else if ((n5 & 8) != 0) {
                n3 -= n6;
            }
            if ((n5 & 2) != 0) {
                n4 -= n7 / 2;
            } else if ((n5 & 0x20) != 0) {
                n4 -= n7;
            }
            int[] nArray = Form.saveClip(graphics, n3, n4, n6, n7);
            graphics.drawImage(image, n3 - n6 * (n2 % n8), n4 - n7 * (n2 / n8), 20);
            Form.restoreClip(graphics, nArray);
        }
    }

    public static final void drawImage(Graphics graphics, int n, int n2, int n3, int n4) {
        Form.drawImageFrame(graphics, n, 0, n2, n3, n4);
    }

    public static int getImageWidth(int n) {
        int n2 = 0;
        try {
            n2 = Form.getImage(n).getWidth();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public static int getImageHeight(int n) {
        int n2 = 0;
        try {
            n2 = Form.getImage(n).getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public static int getFrameInfo(int n, int n2) {
        int n3 = 0;
        try {
            int n4 = n - 7;
            if (n4 < Const.IMAGE_FRAMES.length) {
                n3 = Const.IMAGE_FRAMES[n4][n2];
            }
            if (n3 == 0) {
                if (n2 == 1) {
                    n3 = 1;
                } else {
                    Image image = Form.getImage(n);
                    n3 = image.getWidth() / (image.getHeight() / Form.getFrameInfo(n, 1));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n3;
    }

    public static int getFrameWidth(int n) {
        return Form.getImageWidth(n) / Form.getFrameInfo(n, 0);
    }

    public static int getFrameHeight(int n) {
        return Form.getImageHeight(n) / Form.getFrameInfo(n, 1);
    }

    static {
        rnd = new Random(System.currentTimeMillis());
        sin_table = new int[]{0, 1143, 2287, 3429, 4571, 5711, 6850, 7986, 9120, 10252, 11380, 12504, 13625, 14742, 15854, 16961, 18064, 19160, 20251, 21336, 22414, 23486, 24550, 25606, 26655, 27696, 28729, 29752, 30767, 31772, Short.MAX_VALUE, 33753, 34728, 35693, 36647, 37589, 38521, 39440, 40347, 41243, 42125, 42995, 43852, 44695, 45525, 46340, 47142, 47929, 48702, 49460, 50203, 50931, 51643, 52339, 53019, 53683, 54331, 54963, 55577, 56175, 56755, 57319, 57864, 58393, 58903, 59395, 59870, 60326, 60763, 61183, 61583, 61965, 62328, 62672, 62997, 63302, 63589, 63856, 64103, 64331, 64540, 64729, 64898, 65047, 65176, 65286, 65376, 65446, 65496, 65526, 65536};
    }
}

