/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public class GameLogic
extends Form {
    static final int TYPE_AI = 0;
    static final int TYPE_HOTSEAT = 1;
    int gameType;
    int shipType;
    Player[] player = new Player[2];
    int amountPlayers = 2;
    static Vector cosmos = new Vector();
    static Vector movingObjects = new Vector();
    static Vector animations = new Vector();
    static long G;
    int score;
    int nTurn;
    int nRound;
    static int gameWidth;
    static int gameHeight;
    int shipBlinkState;
    int[][] bkgMapGame;
    static final int FORCE_NEXT_STATE = -100;
    static final int AFTER_TEXT_BAR = -101;
    static final int STATE_PLACE_SHIP = 0;
    static final int STATE_AIM = 1;
    static final int STATE_SHOW_TURN = 2;
    static final int STATE_SHOW_TEXT = 3;
    static final int STATE_END_ROUND = 4;
    int gameState;
    int turnStep;
    int currentPlayer;
    int nextGameState;
    long lastBlinkTime;
    Vector explosions = new Vector();
    int lastAction;
    int repeatValue;
    long rndSeed;
    int calcSteps;
    static final int AI_INIT = 0;
    static final int AI_TRY_NEXT = 1;
    static final int AI_TRYING = 2;
    static final int AI_SHOW = 3;
    int aiState;
    static final int AI_TRY_FIRST = 0;
    static final int AI_TRY_ANGLE = 1;
    static final int AI_TRY_POWER = 2;
    static final int AI_TRY_FLY = 3;
    int aiTryState;
    Missile aiMissile;
    int aiStepsDone;
    boolean wasHitPreviousRound;
    boolean hitPreviousRound;
    static long minDistance;
    long angleMinDistance;
    long baseMinDistance;
    int angleGradient;
    int powerGradient;
    int angleStep;
    int powerStep;
    int minimums;
    int flyTries;
    private boolean gameSaved;
    static final String rmsName = "GPsave";

    GameLogic() {
        for (int i = 0; i < 2; ++i) {
            this.player[i] = new Player();
        }
        this.setButton(0, 7);
        this.buttonHeight = Math.max(this.buttonHeight, GameLogic.getFrameHeight(14));
        gameWidth = Const.SCREEN_WIDTH;
        gameHeight = Const.SCREEN_HEIGHT - this.buttonHeight;
        this.loadGame();
    }

    void drawBody(Graphics graphics) {
        this.drawPlanets(graphics);
        if (App.SM.demoVersion) {
            graphics.setColor(0xFFFFFF);
            graphics.setFont(DefaultDefines.fontText);
            graphics.drawString(App.getString(43), gameWidth / 2, graphics.getFont().getHeight(), 17);
        }
    }

    void drawBackground(Graphics graphics) {
        this.drawBackgroundMap(graphics, this.bkgMapGame);
    }

    void drawAnimations(Graphics graphics) {
        int[] nArray = GameLogic.saveClip(graphics, 0, 0, gameWidth, gameHeight);
        this.drawShips(graphics);
        this.drawStarsGlowing(graphics);
        switch (this.gameState) {
            case 3: {
                super.drawBody(graphics);
                super.drawAnimations(graphics);
                break;
            }
            case 2: {
                this.drawMissiles(graphics);
            }
        }
        for (int i = 0; i < animations.size(); ++i) {
            ((Animation)animations.elementAt(i)).draw(graphics);
        }
        GameLogic.restoreClip(graphics, nArray);
    }

    public void drawPlanets(Graphics graphics) {
        for (int i = 0; i < cosmos.size(); ++i) {
            AstroObject astroObject = (AstroObject)cosmos.elementAt(i);
            if (astroObject instanceof Player) continue;
            astroObject.draw(graphics);
        }
    }

    public void drawShips(Graphics graphics) {
        for (int i = 0; i < this.amountPlayers; ++i) {
            if (this.shipBlinkState % 2 != 0 && i == this.currentPlayer) continue;
            this.player[i].draw(graphics);
        }
    }

    public void drawStarsGlowing(Graphics graphics) {
    }

    public void drawMissiles(Graphics graphics) {
        for (int i = 0; i < movingObjects.size(); ++i) {
            AstroObject astroObject = (AstroObject)movingObjects.elementAt(i);
            if (astroObject.type != 0) continue;
            ((Missile)astroObject).draw(graphics);
        }
    }

    void drawButtons(Graphics graphics) {
        graphics.setFont(DefaultDefines.fontButton);
        int n = Const.SCREEN_HEIGHT - this.buttonHeight;
        this.drawButtonLine(graphics, 0, n, Const.SCREEN_WIDTH);
        int n2 = 4;
        int n3 = GameLogic.getFrameWidth(18) + 1;
        int n4 = graphics.getFont().stringWidth("360 ");
        int n5 = Const.SCREEN_WIDTH - n2;
        int n6 = 8;
        int n7 = 4;
        graphics.setColor(0xFFFFFF);
        Player player = this.player[this.currentPlayer];
        if (this.gameState == 1 && player.aiLevel == 0) {
            for (int i = 0; i <= 2; ++i) {
                String string = "";
                switch (i) {
                    case 0: {
                        string = String.valueOf(player.angle);
                        break;
                    }
                    case 1: {
                        string = String.valueOf(Math.min(100, player.power));
                        break;
                    }
                    case 2: {
                        if (player.actionType != 1) break;
                        i = 3;
                    }
                }
                GameLogic.drawImageFrame(graphics, 18, i, n2, n + this.buttonHeight / 2, 2 | n7);
                graphics.drawString(string, n2 += n3, n + 2 + 2, 0x10 | n7);
                n2 += n4;
            }
        } else {
            graphics.setFont(DefaultDefines.fontButton);
            String string = App.getString(75, String.valueOf(this.nRound), String.valueOf(this.nTurn));
            graphics.drawString(string, n2, n + 2 + 2, 0x10 | n7);
        }
        GameLogic.drawImageFrame(graphics, 18, 4, n5, n + this.buttonHeight / 2, 2 | n6);
    }

    int getDiffValue() {
        int n = this.nRound;
        if (this.gameType == 1) {
            n *= 1;
        }
        return Math.max(1, Math.min(n, 10));
    }

    public void generate(int n, int n2) {
        this.bkgMapGame = this.generateBackgroundMap(false);
        cosmos.removeAllElements();
        G = 5000L + 5000L * (long)this.getDiffValue() / 10L;
        this.generatePlanets(n, n2, 3 + this.getDiffValue() / 6, this.getDiffValue() * 10, Const.PLANET_DIAMETER_MIN, 5);
    }

    void newPlayerPosition(Player player, int n, int n2, int n3) {
        int n4 = player.size;
        int n5 = (n2 -= n4) / 2;
        int n6 = (n3 -= n4) / 2;
        do {
            player.reinit();
            player.x = n4 / 2 + GameLogic.random(n5);
            player.y = n4 / 2 + GameLogic.random(n6);
            player.HP = 100;
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    player.x += n5;
                    player.y += n6;
                    break;
                }
                case 2: {
                    player.x += n5;
                    break;
                }
                case 3: {
                    player.y += n6;
                }
            }
            player.realToFixed();
            n = (n + 1) % 4;
        } while (!this.processNewAO(player));
        cosmos.addElement(player);
    }

    void generatePlanets(int n, int n2, int n3, int n4, int n5, int n6) {
        AstroObject astroObject = new AstroObject();
        int n7 = 0;
        int n8 = 0;
        while (n7 < n3 && n8 < n4) {
            if (astroObject == null) {
                astroObject = new AstroObject();
            }
            astroObject.x = Form.random(n);
            astroObject.y = Form.random(n2);
            int n9 = Form.random(5);
            astroObject.imgID = 22 + n9;
            astroObject.frameID = Form.random(GameLogic.getFrameInfo(astroObject.imgID, 0));
            astroObject.size = n5 + n9 * n6;
            astroObject.realToFixed();
            if (this.processNewAO(astroObject)) {
                cosmos.addElement(astroObject);
                astroObject.makePlanet(0);
                astroObject = null;
                ++n7;
                continue;
            }
            ++n8;
        }
    }

    boolean processNewAO(AstroObject astroObject) {
        for (int i = 0; i < cosmos.size(); ++i) {
            int n;
            int n2;
            int n3;
            int n4;
            AstroObject astroObject2 = (AstroObject)cosmos.elementAt(i);
            if (astroObject == astroObject2 || (n4 = (n3 = astroObject.x - astroObject2.x) * n3 + (n2 = astroObject.y - astroObject2.y) * n2) >= (n = (astroObject.size + astroObject2.size + Math.min(astroObject.size, astroObject2.size)) / 2) * n) continue;
            return false;
        }
        return true;
    }

    boolean keyAction(int n) {
        int n2 = 0;
        switch (this.gameState) {
            case 3: {
                if (n == 1000) break;
                this.setNextState(0, -101);
                n2 |= 1;
                break;
            }
            case 0: 
            case 1: {
                Player player = this.player[this.currentPlayer];
                if (player.aiLevel != 0) break;
                int n3 = 0;
                int n4 = 0;
                int n5 = this.getAcceleratedKey(n);
                switch (n) {
                    case 1: {
                        n3 = n5;
                        n2 |= 2;
                        break;
                    }
                    case 6: {
                        n3 = -n5;
                        n2 |= 2;
                        break;
                    }
                    case 2: {
                        n4 = n5;
                        n2 |= 2;
                        break;
                    }
                    case 5: {
                        n4 = -n5;
                        n2 |= 2;
                        break;
                    }
                    case 48: {
                        player.actionType = (player.actionType + 1) % 2;
                        n2 |= 2;
                        break;
                    }
                    case 42: {
                        break;
                    }
                    case 8: {
                        player.turnFinished = true;
                        App.SM.reinitKeyRepeat();
                    }
                }
                if (this.gameState == 0) {
                    player.x -= n4;
                    player.y -= n3;
                    if (this.processNewAO(player)) {
                        if (this.setInside(player)) break;
                        player.realToFixed();
                        break;
                    }
                    player.x += n4;
                    player.y += n3;
                    break;
                }
                player.power += n3;
                if (player.power < 1) {
                    player.power = 1;
                }
                if (player.power > 100) {
                    player.power = 100;
                }
                player.angle -= n4;
                player.angle = Form.normalizeAngle(player.angle);
            }
        }
        this.repaint(n2);
        return n2 != 0;
    }

    public void reinitAccelerateKeys() {
        this.lastAction = 0xFFFFFF;
        this.repeatValue = 0;
    }

    int getAcceleratedKey(int n) {
        if (n == this.lastAction) {
            ++this.repeatValue;
        } else {
            this.lastAction = n;
            this.repeatValue = 0;
        }
        if (this.repeatValue < 5) {
            return 1;
        }
        return this.repeatValue / 5 * 5;
    }

    void resume() {
    }

    void pause() {
    }

    void init() {
        this.gameType = ((Menu)App.SM.forms[13]).selection;
        this.score = 0;
        this.nRound = 0;
        this.initGame();
    }

    void initGame() {
        this.shipType = ((Menu)App.SM.forms[12]).selection;
        for (int i = 0; i < this.amountPlayers; ++i) {
            this.player[i].aiLevel = 0;
            this.player[i].idName = (i + this.shipType) % 2 == 0 ? 58 : 57;
            this.player[i].wins = 0;
        }
        if (this.gameType == 0) {
            this.player[1].aiLevel = 1;
        }
        this.reinit();
    }

    void restart() {
        if (this.gameType == 1) {
            this.nRound = 0;
        }
        this.reinit();
    }

    void reinit() {
        int n;
        ++this.nRound;
        this.nTurn = 1;
        this.rndSeed = System.currentTimeMillis();
        Form.rnd.setSeed(this.rndSeed);
        this.generate(gameWidth, gameHeight);
        for (n = 0; n < this.amountPlayers; ++n) {
            Player player = this.player[n];
            player.gravSusceptibility = Math.max(1, (10 - this.getDiffValue()) / 2);
            player.x = 0;
            player.y = 0;
            player.HP = 0;
            player.realToFixed();
        }
        for (n = 0; n < this.amountPlayers; ++n) {
            int n2;
            int n3 = GameLogic.random(this.amountPlayers);
            if (n3 == (n2 = GameLogic.random(this.amountPlayers))) continue;
            Player player = this.player[n3];
            this.player[n3] = this.player[n2];
            this.player[n2] = player;
        }
        this.nextTurnInit();
        this.setNextState(0, 0);
        this.aiInit();
    }

    void nextTurnInit() {
        this.currentPlayer = 0;
        for (int i = 0; i < this.player.length; ++i) {
            if (this.player[i].actionType == 1) {
                this.aiInit();
            }
            this.player[i].turnFinished = false;
        }
        this.aiStepsDone = 0;
        animations.removeAllElements();
        movingObjects.removeAllElements();
    }

    void setNextState(int n, int n2) {
        this.repaint();
        String string = null;
        if (n2 == -100) {
            this.gameState = n;
            if (n == 2) {
                this.shipBlinkState = 0;
                this.aiState = 1;
                for (int i = 0; i < this.amountPlayers; ++i) {
                    if (this.player[i].actionType != 0) continue;
                    Target.playSound(4);
                    break;
                }
            }
        } else if (n2 == -101) {
            this.gameState = this.nextGameState;
        } else if (n == 4) {
            Object object;
            this.gameState = 4;
            String string2 = null;
            int n3 = 71;
            int n4 = 29;
            int n5 = 30;
            if (n2 < 0) {
                string2 = App.getString(62);
            }
            if (this.gameType == 1) {
                if (n2 >= 0) {
                    string2 = App.getString(72, App.getString(this.player[n2].idName));
                    ++this.player[n2].wins;
                }
                object = this.player[0].wins + ":" + this.player[1].wins;
                string2 = string2 + "\n";
                if (this.nRound >= 5 && this.player[0].wins != this.player[1].wins) {
                    string2 = string2 + App.getString(66, (String)object) + "\n" + App.getString(73);
                    Target.playSound(1);
                } else {
                    string = string2 = string2 + App.getString(65, (String)object);
                    this.setText(string);
                    this.gameState = 3;
                    this.nextGameState = n;
                }
            } else {
                boolean bl = true;
                if (n2 >= 0) {
                    bl = this.player[n2].aiLevel == 0;
                    string2 = App.getString(63 + (bl ? 0 : 1), String.valueOf(this.nRound));
                }
                int n6 = this.nRound * 100 + (1000 - this.nTurn - this.player[0].shots) + (1000 - this.player[0].hits * 100);
                if (n2 < 0 || !bl) {
                    n6 /= 2;
                }
                string2 = string2 + "\n" + App.getString(65, String.valueOf(n6));
                this.score += n6;
                string2 = string2 + "\n" + App.getString(66, String.valueOf(this.score));
                if (!bl) {
                    n4 = 15;
                    n5 = -1;
                } else {
                    n3 = 34;
                    n4 = 35;
                    n5 = 22;
                }
                Target.playSound(bl ? 1 : 2);
                this.saveGame(bl);
            }
            if (this.gameState != 3) {
                object = new Form(App.getString(n3), string2);
                ((Form)object).setButton(n4, n5);
                App.SM.forms[15] = object;
                App.SM.setNextState(15);
            }
        } else if (n == 1 || n == 0) {
            Player player = this.player[this.currentPlayer];
            if (n == 0) {
                this.newPlayerPosition(player, GameLogic.random(4), gameWidth, gameHeight);
            }
            if (player.aiLevel > 0) {
                this.gameState = n;
            } else {
                this.shipBlinkState = 4;
                this.nextGameState = n;
                this.gameState = 3;
                string = App.getString(n == 1 ? 51 : 50, App.getString(this.player[this.currentPlayer].idName));
                this.setText(string);
            }
        } else {
            this.setText(this.gameState == 3 ? string : null);
        }
    }

    void tick() {
        if (animations.size() > 0) {
            App.SM.redraw();
        }
        int n = 0;
        while (n < animations.size()) {
            if (((Animation)animations.elementAt(n)).tick()) {
                animations.removeElementAt(n);
                continue;
            }
            ++n;
        }
        Player player = this.player[this.currentPlayer];
        switch (this.gameState) {
            case 4: {
                this.reinit();
                break;
            }
            case 2: {
                if (!this.calculate() || animations.size() != 0) break;
                int n2 = 0;
                int n3 = -1;
                for (int i = 0; i < this.amountPlayers; ++i) {
                    if (this.player[i].HP <= 0) continue;
                    ++n2;
                    n3 = i;
                }
                if (n2 <= 1) {
                    this.setNextState(4, n3);
                    break;
                }
                this.nextTurnInit();
                ++this.nTurn;
                if (App.SM.demoVersion && this.nTurn > 3) {
                    App.SM.setNextState(23);
                    break;
                }
                this.setNextState(1, 0);
                break;
            }
            case 0: 
            case 1: {
                if (player.HP <= 0) {
                    ++this.currentPlayer;
                    break;
                }
                if (player.turnFinished) {
                    if (this.currentPlayer >= this.amountPlayers - 1) {
                        if (this.gameState == 1) {
                            this.turnStep = 0;
                            for (int i = 0; i < this.amountPlayers; ++i) {
                                if (this.player[i].actionType == 0) {
                                    ++this.player[i].shots;
                                }
                                movingObjects.addElement(this.player[i].getMissile());
                            }
                            this.setNextState(2, -100);
                            break;
                        }
                        this.nextTurnInit();
                        this.setNextState(1, 0);
                        break;
                    }
                    ++this.currentPlayer;
                    this.setNextState(this.gameState, 0);
                    break;
                }
                if (App.SM.currentTime - this.lastBlinkTime > 350L) {
                    this.lastBlinkTime = App.SM.currentTime;
                    if (this.shipBlinkState > 0) {
                        --this.shipBlinkState;
                        App.SM.redraw();
                    }
                }
                if (player.aiLevel <= 0) break;
                if (this.gameState == 0) {
                    player.turnFinished = true;
                    break;
                }
                this.aiTurn(this.currentPlayer);
            }
        }
        super.tick();
    }

    boolean setInside(AstroObject astroObject) {
        int n = astroObject.size / 2;
        boolean bl = false;
        if (astroObject.x < n) {
            astroObject.x = n;
            bl = true;
        }
        if (astroObject.y < n) {
            astroObject.y = n;
            bl = true;
        }
        if (astroObject.x > gameWidth - n) {
            astroObject.x = gameWidth - n;
            bl = true;
        }
        if (astroObject.y > gameHeight - n) {
            astroObject.y = gameHeight - n;
            bl = true;
        }
        return bl;
    }

    boolean step() {
        int n;
        Object object;
        Missile missile;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < movingObjects.size()) {
            boolean bl3;
            missile = (Missile)movingObjects.elementAt(n2);
            if (missile.x >= 0 && missile.y >= 0 && missile.x < gameWidth && missile.y < gameHeight) {
                bl = true;
            }
            object = missile.move(cosmos);
            boolean bl4 = bl3 = missile.step <= 0 || object != null;
            if (object != null) {
                App.debugText("hit! " + ((AstroObject)object).x + " " + ((AstroObject)object).y);
                if (missile.type == 1) {
                    ((Player)missile).damage += this.getDiffValue() / 5 + 10 + Form.random(this.getDiffValue() / 2);
                    if (((AstroObject)object).type == 1) {
                        ((Player)object).damage += this.getDiffValue() / 5 + 10 + Form.random(this.getDiffValue() / 2);
                    }
                } else {
                    animations.addElement(new Animation(1, missile.x, missile.y, null));
                    bl2 = true;
                    if (((AstroObject)object).type == 1) {
                        Player player = (Player)object;
                        n = GameLogic.sqrt(gameWidth, gameHeight);
                        player.damage += 10 * missile.shipFrom.power / 100 + Form.random(10) + Math.min(GameLogic.sqrt(missile.fixedVX, missile.fixedVY), 10000) / 1000 + Math.abs(n - GameLogic.sqrt(((AstroObject)object).x - missile.x, ((AstroObject)object).y - missile.y)) * 10 / n;
                        ++missile.shipFrom.hits;
                        if (player.aiLevel > 0 && missile.shipFrom.aiLevel == 0) {
                            this.wasHitPreviousRound = true;
                        } else if (player.aiLevel == 0 && missile.shipFrom.aiLevel > 0) {
                            this.hitPreviousRound = true;
                        }
                        if (!movingObjects.contains(player)) {
                            player.fixedVX = missile.fixedVX;
                            player.fixedVY = missile.fixedVX;
                            player.setMaxSpeed();
                            player.step = 15 + 15 * this.getDiffValue() / 10;
                            movingObjects.addElement(player);
                        }
                    }
                }
            } else if (missile.type == 1) {
                if (this.setInside(missile)) {
                    bl3 = true;
                    missile.realToFixed();
                }
                if (missile.step < 15) {
                    missile.fixedVX = missile.fixedVX * 3 / 4;
                    missile.fixedVY = missile.fixedVY * 3 / 4;
                }
            } else if (Math.abs(missile.x - gameWidth / 2) > gameWidth || Math.abs(missile.y - gameHeight / 2) > gameHeight) {
                bl3 = true;
            } else if (missile.step <= 0) {
                animations.addElement(new Animation(1, missile.x, missile.y, null));
                bl2 = true;
            }
            if (bl3) {
                movingObjects.removeElement(missile);
                continue;
            }
            ++n2;
        }
        for (n2 = 0; n2 < this.amountPlayers; ++n2) {
            missile = this.player[n2];
            if (((Player)missile).damage > 0) {
                ((Player)missile).HP -= ((Player)missile).damage;
                object = "-" + ((Player)missile).damage;
                Font font = Font.getDefaultFont();
                int n3 = ((Player)missile).x;
                n = Math.max(2 * ((Player)missile).size, ((Player)missile).y - ((Player)missile).size / 2);
                int n4 = font.getHeight() + 4;
                int n5 = font.stringWidth("-66");
                int n6 = 0;
                for (int i = 0; n6 < animations.size() && i < 100; ++n6, ++i) {
                    Animation animation = (Animation)animations.elementAt(n6);
                    if (n < animation.y - n4 || n > animation.y || n3 <= animation.x || n3 >= animation.x + n5) continue;
                    n += n < Const.SCREEN_HEIGHT / 2 ? n4 : -n4;
                    n6 = -1;
                }
                animations.addElement(new Animation(2, ((Player)missile).x, n, object));
                if (((Player)missile).HP <= 0) {
                    bl2 = false;
                    Target.playSound(6);
                    animations.addElement(new Animation(0, ((Player)missile).x, ((Player)missile).y, null));
                    cosmos.removeElement(missile);
                    movingObjects.removeElement(missile);
                }
            }
            ((Player)missile).damage = 0;
        }
        if (bl2) {
            Target.playSound(5);
        }
        return bl;
    }

    boolean calculate() {
        if (this.step()) {
            this.calcSteps = 1;
        } else {
            int n;
            for (n = 0; n < this.calcSteps && movingObjects.size() != 0 && !this.step(); ++n) {
            }
            if (n == this.calcSteps) {
                this.calcSteps <<= 1;
            }
        }
        return movingObjects.size() == 0;
    }

    void aiInit() {
        this.aiState = 0;
        this.wasHitPreviousRound = false;
        this.hitPreviousRound = false;
        this.minimums = 0;
        this.flyTries = 0;
    }

    void aiSet(Player player, int n, int n2) {
        player.angle = n;
        player.power = n2;
        this.angleGradient = 0;
        this.powerGradient = 0;
        this.angleStep = 30;
        this.powerStep = 4;
    }

    void aiSetTryFly(Player player) {
        int n;
        int n2 = 0;
        do {
            n = GameLogic.random(360);
        } while (n2++ <= 100 && (player.x < player.size && (n > 90 || n < 270) || player.x > gameWidth - player.size && (n < 90 || n > 270) || player.y > gameHeight - player.size && n < 180 || player.y < player.size && n > 180));
        Player player2 = new Player(player);
        player2.angle = n;
        player2.power = 40 + GameLogic.random(40);
        player2.actionType = 1;
        this.aiState = 2;
        this.aiTryState = 3;
        this.aiMissile = player2.getMissile();
        App.debugText("try flying");
    }

    void aiTurn(int n) {
        Player player = this.player[n];
        Player player2 = this.player[(n + 1) % this.amountPlayers];
        if (this.wasHitPreviousRound && !this.hitPreviousRound) {
            this.wasHitPreviousRound = false;
            this.hitPreviousRound = false;
            this.aiSetTryFly(player);
        }
        block0 : switch (this.aiState) {
            case 0: {
                App.debugText("AI init");
                this.aiSet(player, GameLogic.arctan(player2.y - player.y, player2.x - player.x) + GameLogic.random2(5) + GameLogic.random2(Math.max(1, 10 - this.getDiffValue())), 100);
            }
            case 1: {
                if (this.angleStep <= 1 && this.powerStep == 0) {
                    if (++this.minimums > 3) {
                        this.aiSetTryFly(player);
                        break;
                    }
                    this.aiSet(player, GameLogic.random(360), 60 + GameLogic.random(41));
                } else if (!this.hitPreviousRound) {
                    player.angle = GameLogic.normalizeAngle(player.angle - this.angleGradient * this.angleStep);
                    player.power -= this.powerGradient * this.powerStep;
                    if (player.power > 150) {
                        player.power = 150;
                        this.powerStep = 0;
                    }
                }
                player.actionType = 0;
                this.aiMissile = player.getMissile();
                this.aiState = 2;
                this.aiTryState = 0;
                App.debugText("AI trying A:" + player.angle + ", P:" + player.power);
                minDistance = Long.MAX_VALUE;
                break;
            }
            case 2: {
                for (int i = 0; i < 100; ++i) {
                    AstroObject astroObject = this.aiMissile.move(cosmos);
                    if (astroObject == null && this.aiMissile.step > 0) continue;
                    if (astroObject == player2 && this.aiTryState != 3) {
                        this.aiState = 3;
                        player.actionType = 0;
                        break block0;
                    }
                    switch (this.aiTryState) {
                        case 0: {
                            this.baseMinDistance = minDistance;
                            minDistance = Long.MAX_VALUE;
                            player.angle = GameLogic.normalizeAngle(player.angle + 2);
                            this.aiMissile = player.getMissile();
                            this.aiTryState = 1;
                            App.debugText("AI trying angle");
                            break;
                        }
                        case 1: {
                            this.angleMinDistance = minDistance;
                            minDistance = Long.MAX_VALUE;
                            player.angle = GameLogic.normalizeAngle(player.angle - 2);
                            player.power += 2;
                            this.aiMissile = player.getMissile();
                            this.aiTryState = 2;
                            App.debugText("AI trying power");
                            break;
                        }
                        case 2: {
                            int n2 = this.angleMinDistance - this.baseMinDistance > 0L ? 1 : -1;
                            int n3 = minDistance - this.baseMinDistance > 0L ? 1 : -1;
                            App.debugText("AI gradients, angle: " + this.angleGradient + " " + n2 + ", power: " + this.powerGradient + " " + n3);
                            player.power -= 2;
                            if (this.angleGradient != 0) {
                                if (this.angleGradient != n2) {
                                    player.angle += this.angleGradient * this.angleStep;
                                    this.angleStep /= 2;
                                    App.debugText("angle gradient was changed");
                                }
                                if (this.powerGradient != n3) {
                                    player.power += this.powerGradient * this.powerStep;
                                    this.powerStep /= 2;
                                    App.debugText("power gradient was changed");
                                }
                            } else {
                                this.angleGradient = n2;
                                this.powerGradient = n3;
                            }
                            if (this.aiStepsDone++ > Math.min(4, this.getDiffValue() / 4)) {
                                this.aiState = 3;
                                player.actionType = 0;
                                break;
                            }
                            this.aiState = 1;
                            break;
                        }
                        case 3: {
                            if (astroObject == null || ++this.flyTries > 50) {
                                player.angle = ((Player)this.aiMissile).angle;
                                player.power = ((Player)this.aiMissile).power;
                                player.actionType = 1;
                                this.aiState = 3;
                                break;
                            }
                            this.aiSetTryFly(player);
                        }
                    }
                    break block0;
                }
                break;
            }
            case 3: {
                minDistance = Long.MAX_VALUE;
                this.wasHitPreviousRound = false;
                this.hitPreviousRound = false;
                player.turnFinished = true;
            }
        }
    }

    boolean isGameSaved() {
        return this.gameSaved;
    }

    void startLoadedGame() {
        this.loadGame();
        ((Menu)App.SM.forms[12]).selection = this.shipType;
        this.initGame();
    }

    void loadGame() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)rmsName, (boolean)false);
            byte[] byArray = recordStore.getRecord(recordStore.getNextRecordID() - 1);
            recordStore.closeRecordStore();
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.gameSaved = dataInputStream.readBoolean();
            if (this.gameSaved) {
                this.shipType = dataInputStream.readInt();
                this.nRound = dataInputStream.readInt();
                this.score = dataInputStream.readInt();
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            App.debugText("create dumb save");
            this.saveGame(false);
        }
        catch (Exception exception) {
            App.debugText("game not loaded", exception);
            this.gameSaved = false;
        }
    }

    void saveGame(boolean bl) {
        this.gameSaved = bl;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(bl);
            dataOutputStream.writeInt(this.shipType);
            dataOutputStream.writeInt(this.nRound);
            dataOutputStream.writeInt(this.score);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            RecordStore recordStore = RecordStore.openRecordStore((String)rmsName, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(recordStore.getNextRecordID() - 1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            App.debugText("Error saving game", exception);
            this.gameSaved = false;
        }
    }
}

