/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public class ScreenManager
extends MyCanvas
implements Runnable,
CommandListener {
    static final int SENDING_STOP = 0;
    static final int SENDING_SCORE = 1;
    static final int SENDING_SCORE0 = 2;
    static final int SENDING_DEMOSMS = 3;
    static final int SENDING_WAIT = 4;
    int netAction;
    int state = 0;
    int loading;
    int newState = -1;
    int skipActionStep = 0;
    boolean running = true;
    boolean paused = false;
    App app;
    Form[] forms;
    GameLogic game;
    String playerName;
    long introStart;
    long currentTime;
    boolean repaintNeeded;
    TextBox editNameForm;
    Command cmdOk;
    Command cmdCancel;
    static int localeID = -1;
    boolean demoVersion = false;
    boolean hasNetwork;
    boolean hasAdvertisement;
    boolean soundEntered = false;
    Vector keysPressed = new Vector();
    boolean helpCalledFromGameMenu;
    int fpsAmount;
    long pauseTime;
    int repeatingKey;
    long lastKeyPressTime;
    int keyRepeat = 1;
    boolean introFirstRun = true;
    long prevTickTime;
    Image imgLogo;
    Command[] command;
    private static boolean needResetButtons = false;
    private static Image bufferImage;
    private static Graphics bufferGraphics;
    private static boolean repaintFinished;
    static Image pubImage;
    static final String rmsName = "GPrms13";
    public static boolean needSaving;

    public ScreenManager(App app) {
        Target.init();
        this.app = app;
        this.forms = new Form[31];
        this.loadRMS(false);
        this.setFullScreenMode(true);
        this.hasNetwork = !"0".equals(this.app.getAppProperty("G4RT-NET"));
        boolean bl = this.hasAdvertisement = this.hasNetwork && Const.lngID[0].equals(this.app.getAppProperty("Locale")) && !"0".equals(this.app.getAppProperty("G4RT-More"));
        if (!this.hasAdvertisement) {
            Const.MENU_MAIN[4][3] = 0;
        }
        int n = 0;
        for (int i = 0; i < Const.lngID.length; ++i) {
            if (((Object)((Object)this.app)).getClass().getResourceAsStream("text_" + Const.lngID[i] + ".utf") == null) continue;
            ++n;
        }
        if (n <= 1) {
            Const.MENU_OPTIONS[3][3] = 0;
        }
        Const.MENU_OPTIONS[2][3] = 0;
        Const.PLANET_DIAMETER_MIN = Form.getFrameHeight(22);
    }

    public void run() {
        long l = 0L;
        boolean bl = false;
        App.delay(25);
        while (this.running) {
            try {
                this.currentTime += this.timeFromPrevTick();
                App.delay(25);
                if (this.paused) continue;
                if (this.newState == -1) {
                    this.processKeys();
                }
                this.checkNewState();
                if (this.state == 16) continue;
                this.doStateActions();
                if (this.repaintNeeded) {
                    this.repaintNeeded = false;
                    this.repaint();
                    this.serviceRepaints();
                }
                if (this.state == 24 || this.state == 4) {
                    // empty if block
                }
                Target.tick();
            }
            catch (Throwable throwable) {
                App.debugText("Run:", throwable);
                App.printStackTrace(throwable);
            }
        }
    }

    protected void hideNotify() {
        this.pause();
    }

    protected void showNotify() {
        this.resume();
    }

    void checkNewState() {
        Form form;
        if (this.newState < 0) {
            return;
        }
        if (this.state == 3) {
            // empty if block
        }
        if ((form = this.forms[this.newState]) != null) {
            if (form.reload) {
                this.forms[this.newState] = form = this.load(this.newState);
                form.reload = false;
            } else {
                form.reset();
                if (this.newState != this.state) {
                    form.repaint();
                }
            }
        }
        block0 : switch (this.newState) {
            case 2: {
                this.loading = 0;
                break;
            }
            case 3: {
                Target.playSound(0);
                break;
            }
            case 5: {
                switch (this.state) {
                    case 10: {
                        this.game.resume();
                        break block0;
                    }
                    case 15: {
                        this.game.restart();
                        break block0;
                    }
                    case 30: {
                        this.game.startLoadedGame();
                        break block0;
                    }
                }
                this.game.init();
                break;
            }
            case 16: {
                this.app.quit();
                break;
            }
            case 4: {
                if (this.state == 3 || this.state == 24) break;
                Target.playSound(0);
                break;
            }
            case 10: {
                this.game.pause();
                if (this.state == 5) {
                    ((Menu)form).resetMenu();
                    Target.playSound(0);
                }
            }
            case 6: {
                this.helpCalledFromGameMenu = this.state == 10;
                break;
            }
            case 20: {
                switch (this.state) {
                    case 4: 
                    case 8: {
                        ((Scores)form).resetScore();
                        break block0;
                    }
                    case 15: {
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                ((Scores)this.forms[20]).resetScore();
                break;
            }
            case 14: {
                this.editNameForm = new TextBox(App.getString(19), this.playerName, 10, 0);
                this.editNameForm.addCommand(this.cmdOk);
                this.editNameForm.addCommand(this.cmdCancel);
                this.editNameForm.setCommandListener((CommandListener)this);
                this.app.setScreen((Displayable)this.editNameForm);
                break;
            }
            case 19: {
                this.skipActionStep = 1;
                break;
            }
            case 28: {
                LeaderBoard.preShowPublicity();
                String string = LeaderBoard.pubText;
                form = new Form(LeaderBoard.pubTitle, null);
                if (LeaderBoard.pubImageBynary.length != 0) {
                    pubImage = Image.createImage((byte[])LeaderBoard.pubImageBynary, (int)0, (int)LeaderBoard.pubImageBynary.length);
                    int n = 1 + pubImage.getHeight() / form.getLineHeight(DefaultDefines.fontText);
                    for (int i = 0; i < n; ++i) {
                        string = "\n" + string;
                    }
                } else {
                    pubImage = null;
                }
                form.vCenter = false;
                form.setText(string);
                form.setButton(LeaderBoard.pubActionText, App.getString(1));
                this.forms[28] = form;
                Target.initSound(3);
                Target.playSound(3);
            }
        }
        if (this.newState != this.state) {
            this.state = this.newState;
            this.keysPressed.removeAllElements();
            this.reinitKeyRepeat();
            if (form != null) {
                form.resetSliding();
            }
            this.redraw();
        }
        this.newState = -1;
    }

    void setNextState(int n) {
        switch (n) {
            case 8: {
                if (this.hasNetwork) break;
                n = this.state == 20 ? 4 : 20;
                break;
            }
            case 17: {
                if (this.hasNetwork) break;
                n = 4;
                break;
            }
            case 26: {
                if (!this.demoVersion) break;
                break;
            }
            case 12: {
                if (this.state != 13 || !this.game.isGameSaved()) break;
                n = 30;
                break;
            }
            case 13: {
                if (this.state != 12 || !this.game.isGameSaved()) break;
                n = 30;
            }
        }
        this.newState = n == 32 ? this.state : n;
    }

    void pause() {
        Target.stopSound();
        this.reinitKeyRepeat();
        if (!this.paused) {
            this.paused = true;
            this.pauseTime = this.currentTime;
            if (this.state == 5) {
                this.setNextState(10);
            }
        }
    }

    void resume() {
        this.reinitKeyRepeat();
        if (this.paused) {
            this.paused = false;
            if (this.state == 5) {
                // empty if block
            }
        }
    }

    Displayable getCurrentDispl() {
        if (this.state == 14) {
            return this.editNameForm;
        }
        return this;
    }

    void redraw() {
        this.repaintNeeded = true;
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
        this.reinitKeyRepeat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int n) {
        Vector vector = this.keysPressed;
        synchronized (vector) {
            this.lastKeyPressTime = this.currentTime + 400L;
            this.repeatingKey = n;
            this.keysPressed.addElement(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processKeys() {
        Vector vector = this.keysPressed;
        synchronized (vector) {
            if (this.keysPressed.size() > 0) {
                Integer n = (Integer)this.keysPressed.elementAt(0);
                this.keysPressed.removeElementAt(0);
                this.keyAction(n);
            } else if (this.currentTime - this.lastKeyPressTime > 100L && this.repeatingKey != 0xFFFFFF) {
                this.lastKeyPressTime = this.currentTime;
                this.keyAction(this.repeatingKey);
            }
        }
    }

    void reinitKeyRepeat() {
        this.keyRepeat = 1;
        this.repeatingKey = 0xFFFFFF;
        if (this.game != null) {
            this.game.reinitAccelerateKeys();
        }
    }

    void keyAction(int n) {
        if (this.state == 3) {
            this.setNextState(this.demoVersion ? 24 : 4);
            return;
        }
        int n2 = Target.getGameAction(this, n, this.state);
        Form form = this.forms[this.state];
        boolean bl = false;
        if (form != null) {
            bl = form.keyAction(n2);
        }
        if (!bl) {
            if (n2 == 1000) {
                if (form == null || form.existButton(1)) {
                    this.parseSecondaryKey(this.state);
                }
                this.reinitKeyRepeat();
            } else if (n2 == 8) {
                if (form == null || form.existButton(0)) {
                    this.parsePrimaryKey(this.state);
                }
                this.reinitKeyRepeat();
            }
        }
    }

    long timeFromPrevTick() {
        long l = System.currentTimeMillis();
        long l2 = l - this.prevTickTime;
        if (l2 < 0L) {
            l2 = l;
        }
        this.prevTickTime = l;
        return l2;
    }

    public void doStateActions() {
        switch (this.state) {
            case 0: {
                try {
                    this.imgLogo = Image.createImage((String)"/logo.png");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.imgLogo != null) {
                    this.setNextState(1);
                    this.introStart = this.currentTime;
                    this.redraw();
                    break;
                }
                this.setNextState(2);
                break;
            }
            case 1: {
                if (this.currentTime - this.introStart <= 1000L) break;
                this.setNextState(2);
                break;
            }
            case 2: {
                this.imgLogo = null;
                if (!this.loadStep() || !this.soundEntered) break;
                this.introStart = this.currentTime;
                this.setNextState(3);
                break;
            }
            case 3: {
                if (this.currentTime - this.introStart <= 1200L) break;
                this.setNextState(this.demoVersion ? 24 : 4);
                break;
            }
            case 19: {
                this.networkAction();
            }
        }
        if (this.forms[this.state] != null) {
            this.forms[this.state].tick();
        }
    }

    void reloadTexts(int n) {
        this.app.loadLanguage(Const.lngID[n]);
        for (int i = 0; i < 31; ++i) {
            if (this.forms[i] == null) continue;
            this.forms[i].reload = true;
        }
    }

    boolean rusLng() {
        return false;
    }

    Form load(int n) {
        Form form = null;
        switch (n) {
            case 0: {
                this.playerName = App.getString(17);
                this.cmdOk = new Command(this.rusLng() ? "OK" : App.getString(15), DefaultDefines.COMMANDS_ID[0], DefaultDefines.COMMANDS_PRIORITY[0]);
                this.cmdCancel = new Command(this.rusLng() ? "\u040b\u2019\u040a\u2026\u040c\u0402" : App.getString(20), DefaultDefines.COMMANDS_ID[1], DefaultDefines.COMMANDS_PRIORITY[1]);
                form = new Form();
                break;
            }
            case 2: {
                form = new Intro();
                break;
            }
            case 3: {
                form = this.forms[2];
                break;
            }
            case 4: {
                form = new Menu(6, Const.MENU_MAIN);
                if (this.demoVersion) break;
                form.setButton(0, 2);
                break;
            }
            case 5: {
                this.game = new GameLogic();
                form = this.game;
                break;
            }
            case 6: {
                Target.initSounds();
                form = new Form(5, 12);
                break;
            }
            case 7: {
                String string = this.app.getAppProperty("MIDlet-Version");
                if (string == null) {
                    string = "01.01.01";
                }
                String string2 = App.getString(13, string);
                form = new Form(App.getString(16), string2);
                break;
            }
            case 20: {
                form = new Scores(28);
                this.forms[n] = form;
                this.loadRMS(true);
                if (this.demoVersion) break;
                this.switchToFullMode();
                break;
            }
            case 21: {
                form = new Scores(27);
                break;
            }
            case 12: {
                form = new Menu(53, Const.MENU_SHIP);
                break;
            }
            case 11: {
                form = new Menu(69, Const.MENU_LANGUAGE);
                break;
            }
            case 13: {
                form = new Menu(54, Const.MENU_SELECT_GAME_TYPE);
                break;
            }
            case 8: {
                if (!this.hasNetwork) break;
                form = new Menu(14, Const.MENU_SCORES);
                break;
            }
            case 9: {
                form = new Menu(4, Const.MENU_OPTIONS);
                break;
            }
            case 10: {
                form = new Menu(6, Const.MENU_INGAME);
                break;
            }
            case 17: {
                form = new Form(26, 23);
                form.setButton(29, 30);
                break;
            }
            case 18: {
                form = new Form(27, 25);
                form.setButton(29, 30);
                break;
            }
            case 22: {
                form = new Form(31, 32);
                break;
            }
            case 14: {
                break;
            }
            case 23: {
                form = new Form(6, 38);
                break;
            }
            case 24: {
                App.textResources[44] = App.getString(44, App.SMSdata[0]);
                form = new Menu(6, Const.MENU_DEMO);
                form.setButton(0, 2);
                break;
            }
            case 25: {
                form = new Form(App.getString(6), App.getString(39, this.app.getAppProperty("SMSPrice")));
                form.setButton(35, 20);
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                form = new Form(48, 42);
                break;
            }
            case 28: {
                LeaderBoard.LoadPublicity();
                form = new Form(-1, -1);
                form.setButton(74, 1);
                break;
            }
            case 29: {
                form = new Form(-1, -1);
                break;
            }
            case 30: {
                form = new Menu(-1, Const.MENU_LOAD_SAVED);
            }
        }
        return form;
    }

    boolean loadStep() {
        App.debugText("loading " + this.loading);
        if (this.loading < 31) {
            this.forms[this.loading] = this.load(this.loading);
            ++this.loading;
            this.redraw();
        }
        return this.loading >= 31;
    }

    String getMenu(int[][] nArray) {
        String string = App.getString(nArray[0][0]);
        for (int i = 1; i < nArray.length; ++i) {
            string = string + "\n" + App.getString(nArray[i][0]);
        }
        return string;
    }

    void parseSecondaryKey(int n) {
        int n2 = n;
        switch (n) {
            case 4: {
                if (this.demoVersion) {
                    n2 = 24;
                    break;
                }
            }
            case 2: {
                if (!this.soundEntered) {
                    this.setSound(false);
                    return;
                }
            }
            case 3: 
            case 24: {
                n2 = 16;
                break;
            }
            case 11: {
                n2 = 9;
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 28: {
                n2 = 4;
                break;
            }
            case 15: {
                if (this.game.gameType == 0) {
                    Scores scores = (Scores)this.forms[20];
                    scores.add(this.playerName, this.game.score);
                    if (scores.selection >= 0) {
                        n2 = 20;
                        break;
                    }
                }
                n2 = 4;
                break;
            }
            case 12: 
            case 30: {
                n2 = 13;
                break;
            }
            case 5: {
                n2 = 10;
                break;
            }
            case 10: {
                n2 = 5;
                break;
            }
            case 20: {
                n2 = 14;
                break;
            }
            case 17: {
                if (((Scores)this.forms[20]).selection == 0) {
                    n2 = 4;
                    break;
                }
            }
            case 18: {
                n2 = 8;
                break;
            }
            case 25: {
                n2 = 24;
                break;
            }
            case 19: {
                this.setConnection(0);
                return;
            }
            case 14: {
                break;
            }
        }
        this.setNextState(n2);
    }

    void parsePrimaryKey(int n) {
        Form form = this.forms[n];
        switch (n) {
            case 2: {
                if (this.soundEntered) break;
                this.setSound(true);
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 24: 
            case 30: {
                ((Menu)form).setNextState();
                break;
            }
            case 11: {
                Menu menu = (Menu)form;
                if (menu.selection < menu.menuV.size() - 1) {
                    localeID = ((Menu)form).selection;
                    this.saveRMS();
                    this.reloadTexts(localeID);
                }
                this.setNextState(9);
                break;
            }
            case 15: {
                if (form.getButton(0) == App.getString(15)) {
                    Scores scores = (Scores)this.forms[20];
                    scores.add(this.playerName, this.game.score);
                    this.setNextState(scores.selection >= 0 ? 20 : 4);
                    break;
                }
                this.setNextState(5);
                break;
            }
            case 28: {
                LeaderBoard.ActionPublicity();
                break;
            }
            case 7: {
                this.setNextState(9);
                break;
            }
            case 29: {
                this.setNextState(21);
                break;
            }
            case 20: {
                if (((Scores)form).selection >= 0) {
                    this.saveRMS();
                    this.setNextState(((Scores)form).selection == 0 ? 17 : 4);
                    break;
                }
            }
            case 21: {
                if (((Scores)this.forms[20]).selection == 0) {
                    this.setNextState(4);
                    break;
                }
                this.setNextState(8);
                break;
            }
            case 22: {
                this.setNextState(8);
                break;
            }
            case 6: {
                this.setNextState(this.helpCalledFromGameMenu ? 10 : 4);
                break;
            }
            case 17: {
                this.setConnection(1);
                break;
            }
            case 18: {
                this.setConnection(2);
                break;
            }
            case 14: {
                break;
            }
            case 23: {
                this.setNextState(4);
                break;
            }
            case 25: {
                this.setConnection(3);
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                this.setNextState(24);
            }
        }
    }

    void updateCommands(Form form) {
        if (this.command == null) {
            this.command = new Command[2];
        }
        if (form == this.forms[this.state] || this.forms[this.state] == null) {
            String[] stringArray = new String[]{form.strButton[0], form.strButton[1]};
            for (int i = 0; i <= 1; ++i) {
                if (stringArray[i] != null) continue;
                stringArray[i] = " ";
            }
            if (stringArray[0] == null && this.command[0] != null || stringArray[0] != null && (this.command[0] == null || stringArray[0].compareTo(this.command[0].getLabel()) != 0) || stringArray[1] == null && this.command[1] != null || stringArray[1] != null && (this.command[1] == null || stringArray[1].compareTo(this.command[1].getLabel()) != 0)) {
                if (this.command[1] != null) {
                    this.removeCommand(this.command[1]);
                }
                if (this.command[0] != null) {
                    this.removeCommand(this.command[0]);
                }
                if (stringArray[0] != null) {
                    this.command[0] = new Command(stringArray[0], DefaultDefines.COMMANDS_ID[0], DefaultDefines.COMMANDS_PRIORITY[0]);
                    this.addCommand(this.command[0]);
                }
                if (stringArray[1] != null) {
                    this.command[1] = new Command(stringArray[1], DefaultDefines.COMMANDS_ID[1], DefaultDefines.COMMANDS_PRIORITY[1]);
                    this.addCommand(this.command[1]);
                }
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.editNameForm) {
            if (command == this.cmdOk) {
                String string = this.editNameForm.getString().replace('\n', ' ').trim();
                if (string.length() > 0) {
                    this.playerName = string;
                    ((Scores)this.forms[20]).setSelectionName(string);
                    this.state = 20;
                    this.app.setScreen((Displayable)this);
                }
            } else if (command == this.cmdCancel) {
                this.state = 20;
                this.app.setScreen((Displayable)this);
            }
        }
    }

    void setSound(boolean bl) {
        Target.soundOn = bl;
        this.soundEntered = true;
        ((Intro)this.forms[2]).setQuestion(false);
        this.keysPressed.removeAllElements();
        this.reinitKeyRepeat();
    }

    protected void paint(Graphics graphics) {
        this.update(graphics);
        repaintFinished = true;
    }

    protected void update(Graphics graphics) {
        try {
            Form form = this.forms[this.state];
            if (form != null) {
                form.paint(graphics);
            }
            switch (this.state) {
                case 0: {
                    Target.getScreenSize(this);
                    break;
                }
                case 1: {
                    if (this.imgLogo == null) break;
                    graphics.setColor(0xFFFFFF);
                    graphics.fillRect(0, 0, Const.SCREEN_WIDTH, Const.SCREEN_HEIGHT);
                    graphics.drawImage(this.imgLogo, Const.SCREEN_WIDTH / 2, Const.SCREEN_HEIGHT / 2, 3);
                    break;
                }
                case 28: {
                    if (pubImage == null) break;
                    int n = form.getLineHeight(DefaultDefines.fontText);
                    int n2 = 1 + pubImage.getHeight() / n;
                    int n3 = form.getFirstLineY();
                    int n4 = Form.getFrameWidth(13);
                    int[] nArray = Form.saveClip(graphics, n4, n3, Const.SCREEN_WIDTH - 2 * n4, form.getMaxTextHeight() - Form.getFrameHeight(13));
                    int n5 = n3 + (n2 * n - pubImage.getHeight()) / 2 - form.viewStart * n;
                    graphics.drawImage(pubImage, Const.SCREEN_WIDTH / 2, n5, 17);
                    Form.restoreClip(graphics, nArray);
                }
            }
        }
        catch (Throwable throwable) {
            App.debugText("Update: ", throwable);
            App.printStackTrace(throwable);
        }
    }

    void loadRMS(boolean bl) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)rmsName, (boolean)false);
            byte[] byArray = recordStore.getRecord(recordStore.getNextRecordID() - 1);
            recordStore.closeRecordStore();
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            boolean bl2 = dataInputStream.readBoolean();
            if (this.demoVersion) {
                this.demoVersion = bl2;
            }
            Target.vibrationOn = dataInputStream.readBoolean();
            localeID = dataInputStream.readByte();
            if (bl) {
                ((Scores)this.forms[20]).load(dataInputStream);
                this.playerName = dataInputStream.readUTF();
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            if (bl) {
                App.debugText("Store not found, create new. ");
                this.saveRMS();
            }
            return;
        }
        catch (Exception exception) {
            App.debugText("Error reading RS:", exception);
        }
    }

    void saveRMS() {
        this.saveRmsNow();
    }

    void saveRmsNow() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(411);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(this.demoVersion);
            dataOutputStream.writeBoolean(Target.vibrationOn);
            dataOutputStream.writeByte(localeID);
            ((Scores)this.forms[20]).save(dataOutputStream);
            dataOutputStream.writeUTF(this.playerName);
            RecordStore recordStore = RecordStore.openRecordStore((String)rmsName, (boolean)true);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = new byte[411];
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, 411));
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray2, 0, 411);
            } else {
                recordStore.setRecord(recordStore.getNextRecordID() - 1, byArray2, 0, 411);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            App.debugText("Error writing RS:", exception);
        }
    }

    public void publicityAction(int n) {
        switch (n) {
            case 2: 
            case 3: {
                if (this.netAction != 4) break;
                ((Scores)this.forms[21]).load();
                if (n == 3) {
                    this.setNextState(21);
                    break;
                }
                this.forms[29].setText(LeaderBoard.Message);
                this.setNextState(29);
                break;
            }
            case 0: 
            case 1: {
                this.setNextState(22);
            }
        }
    }

    void setConnection(int n) {
        Form form;
        if (n == 0 && this.netAction == 4) {
            LeaderBoard.Cancel();
            this.setNextState(8);
            return;
        }
        switch (n) {
            case 1: 
            case 2: {
                form = new Form(31, 24);
                form.setButton(-1, 20);
                form.setup();
                break;
            }
            case 3: {
                form = new Form(47, 46);
                form.setButton(-1, -1);
                form.setup();
                break;
            }
            default: {
                return;
            }
        }
        this.forms[19] = form;
        this.setNextState(19);
        this.netAction = n;
    }

    void networkAction() {
        if (this.skipActionStep > 0) {
            --this.skipActionStep;
            return;
        }
        int n = 0;
        String string = this.playerName;
        switch (this.netAction) {
            case 1: {
                n = ((Scores)this.forms[20]).getScore(0);
                string = ((Scores)this.forms[20]).getName(0);
            }
            case 2: {
                LeaderBoard.sendScore(string, n);
                this.netAction = 4;
                break;
            }
            case 3: {
                this.setNextState(LeaderBoard.sendSMS(App.SMSdata[1], App.SMSdata[2]) ? 26 : 27);
            }
        }
    }

    void switchToFullMode() {
        this.demoVersion = false;
        Const.MENU_MAIN[Const.MENU_MAIN.length - 1][3] = 1;
        this.forms[4] = new Menu(6, Const.MENU_MAIN);
        this.forms[4].setButton(0, 2);
        this.saveRMS();
    }

    static {
        repaintFinished = true;
        needSaving = false;
    }
}

