/*
 * Decompiled with CFR 0.152.
 */
package classes;

import aeMods.Parser;
import classes.Class_7cf;
import classes.GraphicsClass;
import classes.Main;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public final class ResourceLoader {
    public static Texture2D[] texturesMassive;
    private static String[] texturesNames;
    public static byte texturesCount;
    public static boolean[] texturesUsedTwice;
    public static int spriteWidth;
    public static int spriteHeight;

    public static void clearTextures() {
        for (int i = 0; i < 100; i = (int)((byte)(i + 1))) {
            if (texturesUsedTwice[i]) continue;
            ResourceLoader.texturesMassive[i] = null;
            ResourceLoader.texturesNames[i] = "";
        }
        System.gc();
        texturesCount = 0;
    }

    public static void initTexturesMassive() {
        texturesCount = 0;
        texturesUsedTwice = new boolean[100];
        texturesMassive = new Texture2D[100];
        texturesNames = new String[100];
        System.gc();
    }

    private static byte findTextureId(String path) {
        for (byte i = 0; i < 100; i = (byte)((byte)(i + 1))) {
            if (!path.equals(texturesNames[i]) || path.equals("")) continue;
            return i;
        }
        return -1;
    }

    public static Mesh loadZ1Model(String path) throws IOException {
        int i;
        int i2;
        DataInputStream dis = new DataInputStream(((Object)((Object)Main.midlet)).getClass().getResourceAsStream(path));
        dis.readLong();
        dis.readLong();
        int submeshesCount = dis.readByte();
        String[] submeshesTextures = new String[submeshesCount];
        float[] alphaTestSubmesh = new float[submeshesCount];
        byte[] blendingModeSubmesh = new byte[submeshesCount];
        byte[] doubleSidePolygons = new byte[submeshesCount];
        for (int i3 = 0; i3 < submeshesTextures.length; ++i3) {
            char[] texNameChars = new char[dis.readByte()];
            for (int i22 = 0; i22 < texNameChars.length; ++i22) {
                texNameChars[i22] = (char)dis.readByte();
            }
            submeshesTextures[i3] = String.valueOf(texNameChars);
            alphaTestSubmesh[i3] = dis.readByte();
            blendingModeSubmesh[i3] = dis.readByte();
            doubleSidePolygons[i3] = dis.readByte();
        }
        short[] allPositions = new short[dis.readShort() * 3];
        for (int i4 = 0; i4 < allPositions.length; ++i4) {
            allPositions[i4] = dis.readByte();
        }
        short[] allNormals = new short[dis.readShort() * 3];
        for (int i5 = 0; i5 < allNormals.length; ++i5) {
            allNormals[i5] = dis.readByte();
        }
        int uvXAdd = dis.readInt();
        int uvYAdd = dis.readInt();
        int uvScale = dis.readInt();
        short[] allUVs = new short[dis.readShort() * 2];
        for (int i6 = 0; i6 < allUVs.length; ++i6) {
            allUVs[i6] = i6 % 2 == 1 ? (short)(dis.readUnsignedByte() + uvYAdd) : (short)(dis.readUnsignedByte() + uvXAdd);
        }
        int polygonsCount = dis.readShort();
        int[] positionsIds = new int[polygonsCount * 3];
        int[] normalsIds = new int[polygonsCount * 3];
        short[] vertexUVsID = new short[polygonsCount * 3];
        short[] polygonsSubmeshIds = new short[polygonsCount];
        byte[] stripMassive = new byte[polygonsCount];
        for (i2 = 0; i2 < polygonsCount; ++i2) {
            polygonsSubmeshIds[i2] = dis.readByte();
            stripMassive[i2] = dis.readByte();
        }
        for (i2 = 0; i2 < polygonsCount * 3; ++i2) {
            positionsIds[i2] = dis.readShort();
        }
        for (i2 = 0; i2 < polygonsCount * 3; ++i2) {
            normalsIds[i2] = dis.readShort();
        }
        for (i2 = 0; i2 < polygonsCount * 3; ++i2) {
            vertexUVsID[i2] = dis.readShort();
        }
        dis.close();
        short[] positions = new short[polygonsCount * 3 * 3];
        short[] normals = new short[polygonsCount * 3 * 3];
        for (int i7 = 0; i7 < polygonsCount * 3; ++i7) {
            int posId = positionsIds[i7];
            int normId = normalsIds[i7];
            for (int x = 0; x < 3; ++x) {
                positions[i7 * 3 + x] = allPositions[posId * 3 + x];
                normals[i7 * 3 + x] = allNormals[normId * 3 + x];
            }
        }
        Vector<Short> uvsVector = new Vector<Short>();
        for (int i8 = 0; i8 < polygonsCount * 3; ++i8) {
            short uvId = vertexUVsID[i8];
            Short u = new Short(allUVs[uvId * 2 + 0]);
            uvsVector.addElement(u);
            Short v = new Short(allUVs[uvId * 2 + 1]);
            uvsVector.addElement(v);
        }
        VertexArray vertexPositions = new VertexArray(positions.length / 3, 3, 2);
        VertexArray vertexNormals = new VertexArray(positions.length / 3, 3, 2);
        uvsVector.trimToSize();
        short[] uvsMassive = new short[uvsVector.capacity()];
        for (int i9 = 0; i9 < uvsMassive.length; ++i9) {
            Short uv = (Short)uvsVector.elementAt(i9);
            uvsMassive[i9] = uv;
        }
        VertexArray vertexUVS = new VertexArray(uvsMassive.length / 2, 2, 2);
        vertexUVS.set(0, uvsMassive.length / 2, uvsMassive);
        vertexPositions.set(0, positions.length / 3, positions);
        vertexNormals.set(0, positions.length / 3, normals);
        VertexBuffer vb = new VertexBuffer();
        vb.setPositions(vertexPositions, 1.0f, (float[])null);
        vb.setNormals(vertexNormals);
        vb.setTexCoords(0, vertexUVS, (float)uvScale / 1000000.0f, (float[])null);
        IndexBuffer[] indexBufferMassive = new IndexBuffer[submeshesCount];
        Appearance[] appearanceMassive = new Appearance[submeshesCount];
        for (int sbMesh = 0; sbMesh < submeshesCount; ++sbMesh) {
            Short ind;
            Vector<Short> triangleIndixesVector = new Vector<Short>();
            Vector<Short> stripVector = new Vector<Short>();
            for (int i10 = 0; i10 < polygonsCount; i10 = (int)((short)(i10 + 1))) {
                if (sbMesh != polygonsSubmeshIds[i10]) continue;
                ind = new Short((short)(i10 * 3 + 0));
                triangleIndixesVector.addElement(ind);
                ind = new Short((short)(i10 * 3 + 1));
                triangleIndixesVector.addElement(ind);
                ind = new Short((short)(i10 * 3 + 2));
                triangleIndixesVector.addElement(ind);
                ind = new Short(stripMassive[i10]);
                stripVector.addElement(ind);
            }
            triangleIndixesVector.trimToSize();
            int[] triangleIndexes = new int[triangleIndixesVector.capacity()];
            for (int i11 = 0; i11 < triangleIndexes.length; ++i11) {
                ind = (Short)triangleIndixesVector.elementAt(i11);
                triangleIndexes[i11] = ind.shortValue();
            }
            stripVector.trimToSize();
            int[] submeshStripLengths = new int[stripVector.capacity()];
            for (int i12 = 0; i12 < submeshStripLengths.length; ++i12) {
                ind = (Short)stripVector.elementAt(i12);
                submeshStripLengths[i12] = ind.shortValue();
            }
            appearanceMassive[sbMesh] = new Appearance();
            CompositingMode cm = new CompositingMode();
            Material mat = new Material();
            appearanceMassive[sbMesh].setMaterial(mat);
            if (alphaTestSubmesh[sbMesh] == 0.0f) {
                mat.setColor(4096, -1);
            } else if (alphaTestSubmesh[sbMesh] < 0.0f) {
                mat.setShininess(48.0f);
                mat.setColor(8192, -1);
                mat.setColor(2048, -7829368);
            } else {
                cm.setAlphaThreshold(alphaTestSubmesh[sbMesh] / 100.0f);
            }
            if (blendingModeSubmesh[sbMesh] != 0) {
                cm.setBlending((int)blendingModeSubmesh[sbMesh]);
            }
            appearanceMassive[sbMesh].setCompositingMode(cm);
            indexBufferMassive[sbMesh] = new TriangleStripArray(triangleIndexes, submeshStripLengths);
        }
        Mesh mesh = new Mesh(vb, indexBufferMassive, appearanceMassive);
        try {
            for (int i13 = 0; i13 < submeshesCount; ++i13) {
                String textureName = submeshesTextures[i13];
                if (textureName.length() == 0) continue;
                mesh.getAppearance(i13).setTexture(0, ResourceLoader.getTexture(textureName));
                System.gc();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PolygonMode pm = new PolygonMode();
        pm.setPerspectiveCorrectionEnable(true);
        pm.setCulling(doubleSidePolygons[0] == 1 ? 162 : 160);
        for (i = 0; i < submeshesCount; i = (int)((byte)(i + 1))) {
            if (doubleSidePolygons[i] != 1) continue;
            pm.setTwoSidedLightingEnable(true);
            break;
        }
        for (i = 0; i < submeshesCount; ++i) {
            mesh.getAppearance(i).setPolygonMode(pm);
        }
        mesh.setScale(0.1f, 0.1f, 0.1f);
        return mesh;
    }

    public static Texture2D getTexture(String path) {
        Texture2D tex = null;
        try {
            path = Parser.textureLoading(path);
            byte textureId = ResourceLoader.findTextureId(path);
            if (textureId != -1) {
                tex = texturesMassive[textureId];
                ResourceLoader.texturesUsedTwice[textureId] = true;
            } else {
                Image img = Image.createImage((String)("/" + path));
                tex = new Texture2D(new Image2D(100, (Object)img));
                ResourceLoader.texturesNames[ResourceLoader.texturesCount] = path;
                ResourceLoader.texturesMassive[ResourceLoader.texturesCount] = tex;
                texturesCount = (byte)(texturesCount + 1);
            }
            tex.setBlending(227);
            tex.setBlendColor(0);
            Parser.setTextureStuff(tex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tex;
    }

    public static Sprite3D getSprite(int spriteId) {
        String path;
        Image2D img2D = null;
        Texture2D tex = null;
        String string = path = spriteId > -100 ? GraphicsClass.modelsTextures[spriteId] : "blood.png";
        if (spriteId == -101) {
            path = "";
        }
        byte textureId = ResourceLoader.findTextureId(path);
        try {
            if (textureId != -1) {
                tex = texturesMassive[textureId];
                img2D = tex.getImage();
                ResourceLoader.texturesUsedTwice[textureId] = true;
            } else if (spriteId == -101) {
                Image img = Class_7cf.weaponFireImage;
                img2D = new Image2D(100, (Object)img);
                tex = new Texture2D(img2D);
                Parser.setTextureStuff(tex);
            } else {
                path = Parser.textureLoading(path);
                Image img = Image.createImage((String)("/" + path));
                img2D = new Image2D(100, (Object)img);
                tex = new Texture2D(img2D);
                Parser.setTextureStuff(tex);
                ResourceLoader.texturesNames[ResourceLoader.texturesCount] = path;
                ResourceLoader.texturesMassive[ResourceLoader.texturesCount] = tex;
                texturesCount = (byte)(texturesCount + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CompositingMode cm = new CompositingMode();
        if (spriteId == -100) {
            cm.setBlending(64);
        } else if (spriteId == -101) {
            cm.setBlending(65);
        } else {
            cm.setBlending((int)GraphicsClass.spritesBlendModes[spriteId]);
        }
        if (spriteId != -101) {
            cm.setAlphaThreshold(1.0f);
        } else {
            cm.setAlphaThreshold(0.6f);
        }
        Appearance ap = new Appearance();
        ap.setCompositingMode(cm);
        ap.setTexture(0, tex);
        Sprite3D spr = new Sprite3D(true, img2D, ap);
        if (path.indexOf("glare") > -1) {
            spr.scale(1.3f, 1.3f, 1.3f);
        }
        if (spriteId != -100) {
            spriteWidth = ap.getTexture(0).getImage().getWidth();
            spriteHeight = ap.getTexture(0).getImage().getHeight();
        }
        System.gc();
        return spr;
    }

    public static int getSpriteWidth() {
        return spriteWidth;
    }

    public static int getSpriteHeight() {
        return spriteHeight;
    }

    static {
        texturesCount = 0;
    }
}

