/*
 * Decompiled with CFR 0.152.
 */
package cycles;

import accessories.Ammo;
import accessories.Bumb;
import cycles.Cycles;
import game.GNSprite;
import game.Game;
import game.ViewPort;
import groups.Group;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PathEnemey
extends GNSprite {
    static Vector vectorEnemies;
    static PathEnemey temp;
    static int[] xPositions;
    static Random rndX;
    static int maxNotshot;
    static int notShot;
    static int ammoID;
    static int maxAmmoID;
    private static boolean testedLastEnemy;
    int sp = 9;
    int direction = 12;
    Vector vectorDirections;
    int maxPeriod = 3;
    int movedPeriod = 0;
    boolean started = false;
    int index = 0;
    int health = 1;
    int IDGroup;

    public static void create() {
        vectorEnemies = new Vector();
        xPositions = new int[]{ViewPort.WIDTH / 4, ViewPort.WIDTH / 2};
        rndX = new Random();
    }

    public static void clean() {
        vectorEnemies = null;
        xPositions = null;
        rndX = null;
    }

    public static int rndX() {
        int r = rndX.nextInt() % 2;
        if (r < 0) {
            r *= -1;
        }
        return xPositions[r];
    }

    public static int randomAmmo() {
        if (vectorEnemies.size() == 0) {
            return -1;
        }
        int r = rndX.nextInt() % (maxAmmoID + 1);
        if (r < 0) {
            r *= -1;
        }
        return r;
    }

    public static void generate() {
        if (!Cycles.canGenerate) {
            return;
        }
        testedLastEnemy = false;
        notShot = 0;
        Image rndImg = Group.randomImage();
        int x = PathEnemey.rndX();
        int width = rndImg.getWidth();
        int height = rndImg.getHeight();
        temp = new PathEnemey(rndImg, width, height, 0);
        temp.setPosition(x, -height + 5);
        vectorEnemies.addElement(temp);
        Game.addElement(temp);
        temp = new PathEnemey(rndImg, width, height, 1);
        temp.setPosition(x, -2 * (height + 5));
        vectorEnemies.addElement(temp);
        Game.addElement(temp);
        temp = new PathEnemey(rndImg, width, height, 2);
        temp.setPosition(x, -3 * (height + 5));
        vectorEnemies.addElement(temp);
        Game.addElement(temp);
        temp = new PathEnemey(rndImg, width, height, 3);
        temp.setPosition(x, -4 * (height + 5));
        vectorEnemies.addElement(temp);
        Game.addElement(temp);
        temp = new PathEnemey(rndImg, width, height, 4);
        temp.setPosition(x, -5 * (height + 5));
        vectorEnemies.addElement(temp);
        Game.addElement(temp);
        temp = new PathEnemey(rndImg, width, height, 5);
        temp.setPosition(x, -6 * (height + 5));
        vectorEnemies.addElement(temp);
        Game.addElement(temp);
        temp = new PathEnemey(rndImg, width, height, 6);
        temp.setPosition(x, -7 * (height + 5));
        vectorEnemies.addElement(temp);
        Game.addElement(temp);
        temp = new PathEnemey(rndImg, width, height, 7);
        temp.setPosition(x, -8 * (height + 5));
        vectorEnemies.addElement(temp);
        Game.addElement(temp);
    }

    public static void cycleAll() {
        if (notShot == 0) {
            ammoID = PathEnemey.randomAmmo();
        }
        ++notShot;
        for (int j = 0; j < vectorEnemies.size(); ++j) {
            ((PathEnemey)vectorEnemies.elementAt(j)).cycle();
        }
        PathEnemey.testLastEnemyPlace();
    }

    private static void testLastEnemyPlace() {
        if (testedLastEnemy) {
            return;
        }
        if (vectorEnemies.size() == 0) {
            return;
        }
        try {
            PathEnemey pathEnemey = (PathEnemey)vectorEnemies.lastElement();
            if (pathEnemey.getY() > 320) {
                Cycles.canGenerate = true;
                testedLastEnemy = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void drawAll(Graphics g) {
        for (int j = 0; j < vectorEnemies.size(); ++j) {
            ((PathEnemey)vectorEnemies.elementAt(j)).draw(g);
        }
    }

    public static void removeEnemy(PathEnemey enemy) {
        vectorEnemies.removeElement(enemy);
        Game.removeElement(enemy);
        if (vectorEnemies.size() == 0 && !testedLastEnemy) {
            Cycles.canGenerate = true;
        }
    }

    public PathEnemey(Image img, int width, int height, int Id) {
        super(img, width, height);
        this.IDGroup = Id;
        this.vectorDirections = new Vector();
        this.vectorDirections.addElement(new Integer(14));
        this.vectorDirections.addElement(new Integer(15));
        this.vectorDirections.addElement(new Integer(12));
        this.vectorDirections.addElement(new Integer(11));
        this.vectorDirections.addElement(new Integer(10));
        this.vectorDirections.addElement(new Integer(9));
        this.vectorDirections.addElement(new Integer(12));
    }

    public void cycle() {
        if (!this.started) {
            if (this.getY() < -this.getHeight()) {
                this.move();
                return;
            }
            this.started = true;
            this.direction = (Integer)this.vectorDirections.elementAt(this.index);
            maxAmmoID = this.IDGroup;
        }
        if (this.collidesWith(Game.player, true)) {
            Game.player.hit(5);
            PathEnemey.removeEnemy(this);
            return;
        }
        if (notShot >= maxNotshot && ammoID == this.IDGroup) {
            notShot = 0;
        }
        ++this.movedPeriod;
        if (this.movedPeriod >= this.maxPeriod) {
            this.movedPeriod = 0;
            ++this.index;
            if (this.index > this.vectorDirections.size() - 1) {
                this.index = 0;
            }
        }
        this.direction = (Integer)this.vectorDirections.elementAt(this.index);
        this.move();
        if (this.getY() > ViewPort.HEIGHT) {
            PathEnemey.removeEnemy(this);
        }
    }

    public void move() {
        int errorX = Math.abs(this.tempX - this.getX() * 1000);
        int errorY = Math.abs(this.tempY - this.getY() * 1000);
        if (errorX > 1000 || errorY > 1000) {
            this.tempX = this.getX() * 1000;
            this.tempY = this.getY() * 1000;
        }
        this.tempX += this.sp * Game.cos[this.direction];
        this.tempY -= this.sp * Game.sin[this.direction];
        this.setPosition(this.tempX / 1000, this.tempY / 1000);
    }

    public void hit(Ammo ammo) {
        ++Game.player.score;
        this.health -= ammo.type.healthEffect;
        if (this.health <= 0) {
            Bumb.generateOnCondition(Bumb.TYPE1, this.getX() - Math.abs(this.getWidth() - Bumb.TYPE1.width) / 2, this.getY());
            PathEnemey.removeEnemy(this);
        }
    }

    static {
        maxNotshot = 5;
        notShot = 0;
        maxAmmoID = 0;
    }
}

