/*
 * Decompiled with CFR 0.152.
 */
package game;

import accessories.Ammo;
import accessories.Bumb;
import game.ControlPlayer;
import game.Game;
import game.Main;
import game.Setting;
import game.SoundsPlayer;
import game.ViewPort;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Player
extends Sprite {
    public static final byte WEAPON_MAIN = 0;
    public static final byte WEAPON_BONUS = 1;
    private static ControlPlayer control;
    int notShot = 0;
    int maxNotShot = 5;
    public static Image img;
    public static Image img2;
    public static Image imgHealth;
    public static Sprite spriteHealth;
    public int health = 100;
    public int score = 0;
    public int weapon = 0;
    boolean weaponLastDrawn = false;
    byte weaponAnimatetime = 0;
    public int weaponBonusValue = 200;
    int noRightLeftTime;
    int movingRightTime;
    int movingLeftTime;
    int bumbedTime = 0;
    private int sp;
    private int bumbed = 5;
    private int changeWeaponCounter;
    int[] colorHealth = new int[]{13835776, 13848320, 13857280, 13864960, 0xD0D300, 11129600, 8901376, 7731466, 5110026, 719114};

    public static Player create() {
        Player player = null;
        try {
            img = Image.createImage((String)"/player.png");
            img2 = Image.createImage((String)"/player2.png");
            imgHealth = Image.createImage((String)"/splashes/health.png");
            control = new ControlPlayer();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        player = new Player(img, img.getWidth() / 3, img.getHeight() / 3);
        player.sp = 10;
        player.setPosition(ViewPort.WIDTH / 2 - player.getWidth() / 2, ViewPort.HEIGHT - player.getHeight() - 100);
        spriteHealth = new Sprite(imgHealth, imgHealth.getWidth() / 20, imgHealth.getHeight());
        spriteHealth.setPosition(0, 0);
        return player;
    }

    public void setPosition(int x, int y) {
        super.setPosition(x, y);
        control.setPosition(x - 10, y + this.getHeight());
    }

    public void setControlVisible(boolean visible) {
        control.setVisible(visible);
    }

    public static void clean() {
        img = null;
        img2 = null;
        imgHealth = null;
        spriteHealth = null;
        control = null;
    }

    public Player(Image img, int width, int height) {
        super(img, width, height);
    }

    public void input(int keyState) {
        if ((keyState & 4) != 0) {
            this.moveLeft();
        } else if ((keyState & 0x20) != 0) {
            this.moveRight();
        } else if ((keyState & 2) != 0) {
            this.moveUp();
        } else if ((keyState & 0x40) != 0) {
            this.moveDown();
        }
    }

    public void moveRight() {
        this.noRightLeftTime = 0;
        this.movingLeftTime = 0;
        ++this.movingRightTime;
        this.setPosition(this.getX() + this.sp, this.getY());
        if (this.getX() + this.getWidth() > ViewPort.WIDTH) {
            this.setPosition(this.getX() - this.sp, this.getY());
        }
    }

    public void moveLeft() {
        this.noRightLeftTime = 0;
        ++this.movingLeftTime;
        this.movingRightTime = 0;
        this.setPosition(this.getX() - this.sp, this.getY());
        if (this.getX() < 0) {
            this.setPosition(this.getX() + this.sp, this.getY());
        }
    }

    public void moveUp() {
        this.setPosition(this.getX(), this.getY() - this.sp);
        if (this.getY() < 0) {
            this.setPosition(this.getX(), this.getY() + this.sp);
        }
    }

    public void moveDown() {
        this.setPosition(this.getX(), this.getY() + this.sp);
        if (this.getY() + this.getHeight() > ViewPort.HEIGHT) {
            this.setPosition(this.getX(), this.getY() - this.sp);
        }
    }

    public void move(int dx, int dy) {
        this.setPosition(this.getX() + dx, this.getY() + dy);
        if (this.getX() + this.getWidth() > ViewPort.WIDTH || this.getX() < 0) {
            this.setPosition(this.getX() - dx, this.getY());
        }
        if (this.getY() + this.getHeight() > ViewPort.HEIGHT || this.getY() < 0) {
            this.setPosition(this.getX(), this.getY() - dy);
        }
    }

    public void fire() {
        if (this.notShot < this.maxNotShot) {
            return;
        }
        if (this.weapon == 0) {
            Ammo.generate(this.getX() + (this.getWidth() / 2 - Ammo.TYPE1.width / 2) - 5, this.getY() - Ammo.TYPE1.height, Ammo.TYPE1, 0, 4);
            Ammo.generate(this.getX() + (this.getWidth() / 2 - Ammo.TYPE1.width / 2) + 5, this.getY() - Ammo.TYPE1.height, Ammo.TYPE1, 0, 4);
        } else {
            Ammo.generate(this.getX() + 20, this.getY() - Ammo.TYPE6.height + 15, Ammo.TYPE6, 0, 4);
            Ammo.generate(this.getX() - 5 + this.getWidth() / 2, this.getY() - Ammo.TYPE6.height, Ammo.TYPE6, 0, 4);
            Ammo.generate(this.getX() + this.getWidth() - 30, this.getY() - Ammo.TYPE6.height + 15, Ammo.TYPE6, 0, 4);
        }
        this.notShot = 0;
    }

    public void hit(int effect) {
        if (this.bumbedTime > 0) {
            return;
        }
        SoundsPlayer.getInstance().playerSound();
        if (Setting.Vibrate) {
            Main.display.vibrate(50);
        }
        this.health -= (Setting.Mode + 1) * effect;
        if (this.health < 0) {
            this.health = 0;
        }
        this.bumbed = 0;
        if (this.health <= 0) {
            Game.levelFinished = true;
            ++this.bumbedTime;
            Bumb.generate(Bumb.TYPE2, this.getX() - Math.abs(this.getWidth() - Bumb.TYPE2.width) / 2, this.getY());
        }
    }

    public void cycleWeapon() {
        if (this.changeWeaponCounter > 0) {
            --this.changeWeaponCounter;
        }
        this.weaponAnimatetime = (byte)(this.weaponAnimatetime + 1);
        if (this.weaponAnimatetime > 5) {
            this.weaponLastDrawn = !this.weaponLastDrawn;
            this.weaponAnimatetime = 0;
        }
        if (this.weaponBonusValue > 0) {
            --this.weaponBonusValue;
        }
        this.weapon = this.weaponBonusValue <= 0 ? 0 : 1;
    }

    public void bonusHealth(int bonus) {
        this.health += bonus;
        if (this.health > 100) {
            this.health = 100;
        }
    }

    public void bonusWeapon() {
        this.weaponBonusValue += 150;
    }

    public void changeWeapon() {
        if (this.changeWeaponCounter > 0) {
            return;
        }
        this.changeWeaponCounter = 20;
        if (this.weapon == 1) {
            this.weapon = 0;
        } else if (this.weaponBonusValue > 0) {
            this.weapon = 1;
        }
    }

    public void cycle() {
        if (this.bumbedTime > 0) {
            if (this.bumbedTime == 1) {
                this.setImage(img2, img2.getWidth() / 3, img.getHeight() / 3);
            }
            ++this.bumbedTime;
            if (this.bumbedTime == 10 || this.bumbedTime == 20 || this.bumbedTime == 30 || this.bumbedTime == 40) {
                Bumb.generate(Bumb.TYPE2, this.getX() - Math.abs(this.getWidth() - Bumb.TYPE2.width) / 2, this.getY());
            } else if (this.bumbedTime > 50) {
                Main.gameOver();
            }
            return;
        }
        control.cycle();
        ++this.noRightLeftTime;
        this.noRightLeftTime %= 10;
        if (this.noRightLeftTime >= 2) {
            this.movingLeftTime = 0;
            this.movingRightTime = 0;
        }
        ++this.notShot;
        ++this.bumbed;
        if (this.bumbed > 100) {
            this.bumbed = 100;
        }
        if (this.bumbed == 1) {
            this.setImage(img2, img2.getWidth() / 3, img2.getHeight() / 3);
        } else if (this.bumbed == 5) {
            this.setImage(img, img.getWidth() / 3, img.getHeight() / 3);
        }
        this.cycleWeapon();
    }

    public void draw(Graphics g) {
        if (this.movingLeftTime > 3) {
            this.setFrame(2);
        } else if (this.movingLeftTime > 6) {
            this.setFrame(1);
        } else if (this.movingLeftTime > 10) {
            this.setFrame(0);
        } else if (this.movingRightTime > 3) {
            this.setFrame(5);
        } else if (this.movingRightTime > 6) {
            this.setFrame(6);
        } else if (this.movingRightTime > 10) {
            this.setFrame(7);
        } else {
            this.setFrame(4);
        }
        super.paint(g);
        this.drawHealth(g);
        this.drawWaeapons(g);
        control.draw(g);
    }

    public void drawHealth(Graphics g) {
        int frameIndex = this.health / 5;
        if (this.health % 5 == 0 && this.health != 0) {
            --frameIndex;
        }
        spriteHealth.setFrame(frameIndex);
        spriteHealth.paint(g);
    }

    public void drawWaeapons(Graphics g) {
        int w1 = Ammo.imageType1.getWidth();
        int w2 = Ammo.imageType6.getWidth();
        int y1 = Ammo.imageType1.getHeight();
        int y2 = Ammo.imageType6.getHeight();
        if (this.weapon == 0 && !this.weaponLastDrawn || this.weapon != 0) {
            g.drawImage(Ammo.imageType1, ViewPort.WIDTH / 2, y2 - y1, 0);
            g.drawImage(Ammo.imageType1, ViewPort.WIDTH / 2 + w1, y2 - y1, 0);
        }
        if ((this.weapon == 1 && !this.weaponLastDrawn || this.weapon != 1) && this.weaponBonusValue > 0) {
            for (int j = 0; j < this.weaponBonusValue + 200; j += 200) {
                g.drawImage(Ammo.imageType6, ViewPort.WIDTH / 2 + 2 * w1 + 2 + j / 200 * (w2 - 5), 1, 0);
            }
        }
    }
}

