/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.ViewPort;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Score {
    private Sprite spriteDigits;
    private Image imgScore;
    private Sprite spriteCheckPoint;
    private int checkPointTime = -1;

    public Score() {
        try {
            this.imgScore = Image.createImage((String)"/splashes/score.png");
            Image img = Image.createImage((String)"/splashes/digits.png");
            this.spriteDigits = new Sprite(img, img.getWidth() / 11, img.getHeight());
            this.spriteCheckPoint = new Sprite(Image.createImage((String)"/check.png"));
            this.spriteCheckPoint.setPosition(ViewPort.WIDTH / 2 - this.spriteCheckPoint.getWidth() / 2, 40);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public void draw(Graphics g, int score) {
        if (score % 20 == 0 && this.checkPointTime < 0) {
            this.checkPointTime = 0;
        }
        if (this.checkPointTime >= 0) {
            this.spriteCheckPoint.paint(g);
            ++this.checkPointTime;
        }
        if (this.checkPointTime > 20) {
            this.checkPointTime = -5;
        }
        g.drawImage(this.imgScore, ViewPort.WIDTH - this.imgScore.getWidth(), 0, 20);
        String str = "" + score;
        switch (str.length()) {
            case 1: {
                this.draw1(g, str);
                break;
            }
            case 2: {
                this.draw2(g, str);
            }
        }
    }

    private void draw1(Graphics g, String str) {
        this.spriteDigits.setFrame(10);
        int x = ViewPort.WIDTH - this.imgScore.getWidth() + 6;
        int y = 15;
        y = 23;
        this.spriteDigits.setPosition(x + this.spriteDigits.getWidth(), y);
        this.spriteDigits.paint(g);
        int digit = Integer.parseInt(str);
        this.drawDigit(g, digit, x, y);
    }

    private void draw2(Graphics g, String str) {
        this.spriteDigits.setFrame(10);
        int x = ViewPort.WIDTH - this.imgScore.getWidth() + 6;
        int y = 15;
        y = 23;
        this.spriteDigits.setPosition(x + 2 * this.spriteDigits.getWidth(), y);
        this.spriteDigits.paint(g);
        int digit = Integer.parseInt(str.substring(0, 1));
        this.drawDigit(g, digit, x, y);
        digit = Integer.parseInt(str.substring(1));
        this.drawDigit(g, digit, x + this.spriteDigits.getWidth(), y);
    }

    private void drawDigit(Graphics g, int digit, int x, int y) {
        switch (digit) {
            case 0: {
                this.spriteDigits.setFrame(0);
                break;
            }
            case 1: {
                this.spriteDigits.setFrame(1);
                break;
            }
            case 2: {
                this.spriteDigits.setFrame(2);
                break;
            }
            case 3: {
                this.spriteDigits.setFrame(3);
                break;
            }
            case 4: {
                this.spriteDigits.setFrame(4);
                break;
            }
            case 5: {
                this.spriteDigits.setFrame(5);
                break;
            }
            case 6: {
                this.spriteDigits.setFrame(6);
                break;
            }
            case 7: {
                this.spriteDigits.setFrame(7);
                break;
            }
            case 8: {
                this.spriteDigits.setFrame(8);
                break;
            }
            case 9: {
                this.spriteDigits.setFrame(9);
            }
        }
        this.spriteDigits.setPosition(x, y);
        this.spriteDigits.paint(g);
    }
}

