/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Drawable;
import javax.microedition.lcdui.game.GameCanvas;

public class ViewPort {
    public static int WIDTH;
    public static int HEIGHT;
    public static int XMAP;
    public static int YMAP;
    public static final int MAP_WIDTH = 240;
    public static final int MAP_HEIGHT = 1800;

    public static boolean isBelongToView(Drawable object) {
        return object.getX() + object.getWidth() >= 0 && object.getX() <= WIDTH && object.getY() + object.getHeight() >= 0 && object.getY() <= HEIGHT;
    }

    public static boolean wentOutOfView(Drawable object) {
        return object.getX() <= 0 || object.getX() + object.getWidth() >= WIDTH || object.getY() <= 0 || object.getY() + object.getHeight() >= HEIGHT;
    }

    public static int getScreenX(int xMap) {
        int x = xMap - XMAP;
        return x;
    }

    public static int getScreenY(int yMap) {
        int y = yMap - YMAP;
        return y;
    }

    public static void cycle() {
        --YMAP;
    }

    public static void setViewPort() {
        ViewArea any = new ViewArea();
        HEIGHT = any.getHeight();
        WIDTH = any.getWidth();
        if (WIDTH > HEIGHT) {
            WIDTH = any.getHeight();
            HEIGHT = any.getWidth();
        }
        YMAP = 1800 - HEIGHT;
        XMAP = (240 - WIDTH) / 2;
    }

    public static int getCurveStep(int length) {
        int step = 0;
        step = length % 180 == 0 ? length / 180 : length / 180 + 1;
        return step;
    }

    public static int getCurveStart(int length, int step) {
        int start = (step * 180 - length) / 2 * -1;
        return start;
    }

    static class ViewArea
    extends GameCanvas {
        public ViewArea() {
            super(true);
            this.setFullScreenMode(true);
        }
    }
}

