/*
 * Decompiled with CFR 0.152.
 */
package groups;

import accessories.Ammo;
import accessories.Bumb;
import game.GNSprite;
import game.Game;
import game.Main;
import game.ViewPort;
import groups.Group;
import javax.microedition.lcdui.Image;

public class SmallEnemy
extends GNSprite {
    int prevX;
    int prevY;
    boolean arrivedPlannedPlace;
    int plannedX;
    int plannedY;
    int groupID;
    int health = 2;
    int sp = 8;
    int direction;
    Group myGroup;
    int maxNotShot = 20;
    int notShot = 0;

    public SmallEnemy(Image img, int groupID, Group myGroup) {
        super(img, img.getWidth(), img.getHeight());
        this.groupID = groupID;
        this.myGroup = myGroup;
        this.setMaxNotShot();
    }

    private void setMaxNotShot() {
        this.maxNotShot = Main.random(30);
        if (this.maxNotShot < 15) {
            this.maxNotShot *= 3;
        }
    }

    public void setPosition(int x, int y) {
        this.prevX = this.getX();
        this.prevY = this.getY();
        super.setPosition(x, y);
    }

    public void setPlannedXY(int plannedX, int plannedY, int direction) {
        this.plannedX = plannedX;
        this.plannedY = plannedY;
        this.direction = direction;
    }

    public void cycle() {
        if (this.collidesWith(Game.player, true)) {
            Game.player.hit(5);
            this.myGroup.removeEnemy(this);
            return;
        }
        if (!this.arrivedPlannedPlace || this.myGroup.startedBehavior) {
            this.move();
        }
        if (this.getY() > ViewPort.HEIGHT) {
            this.myGroup.removeEnemy(this);
            return;
        }
        ++this.notShot;
        if (ViewPort.isBelongToView(this) && this.notShot >= this.maxNotShot) {
            Ammo.generate(this.getX() + this.getWidth() / 2 - Ammo.TYPE2.width / 2, this.getY(), Ammo.TYPE2, 1, 12);
            this.notShot = 0;
            this.setMaxNotShot();
        }
        if ((this.plannedX >= this.prevX && this.plannedX <= this.getX() || this.plannedX <= this.prevX && this.plannedX >= this.getX()) && (this.plannedY >= this.prevY && this.plannedY <= this.getY() || this.plannedY <= this.prevY && this.plannedY >= this.getY())) {
            this.arrivedPlannedPlace = true;
        }
    }

    public void move() {
        if (this.myGroup.startedBehavior && this.direction == 12) {
            ++this.sp;
        }
        int errorX = Math.abs(this.tempX - this.getX() * 1000);
        int errorY = Math.abs(this.tempY - this.getY() * 1000);
        if (errorX > 1000 || errorY > 1000) {
            this.tempX = this.getX() * 1000;
            this.tempY = this.getY() * 1000;
        }
        this.tempX += this.sp * Game.cos[this.direction];
        this.tempY -= this.sp * Game.sin[this.direction];
        this.setPosition(this.tempX / 1000, this.tempY / 1000);
    }

    public void hit(Ammo ammo) {
        ++Game.player.score;
        this.health -= ammo.type.healthEffect;
        if (this.health <= 0) {
            Bumb.generateOnCondition(Bumb.TYPE1, this.getX() - Math.abs(this.getWidth() - Bumb.TYPE1.width) / 2, this.getY());
            this.myGroup.removeEnemy(this);
        }
    }
}

