/*
 * Decompiled with CFR 0.152.
 */
package level2.planes;

import accessories.Ammo;
import accessories.Bumb;
import game.GNSprite;
import game.Game;
import game.ViewPort;
import java.util.Random;
import javax.microedition.lcdui.Image;
import level2.planes.PlaneGroupLevel2;

public class PlaneEnemyLevel2
extends GNSprite {
    public final int TYPE0;
    public final int TYPE1;
    public final int TYPE2;
    private PlaneGroupLevel2 planeGroup;
    private int sp = 5;
    private int health = 3;
    private int ammoCounter;
    private int type;
    private Random random;

    public PlaneEnemyLevel2(Image image, int width, int height, PlaneGroupLevel2 planeGroup, int type) {
        super(image, width, height);
        this.TYPE0 = 0;
        this.TYPE1 = 1;
        this.TYPE2 = 2;
        this.planeGroup = planeGroup;
        this.type = type;
        this.random = new Random();
        this.setAmmoCounter();
    }

    public void cycle() {
        if (this.collidesWith(Game.player, true)) {
            this.planeGroup.removeEnemy(this);
            Game.player.hit(5);
            Bumb.generate(Bumb.TYPE3, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE3.width) / 2, this.getY() + Math.abs(this.getHeight() - Bumb.TYPE3.height) / 2);
            return;
        }
        this.setPosition(this.getX(), this.getY() + this.sp);
        if (this.exitedView()) {
            this.planeGroup.removeEnemy(this);
        }
        if (this.ammoCounter == 0 && this.getY() >= this.getHeight() / 2) {
            this.generateAmmo();
            this.setAmmoCounter();
        }
        if (this.ammoCounter != 0) {
            --this.ammoCounter;
        }
    }

    private void setAmmoCounter() {
        this.ammoCounter = this.planeGroup.getAmmoCounter();
    }

    public void generateAmmo() {
        Ammo.generate(this.getX() + this.getWidth() / 2 - Ammo.TYPE11.width / 2, this.getY() + this.getHeight() / 2, Ammo.TYPE11, 1, 12);
    }

    public boolean exitedView() {
        return this.getY() > ViewPort.HEIGHT;
    }

    public void hit(Ammo ammo) {
        ++Game.player.score;
        this.health -= ammo.type.healthEffect;
        if (this.health <= 0) {
            Bumb.generate(Bumb.TYPE3, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE3.width) / 2, this.getY() + Math.abs(this.getHeight() - Bumb.TYPE3.height) / 2);
            this.planeGroup.removeEnemy(this);
        }
    }
}

