/*
 * Decompiled with CFR 0.152.
 */
package level3.enemieammo;

import accessories.Ammo;
import accessories.Bumb;
import game.GNSprite;
import game.Game;
import game.ViewPort;
import java.util.Random;
import javax.microedition.lcdui.Image;
import level3.enemieammo.EnemyAmmoController;

public class EnemyAmmo
extends GNSprite {
    EnemyAmmoController enemyAmmoController;
    int spY = 1;
    int spX = 1;
    int dx = 0;
    int changeCounter = 0;
    private Random random;
    private int ammoCounter;
    private int hitCounter;
    private int frameNumber;
    int health = 25;

    public EnemyAmmo(Image image, int width, int height, EnemyAmmoController enemyAmmoController) {
        super(image, width, height);
        this.enemyAmmoController = enemyAmmoController;
        this.random = new Random();
    }

    public void cycle() {
        this.frameNumber = (this.frameNumber + 1) % 5;
        if (this.hitCounter != 0) {
            this.setFrame(this.frameNumber + 5);
        } else {
            this.setFrame(this.frameNumber);
        }
        if (this.collidesWith(Game.player, true)) {
            this.enemyAmmoController.removeEnemy(this);
            Game.player.hit(5);
            Bumb.generate(Bumb.TYPE3, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE3.width) / 2, this.getY() + Math.abs(this.getHeight() - Bumb.TYPE3.height) / 2);
            return;
        }
        if (this.exitedView()) {
            this.enemyAmmoController.removeEnemy(this);
            return;
        }
        this.move();
        if (this.ammoCounter == 0 && this.getY() >= this.getHeight() / 2) {
            this.generateAmmo();
            this.ammoCounter = (this.random.nextInt(4) + 1) * 20;
        }
        if (this.ammoCounter != 0) {
            --this.ammoCounter;
        }
    }

    public void generateAmmo() {
        Ammo.generate(this.getX() + this.getWidth() / 2 - Ammo.TYPE8.width / 2, this.getY() + this.getHeight(), Ammo.TYPE8, 1, 12);
        Ammo.generate(this.getX(), this.getY() + this.getHeight(), Ammo.TYPE8, 1, 10);
        Ammo.generate(this.getX() + this.getWidth(), this.getY() + this.getHeight(), Ammo.TYPE8, 1, 14);
        Ammo.generate(this.getX() + this.getWidth() / 2 - Ammo.TYPE8.width / 2, this.getY() - Ammo.TYPE8.height, Ammo.TYPE8, 1, 4);
        Ammo.generate(this.getX(), this.getY() - Ammo.TYPE8.height, Ammo.TYPE8, 1, 6);
        Ammo.generate(this.getX() + this.getWidth(), this.getY() - Ammo.TYPE8.height, Ammo.TYPE8, 1, 2);
    }

    public void hit(Ammo ammo) {
        ++Game.player.score;
        this.health -= ammo.type.healthEffect;
        if (this.health <= 0) {
            Bumb.generate(Bumb.TYPE3, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE3.width) / 2, this.getY() + Math.abs(this.getHeight() - Bumb.TYPE3.height) / 2);
            this.enemyAmmoController.removeEnemy(this);
        }
        if (this.hitCounter == 0) {
            this.hitCounter = 2;
        }
    }

    boolean exitedView() {
        return this.getY() > ViewPort.HEIGHT;
    }

    void move() {
        if (this.hitCounter != 0) {
            if (this.hitCounter == 2) {
                this.setPosition(this.getX(), this.getY() - 2 * this.spY);
            } else {
                this.setPosition(this.getX(), this.getY() + 2 * this.spY);
            }
            --this.hitCounter;
            return;
        }
        this.setPosition(this.getX(), this.getY() + this.spY);
        if (this.changeCounter == 0) {
            int rn;
            this.changeCounter = 20;
            this.dx = this.getX() < 0 ? this.spX : (this.getX() + this.getWidth() > ViewPort.WIDTH ? -this.spX : ((rn = this.random.nextInt(2)) == 0 ? this.spX : -this.spX));
        } else {
            --this.changeCounter;
        }
        this.setPosition(this.getX() + this.dx, this.getY());
    }
}

