/*
 * Decompiled with CFR 0.152.
 */
package level3.planes;

import game.Game;
import game.ViewPort;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import level3.planes.PlaneEnemy;

public class PlaneGroup {
    private Image[] arrImages;
    private Random random;
    private Vector vecEnemies;
    private boolean canGenerate = true;
    private boolean testedLastEnemy;

    public PlaneGroup(Image[] arrImages) {
        this.arrImages = arrImages;
        this.vecEnemies = new Vector();
        this.random = new Random();
    }

    public void generate() {
        if (!this.canGenerate) {
            return;
        }
        this.canGenerate = false;
        this.testedLastEnemy = false;
        int rnd = this.random.nextInt(7);
        switch (rnd) {
            case 0: {
                this.generate0();
                break;
            }
            case 1: {
                this.generate1();
                break;
            }
            case 2: {
                this.generate2();
                break;
            }
            case 3: {
                this.generate3();
                break;
            }
            case 4: {
                this.generate4();
                break;
            }
            case 5: {
                this.generate5();
            }
        }
    }

    private void generate0() {
        int type = this.random.nextInt(3);
        PlaneEnemy planeEnemy = new PlaneEnemy(this.arrImages[type], this.arrImages[type].getWidth(), this.arrImages[type].getHeight(), this, type);
        Game.addElement(planeEnemy);
        this.vecEnemies.addElement(planeEnemy);
        planeEnemy.setPosition(ViewPort.WIDTH / 2 - planeEnemy.getWidth() / 2, -planeEnemy.getHeight());
    }

    private void generate1() {
        int type = this.random.nextInt(3);
        PlaneEnemy planeEnemy = new PlaneEnemy(this.arrImages[type], this.arrImages[type].getWidth(), this.arrImages[type].getHeight(), this, type);
        Game.addElement(planeEnemy);
        this.vecEnemies.addElement(planeEnemy);
        planeEnemy.setPosition(30, -planeEnemy.getHeight());
    }

    private void generate2() {
        int type = this.random.nextInt(3);
        PlaneEnemy planeEnemy = new PlaneEnemy(this.arrImages[type], this.arrImages[type].getWidth(), this.arrImages[type].getHeight(), this, type);
        Game.addElement(planeEnemy);
        this.vecEnemies.addElement(planeEnemy);
        planeEnemy.setPosition(ViewPort.WIDTH - planeEnemy.getWidth() - 30, -planeEnemy.getHeight());
    }

    private void generate3() {
        this.generate0();
        this.generate1();
    }

    private void generate4() {
        this.generate0();
        this.generate2();
    }

    private void generate5() {
        this.generate1();
        this.generate2();
    }

    public void cycle() {
        if (this.vecEnemies.size() == 0 && !this.testedLastEnemy) {
            this.canGenerate = true;
            return;
        }
        for (int j = this.vecEnemies.size() - 1; j >= 0; --j) {
            ((PlaneEnemy)this.vecEnemies.elementAt(j)).cycle();
        }
        this.testLastEnemyPlace();
    }

    private void testLastEnemyPlace() {
        if (this.testedLastEnemy) {
            return;
        }
        if (this.vecEnemies.size() == 0) {
            return;
        }
        try {
            PlaneEnemy planeEnemy = (PlaneEnemy)this.vecEnemies.lastElement();
            if (planeEnemy.getY() > 320) {
                this.canGenerate = true;
                this.testedLastEnemy = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void draw(Graphics g) {
        for (int j = this.vecEnemies.size() - 1; j >= 0; --j) {
            ((PlaneEnemy)this.vecEnemies.elementAt(j)).paint(g);
        }
    }

    public void removeEnemy(PlaneEnemy enemy) {
        this.vecEnemies.removeElement(enemy);
        Game.removeElement(enemy);
    }
}

