/*
 * Decompiled with CFR 0.152.
 */
package level4;

import game.Game;
import game.ViewPort;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import level4.Enemy1;

public class Enemy1Control {
    private Image image1;
    private Image image2;
    private Random random;
    private Vector vecEnemies;
    private boolean canGenerate = true;
    private int generateCounter;
    private int width;
    private int height;
    private boolean testedLastEnemy;

    public Enemy1Control(Image image1, Image image2) {
        this.image1 = image1;
        this.image2 = image2;
        this.vecEnemies = new Vector();
        this.random = new Random();
        this.width = image1.getWidth() / 3;
        this.height = image1.getHeight() / 4;
    }

    public void generate() {
        if (!this.canGenerate || this.generateCounter > 0) {
            if (this.generateCounter > 0) {
                --this.generateCounter;
            }
            return;
        }
        this.canGenerate = false;
        this.testedLastEnemy = false;
        this.generateCounter = 0;
        Image img = null;
        int rnd = this.random.nextInt(2);
        img = rnd == 0 ? this.image1 : this.image2;
        rnd = this.random.nextInt(3);
        rnd = 0;
        switch (rnd) {
            case 0: {
                this.generate0(img);
                break;
            }
            case 1: {
                this.generate1(img);
                break;
            }
            case 2: {
                this.generate2(img);
            }
        }
    }

    public void cycle() {
        for (int j = this.vecEnemies.size() - 1; j >= 0; --j) {
            ((Enemy1)this.vecEnemies.elementAt(j)).cycle();
        }
        this.testLastEnemyPlace();
    }

    private void testLastEnemyPlace() {
        if (this.testedLastEnemy) {
            return;
        }
        if (this.vecEnemies.size() == 0) {
            return;
        }
        try {
            Enemy1 enemy1 = (Enemy1)this.vecEnemies.lastElement();
            if (enemy1.getY() > 320) {
                this.canGenerate = true;
                this.testedLastEnemy = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void draw(Graphics g) {
        for (int j = this.vecEnemies.size() - 1; j >= 0; --j) {
            ((Enemy1)this.vecEnemies.elementAt(j)).paint(g);
        }
    }

    private void addEnemy(Enemy1 enemy1) {
        this.vecEnemies.addElement(enemy1);
        Game.addElement(enemy1);
    }

    public void removeEnemy(Enemy1 enemy1) {
        this.vecEnemies.removeElement(enemy1);
        Game.removeElement(enemy1);
        if (this.vecEnemies.size() == 0 && !this.testedLastEnemy) {
            this.canGenerate = true;
        }
    }

    private void generate0(Image image) {
        int x1 = ViewPort.WIDTH / 4 - this.width / 2 + 5;
        int x2 = ViewPort.WIDTH / 2 - this.width / 2;
        int x3 = ViewPort.WIDTH / 4 * 3 - this.width / 2;
        Enemy1 enemy1 = new Enemy1(image, this.width, this.height, this);
        enemy1.setPosition(x1, -enemy1.getHeight());
        this.addEnemy(enemy1);
        enemy1 = new Enemy1(image, this.width, this.height, this);
        enemy1.setPosition(x2, -enemy1.getHeight());
        this.addEnemy(enemy1);
        enemy1 = new Enemy1(image, this.width, this.height, this);
        enemy1.setPosition(x3, -enemy1.getHeight());
        this.addEnemy(enemy1);
    }

    private void generate1(Image image) {
        int x1 = ViewPort.WIDTH / 4 - image.getWidth() / 2 + 5;
        int x2 = ViewPort.WIDTH / 2 - image.getWidth() / 2;
        int x3 = ViewPort.WIDTH / 4 * 3 - image.getWidth() / 2;
    }

    private void generate2(Image image) {
        int x1 = ViewPort.WIDTH / 4 - image.getWidth() / 2 + 5;
        int x2 = ViewPort.WIDTH / 2 - image.getWidth() / 2;
        int x3 = ViewPort.WIDTH / 4 * 3 - image.getWidth() / 2;
    }
}

