/*
 * Decompiled with CFR 0.152.
 */
package level4;

import accessories.Ammo;
import accessories.Bumb;
import accessories.EnemyHealth;
import game.GNSprite;
import game.Game;
import game.Main;
import game.ViewPort;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class HeroL4 {
    private Sprite spriteMain;
    private Sprite spriteWingRight;
    private Sprite spriteWingLeft;
    private HitSprite spriteHitArea;
    private int sp = 3;
    private int spWings = 2;
    private boolean openingWings;
    private int changeCounter = 0;
    private final int changeTime;
    private int closeWingCounter;
    private int spx = 0;
    private int spy = 0;
    private int ammoCounter;
    private int health = 100;
    private int bumbedTime = 0;
    private boolean bumbed;
    private boolean started;

    public HeroL4(Image imgMain, Image imgWings, int wingWidth, int wingHeight, Image imgHitarea, int hitWidth, int hitHeight) {
        this.changeTime = 20;
        this.spriteMain = new Sprite(imgMain);
        this.spriteWingLeft = new Sprite(imgWings, wingWidth, wingHeight);
        this.spriteWingRight = new Sprite(imgWings, wingWidth, wingHeight);
        this.spriteWingRight.setFrame(1);
        this.spriteHitArea = new HitSprite(imgHitarea, hitWidth, hitHeight);
        this.spriteMain.setPosition(ViewPort.WIDTH / 2 - this.spriteMain.getWidth() / 2, -this.spriteMain.getHeight() - 10);
        this.spriteHitArea.setPosition(this.spriteMain.getX() + 65, this.spriteMain.getY() + 75);
        this.spriteWingLeft.setPosition(this.spriteMain.getX(), this.spriteMain.getY() + 28);
        this.spriteWingRight.setPosition(this.spriteMain.getX() + this.spriteMain.getWidth() / 2, this.spriteMain.getY() + 28);
    }

    public void generate() {
        this.started = true;
        if (Game.savedEnemyHealth != -1) {
            this.health = Game.savedEnemyHealth;
            Game.savedEnemyHealth = -1;
        }
    }

    public void cycle() {
        if (!this.started) {
            return;
        }
        Game.enemyHealthForSave = this.health;
        if (this.bumbed) {
            if (this.bumbedTime > 0) {
                --this.bumbedTime;
            } else {
                Main.sucess();
            }
            return;
        }
        this.spy = this.spriteMain.getY() < 0 ? 3 : 0;
        if (this.changeCounter != 0) {
            --this.changeCounter;
        } else if (this.changeCounter == 0) {
            this.spx = this.spriteWingLeft.getX() <= 0 ? this.sp : (this.spriteWingRight.getX() + this.spriteWingRight.getWidth() > ViewPort.WIDTH ? -this.sp : (Main.random(1) == 0 ? this.sp : -this.sp));
            this.changeCounter = 20;
        }
        this.move(this.spx, this.spy);
        this.spriteHitArea.nextFrame();
        this.cycleWings();
        this.ammo();
    }

    private void cycleWings() {
        if (this.closeWingCounter > 0) {
            --this.closeWingCounter;
            return;
        }
        if (this.openingWings) {
            this.moveWings(this.spWings);
            if (this.spriteWingRight.getX() >= this.spriteMain.getX() + this.spriteMain.getWidth() - 22) {
                this.openingWings = false;
                this.setOpenWingsPosition();
            }
        } else {
            this.moveWings(-this.spWings);
            if (this.spriteWingRight.getX() <= this.spriteMain.getX() + this.spriteMain.getWidth() - this.spriteWingRight.getWidth()) {
                this.closeWingCounter = Main.random(10) + 20;
                this.openingWings = true;
                this.setCloseWingsPosition();
            }
        }
    }

    private void ammo() {
        this.ammoFifth();
    }

    private void ammoFifth() {
        if (this.ammoCounter > 0) {
            --this.ammoCounter;
            return;
        }
        this.ammoCounter = Main.random(10) + 10;
        int rnd = Main.random(1);
        if (rnd == 1) {
            Ammo.generate(this.spriteMain.getX() + this.spriteMain.getWidth() / 2 - Ammo.TYPE19.width / 2, this.spriteMain.getY() + 110, Ammo.TYPE19, 1, 12);
        }
        if ((rnd = Main.random(1)) == 1) {
            Ammo.generate(this.spriteWingLeft.getX() + 27, this.spriteMain.getY() + 119, Ammo.TYPE20, 1, 12);
        }
        if ((rnd = Main.random(1)) == 1) {
            Ammo.generate(this.spriteWingRight.getX() + 27, this.spriteMain.getY() + 119, Ammo.TYPE21, 1, 12);
        }
    }

    private void move(int dx, int dy) {
        this.spriteMain.setPosition(this.spriteMain.getX() + dx, this.spriteMain.getY() + dy);
        this.spriteHitArea.setPosition(this.spriteHitArea.getX() + dx, this.spriteHitArea.getY() + dy);
        this.spriteWingLeft.setPosition(this.spriteWingLeft.getX() + dx, this.spriteWingLeft.getY() + dy);
        this.spriteWingRight.setPosition(this.spriteWingRight.getX() + dx, this.spriteWingRight.getY() + dy);
    }

    private void moveWings(int dx) {
        this.spriteWingRight.setPosition(this.spriteWingRight.getX() + dx, this.spriteWingRight.getY());
        this.spriteWingLeft.setPosition(this.spriteWingLeft.getX() - dx, this.spriteWingLeft.getY());
    }

    private void setCloseWingsPosition() {
        this.spriteWingLeft.setPosition(this.spriteMain.getX(), this.spriteMain.getY() + 28);
        this.spriteWingRight.setPosition(this.spriteMain.getX() + this.spriteMain.getWidth() / 2, this.spriteMain.getY() + 28);
    }

    private void setOpenWingsPosition() {
        this.spriteWingLeft.setPosition(this.spriteMain.getX() + 22 - this.spriteWingLeft.getWidth(), this.spriteMain.getY() + 28);
        this.spriteWingRight.setPosition(this.spriteMain.getX() + this.spriteMain.getWidth() - 22, this.spriteMain.getY() + 28);
    }

    public void draw(Graphics g) {
        this.spriteWingLeft.paint(g);
        this.spriteWingRight.paint(g);
        this.spriteMain.paint(g);
        this.spriteHitArea.paint(g);
    }

    class HitSprite
    extends GNSprite {
        HitSprite(Image image, int width, int height) {
            super(image, width, height);
            Game.addElement(this);
        }

        public void hit(Ammo am) {
            if (HeroL4.this.bumbed) {
                return;
            }
            ++Game.player.score;
            HeroL4.this.health -= am.type.healthEffect;
            EnemyHealth.addHealthObject(this.ID, 50, 100, HeroL4.this.health, 5, 20);
            if (HeroL4.this.health <= 0) {
                Bumb.generate(Bumb.TYPE4, this.getX() - 20, this.getY());
                HeroL4.this.bumbed = true;
                HeroL4.this.bumbedTime = 40;
            } else {
                Bumb.generateOnCondition(Bumb.TYPE1, this.getX(), this.getY());
            }
        }
    }
}

