/*
 * Decompiled with CFR 0.152.
 */
package mathEngine;

import game.ViewPort;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mathEngine.CurveEnemy;

public class BottomCurveEnemy
extends CurveEnemy {
    public BottomCurveEnemy(Image image, int width, int height, int x, int y, byte[] dirFrames) {
        super(image, width, height, x, y, dirFrames);
        this.dirFrames = dirFrames;
        this.x = x;
        this.y = y;
        this.initialize();
        this.setLastXY();
        this.setPosition(x, y);
    }

    public void cycle() {
        if (this.x < this.curveStart) {
            this.setLastXY();
            this.x += this.sp;
            this.setPosition(this.x, this.y);
            return;
        }
        if (this.collidedPlayer()) {
            return;
        }
        if (this.lastX + this.getWidth() < 0 && this.x + this.getWidth() >= 0) {
            this.minus = this.y - ViewPort.HEIGHT;
        }
        this.setPosition(this.x, this.y - this.minus - this.getHeight());
        this.setDirFrame();
        this.setLastXY();
        this.x += this.sp;
        this.curveAngle += this.sp / this.step;
        this.calculate();
    }

    protected void setDirFrame() {
        if (this.curveAngle < 30) {
            this.setFrame(this.dirFrames[2]);
        } else if (this.curveAngle >= 30 && this.curveAngle < 60) {
            this.setFrame(this.dirFrames[1]);
        } else if (this.curveAngle >= 60 && this.curveAngle < 120) {
            this.setFrame(this.dirFrames[0]);
        } else if (this.curveAngle >= 120 && this.curveAngle < 150) {
            this.setFrame(this.dirFrames[15]);
        } else {
            this.setFrame(this.dirFrames[14]);
        }
    }

    public void draw(Graphics g) {
        this.paint(g);
    }

    protected void initialize() {
        this.y = ViewPort.HEIGHT;
        this.step = ViewPort.getCurveStep(ViewPort.WIDTH);
        this.curveStart = ViewPort.getCurveStart(ViewPort.WIDTH, this.step);
        this.curveAngle = 0;
    }

    private void setLastXY() {
        this.lastX = this.x;
        this.lastY = this.y;
    }

    protected void calculate() {
        double sinx = Math.sin(Math.toRadians(this.curveAngle));
        this.y = ViewPort.HEIGHT - (int)(sinx * (double)ViewPort.HEIGHT / 2.0);
    }

    public boolean outOfView() {
        return this.x >= ViewPort.WIDTH;
    }
}

