/*
 * Decompiled with CFR 0.152.
 */
package cycles;

import accessories.Ammo;
import accessories.Bumb;
import game.GNSprite;
import game.Game;
import game.SoundsPlayer;
import game.ViewPort;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class StoneEnemy
extends GNSprite {
    public static boolean canGenerate = true;
    static final int TYPE_BUMBED = 0;
    static final int TYPE_NOT_BUMBED = 1;
    static Image image1;
    static Image image2;
    static Vector vectorStone;
    static int[] arrXPositions;
    static int[] arrTypes;
    static Random rndTypes;
    static Random rndX;
    private static boolean testedLastEnemy;
    int type;
    int direction;
    int sp = 8;
    int frameIndex;
    int frameNumb;
    int health = 2;

    public static void create() {
        arrTypes = new int[]{0, 1};
        arrXPositions = new int[]{10, 3 * ViewPort.WIDTH / 6, 4 * ViewPort.WIDTH / 6};
        rndTypes = new Random();
        rndX = new Random();
        vectorStone = new Vector();
        try {
            image1 = Image.createImage((String)"/stone1.png");
            image2 = Image.createImage((String)"/stone2.png");
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public static void clean() {
        arrTypes = null;
        arrXPositions = null;
        rndTypes = null;
        rndX = null;
        image1 = null;
        image2 = null;
        vectorStone = null;
    }

    public static void cycleAll() {
        for (int j = 0; j < vectorStone.size(); ++j) {
            ((StoneEnemy)vectorStone.elementAt(j)).cycle();
        }
        StoneEnemy.testLastEnemyPlace();
    }

    private static void testLastEnemyPlace() {
        if (testedLastEnemy) {
            return;
        }
        if (vectorStone.size() == 0) {
            return;
        }
        try {
            StoneEnemy stoneEnemy = (StoneEnemy)vectorStone.lastElement();
            if (stoneEnemy.getY() > 320) {
                canGenerate = true;
                testedLastEnemy = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void drawAll(Graphics g) {
        for (int j = 0; j < vectorStone.size(); ++j) {
            ((StoneEnemy)vectorStone.elementAt(j)).draw(g);
        }
    }

    public static int randomX() {
        int r = rndX.nextInt() % 3;
        if (r < 0) {
            r *= -1;
        }
        return arrXPositions[r];
    }

    public static int randomType() {
        int r = rndTypes.nextInt() % 2;
        if (r < 0) {
            r *= -1;
        }
        return arrTypes[r];
    }

    public static void generate() {
        if (!canGenerate) {
            return;
        }
        testedLastEnemy = false;
        StoneEnemy temp = null;
        int type = StoneEnemy.randomType();
        int x1 = StoneEnemy.randomX();
        int x2 = StoneEnemy.randomX();
        int x3 = StoneEnemy.randomX();
        boolean x2Ok = false;
        temp = type == 0 ? new StoneEnemy(image1, image1.getWidth() / 8, image1.getHeight() / 3, type, 24) : new StoneEnemy(image2, image2.getWidth() / 5, image2.getHeight() / 5, type, 24);
        temp.setPosition(x1, -temp.getHeight());
        vectorStone.addElement(temp);
        Game.addElement(temp);
        if (x2 != x1) {
            type = StoneEnemy.randomType();
            temp = type == 0 ? new StoneEnemy(image1, image1.getWidth() / 8, image1.getHeight() / 3, type, 24) : new StoneEnemy(image2, image2.getWidth() / 5, image2.getHeight() / 5, type, 24);
            temp.setPosition(x2, -temp.getHeight());
            vectorStone.addElement(temp);
            Game.addElement(temp);
            x2Ok = true;
        }
        if (x3 != x2 && x3 != x1 && !x2Ok) {
            type = StoneEnemy.randomType();
            temp = type == 0 ? new StoneEnemy(image1, image1.getWidth() / 8, image1.getHeight() / 3, type, 24) : new StoneEnemy(image2, image2.getWidth() / 5, image2.getHeight() / 5, type, 24);
            temp.setPosition(x3, -temp.getHeight());
            vectorStone.addElement(temp);
            Game.addElement(temp);
        }
        canGenerate = false;
    }

    public static void removeStone(StoneEnemy enemy) {
        vectorStone.removeElement(enemy);
        Game.removeElement(enemy);
        if (vectorStone.size() == 0 && !testedLastEnemy) {
            canGenerate = true;
            System.gc();
        }
    }

    public StoneEnemy(Image img, int width, int height, int type, int frameNumb) {
        super(img, width, height);
        this.type = type;
        this.frameNumb = frameNumb;
        this.direction = 12;
    }

    public void cycle() {
        if (this.collidesWith(Game.player, true)) {
            Game.player.hit(5);
            StoneEnemy.removeStone(this);
            return;
        }
        this.move();
        this.frameIndex = (this.frameIndex + 1) % this.frameNumb;
        this.setFrame(this.frameIndex);
        if (this.getY() > ViewPort.HEIGHT) {
            SoundsPlayer.getInstance().bumbSound();
            Bumb.generate(Bumb.TYPE3, this.getX() - Math.abs(this.getWidth() - Bumb.TYPE3.width) / 2, this.getY());
            StoneEnemy.removeStone(this);
            return;
        }
    }

    public void move() {
        int errorX = Math.abs(this.tempX - this.getX() * 1000);
        int errorY = Math.abs(this.tempY - this.getY() * 1000);
        if (errorX > 1000 || errorY > 1000) {
            this.tempX = this.getX() * 1000;
            this.tempY = this.getY() * 1000;
        }
        this.tempX += this.sp * Game.cos[this.direction];
        this.tempY -= this.sp * Game.sin[this.direction];
        this.setPosition(this.tempX / 1000, this.tempY / 1000);
    }

    public void hit(Ammo ammo) {
        this.health -= ammo.type.healthEffect;
        if (this.health <= 0) {
            SoundsPlayer.getInstance().bumbSound();
            Bumb.generate(Bumb.TYPE3, this.getX() - Math.abs(this.getWidth() - Bumb.TYPE3.width) / 2, this.getY());
            StoneEnemy.removeStone(this);
        }
    }
}

