/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import game.Main;
import game.ViewPort;
import java.io.IOException;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;

public class Starter
extends GameCanvas
implements Runnable {
    Game game;
    static Image[] arrImages;
    static Image imgBack;
    static Image imgGate;
    static Sprite spriteGate;
    static Image imgPlane;
    int displayTime;
    boolean running = true;
    int yPlane;

    public static void load() {
        arrImages = new Image[4];
        try {
            imgBack = Image.createImage((String)"/starter/back.jpg");
            imgGate = Image.createImage((String)"/starter/Gate.png");
            spriteGate = new Sprite(imgGate, imgGate.getWidth() / 4, imgGate.getHeight() / 2);
            Starter.arrImages[0] = Image.createImage((String)"/starter/The-Ship-01.png");
            Starter.arrImages[1] = Image.createImage((String)"/starter/The-Ship-02.png");
            Starter.arrImages[2] = Image.createImage((String)"/starter/The-Ship-03.png");
            Starter.arrImages[3] = Image.createImage((String)"/starter/The-Ship-04.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void clean() {
        arrImages = null;
        imgBack = null;
        imgGate = null;
        imgPlane = null;
        spriteGate = null;
    }

    public Starter(Game game) {
        super(true);
        this.setFullScreenMode(true);
        this.game = game;
        spriteGate.setPosition(ViewPort.WIDTH / 2 - spriteGate.getWidth() / 2, ViewPort.HEIGHT / 2 - spriteGate.getHeight() / 2);
        this.yPlane = ViewPort.HEIGHT / 2;
    }

    public void start() {
        new Thread(this).start();
    }

    public void run() {
        Graphics g = this.getGraphics();
        while (this.running) {
            this.cycle();
            this.draw(g);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        arrImages = null;
        imgBack = null;
        imgPlane = null;
        this.game.restart();
        Main.setCurrent((Displayable)this.game);
    }

    private void cycle() {
        ++this.displayTime;
        if (this.displayTime < 5) {
            spriteGate.setFrame(0);
        } else if (this.displayTime >= 3 && this.displayTime < 6) {
            spriteGate.setFrame(1);
        } else if (this.displayTime >= 6 && this.displayTime < 9) {
            spriteGate.setFrame(2);
        } else if (this.displayTime >= 9 && this.displayTime < 12) {
            spriteGate.setFrame(3);
        } else if (this.displayTime >= 12 && this.displayTime < 15) {
            spriteGate.setFrame(4);
        } else if (this.displayTime >= 15 && this.displayTime < 18) {
            spriteGate.setFrame(5);
        } else if (this.displayTime >= 18 && this.displayTime < 21) {
            spriteGate.setFrame(6);
        } else if (this.displayTime >= 21 && this.displayTime < 24) {
            imgPlane = arrImages[0];
        } else if (this.displayTime >= 24 && this.displayTime < 27) {
            imgPlane = arrImages[1];
        } else if (this.displayTime >= 27 && this.displayTime < 30) {
            imgPlane = arrImages[2];
        } else if (this.displayTime >= 30 && this.displayTime < 33) {
            imgPlane = arrImages[3];
        } else if (this.displayTime >= 33) {
            this.yPlane -= 20;
        }
        if (imgPlane != null && this.yPlane + imgPlane.getHeight() < 0) {
            this.running = false;
        }
    }

    private void draw(Graphics g) {
        if (this.getWidth() > this.getHeight()) {
            this.renderNotSupported(g);
            return;
        }
        g.drawImage(imgBack, ViewPort.WIDTH / 2, ViewPort.HEIGHT / 2, 3);
        spriteGate.paint(g);
        if (imgPlane != null) {
            g.drawImage(imgPlane, ViewPort.WIDTH / 2, this.yPlane, 3);
        }
        this.flushGraphics();
    }

    public void renderNotSupported(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.game.getImgStop(), this.getWidth() / 2 - this.game.getImgStop().getWidth() / 2, this.getHeight() / 2 - this.game.getImgStop().getHeight() / 2, 20);
        this.flushGraphics();
    }
}

