/*
 * Decompiled with CFR 0.152.
 */
package level3.laser;

import game.ExpandedSprite;
import game.Game;
import javax.microedition.lcdui.Image;
import level3.laser.LaserEnemy;

public class LaserEnemyLeft
extends LaserEnemy {
    private byte cycleCount = 0;

    public LaserEnemyLeft(Image image, int width, int height, int frameIndex, Image imgLaser, int laserWidth, int laserHeight) {
        super(image, width, height, frameIndex);
        try {
            this.setImage(Image.createImage((Image)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (int)7), height, width);
            imgLaser = Image.createImage((Image)imgLaser, (int)0, (int)0, (int)imgLaser.getWidth(), (int)imgLaser.getHeight(), (int)6);
            this.setLaserFrames(imgLaser, laserHeight, laserWidth);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setLaserFrames(Image imgLaser, int laserWidth, int laserHeight) {
        int rows = imgLaser.getWidth() / laserWidth;
        int columns = imgLaser.getHeight() / laserHeight;
        this.laserFrames = new Image[rows * columns];
        int count = 0;
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < columns; ++i) {
                this.laserFrames[count] = Image.createImage((Image)imgLaser, (int)(j * laserWidth), (int)(i * laserHeight), (int)laserWidth, (int)laserHeight, (int)0);
                ++count;
            }
        }
    }

    public void cycle() {
        if (this.spriteLaser == null) {
            this.generateLaser();
        } else {
            this.cycleLaser();
        }
        this.move();
        if (this.exitedView()) {
            this.remove();
        }
    }

    protected void generateLaser() {
        this.spriteLaser = new ExpandedSprite(this.laserFrames[0], 0, 1);
        this.hittedPlayer = false;
        this.spriteLaser.setMinimumWidth();
        this.spriteLaser.setPosition(this.getX() + this.getWidth(), this.getY() + this.getHeight() / 2 - this.spriteLaser.getHeight() / 2);
    }

    protected void cycleLaser() {
        if (!this.hittedPlayer && this.spriteLaser.collidesWith(Game.player, true)) {
            Game.player.hit(10);
            this.hittedPlayer = true;
            this.laserIncreasing = false;
        }
        if (this.laserIncreasing) {
            this.spriteLaser.increaseWidth(10);
            if (this.spriteLaser.reachedMaxWidth()) {
                this.nextLaserFrame();
                this.cycleCount = (byte)10;
                this.laserIncreasing = false;
            }
        } else {
            if (this.cycleCount > 0) {
                this.cycleCount = (byte)(this.cycleCount - 1);
                return;
            }
            this.spriteLaser.decreaseWidth(10);
            if (this.spriteLaser.reachedMinWidth()) {
                this.spriteLaser = null;
                this.laserIncreasing = true;
            }
        }
    }
}

