/*
 * Decompiled with CFR 0.152.
 */
package level4;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import level4.FireEnemy;

public class FireEnemyControl {
    private Image image;
    private int width;
    private int height;
    private boolean canGenerate = true;
    private int type;
    private Vector vecEnemies;
    private boolean testedLastEnemy;

    public FireEnemyControl(Image image, int width, int height, int type) {
        this.image = image;
        this.width = width;
        this.height = height;
        this.type = type;
        this.vecEnemies = new Vector();
    }

    public void generate() {
        if (!this.canGenerate) {
            return;
        }
        this.canGenerate = false;
        this.testedLastEnemy = false;
        this.vecEnemies.addElement(new FireEnemy(this.image, this.width, this.height, this, this.type));
    }

    public void draw(Graphics g) {
        FireEnemy fireEnemy = null;
        for (int j = 0; j < this.vecEnemies.size(); ++j) {
            fireEnemy = (FireEnemy)this.vecEnemies.elementAt(j);
            fireEnemy.paint(g);
        }
    }

    public void cycle() {
        if (this.vecEnemies.size() == 0 && !this.testedLastEnemy) {
            this.canGenerate = true;
            return;
        }
        FireEnemy fireEnemy = null;
        for (int j = this.vecEnemies.size() - 1; j >= 0; --j) {
            fireEnemy = (FireEnemy)this.vecEnemies.elementAt(j);
            fireEnemy.cycle();
        }
        this.testLastEnemyPlace();
    }

    private void testLastEnemyPlace() {
        if (this.testedLastEnemy) {
            return;
        }
        if (this.vecEnemies.size() == 0) {
            return;
        }
        try {
            FireEnemy fireEnemy = (FireEnemy)this.vecEnemies.lastElement();
            if (fireEnemy.getY() > 320) {
                this.canGenerate = true;
                this.testedLastEnemy = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void removeEnemy(FireEnemy enemy) {
        this.vecEnemies.removeElement(enemy);
    }
}

