/*
 * Decompiled with CFR 0.152.
 */
package level4;

import game.Game;
import game.ViewPort;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import level4.GateEnemyControl;

public class GateEnemy {
    private Sprite spriteLeft;
    private Sprite spriteRight;
    private boolean opening;
    private int spY = 1;
    private int spX = 2;
    private int counter = 0;
    private boolean hittedPlayer;
    private GateEnemyControl gateEnemyControl;

    public GateEnemy(Image image, GateEnemyControl gateEnemyControl) {
        this.gateEnemyControl = gateEnemyControl;
        this.spriteLeft = new Sprite(Image.createImage((Image)image, (int)0, (int)0, (int)(image.getWidth() / 2), (int)image.getHeight(), (int)0));
        this.spriteRight = new Sprite(Image.createImage((Image)image, (int)(image.getWidth() / 2), (int)0, (int)(image.getWidth() / 2), (int)image.getHeight(), (int)0));
        this.setPosition(-this.spriteLeft.getWidth(), -this.spriteLeft.getHeight() * 2);
        this.spY *= 2;
        this.spX *= 2;
    }

    public void setPosittionAny() {
        this.setPosition(-this.spriteLeft.getWidth(), 0);
    }

    public void draw(Graphics g) {
        this.spriteLeft.paint(g);
        this.spriteRight.paint(g);
    }

    public void cycle() {
        if (this.hittedPlayer && this.opening) {
            return;
        }
        if (!this.hittedPlayer && (this.spriteLeft.collidesWith((Sprite)Game.player, true) || this.spriteRight.collidesWith((Sprite)Game.player, true))) {
            this.hittedPlayer = true;
            Game.player.hit(Game.player.health);
            return;
        }
        this.openClose();
        this.move(0, this.spY);
        if (this.getY() > ViewPort.HEIGHT) {
            this.gateEnemyControl.removeEnemy(this);
        }
    }

    public void openClose() {
        if (this.counter > 0) {
            --this.counter;
            return;
        }
        if (this.opening) {
            this.move(-this.spX, 0);
            if (this.getX() <= -this.spriteLeft.getWidth()) {
                this.opening = false;
                this.setPosition(-this.spriteLeft.getWidth(), this.getY());
            }
        } else {
            this.move(this.spX, 0);
            if (this.getX() >= 0) {
                this.counter = 5;
                this.opening = true;
                this.setPosition(0, this.getY());
            }
        }
    }

    public void move(int dx, int dy) {
        this.setPosition(this.getX() + dx, this.getY() + dy);
    }

    private void setPosition(int x, int y) {
        this.spriteLeft.setPosition(x, y);
        this.spriteRight.setPosition(ViewPort.WIDTH / 2 - x, y);
    }

    private int getX() {
        return this.spriteLeft.getX();
    }

    public int getY() {
        return this.spriteLeft.getY();
    }
}

