/*
 * Decompiled with CFR 0.152.
 */
package menu;

import game.Main;
import game.ResourceLoader;
import game.SoundsPlayer;
import game.Tasks;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import menu.MenuDownload;
import menu.MenuElement;
import menu.MenuMain;
import menu.MenuMode;
import menu.MenuOptions;
import menu.MenuPause;

public abstract class Menu
extends GameCanvas
implements Runnable {
    public static final byte MENU_TYPE_MAIN = 0;
    public static final byte MENU_TYPE_OPTIONS = 1;
    public static final byte MENU_TYPE_PAUSE = 2;
    public static final byte MENU_TYPE_MODE = 3;
    public static final byte MENU_TYPE_DOWNLOAD = 4;
    public static final byte ELEMENT_TYPE_NEW = 0;
    public static final byte ELEMENT_TYPE_LOAD = 1;
    public static final byte ELEMENT_TYPE_OPTIONS = 2;
    public static final byte ELEMENT_TYPE_EXIT = 3;
    public static final byte ELEMENT_TYPE_MAIN = 4;
    public static final byte ELEMENT_TYPE_MAIN2 = 20;
    public static final byte ELEMENT_TYPE_CONTINUE = 5;
    public static final byte ELEMENT_TYPE_ABOUT = 6;
    public static final byte ELEMENT_TYPE_HELP = 7;
    public static final byte ELEMENT_TYPE_HIGH_SCORES = 8;
    public static final byte ELEMENT_TYPE_MODE = 9;
    public static final byte ELEMENT_TYPE_EASY = 10;
    public static final byte ELEMENT_TYPE_Meduim = 11;
    public static final byte ELEMENT_TYPE_HARD = 12;
    public static final byte ELEMENT_TYPE_BACK = 13;
    public static final byte ELEMENT_TYPE_SOUND_LOW = 14;
    public static final byte ELEMENT_TYPE_SOUND_HIGH = 18;
    public static final byte ELEMENT_TYPE_SOUND_OFF = 15;
    public static final byte ELEMENT_TYPE_VIBRATE_ON = 16;
    public static final byte ELEMENT_TYPE_VIBRATE_OFF = 17;
    public static final byte ELEMENT_TYPE_DOWNLOAD = 19;
    private boolean running = true;
    private boolean paused = false;
    private int selectedIndex = 0;
    protected Vector vectorElements;
    protected Tasks endTask;
    protected final int spacer;
    protected int numberOfElements = -1;
    protected int menuX;
    protected int menuY;
    protected int height;
    protected int width;
    static Image imgNew1;
    static Image imgNew2;
    static Image imgExit1;
    static Image imgExit2;
    static Image imgOptions1;
    static Image imgOptions2;
    static Image imgLoad1;
    static Image imgLoad2;
    static Image imgBack;
    static Image imgMainMenu1;
    static Image imgMainMenu2;
    static Image imgContinue1;
    static Image imgContinue2;
    static Image imgHelp1;
    static Image imgHelp2;
    static Image imgAbout1;
    static Image imgAbout2;
    static Image imgMode1;
    static Image imgMode2;
    static Image imgEasy1;
    static Image imgEasy2;
    static Image imgMeduim1;
    static Image imgMeduim2;
    static Image imgHard1;
    static Image imgHard2;
    static Image imgSoundLow1;
    static Image imgSoundLow2;
    static Image imgSoundHigh1;
    static Image imgSoundHigh2;
    static Image imgSoundOff1;
    static Image imgSoundOff2;
    static Image imgVibrateOn1;
    static Image imgVibrateOn2;
    static Image imgVibrateOff1;
    static Image imgVibrateOff2;
    static Image imgDownload1;
    static Image imgDownload2;
    static Image imgFullVersion;
    static Image imgHelpScreen;
    static Image imgAboutScreen;
    static Menu MAIN_MENU;
    private int lastUp;
    private int lastDown;
    private int lastFire;

    public static Menu getMenu(int type) {
        System.gc();
        Menu menu = null;
        switch (type) {
            case 0: {
                if (MAIN_MENU == null) {
                    MAIN_MENU = new MenuMain();
                    MAIN_MENU.restart();
                }
                menu = MAIN_MENU;
                break;
            }
            case 1: {
                menu = new MenuOptions();
                break;
            }
            case 2: {
                Menu.loadPauseMenu();
                menu = new MenuPause();
                break;
            }
            case 3: {
                menu = new MenuMode();
                break;
            }
            case 4: {
                Menu.loadDownloadMenu();
                menu = new MenuDownload();
            }
        }
        return menu;
    }

    public static void loadPauseMenu() {
        try {
            imgBack = Image.createImage((String)"/menu/back.jpg");
            imgMainMenu1 = Image.createImage((String)"/menu/main-menu.png");
            imgMainMenu2 = Image.createImage((String)"/menu/main-menu1.png");
            imgContinue1 = Image.createImage((String)"/menu/continue.png");
            imgContinue2 = Image.createImage((String)"/menu/continue_1.png");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void loadDownloadMenu() {
        try {
            imgBack = Image.createImage((String)"/menu/back.jpg");
            imgFullVersion = Image.createImage((String)"/menu/full-version.png");
            imgMainMenu1 = Image.createImage((String)"/menu/main-menu.png");
            imgMainMenu2 = Image.createImage((String)"/menu/main-menu1.png");
            imgDownload1 = Image.createImage((String)"/menu/download.png");
            imgDownload2 = Image.createImage((String)"/menu/download_1.png");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void load() {
        ResourceLoader rl = new ResourceLoader(37){

            public void load() {
                try {
                    imgExit1 = Image.createImage((String)"/menu/exit.png");
                    ++finishedSteps;
                    imgExit2 = Image.createImage((String)"/menu/exit_1.png");
                    ++finishedSteps;
                    imgLoad1 = Image.createImage((String)"/menu/load-game.png");
                    ++finishedSteps;
                    imgLoad2 = Image.createImage((String)"/menu/load-game_1.png");
                    ++finishedSteps;
                    imgNew1 = Image.createImage((String)"/menu/new-game.png");
                    ++finishedSteps;
                    imgNew2 = Image.createImage((String)"/menu/new-game_1.png");
                    ++finishedSteps;
                    imgOptions1 = Image.createImage((String)"/menu/options.png");
                    ++finishedSteps;
                    imgOptions2 = Image.createImage((String)"/menu/options_1.png");
                    ++finishedSteps;
                    imgBack = Image.createImage((String)"/menu/back.jpg");
                    ++finishedSteps;
                    imgMainMenu1 = Image.createImage((String)"/menu/main-menu.png");
                    ++finishedSteps;
                    imgMainMenu2 = Image.createImage((String)"/menu/main-menu1.png");
                    ++finishedSteps;
                    imgContinue1 = Image.createImage((String)"/menu/continue.png");
                    ++finishedSteps;
                    imgContinue2 = Image.createImage((String)"/menu/continue_1.png");
                    ++finishedSteps;
                    imgHelp1 = Image.createImage((String)"/menu/help.png");
                    ++finishedSteps;
                    imgHelp2 = Image.createImage((String)"/menu/help_1.png");
                    ++finishedSteps;
                    imgAbout1 = Image.createImage((String)"/menu/about.png");
                    ++finishedSteps;
                    imgAbout2 = Image.createImage((String)"/menu/about_1.png");
                    ++finishedSteps;
                    imgMode1 = Image.createImage((String)"/menu/mode.png");
                    ++finishedSteps;
                    imgMode2 = Image.createImage((String)"/menu/mode_1.png");
                    ++finishedSteps;
                    imgEasy1 = Image.createImage((String)"/menu/easy.png");
                    ++finishedSteps;
                    imgEasy2 = Image.createImage((String)"/menu/easy_1.png");
                    ++finishedSteps;
                    imgMeduim1 = Image.createImage((String)"/menu/meduim.png");
                    ++finishedSteps;
                    imgMeduim2 = Image.createImage((String)"/menu/meduim_1.png");
                    ++finishedSteps;
                    imgHard1 = Image.createImage((String)"/menu/hard.png");
                    ++finishedSteps;
                    imgHard2 = Image.createImage((String)"/menu/hard_1.png");
                    ++finishedSteps;
                    imgSoundLow1 = Image.createImage((String)"/menu/sound-low.png");
                    ++finishedSteps;
                    imgSoundLow2 = Image.createImage((String)"/menu/sound-low_1.png");
                    ++finishedSteps;
                    imgSoundHigh1 = Image.createImage((String)"/menu/sound-high.png");
                    ++finishedSteps;
                    imgSoundHigh2 = Image.createImage((String)"/menu/sound-high_1.png");
                    ++finishedSteps;
                    imgSoundOff1 = Image.createImage((String)"/menu/sound-off.png");
                    ++finishedSteps;
                    imgSoundOff2 = Image.createImage((String)"/menu/sound-off_1.png");
                    ++finishedSteps;
                    imgVibrateOn1 = Image.createImage((String)"/menu/vibration-on.png");
                    ++finishedSteps;
                    imgVibrateOn2 = Image.createImage((String)"/menu/vibration-on_1.png");
                    ++finishedSteps;
                    imgVibrateOff1 = Image.createImage((String)"/menu/vibration-off.png");
                    ++finishedSteps;
                    imgVibrateOff2 = Image.createImage((String)"/menu/vibration-off_1.png");
                    ++finishedSteps;
                    imgHelpScreen = Image.createImage((String)"/menu/help-screen.jpg");
                    ++finishedSteps;
                    imgAboutScreen = Image.createImage((String)"/menu/about-screen.jpg");
                    System.out.println("finishedSteps:" + ++finishedSteps);
                    SoundsPlayer.getInstance().start();
                    SoundsPlayer.getInstance().mainSound();
                    ++finishedSteps;
                    nextDisplay = new MenuMain();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        };
        new Thread(rl).start();
    }

    public static void clean() {
        imgDownload1 = null;
        imgDownload2 = null;
        imgFullVersion = null;
        imgAbout1 = null;
        imgAbout2 = null;
        imgBack = null;
        imgContinue1 = null;
        imgContinue2 = null;
        imgEasy1 = null;
        imgEasy2 = null;
        imgExit1 = null;
        imgExit2 = null;
        imgHard1 = null;
        imgHard2 = null;
        imgHelp1 = null;
        imgHelp2 = null;
        imgLoad1 = null;
        imgLoad2 = null;
        imgVibrateOn2 = null;
        imgVibrateOn1 = null;
        imgVibrateOff2 = null;
        imgVibrateOff1 = null;
        imgSoundLow2 = null;
        imgSoundLow1 = null;
        imgSoundHigh1 = null;
        imgSoundHigh2 = null;
        imgSoundOff2 = null;
        imgSoundOff1 = null;
        imgOptions2 = null;
        imgOptions1 = null;
        imgMainMenu1 = null;
        imgMainMenu2 = null;
        imgMeduim1 = null;
        imgMeduim2 = null;
        imgMode1 = null;
        imgMode2 = null;
        imgNew1 = null;
        imgNew2 = null;
        imgOptions1 = null;
        imgOptions2 = null;
        MAIN_MENU = null;
        System.gc();
    }

    public static void cleanPauseMenu() {
        imgContinue1 = null;
        imgContinue2 = null;
        imgMainMenu1 = null;
        imgMainMenu2 = null;
        imgBack = null;
        System.gc();
    }

    public Menu() {
        super(true);
        this.spacer = 1;
        this.setFullScreenMode(true);
        this.vectorElements = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Graphics g = this.getGraphics();
        try {
            while (this.running) {
                if (this.paused) {
                    try {
                        Menu menu = this;
                        synchronized (menu) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                this.input();
                this.render(g);
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        if (this.endTask != null) {
            this.endTask.execute();
        }
        if (this instanceof MenuMain) {
            Menu.clean();
        } else if (this instanceof MenuPause) {
            Menu.cleanPauseMenu();
        }
    }

    public void start() {
        this.running = true;
        new Thread(this).start();
    }

    public void pause() {
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        this.paused = false;
        Menu menu = this;
        synchronized (menu) {
            this.notifyAll();
        }
    }

    public void stop() {
        this.running = false;
    }

    private void input() {
        int keyState = this.getKeyStates();
        if ((keyState & 2) != 0 && this.lastUp > 3) {
            this.lastUp = 0;
            this.upPressed();
        } else if ((keyState & 0x40) != 0 && this.lastDown > 3) {
            this.lastDown = 0;
            this.downPressed();
        } else if ((keyState & 0x100) != 0 && this.lastFire > 3) {
            this.lastFire = 0;
            this.firePressed();
        }
        ++this.lastDown;
        ++this.lastFire;
        ++this.lastUp;
        if (this.lastDown > 10) {
            this.lastDown = 10;
        }
        if (this.lastFire > 10) {
            this.lastFire = 10;
        }
        if (this.lastUp > 10) {
            this.lastUp = 10;
        }
    }

    private void render(Graphics gg) {
        Image i = null;
        i = this.getWidth() < this.getHeight() ? Image.createImage((int)this.getWidth(), (int)this.getHeight()) : Image.createImage((int)this.getHeight(), (int)this.getWidth());
        Graphics g = i.getGraphics();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(imgBack, 0, 0, 20);
        if (this instanceof MenuDownload) {
            g.drawImage(imgFullVersion, i.getWidth() / 2 - imgFullVersion.getWidth() / 2, 100, 20);
        }
        for (int j = 0; j < this.vectorElements.size(); ++j) {
            ((MenuElement)this.vectorElements.elementAt(j)).draw(g);
        }
        if (this.getWidth() < this.getHeight()) {
            gg.drawImage(i, 0, 0, 20);
        } else {
            gg.drawRegion(i, 0, 0, i.getWidth(), i.getHeight(), 6, 0, 0, 20);
        }
        this.flushGraphics();
    }

    private void setSelectedIndex() {
        MenuElement element = null;
        for (int j = 0; j < this.vectorElements.size(); ++j) {
            element = (MenuElement)this.vectorElements.elementAt(j);
            element.selected = j == this.selectedIndex;
        }
    }

    private void upPressed() {
        --this.selectedIndex;
        if (this.selectedIndex < 0) {
            this.selectedIndex = this.numberOfElements - 1;
        }
        this.setSelectedIndex();
    }

    private void downPressed() {
        ++this.selectedIndex;
        this.selectedIndex %= this.numberOfElements;
        this.setSelectedIndex();
    }

    private void firePressed() {
        ((MenuElement)this.vectorElements.elementAt(this.selectedIndex)).processAction();
    }

    protected void pointerReleased(int x, int y) {
        if (!Main.testForSupported(this.getWidth(), this.getHeight())) {
            int xOld = x;
            int yOld = y;
            y = xOld;
            x = this.getHeight() - yOld;
        }
        if (x < this.menuX || x > this.menuX + MenuElement.WIDTH || y < this.menuY || y > this.menuY + this.height) {
            return;
        }
        this.selectedIndex = (y -= this.menuY) / (MenuElement.HEIGHT + 1);
        if (this.selectedIndex < this.vectorElements.size()) {
            this.setSelectedIndex();
            ((MenuElement)this.vectorElements.elementAt(this.selectedIndex)).processAction();
        }
    }
}

