/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Board {
    protected byte[][] Surface = new byte[30][30];
    protected byte[][] Destroyable = new byte[30][30];
    protected byte[][] Overlay = new byte[30][30];
    protected Image[] SurfaceImages = new Image[4];
    protected Image[] DestroyableImages = new Image[2];
    protected Image[] OverlayImages = new Image[1];
    protected Image[] WaterAnimation = new Image[3];
    protected Image Eagle = null;
    static byte EMPTY = 0;
    static byte MARSH = 1;
    static byte ICE = (byte)2;
    static byte WATER = (byte)3;
    static byte BRICK = 1;
    static byte CONCRETE = (byte)2;
    static byte VINE = 1;
    protected static byte WaterAnimationFrame = 0;

    public Board() {
        this.SurfaceImages[0] = ItemsLoader.SAND;
        this.SurfaceImages[1] = ItemsLoader.BAGNO;
        this.SurfaceImages[2] = ItemsLoader.LOD;
        this.SurfaceImages[3] = ItemsLoader.WODA_1;
        this.WaterAnimation[0] = ItemsLoader.WODA_1;
        this.WaterAnimation[1] = ItemsLoader.WODA_2;
        this.WaterAnimation[2] = ItemsLoader.WODA_3;
        this.DestroyableImages[0] = ItemsLoader.CEGLA;
        this.DestroyableImages[1] = ItemsLoader.BETON;
        this.OverlayImages[0] = ItemsLoader.KRZAK;
        this.Eagle = ItemsLoader.ORZEL;
    }

    public void load(String Nazwa) {
        System.out.println(Nazwa);
        InputStream IS = this.getClass().getResourceAsStream(Nazwa);
        InputStreamReader ISR = new InputStreamReader(IS);
        int tmp = 0;
        try {
            int y;
            int x;
            for (x = 0; x < 30; ++x) {
                for (y = 0; y < 30; ++y) {
                    tmp = ISR.read();
                    this.Surface[x][y] = (byte)tmp;
                }
            }
            for (x = 0; x < 30; ++x) {
                for (y = 0; y < 30; ++y) {
                    tmp = ISR.read();
                    this.Destroyable[x][y] = (byte)tmp;
                }
            }
            for (x = 0; x < 30; ++x) {
                for (y = 0; y < 30; ++y) {
                    tmp = ISR.read();
                    this.Overlay[x][y] = (byte)tmp;
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.repair();
    }

    public void paintSurface(Graphics G) {
        G.setColor(32, 32, 32);
        byte Tile = 0;
        for (int x = 0; x < 30; ++x) {
            for (int y = 0; y < 30; ++y) {
                Tile = this.Surface[x][y];
                G.drawImage(this.SurfaceImages[Tile], x * 8, y * 8, 0);
            }
        }
        WaterAnimationFrame = (byte)((WaterAnimationFrame + 1) % 30);
        this.SurfaceImages[Board.WATER] = this.WaterAnimation[WaterAnimationFrame / 10];
    }

    public void paintDestroyable(Graphics G) {
        byte Tile = 0;
        for (int x = 0; x < 30; ++x) {
            for (int y = 0; y < 30; ++y) {
                Tile = this.Destroyable[x][y];
                if (Tile == 0) continue;
                G.drawImage(this.DestroyableImages[Tile - 1], x * 8, y * 8, 0);
            }
        }
        G.drawImage(this.Eagle, 112, 224, 0);
    }

    public void paintOverlay(Graphics G) {
        byte Tile = 0;
        for (int x = 0; x < 30; ++x) {
            for (int y = 0; y < 30; ++y) {
                Tile = this.Overlay[x][y];
                if (Tile == 0) continue;
                G.drawImage(this.OverlayImages[Tile - 1], x * 8, y * 8, 0);
            }
        }
    }

    public final void repair() {
        this.Destroyable[13][27] = 1;
        this.Destroyable[14][27] = 1;
        this.Destroyable[15][27] = 1;
        this.Destroyable[16][27] = 1;
        this.Destroyable[13][28] = 1;
        this.Destroyable[13][29] = 1;
        this.Destroyable[16][28] = 1;
        this.Destroyable[16][29] = 1;
        this.Destroyable[13][26] = 0;
        this.Destroyable[14][26] = 0;
        this.Destroyable[15][26] = 0;
        this.Destroyable[16][26] = 0;
        this.Destroyable[12][28] = 0;
        this.Destroyable[12][29] = 0;
        this.Destroyable[17][28] = 0;
        this.Destroyable[17][29] = 0;
        this.Destroyable[12][26] = 0;
        this.Destroyable[12][27] = 0;
        this.Destroyable[17][26] = 0;
        this.Destroyable[17][27] = 0;
        this.Destroyable[14][28] = 0;
        this.Destroyable[15][28] = 0;
        this.Destroyable[14][29] = 0;
        this.Destroyable[15][29] = 0;
        this.Destroyable[11][28] = 0;
        this.Destroyable[10][28] = 0;
        this.Destroyable[11][29] = 0;
        this.Destroyable[10][29] = 0;
        this.Destroyable[18][28] = 0;
        this.Destroyable[19][28] = 0;
        this.Destroyable[18][29] = 0;
        this.Destroyable[19][29] = 0;
        if (this.Surface[11][28] == 3) {
            this.Surface[11][28] = 2;
        }
        if (this.Surface[10][28] == 3) {
            this.Surface[10][28] = 2;
        }
        if (this.Surface[11][29] == 3) {
            this.Surface[11][29] = 2;
        }
        if (this.Surface[10][29] == 3) {
            this.Surface[10][29] = 2;
        }
        if (this.Surface[18][28] == 3) {
            this.Surface[18][28] = 2;
        }
        if (this.Surface[19][28] == 3) {
            this.Surface[19][28] = 2;
        }
        if (this.Surface[18][29] == 3) {
            this.Surface[18][29] = 2;
        }
        if (this.Surface[19][29] == 3) {
            this.Surface[19][29] = 2;
        }
        this.Destroyable[0][0] = 0;
        this.Destroyable[0][1] = 0;
        this.Destroyable[1][0] = 0;
        this.Destroyable[1][1] = 0;
        if (this.Surface[0][0] == 3) {
            this.Surface[0][0] = 2;
        }
        if (this.Surface[1][0] == 3) {
            this.Surface[1][0] = 2;
        }
        if (this.Surface[0][1] == 3) {
            this.Surface[0][1] = 2;
        }
        if (this.Surface[1][1] == 3) {
            this.Surface[1][1] = 2;
        }
        this.Destroyable[14][0] = 0;
        this.Destroyable[14][1] = 0;
        this.Destroyable[15][0] = 0;
        this.Destroyable[15][1] = 0;
        if (this.Surface[14][0] == 3) {
            this.Surface[14][0] = 2;
        }
        if (this.Surface[15][0] == 3) {
            this.Surface[15][0] = 2;
        }
        if (this.Surface[14][1] == 3) {
            this.Surface[14][1] = 2;
        }
        if (this.Surface[15][1] == 3) {
            this.Surface[15][1] = 2;
        }
        this.Destroyable[28][0] = 0;
        this.Destroyable[28][1] = 0;
        this.Destroyable[29][0] = 0;
        this.Destroyable[29][1] = 0;
        if (this.Surface[28][0] == 3) {
            this.Surface[28][0] = 2;
        }
        if (this.Surface[29][0] == 3) {
            this.Surface[29][0] = 2;
        }
        if (this.Surface[28][1] == 3) {
            this.Surface[28][1] = 2;
        }
        if (this.Surface[29][1] == 3) {
            this.Surface[29][1] = 2;
        }
    }
}

